import QtQuick 1.0
import oif 1.0

Rectangle {
    width: 500
    height: 500

    function printTouches(touches) {
        for (var i = 0, len = touches.length; i < len; i++) {
            var touch = touches[i]

            console.log("\tTouch (" + touch.id + "):")
            console.log("\t\tlocation: (" + touch.location.x + ", " + touch.location.y + ")")
            console.log("\t\tAttributes:")
            for (var attribute in touch.attributes)
                console.log("\t\t\t" + attribute + ": " + touch.attributes[attribute])
        }
    }

    function printDevice(device) {
        console.log("\tDevice (" + device.id + "):")
        console.log("\t\tType: " + device.type)
        console.log("\t\tX Axis:")
        console.log("\t\t\tMin: " + device.x.min)
        console.log("\t\t\tMax: " + device.x.max)
        console.log("\t\t\tResolution: " + device.x.resolution)
        console.log("\t\tY Axis:")
        console.log("\t\t\tMin: " + device.y.min)
        console.log("\t\t\tMax: " + device.y.max)
        console.log("\t\t\tResolution: " + device.y.resolution)
        console.log("\t\tAttributes:")
        for (var attribute in device.attributes)
            console.log("\t\t\t" + attribute + ": " + device.attributes[attribute])
    }

    function printGestureEvent(gesture, state) {
        console.log(state + " (" + gesture.id + "):")
        console.log("\tAttributes:")
        for (var attribute in gesture.attributes)
            console.log("\t\t" + attribute + ": " + gesture.attributes[attribute])

        printTouches(gesture.touches)

        printDevice(gesture.device)

        console.log("")
    }

    OIFDragArea {
        anchors.fill: parent

        subscription {
            touches.start: 2
        }

        onGestureStart:
            printGestureEvent(gesture, "Start")

        onGestureUpdate:
            printGestureEvent(gesture, "Update")

        onGestureEnd:
            printGestureEvent(gesture, "End")

        onFocusChanged:
            console.log("Drag Focus: (" + focus.x + ", " + focus.y + ")\n")

        centroid.onInitialChanged:
            console.log("Drag Centroid: (" + centroid.initial.x + ", " + centroid.initial.y + ")\n")

        centroid.onCurrentChanged:
            console.log("Drag Centroid: (" + centroid.current.x + ", " + centroid.current.y + ")\n")
    }

    OIFPinchArea {
        anchors.fill: parent

        subscription {
            touches.start: 2
        }

        onGestureStart:
            printGestureEvent(gesture, "Start")

        onGestureUpdate:
            printGestureEvent(gesture, "Update")

        onGestureEnd:
            printGestureEvent(gesture, "End")

        onFocusChanged:
            console.log("Pinch Focus: (" + focus.x + ", " + focus.y + ")\n")

        centroid.onInitialChanged:
            console.log("Pinch Initial Centroid: (" + centroid.initial.x + ", " + centroid.initial.y + ")\n")

        centroid.onCurrentChanged:
            console.log("Pinch Centroid: (" + centroid.current.x + ", " + centroid.current.y + ")\n")

        radius.onInitialChanged:
            console.log("Pinch Initial Radius: " + radius.initial + "\n")

        radius.onCurrentChanged:
            console.log("Pinch Radius: " + radius.current + "\n")
    }

    OIFRotateArea {
        anchors.fill: parent

        subscription {
            touches.start: 2
        }

        onGestureStart:
            printGestureEvent(gesture, "Start")

        onGestureUpdate:
            printGestureEvent(gesture, "Update")

        onGestureEnd:
            printGestureEvent(gesture, "End")

        onFocusChanged:
            console.log("Rotate Focus: (" + focus.x + ", " + focus.y + ")\n")

        centroid.onInitialChanged:
            console.log("Rotate Initial Centroid: (" + centroid.initial.x + ", " + centroid.initial.y + ")\n")

        centroid.onCurrentChanged:
            console.log("Rotate Centroid: (" + centroid.current.x + ", " + centroid.current.y + ")\n")

        angle.onInitialChanged:
            console.log("Rotate Initial Angle: " + angle.initial + "\n")

        angle.onCurrentChanged:
            console.log("Rotate Angle: " + angle.current + "\n")
    }

    OIFTapArea {
        anchors.fill: parent

        subscription {
            touches.start: 2
        }

        onGestureOccurred:
            printGestureEvent(gesture, "Tap")

        onFocusChanged:
            console.log("Tap Focus: (" + focus.x + ", " + focus.y + ")\n")

        centroid.onInitialChanged:
            console.log("Tap Initial Centroid: (" + centroid.initial.x + ", " + centroid.initial.y + ")\n")

        centroid.onCurrentChanged:
            console.log("Tap Centroid: (" + centroid.current.x + ", " + centroid.current.y + ")\n")
    }
}
