% LTFAT - Demos
%
%   Peter L. Soendergaard, 2007 - 2015.
%
%   This page documents the demos.
%
%   Basic demos
%     DEMO_DGT              - DGT and comparison to SGRAM
%     DEMO_GABFIR           - FIR windows in Gabor systems.
%     DEMO_WAVELETS         - Wavelet representations using  FWT and WFBT.
%
%   Compression
%     DEMO_IMAGECOMPRESSION - Image compression using DWILT and FWT
%     DEMO_AUDIOCOMPRESSION - Audio compression using a WMDCT.
%
%   Denoising 
%     DEMO_AUDIODENOISE     - Audio denoising using a WMDCT.
%
%   Applications
%     DEMO_OFDM             - Simple OFDM demo.
%     DEMO_AUDIOSHRINK      - Lasso shrinkage of audio signal.
%     DEMO_GABMULAPPR       - Approx. of time-varying system.
%     DEMO_BPFRAMEMUL       - A Gabor multiplier as a time-varying bandpass filter.
%     DEMO_FRSYNABS         - Synthetic spectrogram iterative reconstruction.
%     DEMO_FILTERBANKSYNCHROSQUEEZE - Reconstruction from synchrosqueezed representation.
%
%   Aspects of particular functions
%     DEMO_NSDGT            - Non-stationary Gabor systems
%     DEMO_PGAUSS           - How to use PGAUSS.
%     DEMO_PBSPLINE         - How to use PBSPLINE.
%     DEMO_GABMIXDUAL       - How to use GABMIXDUAL.
%     DEMO_FRAMEMUL         - Time-frequency localization by Gabor multiplier.
%     DEMO_PHASEPLOT        - Phaseplots.
%     DEMO_PHASERET         - Spectrogram phase retrieval and phase difference
%     DEMO_NEXTFASTFFT      - Next fast FFT size.
%     DEMO_FILTERBANKS      - Non-stationary Gabor systems defined in frequency domain
%
%  Auditory scales and filters
%     DEMO_AUDSCALES          - Different auditory scales.
%     DEMO_AUDITORYFILTERBANK - Erb-spaced auditory filter bank.
%     DEMO_WFBT               - Auditory filter banks created using WFBT.
%
%  Block-processing demos
%     DEMO_BLOCKPROC_BASICLOOP        - Simple audio playback loop.
%     DEMO_BLOCKPROC_PARAMEQUALIZER   - Parametric equalizer.
%     DEMO_BLOCKPROC_DENOISING        - Variable noise-reduction.
%     DEMO_BLOCKPROC_SLIDINGSGRAM     - Sliding spectrogram plot.
%     DEMO_BLOCKPROC_SLIDINGCQT       - Sliding CQT plot.
%     DEMO_BLOCKPROC_SLIDINGERBLETS   - Sliding Erblets plot.
%     DEMO_BLOCKPROC_DGTEQUALIZER     - Variable Gabor Multiplier as equalizer.
%     DEMO_BLOCKPROC_EFFECTS          - Real-time vocoder effects.
%     
%
%  For help, bug reports, suggestions etc. please visit 
%  http://github.com/ltfat/ltfat/issues
%
%   Url: http://ltfat.github.io/doc/demos/Contents.html

% Copyright (C) 2005-2015 Peter L. Soendergaard <peter@sonderport.dk>.
% This file is part of LTFAT version 2.1.1
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.



