// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_TrimmedCurve_HeaderFile
#define _Geom_TrimmedCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_TrimmedCurve_HeaderFile
#include <Handle_Geom_TrimmedCurve.hxx>
#endif

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom_BoundedCurve_HeaderFile
#include <Geom_BoundedCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Geom_Curve;
class Standard_ConstructionError;
class Standard_RangeError;
class Standard_NoSuchObject;
class Geom_UndefinedDerivative;
class Geom_UndefinedValue;
class gp_Pnt;
class gp_Vec;
class gp_Trsf;
class Geom_Geometry;


//! Describes a portion of a curve (termed the "basis <br>
//! curve") limited by two parameter values inside the <br>
//! parametric domain of the basis curve. <br>
//! The trimmed curve is defined by: <br>
//! - the basis curve, and <br>
//! - the two parameter values which limit it. <br>
//! The trimmed curve can either have the same <br>
//! orientation as the basis curve or the opposite orientation. <br>
class Geom_TrimmedCurve : public Geom_BoundedCurve {

public:

  //! Constructs a trimmed curve from the basis curve C <br>
//! which is limited between parameter values U1 and U2. <br>
//! Note: - U1 can be greater or less than U2; in both cases, <br>
//!   the returned curve is oriented from U1 to U2. <br>
//! - If the basis curve C is periodic, there is an <br>
//!   ambiguity because two parts are available. In this <br>
//!   case, the trimmed curve has the same orientation <br>
//!   as the basis curve if Sense is true (default value) <br>
//!   or the opposite orientation if Sense is false. <br>
//! - If the curve is closed but not periodic, it is not <br>
//!   possible to keep the part of the curve which <br>
//!   includes the junction point (except if the junction <br>
//!   point is at the beginning or at the end of the <br>
//!   trimmed curve). If you tried to do this, you could <br>
//!   alter the fundamental characteristics of the basis <br>
//!   curve, which are used, for example, to compute <br>
//!   the derivatives of the trimmed curve. The rules <br>
//!   for a closed curve are therefore the same as <br>
//!   those for an open curve. <br>
//! Warning: The trimmed curve is built from a copy of curve C. <br>
//!   Therefore, when C is modified, the trimmed curve <br>
//!   is not modified. <br>
//! - If the basis curve is periodic, the bounds of the <br>
//!   trimmed curve may be different from U1 and U2 <br>
//!   if the parametric origin of the basis curve is within <br>
//!   the arc of the trimmed curve. In this case, the <br>
//!   modified parameter will be equal to U1 or U2 <br>
//!   plus or minus the period. <br>
//!   Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - C is not periodic and U1 or U2 is outside the <br>
//!   bounds of C, or <br>
//! - U1 is equal to U2. <br>
  Standard_EXPORT   Geom_TrimmedCurve(const Handle(Geom_Curve)& C,const Standard_Real U1,const Standard_Real U2,const Standard_Boolean Sense = Standard_True);
  //! Changes the orientation of this trimmed curve. <br>
//! As a result: <br>
//! - the basis curve is reversed, <br>
//! - the start point of the initial curve becomes the <br>
//!   end point of the reversed curve, <br>
//! - the end point of the initial curve becomes the <br>
//!   start point of the reversed curve, <br>
//! - the first and last parameters are recomputed. <br>
//!   If the trimmed curve was defined by: <br>
//! - a basis curve whose parameter range is [ 0., 1. ], <br>
//! - the two trim values U1 (first parameter) and U2 (last parameter), <br>
//!   the reversed trimmed curve is defined by: <br>
//! - the reversed basis curve, whose parameter range is still [ 0., 1. ], <br>
//! - the two trim values 1. - U2 (first parameter) and 1. - U1 (last parameter). <br>
  Standard_EXPORT     void Reverse() ;
  //! Computes the parameter on the reversed curve for <br>
//! the point of parameter U on this trimmed curve. <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //!  Changes this trimmed curve, by redefining the <br>
//! parameter values U1 and U2 which limit its basis curve. <br>
//! Note: If the basis curve is periodic, the trimmed curve <br>
//! has the same orientation as the basis curve if Sense <br>
//! is true (default value) or the opposite orientation if Sense is false. <br>
//! Warning <br>
//! If the basis curve is periodic, the bounds of the <br>
//! trimmed curve may be different from U1 and U2 if the <br>
//! parametric origin of the basis curve is within the arc of <br>
//! the trimmed curve. In this case, the modified <br>
//! parameter will be equal to U1 or U2 plus or minus the period. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - the basis curve is not periodic, and either U1 or U2 <br>
//!   are outside the bounds of the basis curve, or <br>
//! - U1 is equal to U2. <br>
  Standard_EXPORT     void SetTrim(const Standard_Real U1,const Standard_Real U2,const Standard_Boolean Sense = Standard_True) ;
  //! Returns the basis curve. <br>
//!   Warning <br>
//! This function does not return a constant reference. <br>
//! Consequently, any modification of the returned value <br>
//! directly modifies the trimmed curve. <br>
  Standard_EXPORT     Handle_Geom_Curve BasisCurve() const;
  
//!  Returns the continuity of the curve : <br>
//! C0 : only geometric continuity, <br>
//! C1 : continuity of the first derivative all along the Curve, <br>
//! C2 : continuity of the second derivative all along the Curve, <br>
//! C3 : continuity of the third derivative all along the Curve, <br>
//! CN : the order of continuity is infinite. <br>
  Standard_EXPORT     GeomAbs_Shape Continuity() const;
  //! Returns true if the degree of continuity of the basis <br>
//! curve of this trimmed curve is at least N. A trimmed <br>
//! curve is at least "C0" continuous. <br>
//!  Warnings : <br>
//!  The continuity of the trimmed curve can be greater than <br>
//!  the continuity of the basis curve because you consider <br>
//!  only a part of the basis curve. <br>//! Raised if N < 0. <br>
  Standard_EXPORT     Standard_Boolean IsCN(const Standard_Integer N) const;
  
//!  Returns the end point of <me>. This point is the <br>
//!  evaluation of the curve for the "LastParameter". <br>
  Standard_EXPORT     gp_Pnt EndPoint() const;
  
//!  Returns the value of the first parameter of <me>. <br>
//!  The first parameter is the parameter of the "StartPoint" <br>
//!  of the trimmed curve. <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  
//!  Returns True if the distance between the StartPoint and <br>
//!  the EndPoint is lower or equal to Resolution from package gp. <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! Returns true if the basis curve of this trimmed curve is periodic. <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns the period of the basis curve of this trimmed curve. <br>
//! Exceptions <br>
//! Standard_NoSuchObject if the basis curve is not periodic. <br>
  Standard_EXPORT   virtual  Standard_Real Period() const;
  
//!  Returns the value of the last parameter of <me>. <br>
//!  The last parameter is the parameter of the "EndPoint" of the <br>
//!  trimmed curve. <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  
//!  Returns the start point of <me>. <br>
//!  This point is the evaluation of the curve from the <br>
//!  "FirstParameter". <br>//! value and derivatives <br>
//! Warnings : <br>
//!  The returned derivatives have the same orientation as the <br>
//!  derivatives of the basis curve even if the trimmed curve <br>
//!  has not the same orientation as the basis curve. <br>
  Standard_EXPORT     gp_Pnt StartPoint() const;
  //! Returns in P the point of parameter U. <br>
//! <br>
//!  If the basis curve is an OffsetCurve sometimes it is not <br>
//!  possible to do the evaluation of the curve at the parameter <br>
//!  U (see class OffsetCurve). <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt& P) const;
  //! Raised if the continuity of the curve is not C1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V1) const;
  //! Raised if the continuity of the curve is not C2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;
  //! Raised if the continuity of the curve is not C3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const;
  //! N is the order of derivation. <br>//! Raised if the continuity of the curve is not CN. <br>//! Raised if N < 1. <br>//! geometric transformations <br>
  Standard_EXPORT     gp_Vec DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this trimmed curve. <br>
//! Warning The basis curve is also modified. <br>
  Standard_EXPORT     void Transform(const gp_Trsf& T) ;
  //! Returns the  parameter on the  transformed  curve for <br>
//!          the transform of the point of parameter U on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(me->TransformedParameter(U,T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U).Transformed(T) <br>
//! <br>
//!          This methods calls the basis curve method. <br>
  Standard_EXPORT   virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf& T) const;
  //! Returns a  coefficient to compute the parameter on <br>
//!          the transformed  curve  for  the transform  of the <br>
//!          point on <me>. <br>
//! <br>
//!          Transformed(T)->Value(U * ParametricTransformation(T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          Value(U).Transformed(T) <br>
//! <br>
//!          This methods calls the basis curve method. <br>
  Standard_EXPORT   virtual  Standard_Real ParametricTransformation(const gp_Trsf& T) const;
  //! Creates a new object which is a copy of this trimmed curve. <br>
  Standard_EXPORT     Handle_Geom_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom_TrimmedCurve)

protected:




private: 


Handle_Geom_Curve basisCurve;
Standard_Real uTrim1;
Standard_Real uTrim2;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
