/* Autogenerated: '../fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery' --static --use-value-barrier --inline-internal np224 32 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D mul add opp from_montgomery to_montgomery one msat divstep_precomp divstep to_bytes from_bytes selectznz */
/* curve description: np224 */
/* machine_wordsize = 32 (from "32") */
/* requested operations: mul, add, opp, from_montgomery, to_montgomery, one, msat, divstep_precomp, divstep, to_bytes, from_bytes, selectznz */
/* m = 0xffffffffffffffffffffffffffff16a2e0b8f03e13dd29455c5c2a3d (from "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/*   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) */
/*   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) in */
/*                            if x1 & (2^224-1) < 2^223 then x1 & (2^224-1) else (x1 & (2^224-1)) - 2^224 */

#include <stdint.h>
typedef unsigned char fiat_np224_uint1;
typedef signed char fiat_np224_int1;
#if defined(__GNUC__) || defined(__clang__)
#  define FIAT_NP224_FIAT_INLINE __inline__
#else
#  define FIAT_NP224_FIAT_INLINE
#endif

/* The type fiat_np224_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_np224_montgomery_domain_field_element[7];

/* The type fiat_np224_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_np224_non_montgomery_domain_field_element[7];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_NP224_NO_ASM) && (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t fiat_np224_value_barrier_u32(uint32_t a) {
  __asm__("" : "+r"(a) : /* no inputs */);
  return a;
}
#else
#  define fiat_np224_value_barrier_u32(x) (x)
#endif


/*
 * The function fiat_np224_addcarryx_u32 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_NP224_FIAT_INLINE void fiat_np224_addcarryx_u32(uint32_t* out1, fiat_np224_uint1* out2, fiat_np224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1;
  uint32_t x2;
  fiat_np224_uint1 x3;
  x1 = ((arg1 + (uint64_t)arg2) + arg3);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (fiat_np224_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_np224_subborrowx_u32 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_NP224_FIAT_INLINE void fiat_np224_subborrowx_u32(uint32_t* out1, fiat_np224_uint1* out2, fiat_np224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1;
  fiat_np224_int1 x2;
  uint32_t x3;
  x1 = ((arg2 - (int64_t)arg1) - arg3);
  x2 = (fiat_np224_int1)(x1 >> 32);
  x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_np224_uint1)(0x0 - x2);
}

/*
 * The function fiat_np224_mulx_u32 is a multiplication, returning the full double-width result.
 *
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static FIAT_NP224_FIAT_INLINE void fiat_np224_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1;
  uint32_t x2;
  uint32_t x3;
  x1 = ((uint64_t)arg1 * arg2);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_np224_cmovznz_u32 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static FIAT_NP224_FIAT_INLINE void fiat_np224_cmovznz_u32(uint32_t* out1, fiat_np224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_np224_uint1 x1;
  uint32_t x2;
  uint32_t x3;
  x1 = (!(!arg1));
  x2 = ((fiat_np224_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  x3 = ((fiat_np224_value_barrier_u32(x2) & arg3) | (fiat_np224_value_barrier_u32((~x2)) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_np224_mul multiplies two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_mul(fiat_np224_montgomery_domain_field_element out1, const fiat_np224_montgomery_domain_field_element arg1, const fiat_np224_montgomery_domain_field_element arg2) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  fiat_np224_uint1 x23;
  uint32_t x24;
  fiat_np224_uint1 x25;
  uint32_t x26;
  fiat_np224_uint1 x27;
  uint32_t x28;
  fiat_np224_uint1 x29;
  uint32_t x30;
  fiat_np224_uint1 x31;
  uint32_t x32;
  fiat_np224_uint1 x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint32_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint32_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  fiat_np224_uint1 x52;
  uint32_t x53;
  fiat_np224_uint1 x54;
  uint32_t x55;
  fiat_np224_uint1 x56;
  uint32_t x57;
  fiat_np224_uint1 x58;
  uint32_t x59;
  fiat_np224_uint1 x60;
  uint32_t x61;
  fiat_np224_uint1 x62;
  uint32_t x63;
  uint32_t x64;
  fiat_np224_uint1 x65;
  uint32_t x66;
  fiat_np224_uint1 x67;
  uint32_t x68;
  fiat_np224_uint1 x69;
  uint32_t x70;
  fiat_np224_uint1 x71;
  uint32_t x72;
  fiat_np224_uint1 x73;
  uint32_t x74;
  fiat_np224_uint1 x75;
  uint32_t x76;
  fiat_np224_uint1 x77;
  uint32_t x78;
  fiat_np224_uint1 x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  uint32_t x85;
  uint32_t x86;
  uint32_t x87;
  uint32_t x88;
  uint32_t x89;
  uint32_t x90;
  uint32_t x91;
  uint32_t x92;
  uint32_t x93;
  uint32_t x94;
  fiat_np224_uint1 x95;
  uint32_t x96;
  fiat_np224_uint1 x97;
  uint32_t x98;
  fiat_np224_uint1 x99;
  uint32_t x100;
  fiat_np224_uint1 x101;
  uint32_t x102;
  fiat_np224_uint1 x103;
  uint32_t x104;
  fiat_np224_uint1 x105;
  uint32_t x106;
  uint32_t x107;
  fiat_np224_uint1 x108;
  uint32_t x109;
  fiat_np224_uint1 x110;
  uint32_t x111;
  fiat_np224_uint1 x112;
  uint32_t x113;
  fiat_np224_uint1 x114;
  uint32_t x115;
  fiat_np224_uint1 x116;
  uint32_t x117;
  fiat_np224_uint1 x118;
  uint32_t x119;
  fiat_np224_uint1 x120;
  uint32_t x121;
  fiat_np224_uint1 x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  fiat_np224_uint1 x140;
  uint32_t x141;
  fiat_np224_uint1 x142;
  uint32_t x143;
  fiat_np224_uint1 x144;
  uint32_t x145;
  fiat_np224_uint1 x146;
  uint32_t x147;
  fiat_np224_uint1 x148;
  uint32_t x149;
  fiat_np224_uint1 x150;
  uint32_t x151;
  uint32_t x152;
  fiat_np224_uint1 x153;
  uint32_t x154;
  fiat_np224_uint1 x155;
  uint32_t x156;
  fiat_np224_uint1 x157;
  uint32_t x158;
  fiat_np224_uint1 x159;
  uint32_t x160;
  fiat_np224_uint1 x161;
  uint32_t x162;
  fiat_np224_uint1 x163;
  uint32_t x164;
  fiat_np224_uint1 x165;
  uint32_t x166;
  fiat_np224_uint1 x167;
  uint32_t x168;
  uint32_t x169;
  uint32_t x170;
  uint32_t x171;
  uint32_t x172;
  uint32_t x173;
  uint32_t x174;
  uint32_t x175;
  uint32_t x176;
  uint32_t x177;
  uint32_t x178;
  uint32_t x179;
  uint32_t x180;
  uint32_t x181;
  uint32_t x182;
  uint32_t x183;
  fiat_np224_uint1 x184;
  uint32_t x185;
  fiat_np224_uint1 x186;
  uint32_t x187;
  fiat_np224_uint1 x188;
  uint32_t x189;
  fiat_np224_uint1 x190;
  uint32_t x191;
  fiat_np224_uint1 x192;
  uint32_t x193;
  fiat_np224_uint1 x194;
  uint32_t x195;
  uint32_t x196;
  fiat_np224_uint1 x197;
  uint32_t x198;
  fiat_np224_uint1 x199;
  uint32_t x200;
  fiat_np224_uint1 x201;
  uint32_t x202;
  fiat_np224_uint1 x203;
  uint32_t x204;
  fiat_np224_uint1 x205;
  uint32_t x206;
  fiat_np224_uint1 x207;
  uint32_t x208;
  fiat_np224_uint1 x209;
  uint32_t x210;
  fiat_np224_uint1 x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  uint32_t x225;
  uint32_t x226;
  uint32_t x227;
  uint32_t x228;
  fiat_np224_uint1 x229;
  uint32_t x230;
  fiat_np224_uint1 x231;
  uint32_t x232;
  fiat_np224_uint1 x233;
  uint32_t x234;
  fiat_np224_uint1 x235;
  uint32_t x236;
  fiat_np224_uint1 x237;
  uint32_t x238;
  fiat_np224_uint1 x239;
  uint32_t x240;
  uint32_t x241;
  fiat_np224_uint1 x242;
  uint32_t x243;
  fiat_np224_uint1 x244;
  uint32_t x245;
  fiat_np224_uint1 x246;
  uint32_t x247;
  fiat_np224_uint1 x248;
  uint32_t x249;
  fiat_np224_uint1 x250;
  uint32_t x251;
  fiat_np224_uint1 x252;
  uint32_t x253;
  fiat_np224_uint1 x254;
  uint32_t x255;
  fiat_np224_uint1 x256;
  uint32_t x257;
  uint32_t x258;
  uint32_t x259;
  uint32_t x260;
  uint32_t x261;
  uint32_t x262;
  uint32_t x263;
  uint32_t x264;
  uint32_t x265;
  uint32_t x266;
  uint32_t x267;
  uint32_t x268;
  uint32_t x269;
  uint32_t x270;
  uint32_t x271;
  uint32_t x272;
  fiat_np224_uint1 x273;
  uint32_t x274;
  fiat_np224_uint1 x275;
  uint32_t x276;
  fiat_np224_uint1 x277;
  uint32_t x278;
  fiat_np224_uint1 x279;
  uint32_t x280;
  fiat_np224_uint1 x281;
  uint32_t x282;
  fiat_np224_uint1 x283;
  uint32_t x284;
  uint32_t x285;
  fiat_np224_uint1 x286;
  uint32_t x287;
  fiat_np224_uint1 x288;
  uint32_t x289;
  fiat_np224_uint1 x290;
  uint32_t x291;
  fiat_np224_uint1 x292;
  uint32_t x293;
  fiat_np224_uint1 x294;
  uint32_t x295;
  fiat_np224_uint1 x296;
  uint32_t x297;
  fiat_np224_uint1 x298;
  uint32_t x299;
  fiat_np224_uint1 x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  fiat_np224_uint1 x318;
  uint32_t x319;
  fiat_np224_uint1 x320;
  uint32_t x321;
  fiat_np224_uint1 x322;
  uint32_t x323;
  fiat_np224_uint1 x324;
  uint32_t x325;
  fiat_np224_uint1 x326;
  uint32_t x327;
  fiat_np224_uint1 x328;
  uint32_t x329;
  uint32_t x330;
  fiat_np224_uint1 x331;
  uint32_t x332;
  fiat_np224_uint1 x333;
  uint32_t x334;
  fiat_np224_uint1 x335;
  uint32_t x336;
  fiat_np224_uint1 x337;
  uint32_t x338;
  fiat_np224_uint1 x339;
  uint32_t x340;
  fiat_np224_uint1 x341;
  uint32_t x342;
  fiat_np224_uint1 x343;
  uint32_t x344;
  fiat_np224_uint1 x345;
  uint32_t x346;
  uint32_t x347;
  uint32_t x348;
  uint32_t x349;
  uint32_t x350;
  uint32_t x351;
  uint32_t x352;
  uint32_t x353;
  uint32_t x354;
  uint32_t x355;
  uint32_t x356;
  uint32_t x357;
  uint32_t x358;
  uint32_t x359;
  uint32_t x360;
  uint32_t x361;
  fiat_np224_uint1 x362;
  uint32_t x363;
  fiat_np224_uint1 x364;
  uint32_t x365;
  fiat_np224_uint1 x366;
  uint32_t x367;
  fiat_np224_uint1 x368;
  uint32_t x369;
  fiat_np224_uint1 x370;
  uint32_t x371;
  fiat_np224_uint1 x372;
  uint32_t x373;
  uint32_t x374;
  fiat_np224_uint1 x375;
  uint32_t x376;
  fiat_np224_uint1 x377;
  uint32_t x378;
  fiat_np224_uint1 x379;
  uint32_t x380;
  fiat_np224_uint1 x381;
  uint32_t x382;
  fiat_np224_uint1 x383;
  uint32_t x384;
  fiat_np224_uint1 x385;
  uint32_t x386;
  fiat_np224_uint1 x387;
  uint32_t x388;
  fiat_np224_uint1 x389;
  uint32_t x390;
  uint32_t x391;
  uint32_t x392;
  uint32_t x393;
  uint32_t x394;
  uint32_t x395;
  uint32_t x396;
  uint32_t x397;
  uint32_t x398;
  uint32_t x399;
  uint32_t x400;
  uint32_t x401;
  uint32_t x402;
  uint32_t x403;
  uint32_t x404;
  uint32_t x405;
  uint32_t x406;
  fiat_np224_uint1 x407;
  uint32_t x408;
  fiat_np224_uint1 x409;
  uint32_t x410;
  fiat_np224_uint1 x411;
  uint32_t x412;
  fiat_np224_uint1 x413;
  uint32_t x414;
  fiat_np224_uint1 x415;
  uint32_t x416;
  fiat_np224_uint1 x417;
  uint32_t x418;
  uint32_t x419;
  fiat_np224_uint1 x420;
  uint32_t x421;
  fiat_np224_uint1 x422;
  uint32_t x423;
  fiat_np224_uint1 x424;
  uint32_t x425;
  fiat_np224_uint1 x426;
  uint32_t x427;
  fiat_np224_uint1 x428;
  uint32_t x429;
  fiat_np224_uint1 x430;
  uint32_t x431;
  fiat_np224_uint1 x432;
  uint32_t x433;
  fiat_np224_uint1 x434;
  uint32_t x435;
  uint32_t x436;
  uint32_t x437;
  uint32_t x438;
  uint32_t x439;
  uint32_t x440;
  uint32_t x441;
  uint32_t x442;
  uint32_t x443;
  uint32_t x444;
  uint32_t x445;
  uint32_t x446;
  uint32_t x447;
  uint32_t x448;
  uint32_t x449;
  uint32_t x450;
  fiat_np224_uint1 x451;
  uint32_t x452;
  fiat_np224_uint1 x453;
  uint32_t x454;
  fiat_np224_uint1 x455;
  uint32_t x456;
  fiat_np224_uint1 x457;
  uint32_t x458;
  fiat_np224_uint1 x459;
  uint32_t x460;
  fiat_np224_uint1 x461;
  uint32_t x462;
  uint32_t x463;
  fiat_np224_uint1 x464;
  uint32_t x465;
  fiat_np224_uint1 x466;
  uint32_t x467;
  fiat_np224_uint1 x468;
  uint32_t x469;
  fiat_np224_uint1 x470;
  uint32_t x471;
  fiat_np224_uint1 x472;
  uint32_t x473;
  fiat_np224_uint1 x474;
  uint32_t x475;
  fiat_np224_uint1 x476;
  uint32_t x477;
  fiat_np224_uint1 x478;
  uint32_t x479;
  uint32_t x480;
  uint32_t x481;
  uint32_t x482;
  uint32_t x483;
  uint32_t x484;
  uint32_t x485;
  uint32_t x486;
  uint32_t x487;
  uint32_t x488;
  uint32_t x489;
  uint32_t x490;
  uint32_t x491;
  uint32_t x492;
  uint32_t x493;
  uint32_t x494;
  uint32_t x495;
  fiat_np224_uint1 x496;
  uint32_t x497;
  fiat_np224_uint1 x498;
  uint32_t x499;
  fiat_np224_uint1 x500;
  uint32_t x501;
  fiat_np224_uint1 x502;
  uint32_t x503;
  fiat_np224_uint1 x504;
  uint32_t x505;
  fiat_np224_uint1 x506;
  uint32_t x507;
  uint32_t x508;
  fiat_np224_uint1 x509;
  uint32_t x510;
  fiat_np224_uint1 x511;
  uint32_t x512;
  fiat_np224_uint1 x513;
  uint32_t x514;
  fiat_np224_uint1 x515;
  uint32_t x516;
  fiat_np224_uint1 x517;
  uint32_t x518;
  fiat_np224_uint1 x519;
  uint32_t x520;
  fiat_np224_uint1 x521;
  uint32_t x522;
  fiat_np224_uint1 x523;
  uint32_t x524;
  uint32_t x525;
  uint32_t x526;
  uint32_t x527;
  uint32_t x528;
  uint32_t x529;
  uint32_t x530;
  uint32_t x531;
  uint32_t x532;
  uint32_t x533;
  uint32_t x534;
  uint32_t x535;
  uint32_t x536;
  uint32_t x537;
  uint32_t x538;
  uint32_t x539;
  fiat_np224_uint1 x540;
  uint32_t x541;
  fiat_np224_uint1 x542;
  uint32_t x543;
  fiat_np224_uint1 x544;
  uint32_t x545;
  fiat_np224_uint1 x546;
  uint32_t x547;
  fiat_np224_uint1 x548;
  uint32_t x549;
  fiat_np224_uint1 x550;
  uint32_t x551;
  uint32_t x552;
  fiat_np224_uint1 x553;
  uint32_t x554;
  fiat_np224_uint1 x555;
  uint32_t x556;
  fiat_np224_uint1 x557;
  uint32_t x558;
  fiat_np224_uint1 x559;
  uint32_t x560;
  fiat_np224_uint1 x561;
  uint32_t x562;
  fiat_np224_uint1 x563;
  uint32_t x564;
  fiat_np224_uint1 x565;
  uint32_t x566;
  fiat_np224_uint1 x567;
  uint32_t x568;
  uint32_t x569;
  uint32_t x570;
  uint32_t x571;
  uint32_t x572;
  uint32_t x573;
  uint32_t x574;
  uint32_t x575;
  uint32_t x576;
  uint32_t x577;
  uint32_t x578;
  uint32_t x579;
  uint32_t x580;
  uint32_t x581;
  uint32_t x582;
  uint32_t x583;
  uint32_t x584;
  fiat_np224_uint1 x585;
  uint32_t x586;
  fiat_np224_uint1 x587;
  uint32_t x588;
  fiat_np224_uint1 x589;
  uint32_t x590;
  fiat_np224_uint1 x591;
  uint32_t x592;
  fiat_np224_uint1 x593;
  uint32_t x594;
  fiat_np224_uint1 x595;
  uint32_t x596;
  uint32_t x597;
  fiat_np224_uint1 x598;
  uint32_t x599;
  fiat_np224_uint1 x600;
  uint32_t x601;
  fiat_np224_uint1 x602;
  uint32_t x603;
  fiat_np224_uint1 x604;
  uint32_t x605;
  fiat_np224_uint1 x606;
  uint32_t x607;
  fiat_np224_uint1 x608;
  uint32_t x609;
  fiat_np224_uint1 x610;
  uint32_t x611;
  fiat_np224_uint1 x612;
  uint32_t x613;
  uint32_t x614;
  fiat_np224_uint1 x615;
  uint32_t x616;
  fiat_np224_uint1 x617;
  uint32_t x618;
  fiat_np224_uint1 x619;
  uint32_t x620;
  fiat_np224_uint1 x621;
  uint32_t x622;
  fiat_np224_uint1 x623;
  uint32_t x624;
  fiat_np224_uint1 x625;
  uint32_t x626;
  fiat_np224_uint1 x627;
  uint32_t x628;
  fiat_np224_uint1 x629;
  uint32_t x630;
  uint32_t x631;
  uint32_t x632;
  uint32_t x633;
  uint32_t x634;
  uint32_t x635;
  uint32_t x636;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[0]);
  fiat_np224_mulx_u32(&x8, &x9, x7, (arg2[6]));
  fiat_np224_mulx_u32(&x10, &x11, x7, (arg2[5]));
  fiat_np224_mulx_u32(&x12, &x13, x7, (arg2[4]));
  fiat_np224_mulx_u32(&x14, &x15, x7, (arg2[3]));
  fiat_np224_mulx_u32(&x16, &x17, x7, (arg2[2]));
  fiat_np224_mulx_u32(&x18, &x19, x7, (arg2[1]));
  fiat_np224_mulx_u32(&x20, &x21, x7, (arg2[0]));
  fiat_np224_addcarryx_u32(&x22, &x23, 0x0, x21, x18);
  fiat_np224_addcarryx_u32(&x24, &x25, x23, x19, x16);
  fiat_np224_addcarryx_u32(&x26, &x27, x25, x17, x14);
  fiat_np224_addcarryx_u32(&x28, &x29, x27, x15, x12);
  fiat_np224_addcarryx_u32(&x30, &x31, x29, x13, x10);
  fiat_np224_addcarryx_u32(&x32, &x33, x31, x11, x8);
  x34 = (x33 + x9);
  fiat_np224_mulx_u32(&x35, &x36, x20, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x37, &x38, x35, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x39, &x40, x35, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x41, &x42, x35, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x43, &x44, x35, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x45, &x46, x35, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x47, &x48, x35, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x49, &x50, x35, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x51, &x52, 0x0, x50, x47);
  fiat_np224_addcarryx_u32(&x53, &x54, x52, x48, x45);
  fiat_np224_addcarryx_u32(&x55, &x56, x54, x46, x43);
  fiat_np224_addcarryx_u32(&x57, &x58, x56, x44, x41);
  fiat_np224_addcarryx_u32(&x59, &x60, x58, x42, x39);
  fiat_np224_addcarryx_u32(&x61, &x62, x60, x40, x37);
  x63 = (x62 + x38);
  fiat_np224_addcarryx_u32(&x64, &x65, 0x0, x20, x49);
  fiat_np224_addcarryx_u32(&x66, &x67, x65, x22, x51);
  fiat_np224_addcarryx_u32(&x68, &x69, x67, x24, x53);
  fiat_np224_addcarryx_u32(&x70, &x71, x69, x26, x55);
  fiat_np224_addcarryx_u32(&x72, &x73, x71, x28, x57);
  fiat_np224_addcarryx_u32(&x74, &x75, x73, x30, x59);
  fiat_np224_addcarryx_u32(&x76, &x77, x75, x32, x61);
  fiat_np224_addcarryx_u32(&x78, &x79, x77, x34, x63);
  fiat_np224_mulx_u32(&x80, &x81, x1, (arg2[6]));
  fiat_np224_mulx_u32(&x82, &x83, x1, (arg2[5]));
  fiat_np224_mulx_u32(&x84, &x85, x1, (arg2[4]));
  fiat_np224_mulx_u32(&x86, &x87, x1, (arg2[3]));
  fiat_np224_mulx_u32(&x88, &x89, x1, (arg2[2]));
  fiat_np224_mulx_u32(&x90, &x91, x1, (arg2[1]));
  fiat_np224_mulx_u32(&x92, &x93, x1, (arg2[0]));
  fiat_np224_addcarryx_u32(&x94, &x95, 0x0, x93, x90);
  fiat_np224_addcarryx_u32(&x96, &x97, x95, x91, x88);
  fiat_np224_addcarryx_u32(&x98, &x99, x97, x89, x86);
  fiat_np224_addcarryx_u32(&x100, &x101, x99, x87, x84);
  fiat_np224_addcarryx_u32(&x102, &x103, x101, x85, x82);
  fiat_np224_addcarryx_u32(&x104, &x105, x103, x83, x80);
  x106 = (x105 + x81);
  fiat_np224_addcarryx_u32(&x107, &x108, 0x0, x66, x92);
  fiat_np224_addcarryx_u32(&x109, &x110, x108, x68, x94);
  fiat_np224_addcarryx_u32(&x111, &x112, x110, x70, x96);
  fiat_np224_addcarryx_u32(&x113, &x114, x112, x72, x98);
  fiat_np224_addcarryx_u32(&x115, &x116, x114, x74, x100);
  fiat_np224_addcarryx_u32(&x117, &x118, x116, x76, x102);
  fiat_np224_addcarryx_u32(&x119, &x120, x118, x78, x104);
  fiat_np224_addcarryx_u32(&x121, &x122, x120, x79, x106);
  fiat_np224_mulx_u32(&x123, &x124, x107, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x125, &x126, x123, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x127, &x128, x123, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x129, &x130, x123, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x131, &x132, x123, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x133, &x134, x123, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x135, &x136, x123, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x137, &x138, x123, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x139, &x140, 0x0, x138, x135);
  fiat_np224_addcarryx_u32(&x141, &x142, x140, x136, x133);
  fiat_np224_addcarryx_u32(&x143, &x144, x142, x134, x131);
  fiat_np224_addcarryx_u32(&x145, &x146, x144, x132, x129);
  fiat_np224_addcarryx_u32(&x147, &x148, x146, x130, x127);
  fiat_np224_addcarryx_u32(&x149, &x150, x148, x128, x125);
  x151 = (x150 + x126);
  fiat_np224_addcarryx_u32(&x152, &x153, 0x0, x107, x137);
  fiat_np224_addcarryx_u32(&x154, &x155, x153, x109, x139);
  fiat_np224_addcarryx_u32(&x156, &x157, x155, x111, x141);
  fiat_np224_addcarryx_u32(&x158, &x159, x157, x113, x143);
  fiat_np224_addcarryx_u32(&x160, &x161, x159, x115, x145);
  fiat_np224_addcarryx_u32(&x162, &x163, x161, x117, x147);
  fiat_np224_addcarryx_u32(&x164, &x165, x163, x119, x149);
  fiat_np224_addcarryx_u32(&x166, &x167, x165, x121, x151);
  x168 = ((uint32_t)x167 + x122);
  fiat_np224_mulx_u32(&x169, &x170, x2, (arg2[6]));
  fiat_np224_mulx_u32(&x171, &x172, x2, (arg2[5]));
  fiat_np224_mulx_u32(&x173, &x174, x2, (arg2[4]));
  fiat_np224_mulx_u32(&x175, &x176, x2, (arg2[3]));
  fiat_np224_mulx_u32(&x177, &x178, x2, (arg2[2]));
  fiat_np224_mulx_u32(&x179, &x180, x2, (arg2[1]));
  fiat_np224_mulx_u32(&x181, &x182, x2, (arg2[0]));
  fiat_np224_addcarryx_u32(&x183, &x184, 0x0, x182, x179);
  fiat_np224_addcarryx_u32(&x185, &x186, x184, x180, x177);
  fiat_np224_addcarryx_u32(&x187, &x188, x186, x178, x175);
  fiat_np224_addcarryx_u32(&x189, &x190, x188, x176, x173);
  fiat_np224_addcarryx_u32(&x191, &x192, x190, x174, x171);
  fiat_np224_addcarryx_u32(&x193, &x194, x192, x172, x169);
  x195 = (x194 + x170);
  fiat_np224_addcarryx_u32(&x196, &x197, 0x0, x154, x181);
  fiat_np224_addcarryx_u32(&x198, &x199, x197, x156, x183);
  fiat_np224_addcarryx_u32(&x200, &x201, x199, x158, x185);
  fiat_np224_addcarryx_u32(&x202, &x203, x201, x160, x187);
  fiat_np224_addcarryx_u32(&x204, &x205, x203, x162, x189);
  fiat_np224_addcarryx_u32(&x206, &x207, x205, x164, x191);
  fiat_np224_addcarryx_u32(&x208, &x209, x207, x166, x193);
  fiat_np224_addcarryx_u32(&x210, &x211, x209, x168, x195);
  fiat_np224_mulx_u32(&x212, &x213, x196, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x214, &x215, x212, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x216, &x217, x212, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x218, &x219, x212, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x220, &x221, x212, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x222, &x223, x212, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x224, &x225, x212, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x226, &x227, x212, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x228, &x229, 0x0, x227, x224);
  fiat_np224_addcarryx_u32(&x230, &x231, x229, x225, x222);
  fiat_np224_addcarryx_u32(&x232, &x233, x231, x223, x220);
  fiat_np224_addcarryx_u32(&x234, &x235, x233, x221, x218);
  fiat_np224_addcarryx_u32(&x236, &x237, x235, x219, x216);
  fiat_np224_addcarryx_u32(&x238, &x239, x237, x217, x214);
  x240 = (x239 + x215);
  fiat_np224_addcarryx_u32(&x241, &x242, 0x0, x196, x226);
  fiat_np224_addcarryx_u32(&x243, &x244, x242, x198, x228);
  fiat_np224_addcarryx_u32(&x245, &x246, x244, x200, x230);
  fiat_np224_addcarryx_u32(&x247, &x248, x246, x202, x232);
  fiat_np224_addcarryx_u32(&x249, &x250, x248, x204, x234);
  fiat_np224_addcarryx_u32(&x251, &x252, x250, x206, x236);
  fiat_np224_addcarryx_u32(&x253, &x254, x252, x208, x238);
  fiat_np224_addcarryx_u32(&x255, &x256, x254, x210, x240);
  x257 = ((uint32_t)x256 + x211);
  fiat_np224_mulx_u32(&x258, &x259, x3, (arg2[6]));
  fiat_np224_mulx_u32(&x260, &x261, x3, (arg2[5]));
  fiat_np224_mulx_u32(&x262, &x263, x3, (arg2[4]));
  fiat_np224_mulx_u32(&x264, &x265, x3, (arg2[3]));
  fiat_np224_mulx_u32(&x266, &x267, x3, (arg2[2]));
  fiat_np224_mulx_u32(&x268, &x269, x3, (arg2[1]));
  fiat_np224_mulx_u32(&x270, &x271, x3, (arg2[0]));
  fiat_np224_addcarryx_u32(&x272, &x273, 0x0, x271, x268);
  fiat_np224_addcarryx_u32(&x274, &x275, x273, x269, x266);
  fiat_np224_addcarryx_u32(&x276, &x277, x275, x267, x264);
  fiat_np224_addcarryx_u32(&x278, &x279, x277, x265, x262);
  fiat_np224_addcarryx_u32(&x280, &x281, x279, x263, x260);
  fiat_np224_addcarryx_u32(&x282, &x283, x281, x261, x258);
  x284 = (x283 + x259);
  fiat_np224_addcarryx_u32(&x285, &x286, 0x0, x243, x270);
  fiat_np224_addcarryx_u32(&x287, &x288, x286, x245, x272);
  fiat_np224_addcarryx_u32(&x289, &x290, x288, x247, x274);
  fiat_np224_addcarryx_u32(&x291, &x292, x290, x249, x276);
  fiat_np224_addcarryx_u32(&x293, &x294, x292, x251, x278);
  fiat_np224_addcarryx_u32(&x295, &x296, x294, x253, x280);
  fiat_np224_addcarryx_u32(&x297, &x298, x296, x255, x282);
  fiat_np224_addcarryx_u32(&x299, &x300, x298, x257, x284);
  fiat_np224_mulx_u32(&x301, &x302, x285, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x303, &x304, x301, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x305, &x306, x301, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x307, &x308, x301, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x309, &x310, x301, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x311, &x312, x301, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x313, &x314, x301, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x315, &x316, x301, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x317, &x318, 0x0, x316, x313);
  fiat_np224_addcarryx_u32(&x319, &x320, x318, x314, x311);
  fiat_np224_addcarryx_u32(&x321, &x322, x320, x312, x309);
  fiat_np224_addcarryx_u32(&x323, &x324, x322, x310, x307);
  fiat_np224_addcarryx_u32(&x325, &x326, x324, x308, x305);
  fiat_np224_addcarryx_u32(&x327, &x328, x326, x306, x303);
  x329 = (x328 + x304);
  fiat_np224_addcarryx_u32(&x330, &x331, 0x0, x285, x315);
  fiat_np224_addcarryx_u32(&x332, &x333, x331, x287, x317);
  fiat_np224_addcarryx_u32(&x334, &x335, x333, x289, x319);
  fiat_np224_addcarryx_u32(&x336, &x337, x335, x291, x321);
  fiat_np224_addcarryx_u32(&x338, &x339, x337, x293, x323);
  fiat_np224_addcarryx_u32(&x340, &x341, x339, x295, x325);
  fiat_np224_addcarryx_u32(&x342, &x343, x341, x297, x327);
  fiat_np224_addcarryx_u32(&x344, &x345, x343, x299, x329);
  x346 = ((uint32_t)x345 + x300);
  fiat_np224_mulx_u32(&x347, &x348, x4, (arg2[6]));
  fiat_np224_mulx_u32(&x349, &x350, x4, (arg2[5]));
  fiat_np224_mulx_u32(&x351, &x352, x4, (arg2[4]));
  fiat_np224_mulx_u32(&x353, &x354, x4, (arg2[3]));
  fiat_np224_mulx_u32(&x355, &x356, x4, (arg2[2]));
  fiat_np224_mulx_u32(&x357, &x358, x4, (arg2[1]));
  fiat_np224_mulx_u32(&x359, &x360, x4, (arg2[0]));
  fiat_np224_addcarryx_u32(&x361, &x362, 0x0, x360, x357);
  fiat_np224_addcarryx_u32(&x363, &x364, x362, x358, x355);
  fiat_np224_addcarryx_u32(&x365, &x366, x364, x356, x353);
  fiat_np224_addcarryx_u32(&x367, &x368, x366, x354, x351);
  fiat_np224_addcarryx_u32(&x369, &x370, x368, x352, x349);
  fiat_np224_addcarryx_u32(&x371, &x372, x370, x350, x347);
  x373 = (x372 + x348);
  fiat_np224_addcarryx_u32(&x374, &x375, 0x0, x332, x359);
  fiat_np224_addcarryx_u32(&x376, &x377, x375, x334, x361);
  fiat_np224_addcarryx_u32(&x378, &x379, x377, x336, x363);
  fiat_np224_addcarryx_u32(&x380, &x381, x379, x338, x365);
  fiat_np224_addcarryx_u32(&x382, &x383, x381, x340, x367);
  fiat_np224_addcarryx_u32(&x384, &x385, x383, x342, x369);
  fiat_np224_addcarryx_u32(&x386, &x387, x385, x344, x371);
  fiat_np224_addcarryx_u32(&x388, &x389, x387, x346, x373);
  fiat_np224_mulx_u32(&x390, &x391, x374, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x392, &x393, x390, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x394, &x395, x390, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x396, &x397, x390, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x398, &x399, x390, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x400, &x401, x390, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x402, &x403, x390, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x404, &x405, x390, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x406, &x407, 0x0, x405, x402);
  fiat_np224_addcarryx_u32(&x408, &x409, x407, x403, x400);
  fiat_np224_addcarryx_u32(&x410, &x411, x409, x401, x398);
  fiat_np224_addcarryx_u32(&x412, &x413, x411, x399, x396);
  fiat_np224_addcarryx_u32(&x414, &x415, x413, x397, x394);
  fiat_np224_addcarryx_u32(&x416, &x417, x415, x395, x392);
  x418 = (x417 + x393);
  fiat_np224_addcarryx_u32(&x419, &x420, 0x0, x374, x404);
  fiat_np224_addcarryx_u32(&x421, &x422, x420, x376, x406);
  fiat_np224_addcarryx_u32(&x423, &x424, x422, x378, x408);
  fiat_np224_addcarryx_u32(&x425, &x426, x424, x380, x410);
  fiat_np224_addcarryx_u32(&x427, &x428, x426, x382, x412);
  fiat_np224_addcarryx_u32(&x429, &x430, x428, x384, x414);
  fiat_np224_addcarryx_u32(&x431, &x432, x430, x386, x416);
  fiat_np224_addcarryx_u32(&x433, &x434, x432, x388, x418);
  x435 = ((uint32_t)x434 + x389);
  fiat_np224_mulx_u32(&x436, &x437, x5, (arg2[6]));
  fiat_np224_mulx_u32(&x438, &x439, x5, (arg2[5]));
  fiat_np224_mulx_u32(&x440, &x441, x5, (arg2[4]));
  fiat_np224_mulx_u32(&x442, &x443, x5, (arg2[3]));
  fiat_np224_mulx_u32(&x444, &x445, x5, (arg2[2]));
  fiat_np224_mulx_u32(&x446, &x447, x5, (arg2[1]));
  fiat_np224_mulx_u32(&x448, &x449, x5, (arg2[0]));
  fiat_np224_addcarryx_u32(&x450, &x451, 0x0, x449, x446);
  fiat_np224_addcarryx_u32(&x452, &x453, x451, x447, x444);
  fiat_np224_addcarryx_u32(&x454, &x455, x453, x445, x442);
  fiat_np224_addcarryx_u32(&x456, &x457, x455, x443, x440);
  fiat_np224_addcarryx_u32(&x458, &x459, x457, x441, x438);
  fiat_np224_addcarryx_u32(&x460, &x461, x459, x439, x436);
  x462 = (x461 + x437);
  fiat_np224_addcarryx_u32(&x463, &x464, 0x0, x421, x448);
  fiat_np224_addcarryx_u32(&x465, &x466, x464, x423, x450);
  fiat_np224_addcarryx_u32(&x467, &x468, x466, x425, x452);
  fiat_np224_addcarryx_u32(&x469, &x470, x468, x427, x454);
  fiat_np224_addcarryx_u32(&x471, &x472, x470, x429, x456);
  fiat_np224_addcarryx_u32(&x473, &x474, x472, x431, x458);
  fiat_np224_addcarryx_u32(&x475, &x476, x474, x433, x460);
  fiat_np224_addcarryx_u32(&x477, &x478, x476, x435, x462);
  fiat_np224_mulx_u32(&x479, &x480, x463, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x481, &x482, x479, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x483, &x484, x479, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x485, &x486, x479, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x487, &x488, x479, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x489, &x490, x479, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x491, &x492, x479, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x493, &x494, x479, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x495, &x496, 0x0, x494, x491);
  fiat_np224_addcarryx_u32(&x497, &x498, x496, x492, x489);
  fiat_np224_addcarryx_u32(&x499, &x500, x498, x490, x487);
  fiat_np224_addcarryx_u32(&x501, &x502, x500, x488, x485);
  fiat_np224_addcarryx_u32(&x503, &x504, x502, x486, x483);
  fiat_np224_addcarryx_u32(&x505, &x506, x504, x484, x481);
  x507 = (x506 + x482);
  fiat_np224_addcarryx_u32(&x508, &x509, 0x0, x463, x493);
  fiat_np224_addcarryx_u32(&x510, &x511, x509, x465, x495);
  fiat_np224_addcarryx_u32(&x512, &x513, x511, x467, x497);
  fiat_np224_addcarryx_u32(&x514, &x515, x513, x469, x499);
  fiat_np224_addcarryx_u32(&x516, &x517, x515, x471, x501);
  fiat_np224_addcarryx_u32(&x518, &x519, x517, x473, x503);
  fiat_np224_addcarryx_u32(&x520, &x521, x519, x475, x505);
  fiat_np224_addcarryx_u32(&x522, &x523, x521, x477, x507);
  x524 = ((uint32_t)x523 + x478);
  fiat_np224_mulx_u32(&x525, &x526, x6, (arg2[6]));
  fiat_np224_mulx_u32(&x527, &x528, x6, (arg2[5]));
  fiat_np224_mulx_u32(&x529, &x530, x6, (arg2[4]));
  fiat_np224_mulx_u32(&x531, &x532, x6, (arg2[3]));
  fiat_np224_mulx_u32(&x533, &x534, x6, (arg2[2]));
  fiat_np224_mulx_u32(&x535, &x536, x6, (arg2[1]));
  fiat_np224_mulx_u32(&x537, &x538, x6, (arg2[0]));
  fiat_np224_addcarryx_u32(&x539, &x540, 0x0, x538, x535);
  fiat_np224_addcarryx_u32(&x541, &x542, x540, x536, x533);
  fiat_np224_addcarryx_u32(&x543, &x544, x542, x534, x531);
  fiat_np224_addcarryx_u32(&x545, &x546, x544, x532, x529);
  fiat_np224_addcarryx_u32(&x547, &x548, x546, x530, x527);
  fiat_np224_addcarryx_u32(&x549, &x550, x548, x528, x525);
  x551 = (x550 + x526);
  fiat_np224_addcarryx_u32(&x552, &x553, 0x0, x510, x537);
  fiat_np224_addcarryx_u32(&x554, &x555, x553, x512, x539);
  fiat_np224_addcarryx_u32(&x556, &x557, x555, x514, x541);
  fiat_np224_addcarryx_u32(&x558, &x559, x557, x516, x543);
  fiat_np224_addcarryx_u32(&x560, &x561, x559, x518, x545);
  fiat_np224_addcarryx_u32(&x562, &x563, x561, x520, x547);
  fiat_np224_addcarryx_u32(&x564, &x565, x563, x522, x549);
  fiat_np224_addcarryx_u32(&x566, &x567, x565, x524, x551);
  fiat_np224_mulx_u32(&x568, &x569, x552, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x570, &x571, x568, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x572, &x573, x568, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x574, &x575, x568, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x576, &x577, x568, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x578, &x579, x568, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x580, &x581, x568, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x582, &x583, x568, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x584, &x585, 0x0, x583, x580);
  fiat_np224_addcarryx_u32(&x586, &x587, x585, x581, x578);
  fiat_np224_addcarryx_u32(&x588, &x589, x587, x579, x576);
  fiat_np224_addcarryx_u32(&x590, &x591, x589, x577, x574);
  fiat_np224_addcarryx_u32(&x592, &x593, x591, x575, x572);
  fiat_np224_addcarryx_u32(&x594, &x595, x593, x573, x570);
  x596 = (x595 + x571);
  fiat_np224_addcarryx_u32(&x597, &x598, 0x0, x552, x582);
  fiat_np224_addcarryx_u32(&x599, &x600, x598, x554, x584);
  fiat_np224_addcarryx_u32(&x601, &x602, x600, x556, x586);
  fiat_np224_addcarryx_u32(&x603, &x604, x602, x558, x588);
  fiat_np224_addcarryx_u32(&x605, &x606, x604, x560, x590);
  fiat_np224_addcarryx_u32(&x607, &x608, x606, x562, x592);
  fiat_np224_addcarryx_u32(&x609, &x610, x608, x564, x594);
  fiat_np224_addcarryx_u32(&x611, &x612, x610, x566, x596);
  x613 = ((uint32_t)x612 + x567);
  fiat_np224_subborrowx_u32(&x614, &x615, 0x0, x599, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x616, &x617, x615, x601, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x618, &x619, x617, x603, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x620, &x621, x619, x605, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x622, &x623, x621, x607, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x624, &x625, x623, x609, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x626, &x627, x625, x611, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x628, &x629, x627, x613, 0x0);
  fiat_np224_cmovznz_u32(&x630, x629, x614, x599);
  fiat_np224_cmovznz_u32(&x631, x629, x616, x601);
  fiat_np224_cmovznz_u32(&x632, x629, x618, x603);
  fiat_np224_cmovznz_u32(&x633, x629, x620, x605);
  fiat_np224_cmovznz_u32(&x634, x629, x622, x607);
  fiat_np224_cmovznz_u32(&x635, x629, x624, x609);
  fiat_np224_cmovznz_u32(&x636, x629, x626, x611);
  out1[0] = x630;
  out1[1] = x631;
  out1[2] = x632;
  out1[3] = x633;
  out1[4] = x634;
  out1[5] = x635;
  out1[6] = x636;
}

/*
 * The function fiat_np224_add adds two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_add(fiat_np224_montgomery_domain_field_element out1, const fiat_np224_montgomery_domain_field_element arg1, const fiat_np224_montgomery_domain_field_element arg2) {
  uint32_t x1;
  fiat_np224_uint1 x2;
  uint32_t x3;
  fiat_np224_uint1 x4;
  uint32_t x5;
  fiat_np224_uint1 x6;
  uint32_t x7;
  fiat_np224_uint1 x8;
  uint32_t x9;
  fiat_np224_uint1 x10;
  uint32_t x11;
  fiat_np224_uint1 x12;
  uint32_t x13;
  fiat_np224_uint1 x14;
  uint32_t x15;
  fiat_np224_uint1 x16;
  uint32_t x17;
  fiat_np224_uint1 x18;
  uint32_t x19;
  fiat_np224_uint1 x20;
  uint32_t x21;
  fiat_np224_uint1 x22;
  uint32_t x23;
  fiat_np224_uint1 x24;
  uint32_t x25;
  fiat_np224_uint1 x26;
  uint32_t x27;
  fiat_np224_uint1 x28;
  uint32_t x29;
  fiat_np224_uint1 x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  fiat_np224_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_np224_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_np224_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_np224_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_np224_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_np224_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_np224_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  fiat_np224_subborrowx_u32(&x15, &x16, 0x0, x1, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x17, &x18, x16, x3, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x19, &x20, x18, x5, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x21, &x22, x20, x7, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x23, &x24, x22, x9, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x25, &x26, x24, x11, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x27, &x28, x26, x13, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x29, &x30, x28, x14, 0x0);
  fiat_np224_cmovznz_u32(&x31, x30, x15, x1);
  fiat_np224_cmovznz_u32(&x32, x30, x17, x3);
  fiat_np224_cmovznz_u32(&x33, x30, x19, x5);
  fiat_np224_cmovznz_u32(&x34, x30, x21, x7);
  fiat_np224_cmovznz_u32(&x35, x30, x23, x9);
  fiat_np224_cmovznz_u32(&x36, x30, x25, x11);
  fiat_np224_cmovznz_u32(&x37, x30, x27, x13);
  out1[0] = x31;
  out1[1] = x32;
  out1[2] = x33;
  out1[3] = x34;
  out1[4] = x35;
  out1[5] = x36;
  out1[6] = x37;
}

/*
 * The function fiat_np224_opp negates a field element in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_opp(fiat_np224_montgomery_domain_field_element out1, const fiat_np224_montgomery_domain_field_element arg1) {
  uint32_t x1;
  fiat_np224_uint1 x2;
  uint32_t x3;
  fiat_np224_uint1 x4;
  uint32_t x5;
  fiat_np224_uint1 x6;
  uint32_t x7;
  fiat_np224_uint1 x8;
  uint32_t x9;
  fiat_np224_uint1 x10;
  uint32_t x11;
  fiat_np224_uint1 x12;
  uint32_t x13;
  fiat_np224_uint1 x14;
  uint32_t x15;
  uint32_t x16;
  fiat_np224_uint1 x17;
  uint32_t x18;
  fiat_np224_uint1 x19;
  uint32_t x20;
  fiat_np224_uint1 x21;
  uint32_t x22;
  fiat_np224_uint1 x23;
  uint32_t x24;
  fiat_np224_uint1 x25;
  uint32_t x26;
  fiat_np224_uint1 x27;
  uint32_t x28;
  fiat_np224_uint1 x29;
  fiat_np224_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  fiat_np224_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  fiat_np224_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  fiat_np224_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  fiat_np224_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  fiat_np224_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  fiat_np224_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  fiat_np224_cmovznz_u32(&x15, x14, 0x0, UINT32_C(0xffffffff));
  fiat_np224_addcarryx_u32(&x16, &x17, 0x0, x1, (x15 & UINT32_C(0x5c5c2a3d)));
  fiat_np224_addcarryx_u32(&x18, &x19, x17, x3, (x15 & UINT32_C(0x13dd2945)));
  fiat_np224_addcarryx_u32(&x20, &x21, x19, x5, (x15 & UINT32_C(0xe0b8f03e)));
  fiat_np224_addcarryx_u32(&x22, &x23, x21, x7, (x15 & UINT32_C(0xffff16a2)));
  fiat_np224_addcarryx_u32(&x24, &x25, x23, x9, x15);
  fiat_np224_addcarryx_u32(&x26, &x27, x25, x11, x15);
  fiat_np224_addcarryx_u32(&x28, &x29, x27, x13, x15);
  out1[0] = x16;
  out1[1] = x18;
  out1[2] = x20;
  out1[3] = x22;
  out1[4] = x24;
  out1[5] = x26;
  out1[6] = x28;
}

/*
 * The function fiat_np224_from_montgomery translates a field element out of the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^7) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_from_montgomery(fiat_np224_non_montgomery_domain_field_element out1, const fiat_np224_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  fiat_np224_uint1 x19;
  uint32_t x20;
  fiat_np224_uint1 x21;
  uint32_t x22;
  fiat_np224_uint1 x23;
  uint32_t x24;
  fiat_np224_uint1 x25;
  uint32_t x26;
  fiat_np224_uint1 x27;
  uint32_t x28;
  fiat_np224_uint1 x29;
  uint32_t x30;
  fiat_np224_uint1 x31;
  uint32_t x32;
  fiat_np224_uint1 x33;
  uint32_t x34;
  fiat_np224_uint1 x35;
  uint32_t x36;
  fiat_np224_uint1 x37;
  uint32_t x38;
  fiat_np224_uint1 x39;
  uint32_t x40;
  fiat_np224_uint1 x41;
  uint32_t x42;
  fiat_np224_uint1 x43;
  uint32_t x44;
  fiat_np224_uint1 x45;
  uint32_t x46;
  fiat_np224_uint1 x47;
  uint32_t x48;
  fiat_np224_uint1 x49;
  uint32_t x50;
  fiat_np224_uint1 x51;
  uint32_t x52;
  fiat_np224_uint1 x53;
  uint32_t x54;
  fiat_np224_uint1 x55;
  uint32_t x56;
  fiat_np224_uint1 x57;
  uint32_t x58;
  fiat_np224_uint1 x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  fiat_np224_uint1 x77;
  uint32_t x78;
  fiat_np224_uint1 x79;
  uint32_t x80;
  fiat_np224_uint1 x81;
  uint32_t x82;
  fiat_np224_uint1 x83;
  uint32_t x84;
  fiat_np224_uint1 x85;
  uint32_t x86;
  fiat_np224_uint1 x87;
  uint32_t x88;
  fiat_np224_uint1 x89;
  uint32_t x90;
  fiat_np224_uint1 x91;
  uint32_t x92;
  fiat_np224_uint1 x93;
  uint32_t x94;
  fiat_np224_uint1 x95;
  uint32_t x96;
  fiat_np224_uint1 x97;
  uint32_t x98;
  fiat_np224_uint1 x99;
  uint32_t x100;
  fiat_np224_uint1 x101;
  uint32_t x102;
  fiat_np224_uint1 x103;
  uint32_t x104;
  fiat_np224_uint1 x105;
  uint32_t x106;
  fiat_np224_uint1 x107;
  uint32_t x108;
  fiat_np224_uint1 x109;
  uint32_t x110;
  fiat_np224_uint1 x111;
  uint32_t x112;
  fiat_np224_uint1 x113;
  uint32_t x114;
  fiat_np224_uint1 x115;
  uint32_t x116;
  fiat_np224_uint1 x117;
  uint32_t x118;
  uint32_t x119;
  uint32_t x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  fiat_np224_uint1 x135;
  uint32_t x136;
  fiat_np224_uint1 x137;
  uint32_t x138;
  fiat_np224_uint1 x139;
  uint32_t x140;
  fiat_np224_uint1 x141;
  uint32_t x142;
  fiat_np224_uint1 x143;
  uint32_t x144;
  fiat_np224_uint1 x145;
  uint32_t x146;
  fiat_np224_uint1 x147;
  uint32_t x148;
  fiat_np224_uint1 x149;
  uint32_t x150;
  fiat_np224_uint1 x151;
  uint32_t x152;
  fiat_np224_uint1 x153;
  uint32_t x154;
  fiat_np224_uint1 x155;
  uint32_t x156;
  fiat_np224_uint1 x157;
  uint32_t x158;
  fiat_np224_uint1 x159;
  uint32_t x160;
  fiat_np224_uint1 x161;
  uint32_t x162;
  fiat_np224_uint1 x163;
  uint32_t x164;
  fiat_np224_uint1 x165;
  uint32_t x166;
  fiat_np224_uint1 x167;
  uint32_t x168;
  fiat_np224_uint1 x169;
  uint32_t x170;
  fiat_np224_uint1 x171;
  uint32_t x172;
  fiat_np224_uint1 x173;
  uint32_t x174;
  fiat_np224_uint1 x175;
  uint32_t x176;
  uint32_t x177;
  uint32_t x178;
  uint32_t x179;
  uint32_t x180;
  uint32_t x181;
  uint32_t x182;
  uint32_t x183;
  uint32_t x184;
  uint32_t x185;
  uint32_t x186;
  uint32_t x187;
  uint32_t x188;
  uint32_t x189;
  uint32_t x190;
  uint32_t x191;
  uint32_t x192;
  fiat_np224_uint1 x193;
  uint32_t x194;
  fiat_np224_uint1 x195;
  uint32_t x196;
  fiat_np224_uint1 x197;
  uint32_t x198;
  fiat_np224_uint1 x199;
  uint32_t x200;
  fiat_np224_uint1 x201;
  uint32_t x202;
  fiat_np224_uint1 x203;
  uint32_t x204;
  fiat_np224_uint1 x205;
  uint32_t x206;
  fiat_np224_uint1 x207;
  uint32_t x208;
  fiat_np224_uint1 x209;
  uint32_t x210;
  fiat_np224_uint1 x211;
  uint32_t x212;
  fiat_np224_uint1 x213;
  uint32_t x214;
  fiat_np224_uint1 x215;
  uint32_t x216;
  fiat_np224_uint1 x217;
  uint32_t x218;
  fiat_np224_uint1 x219;
  uint32_t x220;
  fiat_np224_uint1 x221;
  uint32_t x222;
  fiat_np224_uint1 x223;
  uint32_t x224;
  fiat_np224_uint1 x225;
  uint32_t x226;
  fiat_np224_uint1 x227;
  uint32_t x228;
  fiat_np224_uint1 x229;
  uint32_t x230;
  fiat_np224_uint1 x231;
  uint32_t x232;
  fiat_np224_uint1 x233;
  uint32_t x234;
  uint32_t x235;
  uint32_t x236;
  uint32_t x237;
  uint32_t x238;
  uint32_t x239;
  uint32_t x240;
  uint32_t x241;
  uint32_t x242;
  uint32_t x243;
  uint32_t x244;
  uint32_t x245;
  uint32_t x246;
  uint32_t x247;
  uint32_t x248;
  uint32_t x249;
  uint32_t x250;
  fiat_np224_uint1 x251;
  uint32_t x252;
  fiat_np224_uint1 x253;
  uint32_t x254;
  fiat_np224_uint1 x255;
  uint32_t x256;
  fiat_np224_uint1 x257;
  uint32_t x258;
  fiat_np224_uint1 x259;
  uint32_t x260;
  fiat_np224_uint1 x261;
  uint32_t x262;
  fiat_np224_uint1 x263;
  uint32_t x264;
  fiat_np224_uint1 x265;
  uint32_t x266;
  fiat_np224_uint1 x267;
  uint32_t x268;
  fiat_np224_uint1 x269;
  uint32_t x270;
  fiat_np224_uint1 x271;
  uint32_t x272;
  fiat_np224_uint1 x273;
  uint32_t x274;
  fiat_np224_uint1 x275;
  uint32_t x276;
  fiat_np224_uint1 x277;
  uint32_t x278;
  fiat_np224_uint1 x279;
  uint32_t x280;
  fiat_np224_uint1 x281;
  uint32_t x282;
  fiat_np224_uint1 x283;
  uint32_t x284;
  fiat_np224_uint1 x285;
  uint32_t x286;
  fiat_np224_uint1 x287;
  uint32_t x288;
  fiat_np224_uint1 x289;
  uint32_t x290;
  fiat_np224_uint1 x291;
  uint32_t x292;
  uint32_t x293;
  uint32_t x294;
  uint32_t x295;
  uint32_t x296;
  uint32_t x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  fiat_np224_uint1 x309;
  uint32_t x310;
  fiat_np224_uint1 x311;
  uint32_t x312;
  fiat_np224_uint1 x313;
  uint32_t x314;
  fiat_np224_uint1 x315;
  uint32_t x316;
  fiat_np224_uint1 x317;
  uint32_t x318;
  fiat_np224_uint1 x319;
  uint32_t x320;
  fiat_np224_uint1 x321;
  uint32_t x322;
  fiat_np224_uint1 x323;
  uint32_t x324;
  fiat_np224_uint1 x325;
  uint32_t x326;
  fiat_np224_uint1 x327;
  uint32_t x328;
  fiat_np224_uint1 x329;
  uint32_t x330;
  fiat_np224_uint1 x331;
  uint32_t x332;
  fiat_np224_uint1 x333;
  uint32_t x334;
  fiat_np224_uint1 x335;
  uint32_t x336;
  fiat_np224_uint1 x337;
  uint32_t x338;
  fiat_np224_uint1 x339;
  uint32_t x340;
  fiat_np224_uint1 x341;
  uint32_t x342;
  fiat_np224_uint1 x343;
  uint32_t x344;
  fiat_np224_uint1 x345;
  uint32_t x346;
  fiat_np224_uint1 x347;
  uint32_t x348;
  fiat_np224_uint1 x349;
  uint32_t x350;
  uint32_t x351;
  uint32_t x352;
  uint32_t x353;
  uint32_t x354;
  uint32_t x355;
  uint32_t x356;
  uint32_t x357;
  uint32_t x358;
  uint32_t x359;
  uint32_t x360;
  uint32_t x361;
  uint32_t x362;
  uint32_t x363;
  uint32_t x364;
  uint32_t x365;
  uint32_t x366;
  fiat_np224_uint1 x367;
  uint32_t x368;
  fiat_np224_uint1 x369;
  uint32_t x370;
  fiat_np224_uint1 x371;
  uint32_t x372;
  fiat_np224_uint1 x373;
  uint32_t x374;
  fiat_np224_uint1 x375;
  uint32_t x376;
  fiat_np224_uint1 x377;
  uint32_t x378;
  fiat_np224_uint1 x379;
  uint32_t x380;
  fiat_np224_uint1 x381;
  uint32_t x382;
  fiat_np224_uint1 x383;
  uint32_t x384;
  fiat_np224_uint1 x385;
  uint32_t x386;
  fiat_np224_uint1 x387;
  uint32_t x388;
  fiat_np224_uint1 x389;
  uint32_t x390;
  fiat_np224_uint1 x391;
  uint32_t x392;
  fiat_np224_uint1 x393;
  uint32_t x394;
  fiat_np224_uint1 x395;
  uint32_t x396;
  fiat_np224_uint1 x397;
  uint32_t x398;
  fiat_np224_uint1 x399;
  uint32_t x400;
  fiat_np224_uint1 x401;
  uint32_t x402;
  fiat_np224_uint1 x403;
  uint32_t x404;
  fiat_np224_uint1 x405;
  uint32_t x406;
  fiat_np224_uint1 x407;
  uint32_t x408;
  fiat_np224_uint1 x409;
  uint32_t x410;
  uint32_t x411;
  uint32_t x412;
  uint32_t x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  x1 = (arg1[0]);
  fiat_np224_mulx_u32(&x2, &x3, x1, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x4, &x5, x2, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x6, &x7, x2, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x8, &x9, x2, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x10, &x11, x2, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x12, &x13, x2, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x14, &x15, x2, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x16, &x17, x2, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x18, &x19, 0x0, x17, x14);
  fiat_np224_addcarryx_u32(&x20, &x21, x19, x15, x12);
  fiat_np224_addcarryx_u32(&x22, &x23, x21, x13, x10);
  fiat_np224_addcarryx_u32(&x24, &x25, x23, x11, x8);
  fiat_np224_addcarryx_u32(&x26, &x27, x25, x9, x6);
  fiat_np224_addcarryx_u32(&x28, &x29, x27, x7, x4);
  fiat_np224_addcarryx_u32(&x30, &x31, 0x0, x1, x16);
  fiat_np224_addcarryx_u32(&x32, &x33, x31, 0x0, x18);
  fiat_np224_addcarryx_u32(&x34, &x35, x33, 0x0, x20);
  fiat_np224_addcarryx_u32(&x36, &x37, x35, 0x0, x22);
  fiat_np224_addcarryx_u32(&x38, &x39, x37, 0x0, x24);
  fiat_np224_addcarryx_u32(&x40, &x41, x39, 0x0, x26);
  fiat_np224_addcarryx_u32(&x42, &x43, x41, 0x0, x28);
  fiat_np224_addcarryx_u32(&x44, &x45, x43, 0x0, (x29 + x5));
  fiat_np224_addcarryx_u32(&x46, &x47, 0x0, x32, (arg1[1]));
  fiat_np224_addcarryx_u32(&x48, &x49, x47, x34, 0x0);
  fiat_np224_addcarryx_u32(&x50, &x51, x49, x36, 0x0);
  fiat_np224_addcarryx_u32(&x52, &x53, x51, x38, 0x0);
  fiat_np224_addcarryx_u32(&x54, &x55, x53, x40, 0x0);
  fiat_np224_addcarryx_u32(&x56, &x57, x55, x42, 0x0);
  fiat_np224_addcarryx_u32(&x58, &x59, x57, x44, 0x0);
  fiat_np224_mulx_u32(&x60, &x61, x46, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x62, &x63, x60, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x64, &x65, x60, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x66, &x67, x60, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x68, &x69, x60, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x70, &x71, x60, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x72, &x73, x60, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x74, &x75, x60, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x76, &x77, 0x0, x75, x72);
  fiat_np224_addcarryx_u32(&x78, &x79, x77, x73, x70);
  fiat_np224_addcarryx_u32(&x80, &x81, x79, x71, x68);
  fiat_np224_addcarryx_u32(&x82, &x83, x81, x69, x66);
  fiat_np224_addcarryx_u32(&x84, &x85, x83, x67, x64);
  fiat_np224_addcarryx_u32(&x86, &x87, x85, x65, x62);
  fiat_np224_addcarryx_u32(&x88, &x89, 0x0, x46, x74);
  fiat_np224_addcarryx_u32(&x90, &x91, x89, x48, x76);
  fiat_np224_addcarryx_u32(&x92, &x93, x91, x50, x78);
  fiat_np224_addcarryx_u32(&x94, &x95, x93, x52, x80);
  fiat_np224_addcarryx_u32(&x96, &x97, x95, x54, x82);
  fiat_np224_addcarryx_u32(&x98, &x99, x97, x56, x84);
  fiat_np224_addcarryx_u32(&x100, &x101, x99, x58, x86);
  fiat_np224_addcarryx_u32(&x102, &x103, x101, ((uint32_t)x59 + x45), (x87 + x63));
  fiat_np224_addcarryx_u32(&x104, &x105, 0x0, x90, (arg1[2]));
  fiat_np224_addcarryx_u32(&x106, &x107, x105, x92, 0x0);
  fiat_np224_addcarryx_u32(&x108, &x109, x107, x94, 0x0);
  fiat_np224_addcarryx_u32(&x110, &x111, x109, x96, 0x0);
  fiat_np224_addcarryx_u32(&x112, &x113, x111, x98, 0x0);
  fiat_np224_addcarryx_u32(&x114, &x115, x113, x100, 0x0);
  fiat_np224_addcarryx_u32(&x116, &x117, x115, x102, 0x0);
  fiat_np224_mulx_u32(&x118, &x119, x104, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x120, &x121, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x122, &x123, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x124, &x125, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x126, &x127, x118, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x128, &x129, x118, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x130, &x131, x118, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x132, &x133, x118, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x134, &x135, 0x0, x133, x130);
  fiat_np224_addcarryx_u32(&x136, &x137, x135, x131, x128);
  fiat_np224_addcarryx_u32(&x138, &x139, x137, x129, x126);
  fiat_np224_addcarryx_u32(&x140, &x141, x139, x127, x124);
  fiat_np224_addcarryx_u32(&x142, &x143, x141, x125, x122);
  fiat_np224_addcarryx_u32(&x144, &x145, x143, x123, x120);
  fiat_np224_addcarryx_u32(&x146, &x147, 0x0, x104, x132);
  fiat_np224_addcarryx_u32(&x148, &x149, x147, x106, x134);
  fiat_np224_addcarryx_u32(&x150, &x151, x149, x108, x136);
  fiat_np224_addcarryx_u32(&x152, &x153, x151, x110, x138);
  fiat_np224_addcarryx_u32(&x154, &x155, x153, x112, x140);
  fiat_np224_addcarryx_u32(&x156, &x157, x155, x114, x142);
  fiat_np224_addcarryx_u32(&x158, &x159, x157, x116, x144);
  fiat_np224_addcarryx_u32(&x160, &x161, x159, ((uint32_t)x117 + x103), (x145 + x121));
  fiat_np224_addcarryx_u32(&x162, &x163, 0x0, x148, (arg1[3]));
  fiat_np224_addcarryx_u32(&x164, &x165, x163, x150, 0x0);
  fiat_np224_addcarryx_u32(&x166, &x167, x165, x152, 0x0);
  fiat_np224_addcarryx_u32(&x168, &x169, x167, x154, 0x0);
  fiat_np224_addcarryx_u32(&x170, &x171, x169, x156, 0x0);
  fiat_np224_addcarryx_u32(&x172, &x173, x171, x158, 0x0);
  fiat_np224_addcarryx_u32(&x174, &x175, x173, x160, 0x0);
  fiat_np224_mulx_u32(&x176, &x177, x162, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x178, &x179, x176, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x180, &x181, x176, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x182, &x183, x176, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x184, &x185, x176, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x186, &x187, x176, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x188, &x189, x176, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x190, &x191, x176, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x192, &x193, 0x0, x191, x188);
  fiat_np224_addcarryx_u32(&x194, &x195, x193, x189, x186);
  fiat_np224_addcarryx_u32(&x196, &x197, x195, x187, x184);
  fiat_np224_addcarryx_u32(&x198, &x199, x197, x185, x182);
  fiat_np224_addcarryx_u32(&x200, &x201, x199, x183, x180);
  fiat_np224_addcarryx_u32(&x202, &x203, x201, x181, x178);
  fiat_np224_addcarryx_u32(&x204, &x205, 0x0, x162, x190);
  fiat_np224_addcarryx_u32(&x206, &x207, x205, x164, x192);
  fiat_np224_addcarryx_u32(&x208, &x209, x207, x166, x194);
  fiat_np224_addcarryx_u32(&x210, &x211, x209, x168, x196);
  fiat_np224_addcarryx_u32(&x212, &x213, x211, x170, x198);
  fiat_np224_addcarryx_u32(&x214, &x215, x213, x172, x200);
  fiat_np224_addcarryx_u32(&x216, &x217, x215, x174, x202);
  fiat_np224_addcarryx_u32(&x218, &x219, x217, ((uint32_t)x175 + x161), (x203 + x179));
  fiat_np224_addcarryx_u32(&x220, &x221, 0x0, x206, (arg1[4]));
  fiat_np224_addcarryx_u32(&x222, &x223, x221, x208, 0x0);
  fiat_np224_addcarryx_u32(&x224, &x225, x223, x210, 0x0);
  fiat_np224_addcarryx_u32(&x226, &x227, x225, x212, 0x0);
  fiat_np224_addcarryx_u32(&x228, &x229, x227, x214, 0x0);
  fiat_np224_addcarryx_u32(&x230, &x231, x229, x216, 0x0);
  fiat_np224_addcarryx_u32(&x232, &x233, x231, x218, 0x0);
  fiat_np224_mulx_u32(&x234, &x235, x220, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x236, &x237, x234, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x238, &x239, x234, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x240, &x241, x234, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x242, &x243, x234, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x244, &x245, x234, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x246, &x247, x234, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x248, &x249, x234, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x250, &x251, 0x0, x249, x246);
  fiat_np224_addcarryx_u32(&x252, &x253, x251, x247, x244);
  fiat_np224_addcarryx_u32(&x254, &x255, x253, x245, x242);
  fiat_np224_addcarryx_u32(&x256, &x257, x255, x243, x240);
  fiat_np224_addcarryx_u32(&x258, &x259, x257, x241, x238);
  fiat_np224_addcarryx_u32(&x260, &x261, x259, x239, x236);
  fiat_np224_addcarryx_u32(&x262, &x263, 0x0, x220, x248);
  fiat_np224_addcarryx_u32(&x264, &x265, x263, x222, x250);
  fiat_np224_addcarryx_u32(&x266, &x267, x265, x224, x252);
  fiat_np224_addcarryx_u32(&x268, &x269, x267, x226, x254);
  fiat_np224_addcarryx_u32(&x270, &x271, x269, x228, x256);
  fiat_np224_addcarryx_u32(&x272, &x273, x271, x230, x258);
  fiat_np224_addcarryx_u32(&x274, &x275, x273, x232, x260);
  fiat_np224_addcarryx_u32(&x276, &x277, x275, ((uint32_t)x233 + x219), (x261 + x237));
  fiat_np224_addcarryx_u32(&x278, &x279, 0x0, x264, (arg1[5]));
  fiat_np224_addcarryx_u32(&x280, &x281, x279, x266, 0x0);
  fiat_np224_addcarryx_u32(&x282, &x283, x281, x268, 0x0);
  fiat_np224_addcarryx_u32(&x284, &x285, x283, x270, 0x0);
  fiat_np224_addcarryx_u32(&x286, &x287, x285, x272, 0x0);
  fiat_np224_addcarryx_u32(&x288, &x289, x287, x274, 0x0);
  fiat_np224_addcarryx_u32(&x290, &x291, x289, x276, 0x0);
  fiat_np224_mulx_u32(&x292, &x293, x278, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x294, &x295, x292, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x296, &x297, x292, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x298, &x299, x292, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x300, &x301, x292, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x302, &x303, x292, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x304, &x305, x292, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x306, &x307, x292, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x308, &x309, 0x0, x307, x304);
  fiat_np224_addcarryx_u32(&x310, &x311, x309, x305, x302);
  fiat_np224_addcarryx_u32(&x312, &x313, x311, x303, x300);
  fiat_np224_addcarryx_u32(&x314, &x315, x313, x301, x298);
  fiat_np224_addcarryx_u32(&x316, &x317, x315, x299, x296);
  fiat_np224_addcarryx_u32(&x318, &x319, x317, x297, x294);
  fiat_np224_addcarryx_u32(&x320, &x321, 0x0, x278, x306);
  fiat_np224_addcarryx_u32(&x322, &x323, x321, x280, x308);
  fiat_np224_addcarryx_u32(&x324, &x325, x323, x282, x310);
  fiat_np224_addcarryx_u32(&x326, &x327, x325, x284, x312);
  fiat_np224_addcarryx_u32(&x328, &x329, x327, x286, x314);
  fiat_np224_addcarryx_u32(&x330, &x331, x329, x288, x316);
  fiat_np224_addcarryx_u32(&x332, &x333, x331, x290, x318);
  fiat_np224_addcarryx_u32(&x334, &x335, x333, ((uint32_t)x291 + x277), (x319 + x295));
  fiat_np224_addcarryx_u32(&x336, &x337, 0x0, x322, (arg1[6]));
  fiat_np224_addcarryx_u32(&x338, &x339, x337, x324, 0x0);
  fiat_np224_addcarryx_u32(&x340, &x341, x339, x326, 0x0);
  fiat_np224_addcarryx_u32(&x342, &x343, x341, x328, 0x0);
  fiat_np224_addcarryx_u32(&x344, &x345, x343, x330, 0x0);
  fiat_np224_addcarryx_u32(&x346, &x347, x345, x332, 0x0);
  fiat_np224_addcarryx_u32(&x348, &x349, x347, x334, 0x0);
  fiat_np224_mulx_u32(&x350, &x351, x336, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x352, &x353, x350, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x354, &x355, x350, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x356, &x357, x350, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x358, &x359, x350, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x360, &x361, x350, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x362, &x363, x350, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x364, &x365, x350, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x366, &x367, 0x0, x365, x362);
  fiat_np224_addcarryx_u32(&x368, &x369, x367, x363, x360);
  fiat_np224_addcarryx_u32(&x370, &x371, x369, x361, x358);
  fiat_np224_addcarryx_u32(&x372, &x373, x371, x359, x356);
  fiat_np224_addcarryx_u32(&x374, &x375, x373, x357, x354);
  fiat_np224_addcarryx_u32(&x376, &x377, x375, x355, x352);
  fiat_np224_addcarryx_u32(&x378, &x379, 0x0, x336, x364);
  fiat_np224_addcarryx_u32(&x380, &x381, x379, x338, x366);
  fiat_np224_addcarryx_u32(&x382, &x383, x381, x340, x368);
  fiat_np224_addcarryx_u32(&x384, &x385, x383, x342, x370);
  fiat_np224_addcarryx_u32(&x386, &x387, x385, x344, x372);
  fiat_np224_addcarryx_u32(&x388, &x389, x387, x346, x374);
  fiat_np224_addcarryx_u32(&x390, &x391, x389, x348, x376);
  fiat_np224_addcarryx_u32(&x392, &x393, x391, ((uint32_t)x349 + x335), (x377 + x353));
  fiat_np224_subborrowx_u32(&x394, &x395, 0x0, x380, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x396, &x397, x395, x382, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x398, &x399, x397, x384, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x400, &x401, x399, x386, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x402, &x403, x401, x388, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x404, &x405, x403, x390, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x406, &x407, x405, x392, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x408, &x409, x407, x393, 0x0);
  fiat_np224_cmovznz_u32(&x410, x409, x394, x380);
  fiat_np224_cmovznz_u32(&x411, x409, x396, x382);
  fiat_np224_cmovznz_u32(&x412, x409, x398, x384);
  fiat_np224_cmovznz_u32(&x413, x409, x400, x386);
  fiat_np224_cmovznz_u32(&x414, x409, x402, x388);
  fiat_np224_cmovznz_u32(&x415, x409, x404, x390);
  fiat_np224_cmovznz_u32(&x416, x409, x406, x392);
  out1[0] = x410;
  out1[1] = x411;
  out1[2] = x412;
  out1[3] = x413;
  out1[4] = x414;
  out1[5] = x415;
  out1[6] = x416;
}

/*
 * The function fiat_np224_to_montgomery translates a field element into the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_to_montgomery(fiat_np224_montgomery_domain_field_element out1, const fiat_np224_non_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  fiat_np224_uint1 x23;
  uint32_t x24;
  fiat_np224_uint1 x25;
  uint32_t x26;
  fiat_np224_uint1 x27;
  uint32_t x28;
  fiat_np224_uint1 x29;
  uint32_t x30;
  fiat_np224_uint1 x31;
  uint32_t x32;
  fiat_np224_uint1 x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint32_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint32_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  uint32_t x50;
  fiat_np224_uint1 x51;
  uint32_t x52;
  fiat_np224_uint1 x53;
  uint32_t x54;
  fiat_np224_uint1 x55;
  uint32_t x56;
  fiat_np224_uint1 x57;
  uint32_t x58;
  fiat_np224_uint1 x59;
  uint32_t x60;
  fiat_np224_uint1 x61;
  uint32_t x62;
  fiat_np224_uint1 x63;
  uint32_t x64;
  fiat_np224_uint1 x65;
  uint32_t x66;
  fiat_np224_uint1 x67;
  uint32_t x68;
  fiat_np224_uint1 x69;
  uint32_t x70;
  fiat_np224_uint1 x71;
  uint32_t x72;
  fiat_np224_uint1 x73;
  uint32_t x74;
  fiat_np224_uint1 x75;
  uint32_t x76;
  fiat_np224_uint1 x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  uint32_t x85;
  uint32_t x86;
  uint32_t x87;
  uint32_t x88;
  uint32_t x89;
  uint32_t x90;
  uint32_t x91;
  uint32_t x92;
  fiat_np224_uint1 x93;
  uint32_t x94;
  fiat_np224_uint1 x95;
  uint32_t x96;
  fiat_np224_uint1 x97;
  uint32_t x98;
  fiat_np224_uint1 x99;
  uint32_t x100;
  fiat_np224_uint1 x101;
  uint32_t x102;
  fiat_np224_uint1 x103;
  uint32_t x104;
  fiat_np224_uint1 x105;
  uint32_t x106;
  fiat_np224_uint1 x107;
  uint32_t x108;
  fiat_np224_uint1 x109;
  uint32_t x110;
  fiat_np224_uint1 x111;
  uint32_t x112;
  fiat_np224_uint1 x113;
  uint32_t x114;
  fiat_np224_uint1 x115;
  uint32_t x116;
  fiat_np224_uint1 x117;
  uint32_t x118;
  uint32_t x119;
  uint32_t x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  fiat_np224_uint1 x135;
  uint32_t x136;
  fiat_np224_uint1 x137;
  uint32_t x138;
  fiat_np224_uint1 x139;
  uint32_t x140;
  fiat_np224_uint1 x141;
  uint32_t x142;
  fiat_np224_uint1 x143;
  uint32_t x144;
  fiat_np224_uint1 x145;
  uint32_t x146;
  fiat_np224_uint1 x147;
  uint32_t x148;
  fiat_np224_uint1 x149;
  uint32_t x150;
  fiat_np224_uint1 x151;
  uint32_t x152;
  fiat_np224_uint1 x153;
  uint32_t x154;
  fiat_np224_uint1 x155;
  uint32_t x156;
  fiat_np224_uint1 x157;
  uint32_t x158;
  fiat_np224_uint1 x159;
  uint32_t x160;
  fiat_np224_uint1 x161;
  uint32_t x162;
  uint32_t x163;
  uint32_t x164;
  uint32_t x165;
  uint32_t x166;
  uint32_t x167;
  uint32_t x168;
  uint32_t x169;
  uint32_t x170;
  uint32_t x171;
  uint32_t x172;
  uint32_t x173;
  uint32_t x174;
  uint32_t x175;
  uint32_t x176;
  fiat_np224_uint1 x177;
  uint32_t x178;
  fiat_np224_uint1 x179;
  uint32_t x180;
  fiat_np224_uint1 x181;
  uint32_t x182;
  fiat_np224_uint1 x183;
  uint32_t x184;
  fiat_np224_uint1 x185;
  uint32_t x186;
  fiat_np224_uint1 x187;
  uint32_t x188;
  fiat_np224_uint1 x189;
  uint32_t x190;
  fiat_np224_uint1 x191;
  uint32_t x192;
  fiat_np224_uint1 x193;
  uint32_t x194;
  fiat_np224_uint1 x195;
  uint32_t x196;
  fiat_np224_uint1 x197;
  uint32_t x198;
  fiat_np224_uint1 x199;
  uint32_t x200;
  fiat_np224_uint1 x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  fiat_np224_uint1 x219;
  uint32_t x220;
  fiat_np224_uint1 x221;
  uint32_t x222;
  fiat_np224_uint1 x223;
  uint32_t x224;
  fiat_np224_uint1 x225;
  uint32_t x226;
  fiat_np224_uint1 x227;
  uint32_t x228;
  fiat_np224_uint1 x229;
  uint32_t x230;
  fiat_np224_uint1 x231;
  uint32_t x232;
  fiat_np224_uint1 x233;
  uint32_t x234;
  fiat_np224_uint1 x235;
  uint32_t x236;
  fiat_np224_uint1 x237;
  uint32_t x238;
  fiat_np224_uint1 x239;
  uint32_t x240;
  fiat_np224_uint1 x241;
  uint32_t x242;
  fiat_np224_uint1 x243;
  uint32_t x244;
  fiat_np224_uint1 x245;
  uint32_t x246;
  uint32_t x247;
  uint32_t x248;
  uint32_t x249;
  uint32_t x250;
  uint32_t x251;
  uint32_t x252;
  uint32_t x253;
  uint32_t x254;
  uint32_t x255;
  uint32_t x256;
  uint32_t x257;
  uint32_t x258;
  uint32_t x259;
  uint32_t x260;
  fiat_np224_uint1 x261;
  uint32_t x262;
  fiat_np224_uint1 x263;
  uint32_t x264;
  fiat_np224_uint1 x265;
  uint32_t x266;
  fiat_np224_uint1 x267;
  uint32_t x268;
  fiat_np224_uint1 x269;
  uint32_t x270;
  fiat_np224_uint1 x271;
  uint32_t x272;
  fiat_np224_uint1 x273;
  uint32_t x274;
  fiat_np224_uint1 x275;
  uint32_t x276;
  fiat_np224_uint1 x277;
  uint32_t x278;
  fiat_np224_uint1 x279;
  uint32_t x280;
  fiat_np224_uint1 x281;
  uint32_t x282;
  fiat_np224_uint1 x283;
  uint32_t x284;
  fiat_np224_uint1 x285;
  uint32_t x286;
  uint32_t x287;
  uint32_t x288;
  uint32_t x289;
  uint32_t x290;
  uint32_t x291;
  uint32_t x292;
  uint32_t x293;
  uint32_t x294;
  uint32_t x295;
  uint32_t x296;
  uint32_t x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  fiat_np224_uint1 x303;
  uint32_t x304;
  fiat_np224_uint1 x305;
  uint32_t x306;
  fiat_np224_uint1 x307;
  uint32_t x308;
  fiat_np224_uint1 x309;
  uint32_t x310;
  fiat_np224_uint1 x311;
  uint32_t x312;
  fiat_np224_uint1 x313;
  uint32_t x314;
  fiat_np224_uint1 x315;
  uint32_t x316;
  fiat_np224_uint1 x317;
  uint32_t x318;
  fiat_np224_uint1 x319;
  uint32_t x320;
  fiat_np224_uint1 x321;
  uint32_t x322;
  fiat_np224_uint1 x323;
  uint32_t x324;
  fiat_np224_uint1 x325;
  uint32_t x326;
  fiat_np224_uint1 x327;
  uint32_t x328;
  fiat_np224_uint1 x329;
  uint32_t x330;
  uint32_t x331;
  uint32_t x332;
  uint32_t x333;
  uint32_t x334;
  uint32_t x335;
  uint32_t x336;
  uint32_t x337;
  uint32_t x338;
  uint32_t x339;
  uint32_t x340;
  uint32_t x341;
  uint32_t x342;
  uint32_t x343;
  uint32_t x344;
  fiat_np224_uint1 x345;
  uint32_t x346;
  fiat_np224_uint1 x347;
  uint32_t x348;
  fiat_np224_uint1 x349;
  uint32_t x350;
  fiat_np224_uint1 x351;
  uint32_t x352;
  fiat_np224_uint1 x353;
  uint32_t x354;
  fiat_np224_uint1 x355;
  uint32_t x356;
  fiat_np224_uint1 x357;
  uint32_t x358;
  fiat_np224_uint1 x359;
  uint32_t x360;
  fiat_np224_uint1 x361;
  uint32_t x362;
  fiat_np224_uint1 x363;
  uint32_t x364;
  fiat_np224_uint1 x365;
  uint32_t x366;
  fiat_np224_uint1 x367;
  uint32_t x368;
  fiat_np224_uint1 x369;
  uint32_t x370;
  uint32_t x371;
  uint32_t x372;
  uint32_t x373;
  uint32_t x374;
  uint32_t x375;
  uint32_t x376;
  uint32_t x377;
  uint32_t x378;
  uint32_t x379;
  uint32_t x380;
  uint32_t x381;
  uint32_t x382;
  uint32_t x383;
  uint32_t x384;
  uint32_t x385;
  uint32_t x386;
  fiat_np224_uint1 x387;
  uint32_t x388;
  fiat_np224_uint1 x389;
  uint32_t x390;
  fiat_np224_uint1 x391;
  uint32_t x392;
  fiat_np224_uint1 x393;
  uint32_t x394;
  fiat_np224_uint1 x395;
  uint32_t x396;
  fiat_np224_uint1 x397;
  uint32_t x398;
  fiat_np224_uint1 x399;
  uint32_t x400;
  fiat_np224_uint1 x401;
  uint32_t x402;
  fiat_np224_uint1 x403;
  uint32_t x404;
  fiat_np224_uint1 x405;
  uint32_t x406;
  fiat_np224_uint1 x407;
  uint32_t x408;
  fiat_np224_uint1 x409;
  uint32_t x410;
  fiat_np224_uint1 x411;
  uint32_t x412;
  fiat_np224_uint1 x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  uint32_t x417;
  uint32_t x418;
  uint32_t x419;
  uint32_t x420;
  uint32_t x421;
  uint32_t x422;
  uint32_t x423;
  uint32_t x424;
  uint32_t x425;
  uint32_t x426;
  uint32_t x427;
  uint32_t x428;
  fiat_np224_uint1 x429;
  uint32_t x430;
  fiat_np224_uint1 x431;
  uint32_t x432;
  fiat_np224_uint1 x433;
  uint32_t x434;
  fiat_np224_uint1 x435;
  uint32_t x436;
  fiat_np224_uint1 x437;
  uint32_t x438;
  fiat_np224_uint1 x439;
  uint32_t x440;
  fiat_np224_uint1 x441;
  uint32_t x442;
  fiat_np224_uint1 x443;
  uint32_t x444;
  fiat_np224_uint1 x445;
  uint32_t x446;
  fiat_np224_uint1 x447;
  uint32_t x448;
  fiat_np224_uint1 x449;
  uint32_t x450;
  fiat_np224_uint1 x451;
  uint32_t x452;
  fiat_np224_uint1 x453;
  uint32_t x454;
  uint32_t x455;
  uint32_t x456;
  uint32_t x457;
  uint32_t x458;
  uint32_t x459;
  uint32_t x460;
  uint32_t x461;
  uint32_t x462;
  uint32_t x463;
  uint32_t x464;
  uint32_t x465;
  uint32_t x466;
  uint32_t x467;
  uint32_t x468;
  uint32_t x469;
  uint32_t x470;
  fiat_np224_uint1 x471;
  uint32_t x472;
  fiat_np224_uint1 x473;
  uint32_t x474;
  fiat_np224_uint1 x475;
  uint32_t x476;
  fiat_np224_uint1 x477;
  uint32_t x478;
  fiat_np224_uint1 x479;
  uint32_t x480;
  fiat_np224_uint1 x481;
  uint32_t x482;
  fiat_np224_uint1 x483;
  uint32_t x484;
  fiat_np224_uint1 x485;
  uint32_t x486;
  fiat_np224_uint1 x487;
  uint32_t x488;
  fiat_np224_uint1 x489;
  uint32_t x490;
  fiat_np224_uint1 x491;
  uint32_t x492;
  fiat_np224_uint1 x493;
  uint32_t x494;
  fiat_np224_uint1 x495;
  uint32_t x496;
  fiat_np224_uint1 x497;
  uint32_t x498;
  uint32_t x499;
  uint32_t x500;
  uint32_t x501;
  uint32_t x502;
  uint32_t x503;
  uint32_t x504;
  uint32_t x505;
  uint32_t x506;
  uint32_t x507;
  uint32_t x508;
  uint32_t x509;
  uint32_t x510;
  uint32_t x511;
  uint32_t x512;
  fiat_np224_uint1 x513;
  uint32_t x514;
  fiat_np224_uint1 x515;
  uint32_t x516;
  fiat_np224_uint1 x517;
  uint32_t x518;
  fiat_np224_uint1 x519;
  uint32_t x520;
  fiat_np224_uint1 x521;
  uint32_t x522;
  fiat_np224_uint1 x523;
  uint32_t x524;
  fiat_np224_uint1 x525;
  uint32_t x526;
  fiat_np224_uint1 x527;
  uint32_t x528;
  fiat_np224_uint1 x529;
  uint32_t x530;
  fiat_np224_uint1 x531;
  uint32_t x532;
  fiat_np224_uint1 x533;
  uint32_t x534;
  fiat_np224_uint1 x535;
  uint32_t x536;
  fiat_np224_uint1 x537;
  uint32_t x538;
  uint32_t x539;
  uint32_t x540;
  uint32_t x541;
  uint32_t x542;
  uint32_t x543;
  uint32_t x544;
  uint32_t x545;
  uint32_t x546;
  uint32_t x547;
  uint32_t x548;
  uint32_t x549;
  uint32_t x550;
  uint32_t x551;
  uint32_t x552;
  uint32_t x553;
  uint32_t x554;
  fiat_np224_uint1 x555;
  uint32_t x556;
  fiat_np224_uint1 x557;
  uint32_t x558;
  fiat_np224_uint1 x559;
  uint32_t x560;
  fiat_np224_uint1 x561;
  uint32_t x562;
  fiat_np224_uint1 x563;
  uint32_t x564;
  fiat_np224_uint1 x565;
  uint32_t x566;
  fiat_np224_uint1 x567;
  uint32_t x568;
  fiat_np224_uint1 x569;
  uint32_t x570;
  fiat_np224_uint1 x571;
  uint32_t x572;
  fiat_np224_uint1 x573;
  uint32_t x574;
  fiat_np224_uint1 x575;
  uint32_t x576;
  fiat_np224_uint1 x577;
  uint32_t x578;
  fiat_np224_uint1 x579;
  uint32_t x580;
  fiat_np224_uint1 x581;
  uint32_t x582;
  fiat_np224_uint1 x583;
  uint32_t x584;
  fiat_np224_uint1 x585;
  uint32_t x586;
  fiat_np224_uint1 x587;
  uint32_t x588;
  fiat_np224_uint1 x589;
  uint32_t x590;
  fiat_np224_uint1 x591;
  uint32_t x592;
  fiat_np224_uint1 x593;
  uint32_t x594;
  fiat_np224_uint1 x595;
  uint32_t x596;
  fiat_np224_uint1 x597;
  uint32_t x598;
  uint32_t x599;
  uint32_t x600;
  uint32_t x601;
  uint32_t x602;
  uint32_t x603;
  uint32_t x604;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[0]);
  fiat_np224_mulx_u32(&x8, &x9, x7, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x10, &x11, x7, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x12, &x13, x7, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x14, &x15, x7, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x16, &x17, x7, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x18, &x19, x7, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x20, &x21, x7, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x22, &x23, 0x0, x21, x18);
  fiat_np224_addcarryx_u32(&x24, &x25, x23, x19, x16);
  fiat_np224_addcarryx_u32(&x26, &x27, x25, x17, x14);
  fiat_np224_addcarryx_u32(&x28, &x29, x27, x15, x12);
  fiat_np224_addcarryx_u32(&x30, &x31, x29, x13, x10);
  fiat_np224_addcarryx_u32(&x32, &x33, x31, x11, x8);
  fiat_np224_mulx_u32(&x34, &x35, x20, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x36, &x37, x34, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x38, &x39, x34, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x40, &x41, x34, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x42, &x43, x34, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x44, &x45, x34, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x46, &x47, x34, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x48, &x49, x34, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x50, &x51, 0x0, x49, x46);
  fiat_np224_addcarryx_u32(&x52, &x53, x51, x47, x44);
  fiat_np224_addcarryx_u32(&x54, &x55, x53, x45, x42);
  fiat_np224_addcarryx_u32(&x56, &x57, x55, x43, x40);
  fiat_np224_addcarryx_u32(&x58, &x59, x57, x41, x38);
  fiat_np224_addcarryx_u32(&x60, &x61, x59, x39, x36);
  fiat_np224_addcarryx_u32(&x62, &x63, 0x0, x20, x48);
  fiat_np224_addcarryx_u32(&x64, &x65, x63, x22, x50);
  fiat_np224_addcarryx_u32(&x66, &x67, x65, x24, x52);
  fiat_np224_addcarryx_u32(&x68, &x69, x67, x26, x54);
  fiat_np224_addcarryx_u32(&x70, &x71, x69, x28, x56);
  fiat_np224_addcarryx_u32(&x72, &x73, x71, x30, x58);
  fiat_np224_addcarryx_u32(&x74, &x75, x73, x32, x60);
  fiat_np224_addcarryx_u32(&x76, &x77, x75, (x33 + x9), (x61 + x37));
  fiat_np224_mulx_u32(&x78, &x79, x1, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x80, &x81, x1, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x82, &x83, x1, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x84, &x85, x1, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x86, &x87, x1, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x88, &x89, x1, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x90, &x91, x1, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x92, &x93, 0x0, x91, x88);
  fiat_np224_addcarryx_u32(&x94, &x95, x93, x89, x86);
  fiat_np224_addcarryx_u32(&x96, &x97, x95, x87, x84);
  fiat_np224_addcarryx_u32(&x98, &x99, x97, x85, x82);
  fiat_np224_addcarryx_u32(&x100, &x101, x99, x83, x80);
  fiat_np224_addcarryx_u32(&x102, &x103, x101, x81, x78);
  fiat_np224_addcarryx_u32(&x104, &x105, 0x0, x64, x90);
  fiat_np224_addcarryx_u32(&x106, &x107, x105, x66, x92);
  fiat_np224_addcarryx_u32(&x108, &x109, x107, x68, x94);
  fiat_np224_addcarryx_u32(&x110, &x111, x109, x70, x96);
  fiat_np224_addcarryx_u32(&x112, &x113, x111, x72, x98);
  fiat_np224_addcarryx_u32(&x114, &x115, x113, x74, x100);
  fiat_np224_addcarryx_u32(&x116, &x117, x115, x76, x102);
  fiat_np224_mulx_u32(&x118, &x119, x104, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x120, &x121, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x122, &x123, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x124, &x125, x118, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x126, &x127, x118, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x128, &x129, x118, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x130, &x131, x118, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x132, &x133, x118, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x134, &x135, 0x0, x133, x130);
  fiat_np224_addcarryx_u32(&x136, &x137, x135, x131, x128);
  fiat_np224_addcarryx_u32(&x138, &x139, x137, x129, x126);
  fiat_np224_addcarryx_u32(&x140, &x141, x139, x127, x124);
  fiat_np224_addcarryx_u32(&x142, &x143, x141, x125, x122);
  fiat_np224_addcarryx_u32(&x144, &x145, x143, x123, x120);
  fiat_np224_addcarryx_u32(&x146, &x147, 0x0, x104, x132);
  fiat_np224_addcarryx_u32(&x148, &x149, x147, x106, x134);
  fiat_np224_addcarryx_u32(&x150, &x151, x149, x108, x136);
  fiat_np224_addcarryx_u32(&x152, &x153, x151, x110, x138);
  fiat_np224_addcarryx_u32(&x154, &x155, x153, x112, x140);
  fiat_np224_addcarryx_u32(&x156, &x157, x155, x114, x142);
  fiat_np224_addcarryx_u32(&x158, &x159, x157, x116, x144);
  fiat_np224_addcarryx_u32(&x160, &x161, x159, (((uint32_t)x117 + x77) + (x103 + x79)), (x145 + x121));
  fiat_np224_mulx_u32(&x162, &x163, x2, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x164, &x165, x2, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x166, &x167, x2, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x168, &x169, x2, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x170, &x171, x2, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x172, &x173, x2, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x174, &x175, x2, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x176, &x177, 0x0, x175, x172);
  fiat_np224_addcarryx_u32(&x178, &x179, x177, x173, x170);
  fiat_np224_addcarryx_u32(&x180, &x181, x179, x171, x168);
  fiat_np224_addcarryx_u32(&x182, &x183, x181, x169, x166);
  fiat_np224_addcarryx_u32(&x184, &x185, x183, x167, x164);
  fiat_np224_addcarryx_u32(&x186, &x187, x185, x165, x162);
  fiat_np224_addcarryx_u32(&x188, &x189, 0x0, x148, x174);
  fiat_np224_addcarryx_u32(&x190, &x191, x189, x150, x176);
  fiat_np224_addcarryx_u32(&x192, &x193, x191, x152, x178);
  fiat_np224_addcarryx_u32(&x194, &x195, x193, x154, x180);
  fiat_np224_addcarryx_u32(&x196, &x197, x195, x156, x182);
  fiat_np224_addcarryx_u32(&x198, &x199, x197, x158, x184);
  fiat_np224_addcarryx_u32(&x200, &x201, x199, x160, x186);
  fiat_np224_mulx_u32(&x202, &x203, x188, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x204, &x205, x202, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x206, &x207, x202, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x208, &x209, x202, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x210, &x211, x202, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x212, &x213, x202, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x214, &x215, x202, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x216, &x217, x202, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x218, &x219, 0x0, x217, x214);
  fiat_np224_addcarryx_u32(&x220, &x221, x219, x215, x212);
  fiat_np224_addcarryx_u32(&x222, &x223, x221, x213, x210);
  fiat_np224_addcarryx_u32(&x224, &x225, x223, x211, x208);
  fiat_np224_addcarryx_u32(&x226, &x227, x225, x209, x206);
  fiat_np224_addcarryx_u32(&x228, &x229, x227, x207, x204);
  fiat_np224_addcarryx_u32(&x230, &x231, 0x0, x188, x216);
  fiat_np224_addcarryx_u32(&x232, &x233, x231, x190, x218);
  fiat_np224_addcarryx_u32(&x234, &x235, x233, x192, x220);
  fiat_np224_addcarryx_u32(&x236, &x237, x235, x194, x222);
  fiat_np224_addcarryx_u32(&x238, &x239, x237, x196, x224);
  fiat_np224_addcarryx_u32(&x240, &x241, x239, x198, x226);
  fiat_np224_addcarryx_u32(&x242, &x243, x241, x200, x228);
  fiat_np224_addcarryx_u32(&x244, &x245, x243, (((uint32_t)x201 + x161) + (x187 + x163)), (x229 + x205));
  fiat_np224_mulx_u32(&x246, &x247, x3, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x248, &x249, x3, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x250, &x251, x3, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x252, &x253, x3, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x254, &x255, x3, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x256, &x257, x3, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x258, &x259, x3, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x260, &x261, 0x0, x259, x256);
  fiat_np224_addcarryx_u32(&x262, &x263, x261, x257, x254);
  fiat_np224_addcarryx_u32(&x264, &x265, x263, x255, x252);
  fiat_np224_addcarryx_u32(&x266, &x267, x265, x253, x250);
  fiat_np224_addcarryx_u32(&x268, &x269, x267, x251, x248);
  fiat_np224_addcarryx_u32(&x270, &x271, x269, x249, x246);
  fiat_np224_addcarryx_u32(&x272, &x273, 0x0, x232, x258);
  fiat_np224_addcarryx_u32(&x274, &x275, x273, x234, x260);
  fiat_np224_addcarryx_u32(&x276, &x277, x275, x236, x262);
  fiat_np224_addcarryx_u32(&x278, &x279, x277, x238, x264);
  fiat_np224_addcarryx_u32(&x280, &x281, x279, x240, x266);
  fiat_np224_addcarryx_u32(&x282, &x283, x281, x242, x268);
  fiat_np224_addcarryx_u32(&x284, &x285, x283, x244, x270);
  fiat_np224_mulx_u32(&x286, &x287, x272, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x288, &x289, x286, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x290, &x291, x286, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x292, &x293, x286, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x294, &x295, x286, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x296, &x297, x286, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x298, &x299, x286, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x300, &x301, x286, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x302, &x303, 0x0, x301, x298);
  fiat_np224_addcarryx_u32(&x304, &x305, x303, x299, x296);
  fiat_np224_addcarryx_u32(&x306, &x307, x305, x297, x294);
  fiat_np224_addcarryx_u32(&x308, &x309, x307, x295, x292);
  fiat_np224_addcarryx_u32(&x310, &x311, x309, x293, x290);
  fiat_np224_addcarryx_u32(&x312, &x313, x311, x291, x288);
  fiat_np224_addcarryx_u32(&x314, &x315, 0x0, x272, x300);
  fiat_np224_addcarryx_u32(&x316, &x317, x315, x274, x302);
  fiat_np224_addcarryx_u32(&x318, &x319, x317, x276, x304);
  fiat_np224_addcarryx_u32(&x320, &x321, x319, x278, x306);
  fiat_np224_addcarryx_u32(&x322, &x323, x321, x280, x308);
  fiat_np224_addcarryx_u32(&x324, &x325, x323, x282, x310);
  fiat_np224_addcarryx_u32(&x326, &x327, x325, x284, x312);
  fiat_np224_addcarryx_u32(&x328, &x329, x327, (((uint32_t)x285 + x245) + (x271 + x247)), (x313 + x289));
  fiat_np224_mulx_u32(&x330, &x331, x4, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x332, &x333, x4, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x334, &x335, x4, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x336, &x337, x4, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x338, &x339, x4, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x340, &x341, x4, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x342, &x343, x4, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x344, &x345, 0x0, x343, x340);
  fiat_np224_addcarryx_u32(&x346, &x347, x345, x341, x338);
  fiat_np224_addcarryx_u32(&x348, &x349, x347, x339, x336);
  fiat_np224_addcarryx_u32(&x350, &x351, x349, x337, x334);
  fiat_np224_addcarryx_u32(&x352, &x353, x351, x335, x332);
  fiat_np224_addcarryx_u32(&x354, &x355, x353, x333, x330);
  fiat_np224_addcarryx_u32(&x356, &x357, 0x0, x316, x342);
  fiat_np224_addcarryx_u32(&x358, &x359, x357, x318, x344);
  fiat_np224_addcarryx_u32(&x360, &x361, x359, x320, x346);
  fiat_np224_addcarryx_u32(&x362, &x363, x361, x322, x348);
  fiat_np224_addcarryx_u32(&x364, &x365, x363, x324, x350);
  fiat_np224_addcarryx_u32(&x366, &x367, x365, x326, x352);
  fiat_np224_addcarryx_u32(&x368, &x369, x367, x328, x354);
  fiat_np224_mulx_u32(&x370, &x371, x356, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x372, &x373, x370, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x374, &x375, x370, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x376, &x377, x370, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x378, &x379, x370, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x380, &x381, x370, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x382, &x383, x370, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x384, &x385, x370, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x386, &x387, 0x0, x385, x382);
  fiat_np224_addcarryx_u32(&x388, &x389, x387, x383, x380);
  fiat_np224_addcarryx_u32(&x390, &x391, x389, x381, x378);
  fiat_np224_addcarryx_u32(&x392, &x393, x391, x379, x376);
  fiat_np224_addcarryx_u32(&x394, &x395, x393, x377, x374);
  fiat_np224_addcarryx_u32(&x396, &x397, x395, x375, x372);
  fiat_np224_addcarryx_u32(&x398, &x399, 0x0, x356, x384);
  fiat_np224_addcarryx_u32(&x400, &x401, x399, x358, x386);
  fiat_np224_addcarryx_u32(&x402, &x403, x401, x360, x388);
  fiat_np224_addcarryx_u32(&x404, &x405, x403, x362, x390);
  fiat_np224_addcarryx_u32(&x406, &x407, x405, x364, x392);
  fiat_np224_addcarryx_u32(&x408, &x409, x407, x366, x394);
  fiat_np224_addcarryx_u32(&x410, &x411, x409, x368, x396);
  fiat_np224_addcarryx_u32(&x412, &x413, x411, (((uint32_t)x369 + x329) + (x355 + x331)), (x397 + x373));
  fiat_np224_mulx_u32(&x414, &x415, x5, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x416, &x417, x5, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x418, &x419, x5, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x420, &x421, x5, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x422, &x423, x5, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x424, &x425, x5, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x426, &x427, x5, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x428, &x429, 0x0, x427, x424);
  fiat_np224_addcarryx_u32(&x430, &x431, x429, x425, x422);
  fiat_np224_addcarryx_u32(&x432, &x433, x431, x423, x420);
  fiat_np224_addcarryx_u32(&x434, &x435, x433, x421, x418);
  fiat_np224_addcarryx_u32(&x436, &x437, x435, x419, x416);
  fiat_np224_addcarryx_u32(&x438, &x439, x437, x417, x414);
  fiat_np224_addcarryx_u32(&x440, &x441, 0x0, x400, x426);
  fiat_np224_addcarryx_u32(&x442, &x443, x441, x402, x428);
  fiat_np224_addcarryx_u32(&x444, &x445, x443, x404, x430);
  fiat_np224_addcarryx_u32(&x446, &x447, x445, x406, x432);
  fiat_np224_addcarryx_u32(&x448, &x449, x447, x408, x434);
  fiat_np224_addcarryx_u32(&x450, &x451, x449, x410, x436);
  fiat_np224_addcarryx_u32(&x452, &x453, x451, x412, x438);
  fiat_np224_mulx_u32(&x454, &x455, x440, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x456, &x457, x454, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x458, &x459, x454, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x460, &x461, x454, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x462, &x463, x454, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x464, &x465, x454, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x466, &x467, x454, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x468, &x469, x454, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x470, &x471, 0x0, x469, x466);
  fiat_np224_addcarryx_u32(&x472, &x473, x471, x467, x464);
  fiat_np224_addcarryx_u32(&x474, &x475, x473, x465, x462);
  fiat_np224_addcarryx_u32(&x476, &x477, x475, x463, x460);
  fiat_np224_addcarryx_u32(&x478, &x479, x477, x461, x458);
  fiat_np224_addcarryx_u32(&x480, &x481, x479, x459, x456);
  fiat_np224_addcarryx_u32(&x482, &x483, 0x0, x440, x468);
  fiat_np224_addcarryx_u32(&x484, &x485, x483, x442, x470);
  fiat_np224_addcarryx_u32(&x486, &x487, x485, x444, x472);
  fiat_np224_addcarryx_u32(&x488, &x489, x487, x446, x474);
  fiat_np224_addcarryx_u32(&x490, &x491, x489, x448, x476);
  fiat_np224_addcarryx_u32(&x492, &x493, x491, x450, x478);
  fiat_np224_addcarryx_u32(&x494, &x495, x493, x452, x480);
  fiat_np224_addcarryx_u32(&x496, &x497, x495, (((uint32_t)x453 + x413) + (x439 + x415)), (x481 + x457));
  fiat_np224_mulx_u32(&x498, &x499, x6, UINT32_C(0xd4baa4cf));
  fiat_np224_mulx_u32(&x500, &x501, x6, UINT32_C(0x1822bc47));
  fiat_np224_mulx_u32(&x502, &x503, x6, UINT32_C(0xb1e97961));
  fiat_np224_mulx_u32(&x504, &x505, x6, UINT32_C(0x6ad09d91));
  fiat_np224_mulx_u32(&x506, &x507, x6, UINT32_C(0x97a54552));
  fiat_np224_mulx_u32(&x508, &x509, x6, UINT32_C(0x6bdaae6c));
  fiat_np224_mulx_u32(&x510, &x511, x6, UINT32_C(0x3ad01289));
  fiat_np224_addcarryx_u32(&x512, &x513, 0x0, x511, x508);
  fiat_np224_addcarryx_u32(&x514, &x515, x513, x509, x506);
  fiat_np224_addcarryx_u32(&x516, &x517, x515, x507, x504);
  fiat_np224_addcarryx_u32(&x518, &x519, x517, x505, x502);
  fiat_np224_addcarryx_u32(&x520, &x521, x519, x503, x500);
  fiat_np224_addcarryx_u32(&x522, &x523, x521, x501, x498);
  fiat_np224_addcarryx_u32(&x524, &x525, 0x0, x484, x510);
  fiat_np224_addcarryx_u32(&x526, &x527, x525, x486, x512);
  fiat_np224_addcarryx_u32(&x528, &x529, x527, x488, x514);
  fiat_np224_addcarryx_u32(&x530, &x531, x529, x490, x516);
  fiat_np224_addcarryx_u32(&x532, &x533, x531, x492, x518);
  fiat_np224_addcarryx_u32(&x534, &x535, x533, x494, x520);
  fiat_np224_addcarryx_u32(&x536, &x537, x535, x496, x522);
  fiat_np224_mulx_u32(&x538, &x539, x524, UINT32_C(0x6a1fc2eb));
  fiat_np224_mulx_u32(&x540, &x541, x538, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x542, &x543, x538, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x544, &x545, x538, UINT32_C(0xffffffff));
  fiat_np224_mulx_u32(&x546, &x547, x538, UINT32_C(0xffff16a2));
  fiat_np224_mulx_u32(&x548, &x549, x538, UINT32_C(0xe0b8f03e));
  fiat_np224_mulx_u32(&x550, &x551, x538, UINT32_C(0x13dd2945));
  fiat_np224_mulx_u32(&x552, &x553, x538, UINT32_C(0x5c5c2a3d));
  fiat_np224_addcarryx_u32(&x554, &x555, 0x0, x553, x550);
  fiat_np224_addcarryx_u32(&x556, &x557, x555, x551, x548);
  fiat_np224_addcarryx_u32(&x558, &x559, x557, x549, x546);
  fiat_np224_addcarryx_u32(&x560, &x561, x559, x547, x544);
  fiat_np224_addcarryx_u32(&x562, &x563, x561, x545, x542);
  fiat_np224_addcarryx_u32(&x564, &x565, x563, x543, x540);
  fiat_np224_addcarryx_u32(&x566, &x567, 0x0, x524, x552);
  fiat_np224_addcarryx_u32(&x568, &x569, x567, x526, x554);
  fiat_np224_addcarryx_u32(&x570, &x571, x569, x528, x556);
  fiat_np224_addcarryx_u32(&x572, &x573, x571, x530, x558);
  fiat_np224_addcarryx_u32(&x574, &x575, x573, x532, x560);
  fiat_np224_addcarryx_u32(&x576, &x577, x575, x534, x562);
  fiat_np224_addcarryx_u32(&x578, &x579, x577, x536, x564);
  fiat_np224_addcarryx_u32(&x580, &x581, x579, (((uint32_t)x537 + x497) + (x523 + x499)), (x565 + x541));
  fiat_np224_subborrowx_u32(&x582, &x583, 0x0, x568, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x584, &x585, x583, x570, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x586, &x587, x585, x572, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x588, &x589, x587, x574, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x590, &x591, x589, x576, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x592, &x593, x591, x578, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x594, &x595, x593, x580, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x596, &x597, x595, x581, 0x0);
  fiat_np224_cmovznz_u32(&x598, x597, x582, x568);
  fiat_np224_cmovznz_u32(&x599, x597, x584, x570);
  fiat_np224_cmovznz_u32(&x600, x597, x586, x572);
  fiat_np224_cmovznz_u32(&x601, x597, x588, x574);
  fiat_np224_cmovznz_u32(&x602, x597, x590, x576);
  fiat_np224_cmovznz_u32(&x603, x597, x592, x578);
  fiat_np224_cmovznz_u32(&x604, x597, x594, x580);
  out1[0] = x598;
  out1[1] = x599;
  out1[2] = x600;
  out1[3] = x601;
  out1[4] = x602;
  out1[5] = x603;
  out1[6] = x604;
}

/*
 * The function fiat_np224_set_one returns the field element one in the Montgomery domain.
 *
 * Postconditions:
 *   eval (from_montgomery out1) mod m = 1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np224_set_one(fiat_np224_montgomery_domain_field_element out1) {
  out1[0] = UINT32_C(0xa3a3d5c3);
  out1[1] = UINT32_C(0xec22d6ba);
  out1[2] = UINT32_C(0x1f470fc1);
  out1[3] = UINT16_C(0xe95d);
  out1[4] = 0x0;
  out1[5] = 0x0;
  out1[6] = 0x0;
}

/*
 * The function fiat_np224_msat returns the saturated representation of the prime modulus.
 *
 * Postconditions:
 *   twos_complement_eval out1 = m
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np224_msat(uint32_t out1[8]) {
  out1[0] = UINT32_C(0x5c5c2a3d);
  out1[1] = UINT32_C(0x13dd2945);
  out1[2] = UINT32_C(0xe0b8f03e);
  out1[3] = UINT32_C(0xffff16a2);
  out1[4] = UINT32_C(0xffffffff);
  out1[5] = UINT32_C(0xffffffff);
  out1[6] = UINT32_C(0xffffffff);
  out1[7] = 0x0;
}

/*
 * The function fiat_np224_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
 *
 * Postconditions:
 *   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np224_divstep_precomp(uint32_t out1[7]) {
  out1[0] = UINT32_C(0xa680ba62);
  out1[1] = UINT32_C(0x56d11323);
  out1[2] = UINT32_C(0x9289274a);
  out1[3] = UINT32_C(0xa334e391);
  out1[4] = UINT32_C(0xef16fedb);
  out1[5] = UINT32_C(0x4704d6d8);
  out1[6] = UINT32_C(0x30476f44);
}

/*
 * The function fiat_np224_divstep computes a divstep.
 *
 * Preconditions:
 *   0 ≤ eval arg4 < m
 *   0 ≤ eval arg5 < m
 * Postconditions:
 *   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
 *   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
 *   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
 *   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
 *   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out2 < m
 *   0 ≤ eval out3 < m
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np224_divstep(uint32_t* out1, uint32_t out2[8], uint32_t out3[8], uint32_t out4[7], uint32_t out5[7], uint32_t arg1, const uint32_t arg2[8], const uint32_t arg3[8], const uint32_t arg4[7], const uint32_t arg5[7]) {
  uint32_t x1;
  fiat_np224_uint1 x2;
  fiat_np224_uint1 x3;
  uint32_t x4;
  fiat_np224_uint1 x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  fiat_np224_uint1 x16;
  uint32_t x17;
  fiat_np224_uint1 x18;
  uint32_t x19;
  fiat_np224_uint1 x20;
  uint32_t x21;
  fiat_np224_uint1 x22;
  uint32_t x23;
  fiat_np224_uint1 x24;
  uint32_t x25;
  fiat_np224_uint1 x26;
  uint32_t x27;
  fiat_np224_uint1 x28;
  uint32_t x29;
  fiat_np224_uint1 x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint32_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint32_t x44;
  uint32_t x45;
  uint32_t x46;
  fiat_np224_uint1 x47;
  uint32_t x48;
  fiat_np224_uint1 x49;
  uint32_t x50;
  fiat_np224_uint1 x51;
  uint32_t x52;
  fiat_np224_uint1 x53;
  uint32_t x54;
  fiat_np224_uint1 x55;
  uint32_t x56;
  fiat_np224_uint1 x57;
  uint32_t x58;
  fiat_np224_uint1 x59;
  uint32_t x60;
  fiat_np224_uint1 x61;
  uint32_t x62;
  fiat_np224_uint1 x63;
  uint32_t x64;
  fiat_np224_uint1 x65;
  uint32_t x66;
  fiat_np224_uint1 x67;
  uint32_t x68;
  fiat_np224_uint1 x69;
  uint32_t x70;
  fiat_np224_uint1 x71;
  uint32_t x72;
  fiat_np224_uint1 x73;
  uint32_t x74;
  fiat_np224_uint1 x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  fiat_np224_uint1 x84;
  uint32_t x85;
  fiat_np224_uint1 x86;
  uint32_t x87;
  fiat_np224_uint1 x88;
  uint32_t x89;
  fiat_np224_uint1 x90;
  uint32_t x91;
  fiat_np224_uint1 x92;
  uint32_t x93;
  fiat_np224_uint1 x94;
  uint32_t x95;
  fiat_np224_uint1 x96;
  uint32_t x97;
  uint32_t x98;
  fiat_np224_uint1 x99;
  uint32_t x100;
  fiat_np224_uint1 x101;
  uint32_t x102;
  fiat_np224_uint1 x103;
  uint32_t x104;
  fiat_np224_uint1 x105;
  uint32_t x106;
  fiat_np224_uint1 x107;
  uint32_t x108;
  fiat_np224_uint1 x109;
  uint32_t x110;
  fiat_np224_uint1 x111;
  uint32_t x112;
  uint32_t x113;
  uint32_t x114;
  uint32_t x115;
  uint32_t x116;
  uint32_t x117;
  uint32_t x118;
  fiat_np224_uint1 x119;
  uint32_t x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  fiat_np224_uint1 x129;
  uint32_t x130;
  fiat_np224_uint1 x131;
  uint32_t x132;
  fiat_np224_uint1 x133;
  uint32_t x134;
  fiat_np224_uint1 x135;
  uint32_t x136;
  fiat_np224_uint1 x137;
  uint32_t x138;
  fiat_np224_uint1 x139;
  uint32_t x140;
  fiat_np224_uint1 x141;
  uint32_t x142;
  fiat_np224_uint1 x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  uint32_t x148;
  uint32_t x149;
  uint32_t x150;
  uint32_t x151;
  fiat_np224_uint1 x152;
  uint32_t x153;
  fiat_np224_uint1 x154;
  uint32_t x155;
  fiat_np224_uint1 x156;
  uint32_t x157;
  fiat_np224_uint1 x158;
  uint32_t x159;
  fiat_np224_uint1 x160;
  uint32_t x161;
  fiat_np224_uint1 x162;
  uint32_t x163;
  fiat_np224_uint1 x164;
  uint32_t x165;
  fiat_np224_uint1 x166;
  uint32_t x167;
  fiat_np224_uint1 x168;
  uint32_t x169;
  fiat_np224_uint1 x170;
  uint32_t x171;
  fiat_np224_uint1 x172;
  uint32_t x173;
  fiat_np224_uint1 x174;
  uint32_t x175;
  fiat_np224_uint1 x176;
  uint32_t x177;
  fiat_np224_uint1 x178;
  uint32_t x179;
  fiat_np224_uint1 x180;
  uint32_t x181;
  fiat_np224_uint1 x182;
  uint32_t x183;
  uint32_t x184;
  uint32_t x185;
  uint32_t x186;
  uint32_t x187;
  uint32_t x188;
  uint32_t x189;
  uint32_t x190;
  uint32_t x191;
  uint32_t x192;
  uint32_t x193;
  uint32_t x194;
  uint32_t x195;
  uint32_t x196;
  uint32_t x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  fiat_np224_addcarryx_u32(&x1, &x2, 0x0, (~arg1), 0x1);
  x3 = (fiat_np224_uint1)((fiat_np224_uint1)(x1 >> 31) & (fiat_np224_uint1)((arg3[0]) & 0x1));
  fiat_np224_addcarryx_u32(&x4, &x5, 0x0, (~arg1), 0x1);
  fiat_np224_cmovznz_u32(&x6, x3, arg1, x4);
  fiat_np224_cmovznz_u32(&x7, x3, (arg2[0]), (arg3[0]));
  fiat_np224_cmovznz_u32(&x8, x3, (arg2[1]), (arg3[1]));
  fiat_np224_cmovznz_u32(&x9, x3, (arg2[2]), (arg3[2]));
  fiat_np224_cmovznz_u32(&x10, x3, (arg2[3]), (arg3[3]));
  fiat_np224_cmovznz_u32(&x11, x3, (arg2[4]), (arg3[4]));
  fiat_np224_cmovznz_u32(&x12, x3, (arg2[5]), (arg3[5]));
  fiat_np224_cmovznz_u32(&x13, x3, (arg2[6]), (arg3[6]));
  fiat_np224_cmovznz_u32(&x14, x3, (arg2[7]), (arg3[7]));
  fiat_np224_addcarryx_u32(&x15, &x16, 0x0, 0x1, (~(arg2[0])));
  fiat_np224_addcarryx_u32(&x17, &x18, x16, 0x0, (~(arg2[1])));
  fiat_np224_addcarryx_u32(&x19, &x20, x18, 0x0, (~(arg2[2])));
  fiat_np224_addcarryx_u32(&x21, &x22, x20, 0x0, (~(arg2[3])));
  fiat_np224_addcarryx_u32(&x23, &x24, x22, 0x0, (~(arg2[4])));
  fiat_np224_addcarryx_u32(&x25, &x26, x24, 0x0, (~(arg2[5])));
  fiat_np224_addcarryx_u32(&x27, &x28, x26, 0x0, (~(arg2[6])));
  fiat_np224_addcarryx_u32(&x29, &x30, x28, 0x0, (~(arg2[7])));
  fiat_np224_cmovznz_u32(&x31, x3, (arg3[0]), x15);
  fiat_np224_cmovznz_u32(&x32, x3, (arg3[1]), x17);
  fiat_np224_cmovznz_u32(&x33, x3, (arg3[2]), x19);
  fiat_np224_cmovznz_u32(&x34, x3, (arg3[3]), x21);
  fiat_np224_cmovznz_u32(&x35, x3, (arg3[4]), x23);
  fiat_np224_cmovznz_u32(&x36, x3, (arg3[5]), x25);
  fiat_np224_cmovznz_u32(&x37, x3, (arg3[6]), x27);
  fiat_np224_cmovznz_u32(&x38, x3, (arg3[7]), x29);
  fiat_np224_cmovznz_u32(&x39, x3, (arg4[0]), (arg5[0]));
  fiat_np224_cmovznz_u32(&x40, x3, (arg4[1]), (arg5[1]));
  fiat_np224_cmovznz_u32(&x41, x3, (arg4[2]), (arg5[2]));
  fiat_np224_cmovznz_u32(&x42, x3, (arg4[3]), (arg5[3]));
  fiat_np224_cmovznz_u32(&x43, x3, (arg4[4]), (arg5[4]));
  fiat_np224_cmovznz_u32(&x44, x3, (arg4[5]), (arg5[5]));
  fiat_np224_cmovznz_u32(&x45, x3, (arg4[6]), (arg5[6]));
  fiat_np224_addcarryx_u32(&x46, &x47, 0x0, x39, x39);
  fiat_np224_addcarryx_u32(&x48, &x49, x47, x40, x40);
  fiat_np224_addcarryx_u32(&x50, &x51, x49, x41, x41);
  fiat_np224_addcarryx_u32(&x52, &x53, x51, x42, x42);
  fiat_np224_addcarryx_u32(&x54, &x55, x53, x43, x43);
  fiat_np224_addcarryx_u32(&x56, &x57, x55, x44, x44);
  fiat_np224_addcarryx_u32(&x58, &x59, x57, x45, x45);
  fiat_np224_subborrowx_u32(&x60, &x61, 0x0, x46, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x62, &x63, x61, x48, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x64, &x65, x63, x50, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x66, &x67, x65, x52, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x68, &x69, x67, x54, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x70, &x71, x69, x56, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x72, &x73, x71, x58, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x74, &x75, x73, x59, 0x0);
  x76 = (arg4[6]);
  x77 = (arg4[5]);
  x78 = (arg4[4]);
  x79 = (arg4[3]);
  x80 = (arg4[2]);
  x81 = (arg4[1]);
  x82 = (arg4[0]);
  fiat_np224_subborrowx_u32(&x83, &x84, 0x0, 0x0, x82);
  fiat_np224_subborrowx_u32(&x85, &x86, x84, 0x0, x81);
  fiat_np224_subborrowx_u32(&x87, &x88, x86, 0x0, x80);
  fiat_np224_subborrowx_u32(&x89, &x90, x88, 0x0, x79);
  fiat_np224_subborrowx_u32(&x91, &x92, x90, 0x0, x78);
  fiat_np224_subborrowx_u32(&x93, &x94, x92, 0x0, x77);
  fiat_np224_subborrowx_u32(&x95, &x96, x94, 0x0, x76);
  fiat_np224_cmovznz_u32(&x97, x96, 0x0, UINT32_C(0xffffffff));
  fiat_np224_addcarryx_u32(&x98, &x99, 0x0, x83, (x97 & UINT32_C(0x5c5c2a3d)));
  fiat_np224_addcarryx_u32(&x100, &x101, x99, x85, (x97 & UINT32_C(0x13dd2945)));
  fiat_np224_addcarryx_u32(&x102, &x103, x101, x87, (x97 & UINT32_C(0xe0b8f03e)));
  fiat_np224_addcarryx_u32(&x104, &x105, x103, x89, (x97 & UINT32_C(0xffff16a2)));
  fiat_np224_addcarryx_u32(&x106, &x107, x105, x91, x97);
  fiat_np224_addcarryx_u32(&x108, &x109, x107, x93, x97);
  fiat_np224_addcarryx_u32(&x110, &x111, x109, x95, x97);
  fiat_np224_cmovznz_u32(&x112, x3, (arg5[0]), x98);
  fiat_np224_cmovznz_u32(&x113, x3, (arg5[1]), x100);
  fiat_np224_cmovznz_u32(&x114, x3, (arg5[2]), x102);
  fiat_np224_cmovznz_u32(&x115, x3, (arg5[3]), x104);
  fiat_np224_cmovznz_u32(&x116, x3, (arg5[4]), x106);
  fiat_np224_cmovznz_u32(&x117, x3, (arg5[5]), x108);
  fiat_np224_cmovznz_u32(&x118, x3, (arg5[6]), x110);
  x119 = (fiat_np224_uint1)(x31 & 0x1);
  fiat_np224_cmovznz_u32(&x120, x119, 0x0, x7);
  fiat_np224_cmovznz_u32(&x121, x119, 0x0, x8);
  fiat_np224_cmovznz_u32(&x122, x119, 0x0, x9);
  fiat_np224_cmovznz_u32(&x123, x119, 0x0, x10);
  fiat_np224_cmovznz_u32(&x124, x119, 0x0, x11);
  fiat_np224_cmovznz_u32(&x125, x119, 0x0, x12);
  fiat_np224_cmovznz_u32(&x126, x119, 0x0, x13);
  fiat_np224_cmovznz_u32(&x127, x119, 0x0, x14);
  fiat_np224_addcarryx_u32(&x128, &x129, 0x0, x31, x120);
  fiat_np224_addcarryx_u32(&x130, &x131, x129, x32, x121);
  fiat_np224_addcarryx_u32(&x132, &x133, x131, x33, x122);
  fiat_np224_addcarryx_u32(&x134, &x135, x133, x34, x123);
  fiat_np224_addcarryx_u32(&x136, &x137, x135, x35, x124);
  fiat_np224_addcarryx_u32(&x138, &x139, x137, x36, x125);
  fiat_np224_addcarryx_u32(&x140, &x141, x139, x37, x126);
  fiat_np224_addcarryx_u32(&x142, &x143, x141, x38, x127);
  fiat_np224_cmovznz_u32(&x144, x119, 0x0, x39);
  fiat_np224_cmovznz_u32(&x145, x119, 0x0, x40);
  fiat_np224_cmovznz_u32(&x146, x119, 0x0, x41);
  fiat_np224_cmovznz_u32(&x147, x119, 0x0, x42);
  fiat_np224_cmovznz_u32(&x148, x119, 0x0, x43);
  fiat_np224_cmovznz_u32(&x149, x119, 0x0, x44);
  fiat_np224_cmovznz_u32(&x150, x119, 0x0, x45);
  fiat_np224_addcarryx_u32(&x151, &x152, 0x0, x112, x144);
  fiat_np224_addcarryx_u32(&x153, &x154, x152, x113, x145);
  fiat_np224_addcarryx_u32(&x155, &x156, x154, x114, x146);
  fiat_np224_addcarryx_u32(&x157, &x158, x156, x115, x147);
  fiat_np224_addcarryx_u32(&x159, &x160, x158, x116, x148);
  fiat_np224_addcarryx_u32(&x161, &x162, x160, x117, x149);
  fiat_np224_addcarryx_u32(&x163, &x164, x162, x118, x150);
  fiat_np224_subborrowx_u32(&x165, &x166, 0x0, x151, UINT32_C(0x5c5c2a3d));
  fiat_np224_subborrowx_u32(&x167, &x168, x166, x153, UINT32_C(0x13dd2945));
  fiat_np224_subborrowx_u32(&x169, &x170, x168, x155, UINT32_C(0xe0b8f03e));
  fiat_np224_subborrowx_u32(&x171, &x172, x170, x157, UINT32_C(0xffff16a2));
  fiat_np224_subborrowx_u32(&x173, &x174, x172, x159, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x175, &x176, x174, x161, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x177, &x178, x176, x163, UINT32_C(0xffffffff));
  fiat_np224_subborrowx_u32(&x179, &x180, x178, x164, 0x0);
  fiat_np224_addcarryx_u32(&x181, &x182, 0x0, x6, 0x1);
  x183 = ((x128 >> 1) | ((x130 << 31) & UINT32_C(0xffffffff)));
  x184 = ((x130 >> 1) | ((x132 << 31) & UINT32_C(0xffffffff)));
  x185 = ((x132 >> 1) | ((x134 << 31) & UINT32_C(0xffffffff)));
  x186 = ((x134 >> 1) | ((x136 << 31) & UINT32_C(0xffffffff)));
  x187 = ((x136 >> 1) | ((x138 << 31) & UINT32_C(0xffffffff)));
  x188 = ((x138 >> 1) | ((x140 << 31) & UINT32_C(0xffffffff)));
  x189 = ((x140 >> 1) | ((x142 << 31) & UINT32_C(0xffffffff)));
  x190 = ((x142 & UINT32_C(0x80000000)) | (x142 >> 1));
  fiat_np224_cmovznz_u32(&x191, x75, x60, x46);
  fiat_np224_cmovznz_u32(&x192, x75, x62, x48);
  fiat_np224_cmovznz_u32(&x193, x75, x64, x50);
  fiat_np224_cmovznz_u32(&x194, x75, x66, x52);
  fiat_np224_cmovznz_u32(&x195, x75, x68, x54);
  fiat_np224_cmovznz_u32(&x196, x75, x70, x56);
  fiat_np224_cmovznz_u32(&x197, x75, x72, x58);
  fiat_np224_cmovznz_u32(&x198, x180, x165, x151);
  fiat_np224_cmovznz_u32(&x199, x180, x167, x153);
  fiat_np224_cmovznz_u32(&x200, x180, x169, x155);
  fiat_np224_cmovznz_u32(&x201, x180, x171, x157);
  fiat_np224_cmovznz_u32(&x202, x180, x173, x159);
  fiat_np224_cmovznz_u32(&x203, x180, x175, x161);
  fiat_np224_cmovznz_u32(&x204, x180, x177, x163);
  *out1 = x181;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out3[0] = x183;
  out3[1] = x184;
  out3[2] = x185;
  out3[3] = x186;
  out3[4] = x187;
  out3[5] = x188;
  out3[6] = x189;
  out3[7] = x190;
  out4[0] = x191;
  out4[1] = x192;
  out4[2] = x193;
  out4[3] = x194;
  out4[4] = x195;
  out4[5] = x196;
  out4[6] = x197;
  out5[0] = x198;
  out5[1] = x199;
  out5[2] = x200;
  out5[3] = x201;
  out5[4] = x202;
  out5[5] = x203;
  out5[6] = x204;
}

/*
 * The function fiat_np224_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..27]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_np224_to_bytes(uint8_t out1[28], const uint32_t arg1[7]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint8_t x8;
  uint32_t x9;
  uint8_t x10;
  uint32_t x11;
  uint8_t x12;
  uint8_t x13;
  uint8_t x14;
  uint32_t x15;
  uint8_t x16;
  uint32_t x17;
  uint8_t x18;
  uint8_t x19;
  uint8_t x20;
  uint32_t x21;
  uint8_t x22;
  uint32_t x23;
  uint8_t x24;
  uint8_t x25;
  uint8_t x26;
  uint32_t x27;
  uint8_t x28;
  uint32_t x29;
  uint8_t x30;
  uint8_t x31;
  uint8_t x32;
  uint32_t x33;
  uint8_t x34;
  uint32_t x35;
  uint8_t x36;
  uint8_t x37;
  uint8_t x38;
  uint32_t x39;
  uint8_t x40;
  uint32_t x41;
  uint8_t x42;
  uint8_t x43;
  uint8_t x44;
  uint32_t x45;
  uint8_t x46;
  uint32_t x47;
  uint8_t x48;
  uint8_t x49;
  x1 = (arg1[6]);
  x2 = (arg1[5]);
  x3 = (arg1[4]);
  x4 = (arg1[3]);
  x5 = (arg1[2]);
  x6 = (arg1[1]);
  x7 = (arg1[0]);
  x8 = (uint8_t)(x7 & UINT8_C(0xff));
  x9 = (x7 >> 8);
  x10 = (uint8_t)(x9 & UINT8_C(0xff));
  x11 = (x9 >> 8);
  x12 = (uint8_t)(x11 & UINT8_C(0xff));
  x13 = (uint8_t)(x11 >> 8);
  x14 = (uint8_t)(x6 & UINT8_C(0xff));
  x15 = (x6 >> 8);
  x16 = (uint8_t)(x15 & UINT8_C(0xff));
  x17 = (x15 >> 8);
  x18 = (uint8_t)(x17 & UINT8_C(0xff));
  x19 = (uint8_t)(x17 >> 8);
  x20 = (uint8_t)(x5 & UINT8_C(0xff));
  x21 = (x5 >> 8);
  x22 = (uint8_t)(x21 & UINT8_C(0xff));
  x23 = (x21 >> 8);
  x24 = (uint8_t)(x23 & UINT8_C(0xff));
  x25 = (uint8_t)(x23 >> 8);
  x26 = (uint8_t)(x4 & UINT8_C(0xff));
  x27 = (x4 >> 8);
  x28 = (uint8_t)(x27 & UINT8_C(0xff));
  x29 = (x27 >> 8);
  x30 = (uint8_t)(x29 & UINT8_C(0xff));
  x31 = (uint8_t)(x29 >> 8);
  x32 = (uint8_t)(x3 & UINT8_C(0xff));
  x33 = (x3 >> 8);
  x34 = (uint8_t)(x33 & UINT8_C(0xff));
  x35 = (x33 >> 8);
  x36 = (uint8_t)(x35 & UINT8_C(0xff));
  x37 = (uint8_t)(x35 >> 8);
  x38 = (uint8_t)(x2 & UINT8_C(0xff));
  x39 = (x2 >> 8);
  x40 = (uint8_t)(x39 & UINT8_C(0xff));
  x41 = (x39 >> 8);
  x42 = (uint8_t)(x41 & UINT8_C(0xff));
  x43 = (uint8_t)(x41 >> 8);
  x44 = (uint8_t)(x1 & UINT8_C(0xff));
  x45 = (x1 >> 8);
  x46 = (uint8_t)(x45 & UINT8_C(0xff));
  x47 = (x45 >> 8);
  x48 = (uint8_t)(x47 & UINT8_C(0xff));
  x49 = (uint8_t)(x47 >> 8);
  out1[0] = x8;
  out1[1] = x10;
  out1[2] = x12;
  out1[3] = x13;
  out1[4] = x14;
  out1[5] = x16;
  out1[6] = x18;
  out1[7] = x19;
  out1[8] = x20;
  out1[9] = x22;
  out1[10] = x24;
  out1[11] = x25;
  out1[12] = x26;
  out1[13] = x28;
  out1[14] = x30;
  out1[15] = x31;
  out1[16] = x32;
  out1[17] = x34;
  out1[18] = x36;
  out1[19] = x37;
  out1[20] = x38;
  out1[21] = x40;
  out1[22] = x42;
  out1[23] = x43;
  out1[24] = x44;
  out1[25] = x46;
  out1[26] = x48;
  out1[27] = x49;
}

/*
 * The function fiat_np224_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np224_from_bytes(uint32_t out1[7], const uint8_t arg1[28]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint8_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint8_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint8_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint8_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint8_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint8_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint8_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint32_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint32_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  x1 = ((uint32_t)(arg1[27]) << 24);
  x2 = ((uint32_t)(arg1[26]) << 16);
  x3 = ((uint32_t)(arg1[25]) << 8);
  x4 = (arg1[24]);
  x5 = ((uint32_t)(arg1[23]) << 24);
  x6 = ((uint32_t)(arg1[22]) << 16);
  x7 = ((uint32_t)(arg1[21]) << 8);
  x8 = (arg1[20]);
  x9 = ((uint32_t)(arg1[19]) << 24);
  x10 = ((uint32_t)(arg1[18]) << 16);
  x11 = ((uint32_t)(arg1[17]) << 8);
  x12 = (arg1[16]);
  x13 = ((uint32_t)(arg1[15]) << 24);
  x14 = ((uint32_t)(arg1[14]) << 16);
  x15 = ((uint32_t)(arg1[13]) << 8);
  x16 = (arg1[12]);
  x17 = ((uint32_t)(arg1[11]) << 24);
  x18 = ((uint32_t)(arg1[10]) << 16);
  x19 = ((uint32_t)(arg1[9]) << 8);
  x20 = (arg1[8]);
  x21 = ((uint32_t)(arg1[7]) << 24);
  x22 = ((uint32_t)(arg1[6]) << 16);
  x23 = ((uint32_t)(arg1[5]) << 8);
  x24 = (arg1[4]);
  x25 = ((uint32_t)(arg1[3]) << 24);
  x26 = ((uint32_t)(arg1[2]) << 16);
  x27 = ((uint32_t)(arg1[1]) << 8);
  x28 = (arg1[0]);
  x29 = (x27 + (uint32_t)x28);
  x30 = (x26 + x29);
  x31 = (x25 + x30);
  x32 = (x23 + (uint32_t)x24);
  x33 = (x22 + x32);
  x34 = (x21 + x33);
  x35 = (x19 + (uint32_t)x20);
  x36 = (x18 + x35);
  x37 = (x17 + x36);
  x38 = (x15 + (uint32_t)x16);
  x39 = (x14 + x38);
  x40 = (x13 + x39);
  x41 = (x11 + (uint32_t)x12);
  x42 = (x10 + x41);
  x43 = (x9 + x42);
  x44 = (x7 + (uint32_t)x8);
  x45 = (x6 + x44);
  x46 = (x5 + x45);
  x47 = (x3 + (uint32_t)x4);
  x48 = (x2 + x47);
  x49 = (x1 + x48);
  out1[0] = x31;
  out1[1] = x34;
  out1[2] = x37;
  out1[3] = x40;
  out1[4] = x43;
  out1[5] = x46;
  out1[6] = x49;
}

/*
 * The function fiat_np224_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np224_selectznz(uint32_t out1[7], fiat_np224_uint1 arg1, const uint32_t arg2[7], const uint32_t arg3[7]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  fiat_np224_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  fiat_np224_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  fiat_np224_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  fiat_np224_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  fiat_np224_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  fiat_np224_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  fiat_np224_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
}
