/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Filter;
import org.chefproject.core.NewsChannel;
import org.chefproject.exception.NewsConnectionException;
import org.chefproject.exception.NewsFormatException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericNewsService;

public class NewsService {
    private static GenericNewsService M_service = null;

    private static void find() {
        Log.debug("chef", "NewsService.find() SERVICE_NAME: " + GenericNewsService.SERVICE_NAME);
        if (M_service == null && (M_service = (GenericNewsService)((Object)TurbineServices.getInstance().getService(GenericNewsService.SERVICE_NAME))) == null) {
            Log.warn("chef", "NewsService.find: missing service: " + GenericNewsService.SERVICE_NAME);
        }
    }

    public static GenericNewsService getInstance() {
        Log.debug("chef", "NewsService.getInstance()");
        NewsService.find();
        return M_service;
    }

    public static List getNewsitems(String channel) throws NewsConnectionException, NewsFormatException {
        NewsService.find();
        return M_service.getNewsitems(channel);
    }

    public static List getNewsItems(String channel, Filter filter) throws NewsConnectionException, NewsFormatException {
        NewsService.find();
        return M_service.getNewsitems(channel, filter);
    }

    public boolean isUpdateAvailable(String channel) {
        NewsService.find();
        return M_service.isUpdateAvailable(channel);
    }

    public static List getChannels() {
        Log.debug("chef", "NewsService.getChannels()");
        NewsService.find();
        return M_service.getChannels();
    }

    public static NewsChannel getChannel(String url) throws NewsConnectionException, NewsFormatException {
        Log.debug("chef", "NewsService.getChannel(" + url + ")");
        NewsService.find();
        return M_service.getChannel(url);
    }

    public static void removeChannel(String channel) throws PermissionException {
        Log.debug("chef", "NewsService.removeChannel()");
        NewsService.find();
        M_service.removeChannel(channel);
    }
}

