/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.IRealmService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.Realm;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JMSRISRealmService
extends JMSRISService
implements IRealmService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.Realm";
    private static Vector mClassNames = new Vector();
    String mUser = null;
    String mAuth = null;

    public JMSRISRealmService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public void connect(String user, String passwd) {
        this.mLogger.info("calling JMSRISRealmService.connect");
        this.mUser = user;
        this.mAuth = passwd;
        super.connect(user, passwd);
        boolean loadRealms = false;
        if (this.mUseCache) {
            if (this.mCacheById.size() == 0) {
                loadRealms = true;
            }
        } else if (this.getAllResourceObjects(CLASSNAME).size() == 0) {
            loadRealms = true;
        }
        if (loadRealms) {
            try {
                this.mLogger.info("trying to load default realms");
                InputStream is = this.getClass().getResourceAsStream("/realm.xml");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document newrdoc = db.parse(is);
                NodeList nodes = newrdoc.getElementsByTagName("realm");
                this.mLogger.info("Saving new base realms: " + nodes.getLength());
                Object grouprealm = null;
                for (int idx = 0; idx < nodes.getLength(); ++idx) {
                    Element el = (Element)nodes.item(idx);
                    Realm r = new Realm();
                    r.setContent(JMSRISRealmService.getContentFromElement(el));
                    String owner = el.getAttribute("id");
                    r.setOwnerId(owner);
                    System.out.println("Realm " + r.toXML());
                    this.save(r);
                }
            }
            catch (Exception e) {
                this.mLogger.severe("Could not load default realms!\n" + e.toString() + "\n" + LoggerUtils.getStackTrace(e));
            }
        }
        this.mLogger.info("end connect");
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String realms = props.getProperty("realms");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + realms + "%");
        return ret;
    }

    public void logAllRealms() {
        try {
            Realm[] tmp = this.getRealms();
            if (tmp != null) {
                for (int idx = 0; idx < tmp.length; ++idx) {
                    this.mLogger.info("Realm-> " + tmp[idx].toXML());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Realm[] getRealms() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        Realm[] ret = new Realm[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Realm)it.next();
        }
        return ret;
    }

    public Realm getRealmByName(String owner) throws IOException {
        Realm ret = null;
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        if (objects != null && objects.size() > 0) {
            Iterator it = objects.iterator();
            ret = (Realm)it.next();
        }
        return ret;
    }

    public Realm getRealmById(String id) throws IOException {
        Realm ret = null;
        Collection objects = this.getResourceObjectsByOwner(id, CLASSNAME);
        if (objects != null && objects.size() > 0) {
            Iterator it = objects.iterator();
            ret = (Realm)it.next();
        }
        return ret;
    }

    public void addRealm(Realm data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save realm " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public String save(ResourceObject obj) throws RISException {
        if (obj.getId() == null || obj.getId().equals("")) {
            String owner = new String(obj.getOwnerId());
            owner = owner.replace('/', '-');
            owner = owner.replaceAll("\\!", "");
            owner = owner.replaceAll("~", "user-");
            owner = owner.replaceAll("@", "site-");
            owner = "realm-" + owner + ".txt";
            this.mLogger.info("trying to save realm with id: " + owner);
            obj.setId(owner);
        }
        return super.save(obj);
    }

    public boolean deleteRealm(Realm data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Realm " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    protected Document parseRealm(String data) {
        Document ret = null;
        try {
            if (data != null && data.length() > 1) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = dbf.newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(data));
                ret = docBuilder.parse(inputSource);
                this.mLogger.info("Loaded realm data " + data);
            }
        }
        catch (Exception ex) {
            this.mLogger.warning("Unable to load or parse realm: " + data + "\n" + ex.toString());
        }
        return ret;
    }

    public String[] getMembers(String rid) {
        String[] ret = null;
        try {
            Realm r = this.getRealmByName("/site/" + rid);
            if (r != null) {
                Document doc = this.parseRealm(r.getContent());
                Element realm = doc.getDocumentElement();
                HashSet<String> users = new HashSet<String>();
                NodeList children = realm.getChildNodes();
                int nChildren = children.getLength();
                for (int adx = 0; adx < nChildren; ++adx) {
                    NamedNodeMap attributes;
                    Node unode;
                    Node anode = children.item(adx);
                    if (anode.getNodeType() != 1 || !"ability".equals(anode.getNodeName()) || (unode = (attributes = anode.getAttributes()).getNamedItem("user")) == null) continue;
                    users.add(unode.getNodeValue());
                }
                ret = users.toArray(new String[users.size()]);
            } else {
                this.mLogger.warning("Realm not found: " + rid);
            }
        }
        catch (Exception ex) {
            this.mLogger.warning("Unable to get members" + rid + " " + ex.toString());
        }
        return ret;
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

