# export PKG_CONFIG_PATH to $prefix/lib/pkgconfig if needed
pkg_search_module(LIBNUSSL "libnussl")
IF (LIBNUSSL_FOUND)
	MESSAGE (STATUS "Found libnussl ${LIBNUSSL_VERSION}")
	SET (CMAKE_REQUIRED_INCLUDES "${LIBNUSSL_INCLUDE_DIRS};${CMAKE_REQUIRED_INCLUDES}")
	CHECK_INCLUDE_FILES("sys/socket.h;nussl.h" HAVE_NUSSL_H)
	SET (HAVE_NUSSL 1 CACHE INTERNAL "libnussl detected")
ELSE (LIBNUSSL_FOUND)
	MESSAGE(FATAL_ERROR "Could not find libnussl")
ENDIF (LIBNUSSL_FOUND)

# export PKG_CONFIG_PATH to $prefix/lib/pkgconfig if needed
pkg_search_module(LIBNUCLIENT "libnuclient")
IF (LIBNUCLIENT_FOUND)
	MESSAGE (STATUS "Found libnuclient ${LIBNUCLIENT_VERSION}")
	SET (CMAKE_REQUIRED_INCLUDES "${LIBNUSSL_INCLUDE_DIRS};${CMAKE_REQUIRED_INCLUDES}")
	CHECK_INCLUDE_FILES("sys/socket.h;nussl.h;nuclient.h" HAVE_NUCLIENT_H)
	SET (HAVE_NUSSL 1 CACHE INTERNAL "libnussl detected")
ELSE (LIBNUCLIENT_FOUND)
	MESSAGE(FATAL_ERROR "Could not find libnuclient")
ENDIF (LIBNUCLIENT_FOUND)

# Define nuauth default port
SET(LIBNUCLIENT_DEFINITIONS "${LIBNUCLIENT_DEFINITIONS} -DDEFAULT_NUAUTH_PORT=\"4129\"")

SET(CMAKE_REQUIRED_LIBRARIES "${CMAKE_REQUIRED_LIBRARIES};${LIBNUSSL_LIBRARIES};${LIBNUCLIENT_LIBRARIES}")

# Had some defines depending on libnuclient's version

# We cannot use CHECK_SYMBOL_EXISTS here since the symbol is not defined in header
# (but is present in lib)
CHECK_LIBRARY_EXISTS("nussl" load_sys_config "" HAVE_DEFAULT_NUAUTH_IP)
#CHECK_SYMBOL_EXISTS (load_sys_config "sys/socket.h;nussl.h;nuclient.h" HAVE_DEFAULT_NUAUTH_IP)
IF(HAVE_DEFAULT_NUAUTH_IP)
	SET(LIBNUCLIENT_DEFINITIONS "${LIBNUCLIENT_DEFINITIONS}  -DHAVE_DEFAULT_NUAUTH_IP")
	MESSAGE(STATUS "HAVE_DEFAULT_NUAUTH_IP")
ENDIF(HAVE_DEFAULT_NUAUTH_IP)

#CHECK_LIBRARY_EXISTS(${NUCLIENT_LIBRARY} nu_client_default_hostname "" HAVE_DEFAULT_HOSTNAME_FUNC)
CHECK_SYMBOL_EXISTS (nu_client_default_hostname "sys/socket.h;nussl.h;nuclient.h" HAVE_DEFAULT_HOSTNAME_FUNC)
IF(HAVE_DEFAULT_HOSTNAME_FUNC)
	SET(LIBNUCLIENT_DEFINITIONS "${LIBNUCLIENT_DEFINITIONS} -DHAVE_DEFAULT_HOSTNAME_FUNC")
	MESSAGE(STATUS "HAVE_DEFAULT_HOSTNAME_FUNC")
ENDIF(HAVE_DEFAULT_HOSTNAME_FUNC)

#CHECK_LIBRARY_EXISTS("nussl" nu_client_default_tls_ca "" HAVE_DEFAULT_TLS_FUNC)
CHECK_SYMBOL_EXISTS (nu_client_default_tls_ca "sys/socket.h;nussl.h;nuclient.h" HAVE_DEFAULT_TLS_FUNC)
IF(HAVE_DEFAULT_TLS_FUNC)
	SET(LIBNUCLIENT_DEFINITIONS "${LIBNUCLIENT_DEFINITIONS} -DHAVE_DEFAULT_TLS_FUNC")
	MESSAGE(STATUS "HAVE_DEFAULT_TLS_FUNC")
ENDIF(HAVE_DEFAULT_TLS_FUNC)

# Uses libnuclient new API (with NuSSL)
#CHECK_LIBRARY_EXISTS("nussl" nu_client_set_pkcs12 "" HAVE_NUFW24)
CHECK_SYMBOL_EXISTS (nu_client_set_pkcs12 "sys/socket.h;nussl.h;nuclient.h" HAVE_NUFW24)
IF(HAVE_NUFW24)
	SET(LIBNUCLIENT_DEFINITIONS "${LIBNUCLIENT_DEFINITIONS} -DHAVE_NUFW24")
	MESSAGE(STATUS "HAVE_NUFW24")
ENDIF(HAVE_NUFW24)


