<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [screenshot](./puppeteer.page.screenshot.md)

## Page.screenshot() method

<b>Signature:</b>

```typescript
screenshot(options?: ScreenshotOptions): Promise<Buffer | string | void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [ScreenshotOptions](./puppeteer.screenshotoptions.md) |  |

<b>Returns:</b>

Promise&lt;Buffer \| string \| void&gt;

Promise which resolves to buffer or a base64 string (depending on the value of `encoding`) with captured screenshot.

## Remarks

Options object which might have the following properties:

- `path` : The file path to save the image to. The screenshot type will be inferred from file extension. If `path` is a relative path, then it is resolved relative to [current working directory](https://nodejs.org/api/process.html#process_process_cwd). If no path is provided, the image won't be saved to the disk.

- `type` : Specify screenshot type, can be either `jpeg` or `png`. Defaults to 'png'.

- `quality` : The quality of the image, between 0-100. Not applicable to `png` images.

- `fullPage` : When true, takes a screenshot of the full scrollable page. Defaults to `false`

- `clip` : An object which specifies clipping region of the page. Should have the following fields:<br/> - `x` : x-coordinate of top-left corner of clip area.<br/> - `y` : y-coordinate of top-left corner of clip area.<br/> - `width` : width of clipping area.<br/> - `height` : height of clipping area.

- `omitBackground` : Hides default white background and allows capturing screenshots with transparency. Defaults to `false`

- `encoding` : The encoding of the image, can be either base64 or binary. Defaults to `binary`.

NOTE: Screenshots take at least 1/6 second on OS X. See [https://crbug.com/741689](https://crbug.com/741689) for discussion.

