#!/usr/bin/env python3
import sys
from configparser import ConfigParser
from pathlib import Path

if sys.version_info < (3, 6):
    print("This script requires Python 3.6 to work correctly")
    sys.exit(1)

repo_root = Path(__file__).parent.parent
setup_cfg = repo_root / "setup.cfg"
reqs = repo_root / "requirements.txt"
min_reqs = repo_root / "min-requirements.txt"

config = ConfigParser()
config.read(setup_cfg)
requirements = config.get("options", "install_requires").strip().splitlines()

script_name = Path(__file__).relative_to(repo_root)

lines = [f"# Auto-generated by {script_name}", ""]

# Write requirements
lines[1:-1] = requirements
reqs.write_text("\n".join(lines))

# Write minimum requirements
lines[1:-1] = [req.replace(">=", "==").replace("~=", "==") for req in requirements]
min_reqs.write_text("\n".join(lines))
