/*===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

#ifndef _xencws_h_
#define _xencws_h_

#include <xfs/xfs-defs.h>

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/*))))
 ((((   There is temporary interface which needed to store encrypted
  ))))  data in encrypted directory
 ((((*/
/*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*/

/*))    Forwards
 ((*/
struct KDirectory;

/*))
 //     Depot
((*/
XFS_EXTERN rc_t CC XFSEncDirectoryDepotInit ();
XFS_EXTERN rc_t CC XFSEncDirectoryDepotDispose ();
XFS_EXTERN rc_t CC XFSEncDirectoryDepotClear ();

/*))
 //     The only method we will use
((*/
XFS_EXTERN rc_t CC XFSEncDirectoryOpen (
                                const struct KDirectory ** Dir,
                                bool Update,
                                const char * Password,
                                const char * EncType,
                                const char * Path,
                                ...
                                );

/*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*/

#ifdef __cplusplus 
}
#endif /* __cplusplus */

#endif /* _xencws_h_ */
