/*  $Id: metamodules_doxygen.h 119500 2008-02-11 02:52:52Z vakatov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Karanjit Siyan
 *
 * File Description:
 *   Comment blocks for doxygen metamodules
 *
 */


/* ========================================================================= */

/**
  @mainpage NCBI C++ Toolkit API

  NOTE: This page contains only a limited set of selected articles.
        To see all of the documentation, visit the "Modules" section. 

  @li @ref blast_opts_cookbook
  @li @ref blast_opts_cpp_design
  @li @ref _impl_blast_seqsrc_howto
*/



/* ========================================================================= */


/** @defgroup CORELIB
 *  Core Library members
 */

/** @defgroup AppFramework Application Framework
 *  @ingroup CORELIB
 */

/** @defgroup Args Command-Line Argument Processing
 *  @ingroup CORELIB
 */

/** @defgroup Counters Atomic Counters
 *  @ingroup CORELIB
 */

/** @defgroup Debug Debugging Macros
 *  @ingroup CORELIB
 */

/** @defgroup Diagnostics Run-Time Diagnostics
 *  @ingroup CORELIB
 */

/** @defgroup Environment Access To Shell Environment
 *  @ingroup CORELIB
 */

/** @defgroup Files File System Access
 *  @ingroup CORELIB
 */

/** @defgroup Object Smart Pointers with Reference Counting
 *  @ingroup CORELIB
 */

/** @defgroup Portability Fixed-Size Types and Their Limits
 *  @ingroup CORELIB
 */

/** @defgroup Dll DLL Support
 *  @ingroup CORELIB
 */

/** @defgroup PluginMgr Plugin Creation and Usage Framework
 *  @ingroup CORELIB
 */

/** @defgroup ModuleConfig Configuration Utilities
 *  @ingroup CORELIB
 */


/** @defgroup Exec Process Creation and Execution
 *  @ingroup CORELIB
 */

/** @defgroup Exception Exceptions Hierarchy
 *  @ingroup CORELIB
 */

/** @defgroup Registry Application Registry
 *  @ingroup CORELIB
 */

/** @defgroup STL NCBI Namespaces Etc
 *  @ingroup CORELIB
 */

/** @defgroup Stream C++ IOStream Fixups And Utilities
 *  @ingroup CORELIB
 */

/** @defgroup String String Manipulations
 *  @ingroup CORELIB
 */

/** @defgroup Utility STL-related And Other Template Utilities
 *  @ingroup CORELIB
 */

/** @defgroup Threads Threads
 *  @ingroup CORELIB
 */

/** @defgroup Time Time And Date
 *  @ingroup CORELIB
 */

/** @defgroup Version Versioning
 *  @ingroup CORELIB
 */

/** @defgroup Tree Tree Templates
 *  @ingroup CORELIB
 */

/** @defgroup MTWrappers MT-safety Testing Framework
 *  @ingroup CORELIB
 */

/** @defgroup Process Process Management
 *  @ingroup CORELIB
 */


/** @defgroup Param Parameters Storage
 *  @ingroup CORELIB
 */

/* ========================================================================= */


/** @defgroup CONNECT
 *  Connect Library members
 */

/** @defgroup BuffServices Buffering Services
 *  @ingroup CONNECT
 */

/** @defgroup ConnExcep Connection Exceptions
 *  @ingroup CONNECT
 */

/** @defgroup ConnStreams Connection Streams
 *  @ingroup CONNECT
 */

/** @defgroup Connectors
 *  @ingroup CONNECT
 */

/** @defgroup Pipes Portable Pipes
 *  @ingroup CONNECT
 */

/** @defgroup Pipes Portable Pipes
 *  @ingroup CONNECT
 */

/** @defgroup Sendmail
 *  @ingroup CONNECT
 */

/** @defgroup ServiceSupport Service Support
 *  @ingroup CONNECT
 */

/** @defgroup Sockets Socket Services
 *  @ingroup CONNECT
 */

/** @defgroup UtilityFunc Utility Functions
 *  @ingroup CONNECT
 */

/** @defgroup EmailDiag Email Diagnostic Handler
 *  @ingroup CONNECT
 */

/** @defgroup ThreadedServer Threaded Server
 *  @ingroup CONNECT
 */

/** @defgroup ReaderWriter Socket reader-writer
 *  @ingroup CONNECT
 */


/** @defgroup NetServices General Purpose Network Infrastructure Services
 *  @ingroup CONNECT
 */


/** @defgroup NetCacheClient Client API to NCBI NetCache
 *  @ingroup NetServices
 */

/** @defgroup NetScheduleClient Client API to NCBI NetSchedule
 *  @ingroup NetServices
 */


/* ========================================================================= */


/** @defgroup BDB
 *  Berkeley DB support API
 */

/** @defgroup BDB_Types BDB library field types
 *  @ingroup BDB
 */

/** @defgroup BDB_BLOB  BDB library BLOB support
 *  @ingroup BDB
 */

/** @defgroup BDB_BLOB_Cache    BDB library BLOB Cache
 *  @ingroup BDB
 */

/** @defgroup BDB_Files BDB library files and cursors
 *  @ingroup BDB
 */

/** @defgroup BDB_Map   BDB library map templates
 *  @ingroup BDB
 */

/** @defgroup BDB_Util  BDB library utilities
 *  @ingroup BDB
 */

/** @defgroup BDB_Query  BDB library queries
 *  @ingroup BDB
 */


/* ========================================================================= */


/** @defgroup DBAPI
 *  Database API members
 */

/** @defgroup DbAPI     Database APIs
 *  @ingroup DBAPI
 */

/** @defgroup DbDrvMgr  Driver Manager
 *  @ingroup DBAPI
 */

/** @defgroup DbVariant Variant exception and data type
 *  @ingroup DBAPI
 */

/** @defgroup DbExceptions Database Exceptions
 *  @ingroup DBAPI
 */

/** @defgroup DbInterfaces Database Server Interfaces
 *  @ingroup DBAPI
 */

/** @defgroup DbPubInterfaces Database Server Public Interfaces
 *  @ingroup DBAPI
 */

/** @defgroup DbTypes Database Types
 *  @ingroup DBAPI
 */

/** @defgroup DbDriverReg Drivers' Registration
 *  @ingroup DBAPI
 */


/* ========================================================================= */


/**
 *  @defgroup CGI
 *  CGI Members
 */

/** @defgroup CGIBase CGI Base Classes
 *  @ingroup CGI
 */

/** @defgroup CGICmd CGI Command APIs
 *  @ingroup CGI
 */

/** @defgroup CGIExcep CGI Exception
 *  @ingroup CGI
 */

/** @defgroup CGIReqRes CGI Request/Response APIs
 *  @ingroup CGI
 */

/** @defgroup CookieAffinity Cookie Affinity Services 
 *  @ingroup CGI
 */


/* ========================================================================= */


/** @defgroup HTML
 *  HTML members
 */

/** @defgroup CreationFactory Creation Factory
 *  @ingroup HTML
 */

/** @defgroup DiagHandler Diagnostic Handler
 *  @ingroup HTML
 */

/** @defgroup HTMLHelper HTML Helper and Utility Functions
 *  @ingroup HTML
 */

/** @defgroup HTMLcomp  HTML Page Components
 *  @ingroup HTML
 */

/** @defgroup HTMLStream HTML Stream
 *  @ingroup HTML
 */

/** @defgroup PagerClass Pager Classes
 *  @ingroup HTML
 */

/** @defgroup TagMapper Tag Mapper Classes
 *  @ingroup HTML
 */

/** @defgroup HTMLexpt  HTML Exception
 *  @ingroup HTML
 */


/* ========================================================================= */


/** @defgroup UTIL
 *  Util members
 */

/** @defgroup Cache Generic Cache
 *  @ingroup UTIL
 */

/** @defgroup Checksum
 *  @ingroup UTIL
 */

/** @defgroup ConsoleDebug Console Debug Dump Viewer
 *  @ingroup UTIL
 */

/** @defgroup IntervalTree Interval Search Tree
 *  @ingroup UTIL
 */

/** @defgroup LightStr Lightweight String
 *  @ingroup UTIL
 */

/** @defgroup LinkedSet Linked Set
 *  @ingroup UTIL
 */

/** @defgroup RandomGen Random Number Generation
 *  @ingroup UTIL
 */

/** @defgroup RangeSupport Range Support
 *  @ingroup UTIL
 */

/** @defgroup Regexp Regular Expressions
 *  @ingroup UTIL
 */

/** @defgroup RegistryDNS Registry-based DNS
 *  @ingroup UTIL
 */

/** @defgroup ResizingIterator Resizing Iterator
 *  @ingroup UTIL
 */

/** @defgroup RotatingLog Rotating Log Streams
 *  @ingroup UTIL
 */

/** @defgroup StreamSupport Stream Support
 *  @ingroup UTIL
 */

/** @defgroup StringSearch String Search
 *  @ingroup UTIL
 */

/** @defgroup ThreadedPools Threaded Pools for Request Handling
 *  @ingroup UTIL
 */

/** @defgroup utf8 UTF-8 Conversion
 *  @ingroup UTIL
 */

/** @defgroup UtilExcep Utility Exceptions
 *  @ingroup UTIL
 */

/** @defgroup WeakMap Weak Map Template
 *  @ingroup UTIL
 */

/** @defgroup QParser Query Parser and Query Tree
 *  @ingroup UTIL
 */

/** @defgroup Transact Transactions and Transactional Objects
 *  @ingroup UTIL
 */

/** @defgroup BlastFormatting BLAST Formatting
 *  @ingroup UTIL
 */

/* ========================================================================= */


/** @defgroup SERIAL
 *  Serial members
 */

/** @defgroup FieldsComplex Fields for Complex ASN types
 *  @ingroup SERIAL
 */

/** @defgroup GenClassSupport Generated Classes Support
 *  @ingroup SERIAL
 */

/** @defgroup HookSupport Hook Support
 *  @ingroup SERIAL
 */

/** @defgroup ObjHierarchy Object Hierarchy Iterator
 *  @ingroup SERIAL
 */

/** @defgroup ObjStreamSupport Object Stream Support
 *  @ingroup SERIAL
 */

/** @defgroup SerialDef Serialization Definition
 *  @ingroup SERIAL
 */

/** @defgroup SerialExcep Serial Exception
 *  @ingroup SERIAL
 */

/** @defgroup TypeInfoC Type Info Classes for C Toolkit
 *  @ingroup SERIAL
 */

/** @defgroup TypeInfoCPP Type Info Classes for C++ Toolkit
 *  @ingroup SERIAL
 */

/** @defgroup TypeLookup Type Lookup
 *  @ingroup SERIAL
 */

/** @defgroup UserCodeSupport User Code Support
 *  @ingroup SERIAL
 */


/* ========================================================================= */


/** @defgroup OBJECTS OBJECTS
 *  ASN.1 objects
 */

/** @defgroup OBJECTS_Seqloc Seq-loc Management
 *  @ingroup OBJECTS
 */

/** @defgroup OBJECTS_Seqid Seq-id Management
 *  @ingroup OBJECTS
 */


/* ========================================================================= */


/** @defgroup OBJECTMANAGER OBJECT MANAGER
 *  Object Manager members
 */

/** @defgroup ObjectManagerCore Object Manager Core Classes 
 *  @ingroup OBJECTMANAGER
 */

/** @defgroup ObjectManagerHandles Handles
 *  @ingroup OBJECTMANAGER
 */

/** @defgroup ObjectManagerSequenceRep Sequence Representations 
 *  @ingroup OBJECTMANAGER
 */

/** @defgroup ObjectManagerIterators Iterators 
 *  @ingroup OBJECTMANAGER
 */

/* ========================================================================= */


/** @defgroup OBJUTIL
 *  Object Manager utilities
 */

/** @defgroup ObjUtilSequence Sequence utilities
 *  @ingroup OBJUTIL
 */

/** @defgroup ObjUtilSeqLoc Seq-loc utilities
 *  @ingroup OBJUTIL
 */

/** @defgroup ObjUtilSeqAlign Seq-align utilities
 *  @ingroup OBJUTIL
 */

/** @defgroup ObjUtilFeature Feature utilities
 *  @ingroup OBJUTIL
 */

/** @defgroup ObjUtilWeight Sequence weight
 *  @ingroup OBJUTIL
 */


/* ========================================================================= */


/** @defgroup CTOOLS
 *  Ctool members
 */

/** @defgroup CToolsBridge C/C++ Toolkit Bridge
 *  @ingroup CTOOLS
 */

/** @defgroup CToolsASNConn ASN Streams Connection
 *  @ingroup CTOOLS
 */

/** @defgroup CToolsASNConv ASN Converter
 *  @ingroup CTOOLS
 */


/* ========================================================================= */


/** @defgroup ALGO ALGORITHMS
 *  Algorithm members
 */

/** @defgroup AlgoBlast BLAST (Basic Local Alignment Search Tool)
 *  @ingroup ALGO
 */

/** @defgroup AlgoAlignExcep Global Alignment Exceptions
 *  @ingroup ALGO
 */

/** @defgroup AlgoAlignFormat Global Alignment Formatter
 *  @ingroup ALGO
 */

/** @defgroup AlgoAlignRoot Generic Global(Needleman-Wunsch) Alignment
 *  @ingroup ALGO
 */

/** @defgroup AlgoAlignMM Linear Space Global Alignment
 *  @ingroup ALGO
 */

/** @defgroup AlgoAlignSpliced Spliced cDna-to-Genomic Alignment
 *  @ingroup ALGO
 */


/* ========================================================================= */


/** @defgroup GUI GUI Framework
 *  The GUI framework provides GUI support for toolkit functions.
 */

/** @defgroup GUI_MATH GUI Math Classes and Modules
 *  @ingroup GUI
 * Math routines to support computer graphics
 */

/** @defgroup GUI_UTILS GUI Utility Classes and Modules
 *  @ingroup GUI
 * Utility and support routines for the GUI framework
 */

/** @defgroup GUI_GRAPH GUI Graph Rendering Classes and Modules
 *  @ingroup GUI
 * Routines to support rendering of various types of graphs
 */

/** @defgroup GUI_OBJUTILS GUI Object Utility Classes and Modules
 *  @ingroup GUI
 * Utility and support routines for the GUI framework.  These routines make
 * use of the object manager and associated tools.
 */

/** @defgroup GUI_CONFIG GUI Configuration Classes and Modules
 *  @ingroup GUI
 * Generic configuration support for GUI projects.  This includes management of
 * configuration data in a hierarchical, key/value pair structure, as well as
 * support for named sets of options and themes.
 */

/** @defgroup GUI_WIDGETS GUI Widget Classes and Modules
 *  @ingroup GUI
 * General widget support for GUI projects.  This includes simple extensions on
 * top of FLTK designed to provide basic building blocks (such as extended text
 * viewers), as well as heavier-weight widgets designed with specific tasks in
 * mind (such as graphical sequence and alignment viewers)
 */

/** @defgroup GUI_FltkWidgets Simple Extensions and Wrappers Wround FLTK
 *  @ingroup GUI_WIDGETS
 */

/** @defgroup GUI_GlWidgets Simple OpenGL Widgets and Utilities
 *  @ingroup GUI_WIDGETS
 */

/** @defgroup GUI_SeqWidgets Sequence Viewer Widgets and Utilities
 *  @ingroup GUI_WIDGETS
 */

/** @defgroup GUI_AlnWidgets Alignment Viewer Widgets and Utilities
 *  @ingroup GUI_WIDGETS
 */

/** @defgroup GUI_MiscWidgets Miscellaneous Widgets
 *  @ingroup GUI_WIDGETS
 */

/** @defgroup GUI_OPENGL GUI OpenGL Classes and Modules
 *  @ingroup GUI
 * OpenGL wrappers and customization
 */

/** @defgroup GUI_OPENGL_MESA MESA Off-Screen Rendering Classes and Modules
 *  @ingroup GUI
 * Support classes that wrap MesaLib's off-screen renderer
 */

/** @defgroup GUI_CORE GUI Core Classes and Modules
 *  @ingroup GUI
 * Core routines offering full framework support for Genome Workbench and other
 * GUI applications.  The core framework provides support for managing plugins
 * as well as support for the document/view architecture of Genome Workbench
 */

/** @defgroup GUI_CORE_PluginArch Plugin Architecture Support Classes
 *  @ingroup GUI_CORE
 */

/** @defgroup GUI_CORE_DocView Document/View Architecture Support Classes
 *  @ingroup GUI_CORE
 */

/** @defgroup GUI_PLUGIN GUI Plugin Interface Classes and Modules
 *  @ingroup GUI
 * ASN.1 definitions and support routines for the plugin interface of the GUI
 * toolkit
 */

/** @defgroup GUI_PLUGINS_ALGO GUI Algorithm Plugin Classes and Modules
 *  @ingroup GUI
 * Algorithm plugins for Genome Workbench
 */

/** @defgroup GUI_PLUGINS_ALGO_Basic Basic / Intrinsic Plugin Libraries
 *  @ingroup GUI_PLUGINS_ALGO
 * These classes support basic or "intrinsic" functions of sequence analysis,
 * such as sequence searching, simple pattern recognition, and sequence
 * compostion.
 */

/** @defgroup GUI_PLUGINS_ALGO_Align Alignment Generation Plugins
 *  @ingroup GUI_PLUGINS_ALGO
 *  These classes support the generation and management of alignments, both
 *  locally and through network services.
 */

/** @defgroup GUI_PLUGINS_DOC GUI Data Loader Plugin Classes and Modules
 *  @ingroup GUI
 * Data loader plugins for Genome Workbench
 */

/** @defgroup GUI_PLUGINS_DOC_Basic Basic Data Loaders
 *  @ingroup GUI_PLUGINS_DOC
 *  These classes support a subset of "standard" data loaders, such as
 *  retrieval of data from GenBank, loading of files, and management of indexed
 *  directories.
 */

/** @defgroup GUI_PLUGINS_VIEW GUI View Plugin Classes and Modules
 *  @ingroup GUI
 * View plugins for Genome Workbench
 */

/** @defgroup GUI_PLUGINS_VIEW_Alignment Alignment Viewers
 *  @ingroup GUI_PLUGINS_VIEW
 */

/** @defgroup GUI_PLUGINS_VIEW_SeqGraphic Graphical Sequence Viewers
 *  @ingroup GUI_PLUGINS_VIEW
 */

/** @defgroup GUI_PLUGINS_VIEW_SeqText Text-based Sequence Viewers
 *  @ingroup GUI_PLUGINS_VIEW
 */

/** @defgroup GUI_PLUGINS_VIEW_Tree Tree Viewers
 *  @ingroup GUI_PLUGINS_VIEW
 */

/** @defgroup GUI_GBENCH Genome Workbench Classes and Modules
 *  @ingroup GUI
 * Genome Workbench application and support classes
 */

/* ========================================================================= */


/** @defgroup MISC
 *  Miscellaneous
 */

/** @defgroup Miscellaneous
 *  @ingroup MISC
 */

/** @defgroup WinDLL DLL Export/Import Defines for MS Windows
 *  @ingroup MISC
 */

/* ========================================================================= */

/** @defgroup DatatoolGeneratedClasses
 *  Code generated by DATATOOL
 */
