&nbsp;
![MultiQC](docs/images/MultiQC_logo.png#gh-light-mode-only)
![MultiQC](docs/images/MultiQC_logo_darkbg.png#gh-dark-mode-only)
&nbsp;

### Aggregate bioinformatics results across many samples into a single report

##### Find [documentation](http://multiqc.info/docs) and [example reports](https://multiqc.info/example-reports/) at [http://multiqc.info](http://multiqc.info)

[![PyPI Version](https://img.shields.io/pypi/v/multiqc)](https://pypi.python.org/pypi/multiqc/)
[![Bioconda Version](https://img.shields.io/conda/v/bioconda/multiqc?label=bioconda)](https://bioconda.github.io/recipes/multiqc/README.html)
[![DOI](https://img.shields.io/badge/DOI-10.1093%2Fbioinformatics%2Fbtw354-red.svg)](http://dx.doi.org/10.1093/bioinformatics/btw354)

---

MultiQC is a tool to create a single report with interactive plots for multiple bioinformatics analyses across many samples.

Reports are generated by scanning given directories for recognised log files.
These are parsed and a single HTML report is generated summarising the statistics
for all logs found. MultiQC reports can describe multiple analysis steps and
large numbers of samples within a single plot, and multiple analysis tools making
it ideal for routine fast quality control.

A very large number of Bioinformatics tools are supported by MultiQC. Please see the MultiQC website for a [complete list](https://multiqc.info/modules/).
MultiQC can also easily parse data from custom scripts, if correctly formatted / configured - a feature called [Custom Content](https://multiqc.info/docs/custom_content/).

More modules are being written all of the time. Please suggest any ideas as a new
[issue](https://github.com/ewels/MultiQC/issues) _(please include example log files)_.

## Installation

You can install MultiQC from [PyPI](https://pypi.python.org/pypi/multiqc/)
using `pip` as follows:

```bash
pip install multiqc
```

Alternatively, you can install using [Conda](http://anaconda.org/)
from [Bioconda](https://bioconda.github.io/) ([set up your channels](https://bioconda.github.io/#usage) first):

```bash
conda install multiqc
```

If you would like the development version from GitHub instead, you can install it with `pip`:

```bash
pip install --upgrade --force-reinstall git+https://github.com/ewels/MultiQC.git
```

MultiQC is also available via Docker and Singularity images, Galaxy wrappers, and
many more software distribution systems.
See [the documentation](https://multiqc.info/docs/getting_started/installation/) for details.

## Usage

Once installed, you can use MultiQC by navigating to your analysis directory
(or a parent directory) and running the tool:

```bash
multiqc .
```

That's it! MultiQC will scan the specified directory (`.` is the current dir)
and produce a report detailing whatever it finds.

<!-- RICH-CODEX fake_command: "multiqc ." -->

![`cd test_data/data/modules/fastqc/v0.10.1 && multiqc .`](docs/images/screenshots/fastqc-run.svg)

The report is created in `multiqc_report.html` by default. Tab-delimited data
files are also created in `multiqc_data/`, containing extra information.
These can be easily inspected using Excel (use `--data-format` to get `yaml`
or `json` instead).

For more detailed instructions, run `multiqc -h` or see the
[documentation](http://multiqc.info/docs/#running-multiqc).

## Citation

Please consider citing MultiQC if you use it in your analysis.

> **MultiQC: Summarize analysis results for multiple tools and samples in a single report.** <br> _Philip Ewels, Måns Magnusson, Sverker Lundin and Max Käller_ <br>
> Bioinformatics (2016) <br>
> doi: [10.1093/bioinformatics/btw354](http://dx.doi.org/10.1093/bioinformatics/btw354) <br>
> PMID: [27312411](http://www.ncbi.nlm.nih.gov/pubmed/27312411)

```BibTeX
@article{doi:10.1093/bioinformatics/btw354,
 author = {Ewels, Philip and Magnusson, Måns and Lundin, Sverker and Käller, Max},
 title = {MultiQC: summarize analysis results for multiple tools and samples in a single report},
 journal = {Bioinformatics},
 volume = {32},
 number = {19},
 pages = {3047},
 year = {2016},
 doi = {10.1093/bioinformatics/btw354},
 URL = { + http://dx.doi.org/10.1093/bioinformatics/btw354},
 eprint = {/oup/backfile/Content_public/Journal/bioinformatics/32/19/10.1093_bioinformatics_btw354/3/btw354.pdf}
}
```

## Contributions & Support

Contributions and suggestions for new features are welcome, as are bug reports!
Please create a new [issue](https://github.com/ewels/MultiQC/issues) for any
of these, including example reports where possible.
Pull-requests for fixes and additions are very welcome.
Please see the [contributing notes](https://github.com/ewels/MultiQC/blob/master/.github/CONTRIBUTING.md) for more information about how the process works.

MultiQC has extensive [documentation](http://multiqc.info/docs/development/)
describing how to write new modules, plugins and templates.

If in doubt, feel free to get in touch with the author directly:
[@ewels](https://github.com/ewels) (phil.ewels@seqera.io)

### Contributors

MultiQC is developed and maintained by Phil Ewels ([@ewels](https://github.com/ewels)) at [Seqera Labs](https://seqera.io/).
It was originally written at the [National Genomics Infrastructure](https://ngisweden.scilifelab.se/), part of [SciLifeLab](https://www.scilifelab.se/) in Sweden.

A huge thank you to all code contributors - there are a lot of you!
See the [Contributors Graph](https://github.com/ewels/MultiQC/graphs/contributors) for details.

MultiQC is released under the GPL v3 or later licence.
