/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.TaggedInputSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class DelegatingMapper<K1, V1, K2, V2>
implements Mapper<K1, V1, K2, V2> {
    private JobConf conf;
    private Mapper<K1, V1, K2, V2> mapper;

    @Override
    public void map(K1 key, V1 value, OutputCollector<K2, V2> outputCollector, Reporter reporter) throws IOException {
        if (this.mapper == null) {
            TaggedInputSplit inputSplit = (TaggedInputSplit)reporter.getInputSplit();
            this.mapper = ReflectionUtils.newInstance(inputSplit.getMapperClass(), this.conf);
        }
        this.mapper.map(key, value, outputCollector, reporter);
    }

    @Override
    public void configure(JobConf conf) {
        this.conf = conf;
    }

    @Override
    public void close() throws IOException {
        if (this.mapper != null) {
            this.mapper.close();
        }
    }
}

