/* 
  Copyright (C) 2008 Kai Hertel

	This file is part of mmpong.

	mmpong is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	mmpong is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __HASHMAP_HEADER__
#define __HASHMAP_HEADER__

// Quick drive-by instructions on how to use this mapping scheme:
// * create map of desired size (I will spare you the introduction to stochastics here)
// * after that, you can begin to insert (key, value) pairs into the map, look them up, work on the values in store and remove them easily
// * functions to provide:
//   -- int map(int hashmap_size, void *key); // this one is supposed to map any given key to a number in [ 0 ; hashmap_size-1 ]
//   -- int cmp(void *key_to_be_found, void *key_in_store); // this one needs to recognize a key when iterating through possible candidates (e.g. strcmp, memcmp)

struct hashentry {
	void **keys;
	void **vals;
	unsigned size;
};

struct hashmap {
	struct hashentry *table;
	unsigned size;
};

struct hashmap *hashmap_create(unsigned, const struct hashmap *, unsigned (*)(const unsigned, const void *));
void hashmap_destroy(struct hashmap *);
void **hashmap_lookup(struct hashmap *, const void *, unsigned (*)(const unsigned, const void *), int (*)(const void *, const void *));
int hashmap_insert(struct hashmap *, void *, void *, unsigned (*)(const unsigned, const void *), int (*)(const void *, const void *));
int hashmap_remove(struct hashmap *, const void *, unsigned (*)(const unsigned, const void *), int (*)(const void *, const void *));
//unsigned hashmap_fast_inc(struct hashmap *, unsigned, int, unsigned (*)(unsigned, void *)); 	// special operation to speed up server accesses

#endif

