/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Request_H
#define Request_H

#include <string>
using std::string;

#include "inc_stl.h"

#ifndef Metview_H
#include "Metview.h"
#endif

class Path;

class Request : public MvRequest {
public:

// -- Exceptions
	// None

// -- Contructors

	Request();
	Request(const char*);
	Request(const string&);

	Request(const Path&);
	Request(const MvRequest&);

// -- Destructor

	~Request(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void load(const Path&);
	void save(const Path&) const;

	vector<string> get(const string&) const;
	vector<string> get(const char*) const;

	void set(const string&,const vector<string>&);
	void set(const char*,const vector<string>&);
	
	static Request fromText(const string&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

//	Request(const Request&);
//	Request& operator=(const Request&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Request& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Request**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Request);
//#endif

#endif
