/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef DropSite_H
#include "DropSite.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#include <Drag.h>

#ifndef Dropping_H
#include "Dropping.h"
#endif

#ifndef MotifDrop_H
#include "MotifDrop.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif


DropSite::DropSite()
{
}

DropSite::~DropSite()
{
	MotifDrop::removeSite(this);
}

void DropSite::install(Widget w)
{
	if(XtIsDrag(w))
		XtAddCallback(w, XmNdropCallback, dropCB, (XtPointer) this);
	else
		DragAcceptDropCallback(w,dropCB,this);


	MotifDrop::addSite(this,w);

}

void DropSite::dropCB(Widget,XtPointer data,XtPointer cbd)
{
	DragCallbackStruct* cb = static_cast<DragCallbackStruct*>(cbd);
	DropSite*            e = static_cast<DropSite*>(data);

	Dropping **drop = static_cast<Dropping**>(cb->message);

	if(*drop)
	{
		(*drop)->position(cb->x,cb->y);
		e->drop(**drop);
		delete *drop;
	}
	else
	{
		Log::info(0) << "Sorry - this drop is not (yet) possible !" << endl;
	}

}
