/* argument.c generated by valac 0.14.2, the Vala compiler
 * generated from argument.vala, do not modify */

/*
 * -- Mickey's DBus Utility V2 --
 *
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Frederik 'playya' Sdun <frederik.sdun@googlemail.com>
 *                         Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>


#define TYPE_ARGUMENT (argument_get_type ())
#define ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARGUMENT, Argument))
#define ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARGUMENT, ArgumentClass))
#define IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARGUMENT))
#define IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARGUMENT))
#define ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARGUMENT, ArgumentClass))

typedef struct _Argument Argument;
typedef struct _ArgumentClass ArgumentClass;
typedef struct _ArgumentPrivate ArgumentPrivate;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Argument {
	GObject parent_instance;
	ArgumentPrivate * priv;
	gchar* name;
	gchar* type;
};

struct _ArgumentClass {
	GObjectClass parent_class;
};

struct _ArgumentPrivate {
	GVariantBuilder* _vbuilder;
};


static gpointer argument_parent_class = NULL;

GType argument_get_type (void) G_GNUC_CONST;
#define ARGUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ARGUMENT, ArgumentPrivate))
enum  {
	ARGUMENT_DUMMY_PROPERTY
};
#define ARGUMENT_arg_separator ','
Argument* argument_new (const gchar* name, const gchar* type, GVariantBuilder* vbuilder);
Argument* argument_construct (GType object_type, const gchar* name, const gchar* type, GVariantBuilder* vbuilder);
gboolean argument_append (Argument* self, const gchar* arg);
static gboolean argument_append_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gchar* argument_get_sub_signature (Argument* self, const gchar* signature);
static gboolean argument_append_array_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gboolean argument_append_struct_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
gboolean argument_append_dict_entry_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gchar** argument_get_sub_args (Argument* self, const gchar* arg, gchar separator, int* result_length1);
static gboolean _vala_char_array_contains (gchar* stack, int stack_length, gchar needle);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void argument_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar ARGUMENT_start_chars[3] = {'{', '[', '('};
static const gchar ARGUMENT_end_chars[3] = {'}', ']', ')'};

static gpointer _g_variant_builder_ref0 (gpointer self) {
	return self ? g_variant_builder_ref (self) : NULL;
}


Argument* argument_construct (GType object_type, const gchar* name, const gchar* type, GVariantBuilder* vbuilder) {
	Argument * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GVariantBuilder* _tmp4_;
	GVariantBuilder* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (vbuilder != NULL, NULL);
	self = (Argument*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->type);
	self->type = _tmp3_;
	_tmp4_ = vbuilder;
	_tmp5_ = _g_variant_builder_ref0 (_tmp4_);
	_g_variant_builder_unref0 (self->priv->_vbuilder);
	self->priv->_vbuilder = _tmp5_;
	return self;
}


Argument* argument_new (const gchar* name, const gchar* type, GVariantBuilder* vbuilder) {
	return argument_construct (TYPE_ARGUMENT, name, type, vbuilder);
}


gboolean argument_append (Argument* self, const gchar* arg) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariantBuilder* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	_tmp0_ = arg;
	_tmp1_ = self->type;
	_tmp2_ = self->priv->_vbuilder;
	_tmp3_ = argument_append_type (self, _tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean argument_append_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	static GQuark _tmp3_label10 = 0;
	static GQuark _tmp3_label11 = 0;
	static GQuark _tmp3_label12 = 0;
	static GQuark _tmp3_label13 = 0;
	static GQuark _tmp3_label14 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = string_substring (_tmp0_, (glong) 0, (glong) 1);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("v")))) {
		switch (0) {
			default:
			{
				GVariantBuilder* _tmp5_;
				const gchar* _tmp6_;
				GVariant* _tmp7_;
				GVariant* _tmp8_;
				GVariant* _tmp9_;
				GVariant* _tmp10_;
				_tmp5_ = vbuilder;
				_tmp6_ = arg;
				_tmp7_ = g_variant_new_parsed (_tmp6_, NULL);
				_tmp8_ = g_variant_ref_sink (_tmp7_);
				_tmp9_ = g_variant_new_variant (_tmp8_);
				_tmp10_ = g_variant_ref_sink (_tmp9_);
				g_variant_builder_add_value (_tmp5_, _tmp10_);
				_g_variant_unref0 (_tmp10_);
				_g_variant_unref0 (_tmp8_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("y")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				gint _tmp12_ = 0;
				guint8 value;
				GVariantBuilder* _tmp13_;
				guint8 _tmp14_;
				GVariant* _tmp15_;
				GVariant* _tmp16_;
				_tmp11_ = arg;
				_tmp12_ = atoi (_tmp11_);
				value = (guint8) _tmp12_;
				_tmp13_ = vbuilder;
				_tmp14_ = value;
				_tmp15_ = g_variant_new_byte ((guchar) _tmp14_);
				_tmp16_ = g_variant_ref_sink (_tmp15_);
				g_variant_builder_add_value (_tmp13_, _tmp16_);
				_g_variant_unref0 (_tmp16_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
				gboolean _tmp21_;
				gboolean _tmp23_;
				gboolean value;
				GVariantBuilder* _tmp24_;
				gboolean _tmp25_;
				GVariant* _tmp26_;
				GVariant* _tmp27_;
				_tmp19_ = arg;
				if (g_strcmp0 (_tmp19_, "true") == 0) {
					_tmp18_ = TRUE;
				} else {
					const gchar* _tmp20_;
					_tmp20_ = arg;
					_tmp18_ = g_strcmp0 (_tmp20_, "True") == 0;
				}
				_tmp21_ = _tmp18_;
				if (_tmp21_) {
					_tmp17_ = TRUE;
				} else {
					const gchar* _tmp22_;
					_tmp22_ = arg;
					_tmp17_ = g_strcmp0 (_tmp22_, "1") == 0;
				}
				_tmp23_ = _tmp17_;
				value = _tmp23_;
				_tmp24_ = vbuilder;
				_tmp25_ = value;
				_tmp26_ = g_variant_new_boolean (_tmp25_);
				_tmp27_ = g_variant_ref_sink (_tmp26_);
				g_variant_builder_add_value (_tmp24_, _tmp27_);
				_g_variant_unref0 (_tmp27_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("n")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp28_;
				gint _tmp29_ = 0;
				gint16 value;
				GVariantBuilder* _tmp30_;
				gint16 _tmp31_;
				GVariant* _tmp32_;
				GVariant* _tmp33_;
				_tmp28_ = arg;
				_tmp29_ = atoi (_tmp28_);
				value = (gint16) _tmp29_;
				_tmp30_ = vbuilder;
				_tmp31_ = value;
				_tmp32_ = g_variant_new_int16 (_tmp31_);
				_tmp33_ = g_variant_ref_sink (_tmp32_);
				g_variant_builder_add_value (_tmp30_, _tmp33_);
				_g_variant_unref0 (_tmp33_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp34_;
				gint _tmp35_ = 0;
				gint32 value;
				GVariantBuilder* _tmp36_;
				gint32 _tmp37_;
				GVariant* _tmp38_;
				GVariant* _tmp39_;
				_tmp34_ = arg;
				_tmp35_ = atoi (_tmp34_);
				value = (gint32) _tmp35_;
				_tmp36_ = vbuilder;
				_tmp37_ = value;
				_tmp38_ = g_variant_new_int32 (_tmp37_);
				_tmp39_ = g_variant_ref_sink (_tmp38_);
				g_variant_builder_add_value (_tmp36_, _tmp39_);
				_g_variant_unref0 (_tmp39_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("q")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp40_;
				gint _tmp41_ = 0;
				guint16 value;
				GVariantBuilder* _tmp42_;
				guint16 _tmp43_;
				GVariant* _tmp44_;
				GVariant* _tmp45_;
				_tmp40_ = arg;
				_tmp41_ = atoi (_tmp40_);
				value = (guint16) _tmp41_;
				_tmp42_ = vbuilder;
				_tmp43_ = value;
				_tmp44_ = g_variant_new_uint16 (_tmp43_);
				_tmp45_ = g_variant_ref_sink (_tmp44_);
				g_variant_builder_add_value (_tmp42_, _tmp45_);
				_g_variant_unref0 (_tmp45_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("u")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp46_;
				glong _tmp47_ = 0L;
				guint32 value;
				GVariantBuilder* _tmp48_;
				guint32 _tmp49_;
				GVariant* _tmp50_;
				GVariant* _tmp51_;
				_tmp46_ = arg;
				_tmp47_ = atol (_tmp46_);
				value = (guint32) _tmp47_;
				_tmp48_ = vbuilder;
				_tmp49_ = value;
				_tmp50_ = g_variant_new_uint32 (_tmp49_);
				_tmp51_ = g_variant_ref_sink (_tmp50_);
				g_variant_builder_add_value (_tmp48_, _tmp51_);
				_g_variant_unref0 (_tmp51_);
				break;
			}
		}
	} else if ((_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("t")))) || (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("x"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp52_;
				glong _tmp53_ = 0L;
				guint64 value;
				GVariantBuilder* _tmp54_;
				guint64 _tmp55_;
				GVariant* _tmp56_;
				GVariant* _tmp57_;
				_tmp52_ = arg;
				_tmp53_ = atol (_tmp52_);
				value = (guint64) _tmp53_;
				_tmp54_ = vbuilder;
				_tmp55_ = value;
				_tmp56_ = g_variant_new_uint64 (_tmp55_);
				_tmp57_ = g_variant_ref_sink (_tmp56_);
				g_variant_builder_add_value (_tmp54_, _tmp57_);
				_g_variant_unref0 (_tmp57_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp58_;
				gdouble _tmp59_ = 0.0;
				gdouble value;
				GVariantBuilder* _tmp60_;
				gdouble _tmp61_;
				GVariant* _tmp62_;
				GVariant* _tmp63_;
				_tmp58_ = arg;
				_tmp59_ = double_parse (_tmp58_);
				value = _tmp59_;
				_tmp60_ = vbuilder;
				_tmp61_ = value;
				_tmp62_ = g_variant_new_double (_tmp61_);
				_tmp63_ = g_variant_ref_sink (_tmp62_);
				g_variant_builder_add_value (_tmp60_, _tmp63_);
				_g_variant_unref0 (_tmp63_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("s")))) {
		switch (0) {
			default:
			{
				{
					const GVariantType* _tmp64_;
					const gchar* _tmp65_;
					GVariant* _tmp66_ = NULL;
					GVariant* v;
					GVariantBuilder* _tmp67_;
					GVariant* _tmp68_;
					_tmp64_ = G_VARIANT_TYPE_STRING;
					_tmp65_ = arg;
					_tmp66_ = g_variant_parse (_tmp64_, _tmp65_, NULL, NULL, &_inner_error_);
					v = _tmp66_;
					if (_inner_error_ != NULL) {
						goto __catch9_g_error;
					}
					_tmp67_ = vbuilder;
					_tmp68_ = v;
					g_variant_builder_add_value (_tmp67_, _tmp68_);
					_g_variant_unref0 (v);
				}
				goto __finally9;
				__catch9_g_error:
				{
					GError* e = NULL;
					GVariantBuilder* _tmp69_;
					const gchar* _tmp70_;
					GVariant* _tmp71_;
					GVariant* _tmp72_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp69_ = vbuilder;
					_tmp70_ = arg;
					_tmp71_ = g_variant_new_string (_tmp70_);
					_tmp72_ = g_variant_ref_sink (_tmp71_);
					g_variant_builder_add_value (_tmp69_, _tmp72_);
					_g_variant_unref0 (_tmp72_);
					_g_error_free0 (e);
				}
				__finally9:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label11) ? _tmp3_label11 : (_tmp3_label11 = g_quark_from_static_string ("o")))) {
		switch (0) {
			default:
			{
				GVariantBuilder* _tmp73_;
				const gchar* _tmp74_;
				GVariant* _tmp75_;
				GVariant* _tmp76_;
				_tmp73_ = vbuilder;
				_tmp74_ = arg;
				_tmp75_ = g_variant_new_object_path (_tmp74_);
				_tmp76_ = g_variant_ref_sink (_tmp75_);
				g_variant_builder_add_value (_tmp73_, _tmp76_);
				_g_variant_unref0 (_tmp76_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label12) ? _tmp3_label12 : (_tmp3_label12 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp77_;
				const gchar* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				gchar* _tmp83_ = NULL;
				gchar* _tmp84_;
				gchar* subsig;
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				GVariantBuilder* _tmp87_;
				gboolean _tmp88_ = FALSE;
				_tmp77_ = type;
				_tmp78_ = type;
				_tmp79_ = strlen (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = string_substring (_tmp77_, (glong) 1, (glong) (_tmp80_ - 1));
				_tmp82_ = _tmp81_;
				_tmp83_ = argument_get_sub_signature (self, _tmp82_);
				_tmp84_ = _tmp83_;
				_g_free0 (_tmp82_);
				subsig = _tmp84_;
				_tmp85_ = arg;
				_tmp86_ = subsig;
				_tmp87_ = vbuilder;
				_tmp88_ = argument_append_array_type (self, _tmp85_, _tmp86_, _tmp87_);
				result = _tmp88_;
				_g_free0 (subsig);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label13) ? _tmp3_label13 : (_tmp3_label13 = g_quark_from_static_string ("(")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				GVariantBuilder* _tmp91_;
				gboolean _tmp92_ = FALSE;
				_tmp89_ = arg;
				_tmp90_ = type;
				_tmp91_ = vbuilder;
				_tmp92_ = argument_append_struct_type (self, _tmp89_, _tmp90_, _tmp91_);
				result = _tmp92_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label14) ? _tmp3_label14 : (_tmp3_label14 = g_quark_from_static_string ("{")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				GVariantBuilder* _tmp95_;
				gboolean _tmp96_ = FALSE;
				_tmp93_ = arg;
				_tmp94_ = type;
				_tmp95_ = vbuilder;
				_tmp96_ = argument_append_dict_entry_type (self, _tmp93_, _tmp94_, _tmp95_);
				result = _tmp96_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FILE* _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_ = NULL;
				gchar* _tmp100_ = NULL;
				gchar* _tmp101_;
				_tmp97_ = stderr;
				_tmp98_ = type;
				_tmp99_ = string_to_string (_tmp98_);
				_tmp100_ = g_strconcat ("Unsupported type ", _tmp99_, "\n", NULL);
				_tmp101_ = _tmp100_;
				fprintf (_tmp97_, "%s", _tmp101_);
				_g_free0 (_tmp101_);
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean argument_append_array_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	const GVariantType* _tmp0_;
	GVariantBuilder* _tmp1_;
	GVariantBuilder* va;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GVariantBuilder* _tmp16_;
	GVariantBuilder* _tmp17_;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = G_VARIANT_TYPE_ARRAY;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	va = _tmp1_;
	_tmp2_ = arg;
	_tmp3_ = arg;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp2_, (glong) 1, (glong) (_tmp5_ - 2));
	_tmp7_ = _tmp6_;
	_tmp9_ = argument_get_sub_args (self, _tmp7_, ARGUMENT_arg_separator, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_g_free0 (_tmp7_);
	{
		gchar** sub_arg_collection = NULL;
		gint sub_arg_collection_length1 = 0;
		gint _sub_arg_collection_size_ = 0;
		gint sub_arg_it = 0;
		sub_arg_collection = _tmp10_;
		sub_arg_collection_length1 = _tmp10__length1;
		for (sub_arg_it = 0; sub_arg_it < _tmp10__length1; sub_arg_it = sub_arg_it + 1) {
			gchar* _tmp11_;
			gchar* sub_arg = NULL;
			_tmp11_ = g_strdup (sub_arg_collection[sub_arg_it]);
			sub_arg = _tmp11_;
			{
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GVariantBuilder* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp12_ = sub_arg;
				_tmp13_ = type;
				_tmp14_ = va;
				_tmp15_ = argument_append_type (self, _tmp12_, _tmp13_, _tmp14_);
				if (_tmp15_ == FALSE) {
					result = FALSE;
					_g_free0 (sub_arg);
					sub_arg_collection = (_vala_array_free (sub_arg_collection, sub_arg_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_builder_unref0 (va);
					return result;
				}
				_g_free0 (sub_arg);
			}
		}
		sub_arg_collection = (_vala_array_free (sub_arg_collection, sub_arg_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = vbuilder;
	_tmp17_ = va;
	_tmp18_ = g_variant_builder_end (_tmp17_);
	_tmp19_ = g_variant_ref_sink (_tmp18_);
	g_variant_builder_add_value (_tmp16_, _tmp19_);
	_g_variant_unref0 (_tmp19_);
	result = TRUE;
	_g_variant_builder_unref0 (va);
	return result;
}


static gboolean argument_append_struct_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	gint sigpos;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* subtype;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	sigpos = 0;
	_tmp0_ = type;
	_tmp1_ = type;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp0_, (glong) 1, (glong) (_tmp3_ - 2));
	subtype = _tmp4_;
	_tmp5_ = arg;
	_tmp6_ = arg;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_substring (_tmp5_, (glong) 1, (glong) (_tmp8_ - 2));
	_tmp10_ = _tmp9_;
	_tmp12_ = argument_get_sub_args (self, _tmp10_, ARGUMENT_arg_separator, &_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp11_;
	_g_free0 (_tmp10_);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp13_;
		s_collection_length1 = _tmp13__length1;
		for (s_it = 0; s_it < _tmp13__length1; s_it = s_it + 1) {
			gchar* _tmp14_;
			gchar* s = NULL;
			_tmp14_ = g_strdup (s_collection[s_it]);
			s = _tmp14_;
			{
				const gchar* _tmp15_;
				gint _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* sig;
				gint _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				GVariantBuilder* _tmp27_;
				gboolean _tmp28_ = FALSE;
				_tmp15_ = subtype;
				_tmp16_ = sigpos;
				_tmp17_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (-1));
				_tmp18_ = _tmp17_;
				_tmp19_ = argument_get_sub_signature (self, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				sig = _tmp20_;
				_tmp21_ = sigpos;
				_tmp22_ = sig;
				_tmp23_ = strlen (_tmp22_);
				_tmp24_ = _tmp23_;
				sigpos = _tmp21_ + ((gint) _tmp24_);
				_tmp25_ = s;
				_tmp26_ = sig;
				_tmp27_ = vbuilder;
				_tmp28_ = argument_append_type (self, _tmp25_, _tmp26_, _tmp27_);
				if (_tmp28_ == FALSE) {
					result = FALSE;
					_g_free0 (sig);
					_g_free0 (s);
					s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (subtype);
					return result;
				}
				_g_free0 (sig);
				_g_free0 (s);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	_g_free0 (subtype);
	return result;
}


gboolean argument_append_dict_entry_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* subtype;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* keytype;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* valuetype;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* key;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* value;
	const GVariantType* _tmp21_;
	GVariantBuilder* _tmp22_;
	GVariantBuilder* vde;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GVariantBuilder* _tmp25_;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GVariantBuilder* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GVariantBuilder* _tmp31_;
	GVariantBuilder* _tmp32_;
	GVariant* _tmp33_ = NULL;
	GVariant* _tmp34_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = type;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp0_, (glong) 1, (glong) (_tmp3_ - 2));
	subtype = _tmp4_;
	_tmp5_ = subtype;
	_tmp6_ = argument_get_sub_signature (self, _tmp5_);
	keytype = _tmp6_;
	_tmp7_ = subtype;
	_tmp8_ = keytype;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_substring (_tmp7_, (glong) _tmp10_, (glong) (-1));
	valuetype = _tmp11_;
	_tmp12_ = arg;
	_tmp14_ = argument_get_sub_args (self, _tmp12_, ':', &_tmp13_);
	values = _tmp14_;
	values_length1 = _tmp13_;
	_values_size_ = values_length1;
	_tmp15_ = values;
	_tmp15__length1 = values_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = g_strdup (_tmp16_);
	key = _tmp17_;
	_tmp18_ = values;
	_tmp18__length1 = values_length1;
	_tmp19_ = _tmp18_[1];
	_tmp20_ = g_strdup (_tmp19_);
	value = _tmp20_;
	_tmp21_ = G_VARIANT_TYPE_DICT_ENTRY;
	_tmp22_ = g_variant_builder_new (_tmp21_);
	vde = _tmp22_;
	_tmp23_ = key;
	_tmp24_ = keytype;
	_tmp25_ = vde;
	_tmp26_ = argument_append_type (self, _tmp23_, _tmp24_, _tmp25_);
	if (_tmp26_ == FALSE) {
		result = FALSE;
		_g_variant_builder_unref0 (vde);
		_g_free0 (value);
		_g_free0 (key);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (valuetype);
		_g_free0 (keytype);
		_g_free0 (subtype);
		return result;
	}
	_tmp27_ = value;
	_tmp28_ = valuetype;
	_tmp29_ = vde;
	_tmp30_ = argument_append_type (self, _tmp27_, _tmp28_, _tmp29_);
	if (_tmp30_ == FALSE) {
		result = FALSE;
		_g_variant_builder_unref0 (vde);
		_g_free0 (value);
		_g_free0 (key);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (valuetype);
		_g_free0 (keytype);
		_g_free0 (subtype);
		return result;
	}
	_tmp31_ = vbuilder;
	_tmp32_ = vde;
	_tmp33_ = g_variant_builder_end (_tmp32_);
	_tmp34_ = g_variant_ref_sink (_tmp33_);
	g_variant_builder_add_value (_tmp31_, _tmp34_);
	_g_variant_unref0 (_tmp34_);
	result = TRUE;
	_g_variant_builder_unref0 (vde);
	_g_free0 (value);
	_g_free0 (key);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (valuetype);
	_g_free0 (keytype);
	_g_free0 (subtype);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _vala_char_array_contains (gchar* stack, int stack_length, gchar needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gchar* argument_get_sub_signature (Argument* self, const gchar* signature) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gint depth;
	gint _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	depth = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_ = '\0';
				gchar c;
				gchar _tmp11_;
				const gchar* _tmp21_;
				gchar _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gint _tmp26_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = signature;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = signature;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				c = (gchar) _tmp10_;
				_tmp11_ = c;
				if (_tmp11_ == 'a') {
					const gchar* _tmp12_;
					gchar _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = _result_;
					_tmp13_ = c;
					_tmp14_ = g_strdup_printf ("%c", _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
					_g_free0 (_result_);
					_result_ = _tmp16_;
					_g_free0 (_tmp15_);
					continue;
				} else {
					gchar _tmp17_;
					_tmp17_ = c;
					if (_vala_char_array_contains (ARGUMENT_start_chars, G_N_ELEMENTS (ARGUMENT_start_chars), _tmp17_)) {
						gint _tmp18_;
						_tmp18_ = depth;
						depth = _tmp18_ + 1;
					} else {
						gchar _tmp19_;
						_tmp19_ = c;
						if (_vala_char_array_contains (ARGUMENT_end_chars, G_N_ELEMENTS (ARGUMENT_end_chars), _tmp19_)) {
							gint _tmp20_;
							_tmp20_ = depth;
							depth = _tmp20_ - 1;
						}
					}
				}
				_tmp21_ = _result_;
				_tmp22_ = c;
				_tmp23_ = g_strdup_printf ("%c", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp25_;
				_g_free0 (_tmp24_);
				_tmp26_ = depth;
				if (_tmp26_ == 0) {
					break;
				}
			}
		}
	}
	_tmp27_ = depth;
	g_assert (_tmp27_ == 0);
	result = _result_;
	return result;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** argument_get_sub_args (Argument* self, const gchar* arg, gchar separator, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gchar* _tmp1_;
	gchar* part;
	gint depth;
	gint _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = g_strdup ("");
	part = _tmp1_;
	depth = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gchar _tmp11_ = '\0';
				gchar c;
				gchar _tmp12_;
				const gchar* _tmp16_;
				gchar _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				gint _tmp22_;
				gboolean _tmp25_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = arg;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = arg;
				_tmp10_ = i;
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
				c = (gchar) _tmp11_;
				_tmp12_ = c;
				if (_vala_char_array_contains (ARGUMENT_start_chars, G_N_ELEMENTS (ARGUMENT_start_chars), _tmp12_)) {
					gint _tmp13_;
					_tmp13_ = depth;
					depth = _tmp13_ + 1;
				} else {
					gchar _tmp14_;
					_tmp14_ = c;
					if (_vala_char_array_contains (ARGUMENT_end_chars, G_N_ELEMENTS (ARGUMENT_end_chars), _tmp14_)) {
						gint _tmp15_;
						_tmp15_ = depth;
						depth = _tmp15_ - 1;
					}
				}
				_tmp16_ = part;
				_tmp17_ = c;
				_tmp18_ = g_strdup_printf ("%c", _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_g_free0 (part);
				part = _tmp20_;
				_g_free0 (_tmp19_);
				_tmp22_ = depth;
				if (_tmp22_ == 0) {
					gchar _tmp23_;
					gchar _tmp24_;
					_tmp23_ = c;
					_tmp24_ = separator;
					_tmp21_ = _tmp23_ == _tmp24_;
				} else {
					_tmp21_ = FALSE;
				}
				_tmp25_ = _tmp21_;
				if (_tmp25_) {
					gchar** _tmp26_;
					gint _tmp26__length1;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					_tmp26_ = _result_;
					_tmp26__length1 = _result__length1;
					_tmp27_ = part;
					_tmp28_ = part;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = string_substring (_tmp27_, (glong) 0, (glong) (_tmp30_ - 1));
					_vala_array_add8 (&_result_, &_result__length1, &__result__size_, _tmp31_);
					_tmp32_ = g_strdup ("");
					_g_free0 (part);
					part = _tmp32_;
				}
			}
		}
	}
	_tmp33_ = depth;
	g_assert (_tmp33_ == 0);
	_tmp34_ = part;
	_tmp35_ = strlen (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != 0) {
		gchar** _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp37_ = _result_;
		_tmp37__length1 = _result__length1;
		_tmp38_ = part;
		_tmp39_ = g_strdup (_tmp38_);
		_vala_array_add9 (&_result_, &_result__length1, &__result__size_, _tmp39_);
	}
	_tmp40_ = _result_;
	_tmp40__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	_g_free0 (part);
	return result;
}


static void argument_class_init (ArgumentClass * klass) {
	argument_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ArgumentPrivate));
	G_OBJECT_CLASS (klass)->finalize = argument_finalize;
}


static void argument_instance_init (Argument * self) {
	self->priv = ARGUMENT_GET_PRIVATE (self);
}


static void argument_finalize (GObject* obj) {
	Argument * self;
	self = ARGUMENT (obj);
	_g_variant_builder_unref0 (self->priv->_vbuilder);
	_g_free0 (self->name);
	_g_free0 (self->type);
	G_OBJECT_CLASS (argument_parent_class)->finalize (obj);
}


GType argument_get_type (void) {
	static volatile gsize argument_type_id__volatile = 0;
	if (g_once_init_enter (&argument_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Argument), 0, (GInstanceInitFunc) argument_instance_init, NULL };
		GType argument_type_id;
		argument_type_id = g_type_register_static (G_TYPE_OBJECT, "Argument", &g_define_type_info, 0);
		g_once_init_leave (&argument_type_id__volatile, argument_type_id);
	}
	return argument_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



