# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class SegYReader(DataSetAlgorithm):
    r"""
    SegYReader - Reads SegY data files.
    
    Superclass: DataSetAlgorithm
    
    SegYReader reads SegY data files. We create a StructuredGrid
    for 2.5D SegY and 3D data. If we set the structured_grid option to 0
    we create a ImageData for 3D data. This saves memory and may
    speed-up certain algorithms, but the position and the shape of the
    data may not be correct. The axes for the data are: crossline,
    inline, depth. For situations where traces are missing values of zero
    are used to fill in the dataset.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSegYReader, obj, update, **traits)
    
    force2d = tvtk_base.false_bool_trait(desc=\
        r"""
        Should we force the data to be interpreted as a 2D dataset? It
        may be a 2D sheet through 3D space. When this is turned on we
        ignore the cross line and line values and instead build a 2D data
        by processing and connecting the traces in order from first to
        last. The output will be a Structrured Grid.
        """
    )

    def _force2d_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForce2D,
                        self.force2d_)

    structured_grid = tvtk_base.true_bool_trait(desc=\
        r"""
        Specify if we create a StructuredGrid even when the data is
        3D. Note this consumes more memory but it shows the precise
        location for each point and the correct shape of the data. The
        default value is true.  If we set this option to false we create
        a ImageData for the SegY 3D dataset.
        """
    )

    def _structured_grid_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStructuredGrid,
                        self.structured_grid_)

    xy_coord_mode = tvtk_base.RevPrefixMap({'source': 0, 'cdp': 1, 'custom': 2}, default_value='source', desc=\
        r"""
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
    )

    def _xy_coord_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXYCoordMode,
                        self.xy_coord_mode_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    vertical_crs = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify whether the vertical coordinates in the SEG-Y file are
        heights (positive up) or depths (positive down). By default, the
        vertical coordinates are treated as heights (i.e. positive up).
        This means that the Z-axis of the dataset goes from 0 (surface)
        to -ve depth (last sample).
        
        ote As per the SEG-Y rev 2.0 specification, this information is
        defined in the Location Data Stanza of the Extended Textual
        Header. However, as of this revision, SegY2DReader does not
        support reading the extended textual header.
        """
    )

    def _vertical_crs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerticalCRS,
                        self.vertical_crs)

    x_coord_byte = traits.Int(73, enter_set=True, auto_set=False, desc=\
        r"""
        Specify X and Y byte positions for custom XYcoordinate_mode. By
        default, Xcoord_byte = 73, Ycoord_byte = 77 i.e. source xy.
        
        \sa set_xy_coordinates_mode_to_custom()
        """
    )

    def _x_coord_byte_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXCoordByte,
                        self.x_coord_byte)

    y_coord_byte = traits.Int(77, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _y_coord_byte_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetYCoordByte,
                        self.y_coord_byte)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('force2d', 'GetForce2D'), ('structured_grid', 'GetStructuredGrid'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('xy_coord_mode', 'GetXYCoordMode'), ('file_name', 'GetFileName'),
    ('vertical_crs', 'GetVerticalCRS'), ('x_coord_byte', 'GetXCoordByte'),
    ('y_coord_byte', 'GetYCoordByte'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'force2d', 'global_warning_display',
    'release_data_flag', 'structured_grid', 'xy_coord_mode', 'file_name',
    'object_name', 'progress_text', 'vertical_crs', 'x_coord_byte',
    'y_coord_byte'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SegYReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SegYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['force2d', 'structured_grid'], ['xy_coord_mode'], ['file_name',
            'object_name', 'vertical_crs', 'x_coord_byte', 'y_coord_byte']),
            title='Edit SegYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SegYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

