doc ///
  Key
    reiffen
    (reiffen,ZZ,ZZ)
  Headline
    Reiffen's curve
  Usage
    reiffen(p,q)
  Inputs
    p:ZZ
    q:ZZ
  Outputs
    :RingElement
    	the defining polynomial of Reiffen's (p,q)-curve 
  Description
    Text
      Reiffen's (p,q)-curve is a singular curve defined by $f_{p,q} = x_1^p+x_2^q+x_1x_2^{q-1} = 0$ for $p>=4$ and $q>=p+1$.
    Example
      reiffen(4,5)	
///

doc ///
  Key
    kappaAnnF1PlanarCurve
    (kappaAnnF1PlanarCurve,RingElement)    
  Headline
    D-annihilator of 1/f for a planar curve
  Usage
    kappaAnnF1PlanarCurve f
  Inputs 
    k:ZZ
      positive
    f:RingElement
      a polynomial in $R = K[x_1,x_2]$
  Outputs
    I:Ideal
      an ideal in the Weyl algebra $D = K<x_1,x_2,\partial_1,\partial_2>$ 
  Description
    Text 
      The method uses @TO kOrderAnnFs@ to efficiently compute the annihilator of $f^{-1}$, which equals the output of @TO AnnFs@ after substitution $s=-1$, for a {\em planar curve}.  
      This annihilator defines the localization: $D/I \cong R_f$.
      See [@HREF("https://arxiv.org/abs/1110.0182","Castro-Jimenez, Leykin \"Computing localizations iteratively\" (2012)")@] for details.    
    Example
      f = reiffen(4,5)
      As = AnnFs f
      A = sub(As, {last gens ring As => -1});
      (kappa,A') = kappaAnnF1PlanarCurve f
      A == sub(A', ring A)
  SeeAlso    
      kOrderAnnFa
      kOrderAnnFs
      AnnFs
///

doc ///
  Key
    kOrderAnnFa
    (kOrderAnnFa,ZZ,RingElement,ZZ)
    kOrderAnnFs
    (kOrderAnnFs,ZZ,RingElement)
  Headline
    k-th order D-annihilator of a power of a polynomial   
  Usage
    kOrderAnnFa(k,f,a)
    kOrderAnnFs(k,f)
  Inputs 
    k:ZZ
      positive
    f:RingElement
      a polynomial in $K[x_1,...,x_n]$
    a:ZZ
      (usually negative) exponent
  Outputs
    I:Ideal
      an ideal in the Weyl algebra $K<x_1,...,x_n,\partial_1,...,\partial_n>$ (or  $K[s]<x_1,...,x_n,\partial_1,...,\partial_n>$)
  Description
    Text 
      @TO kOrderAnnFa@ (@TO kOrderAnnFs@) return an ideal generated by elements of order at most $k$ of the annihilator of $f^a$ ($f^s$). 
      See [@HREF("https://arxiv.org/abs/1110.0182","Castro-Jimenez, Leykin \"Computing localizations iteratively\" (2012)")@] for details.    
    Example
      R = QQ[x_1,x_2]; f = x_1^2-x_2^3;
      A1 = kOrderAnnFa(1,f,-1)
      As = kOrderAnnFs(1,f)
  SeeAlso    
      kappaAnnF1PlanarCurve
      AnnFs
///
