.TH "ZIP_SOURCE_TELL_WRITE" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_tell_write\fR
\- report current write offset in zip source
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.br
.PD 0
.HP 4n
\fBzip_source_tell_write\fR(\fIzip_source_t\ *source\fR);
.PD
.SH "DESCRIPTION"
The function
\fBzip_source_tell_write\fR()
returns the current write offset
for
\fIsource\fR.
The return value can be passed to
zip_source_seek_write(3)
with
\fIwhence\fR
set to
\fRSEEK_SET\fR
to return to the same location in the source.
.SH "RETURN VALUES"
Upon successful completion the current write offset is returned.
Otherwise, \-1 is returned and the error information in
\fIsource\fR
is set to indicate the error.
.SH "SEE ALSO"
libzip(3),
zip_source(3),
zip_source_begin_write(3),
zip_source_commit_write(3),
zip_source_rollback_write(3),
zip_source_tell(3),
zip_source_write(3)
.SH "HISTORY"
\fBzip_source_tell_write\fR()
was added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
