#include "sw-avatar-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_avatar_iface_object_info;

struct _SwAvatarIfaceClass {
    GTypeInterface parent_class;
    sw_avatar_iface_request_avatar_impl request_avatar;
};

enum {
    SIGNAL_AVATAR_IFACE_AvatarRetrieved,
    N_AVATAR_IFACE_SIGNALS
};
static guint avatar_iface_signals[N_AVATAR_IFACE_SIGNALS] = {0};

static void sw_avatar_iface_base_init (gpointer klass);

GType
sw_avatar_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwAvatarIfaceClass),
        sw_avatar_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwAvatarIface", &info, 0);
    }

  return type;
}

/**
 * sw_avatar_iface_request_avatar_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatar on interface com.meego.libsocialweb.Avatar.
 */
static void
sw_avatar_iface_request_avatar (SwAvatarIface *self,
    DBusGMethodInvocation *context)
{
  sw_avatar_iface_request_avatar_impl impl = (SW_AVATAR_IFACE_GET_CLASS (self)->request_avatar);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_avatar_iface_implement_request_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatar D-Bus method
 *
 * Register an implementation for the RequestAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_avatar_iface_implement_request_avatar (SwAvatarIfaceClass *klass, sw_avatar_iface_request_avatar_impl impl)
{
  klass->request_avatar = impl;
}

/**
 * sw_avatar_iface_emit_avatar_retrieved:
 * @instance: The object implementing this interface
 * @arg_path: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarRetrieved signal on interface com.meego.libsocialweb.Avatar.
 */
void
sw_avatar_iface_emit_avatar_retrieved (gpointer instance,
    const gchar *arg_path)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_AVATAR_IFACE));
  g_signal_emit (instance,
      avatar_iface_signals[SIGNAL_AVATAR_IFACE_AvatarRetrieved],
      0,
      arg_path);
}

static inline void
sw_avatar_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_avatar_iface_get_type (),
      &_sw_avatar_iface_object_info);

  /**
   * SwAvatarIface::avatar-retrieved:
   * @arg_path: const gchar * (FIXME, generate documentation)
   *
   * The AvatarRetrieved D-Bus signal is emitted whenever this GObject signal is.
   */
  avatar_iface_signals[SIGNAL_AVATAR_IFACE_AvatarRetrieved] =
  g_signal_new ("avatar-retrieved",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__STRING,
      G_TYPE_NONE,
      1,
      G_TYPE_STRING);

}
static void
sw_avatar_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_avatar_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_avatar_iface_methods[] = {
  { (GCallback) sw_avatar_iface_request_avatar, g_cclosure_marshal_VOID__POINTER, 0 },
};

static const DBusGObjectInfo _sw_avatar_iface_object_info = {
  0,
  _sw_avatar_iface_methods,
  1,
"com.meego.libsocialweb.Avatar\0RequestAvatar\0A\0\0\0",
"com.meego.libsocialweb.Avatar\0AvatarRetrieved\0\0",
"\0\0",
};


