///////////////////////////////////////////////////////////////////////////////
// UTF8CONV.H
//
// Unicode UTF8-UCHAR functions. These are helpers that are internal to the
// framework (as they make some assumptions about legality of the data.
//
// Dr J A Gow : 12/2006
//
// This file is distributed under the terms and conditions of the LGPL - please
// see the file LICENCE in the package root directory.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _UTF8CONV_H_
#define _UTF8CONV_H_

#include "sysincludes.h"

#define XU_UNICODE_CHARMAX	0x10FFFF

//
// Exported functions

///////////////////////////////////////////////////////////////////////////////
// CV_UTF32FromUTF8
//
// EXPORTED
//
// Generates a Unicode code point from a UTF8 byte array.
//
///////////////////////////////////////////////////////////////////////////////

DWORD CV_UTF32FromUTF8(BYTE * utfchar);

///////////////////////////////////////////////////////////////////////////////
// CV_UTF8FromUTF32
//
// EXPORTED
//
// Fills the array with code point specified by the Unicode DWORD
//
///////////////////////////////////////////////////////////////////////////////

int CV_UTF8FromUTF32(DWORD ch, BYTE * data);

///////////////////////////////////////////////////////////////////////////////
// CV_SizeOfUTF8
//
// EXPORTED
//
// Returns the size in bytes of a given character when encoded in UTF-8
//
///////////////////////////////////////////////////////////////////////////////

int CV_SizeOfUTF8(const DWORD ch);

///////////////////////////////////////////////////////////////////////////////
// CV_SizeOfUTF8Data
//
// EXPORTED
//
// Returns the number of BYTEs in the character pointed to.
//
///////////////////////////////////////////////////////////////////////////////

int CV_SizeOfUTF8Data(const BYTE * data);


#endif
