/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2015  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef ODSDOCHANDLERINTERFACE_H
#define ODSDOCHANDLERINTERFACE_H

#include <QString>
#include "reader/odscell.h"

class OdsDocHandlerInterface
{
public:
    /**
     * callback that indicates the begining of a data sheet. Override it in
     * order to retrieve information about the current data sheet.
     *
     */
    virtual void startSheet(const QString & sheet_name) = 0 ;

    /**
    * callback that indicates the end of the current data sheet. Override it if
    * needed
    */
    virtual void endSheet()  = 0 ;

    /**
     * callback that indicates a new line start. Override it if needed.
     */

    virtual void startLine()  = 0 ;

    /**
     * callback that indicates a line ending. Override it if needed.
     */

    virtual void endLine()  = 0 ;

    /**
     * callback that report the content of the current cell in a dedicated Cell
     * object. Override it if you need to retrieve cell content.
     */
    virtual void setCell(const OdsCell &)  = 0 ;

    /**
     * callback that report the end of the ODS document. Override it if you need
     * to know that reading is finished.
     */
    virtual void endDocument() = 0 ;

};

#endif // ODSDOCHANDLERINTERFACE_H
