/*
 * The internal definitions
 *
 * Copyright (C) 2021-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSFAT_INTERNAL_DEFINITIONS_H )
#define _LIBFSFAT_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

#define LIBFSFAT_ENDIAN_BIG					_BYTE_STREAM_ENDIAN_BIG
#define LIBFSFAT_ENDIAN_LITTLE					_BYTE_STREAM_ENDIAN_LITTLE

/* Define HAVE_LOCAL_LIBFSFAT for local use of libfsfat
 */
#if !defined( HAVE_LOCAL_LIBFSFAT )
#include <libfsfat/definitions.h>

/* The definitions in <libfsfat/definitions.h> are copied here
 * for local use of libfsfat
 */
#else
#define LIBFSFAT_VERSION					20240501

/* The version string
 */
#define LIBFSFAT_VERSION_STRING					"20240501"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSFAT_ACCESS_FLAGS
{
	LIBFSFAT_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBFSFAT_ACCESS_FLAG_WRITE				= 0x02
};

/* The file access macros
 */
#define LIBFSFAT_OPEN_READ					( LIBFSFAT_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSFAT_OPEN_WRITE					( LIBFSFAT_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSFAT_OPEN_READ_WRITE				( LIBFSFAT_ACCESS_FLAG_READ | LIBFSFAT_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSFAT_SEPARATOR					'\\'

/* The file system formats
 */
enum LIBFSFAT_FILE_SYSTEM_FORMAT
{
	LIBFSFAT_FILE_SYSTEM_FORMAT_UNKNOWN			= 0,
	LIBFSFAT_FILE_SYSTEM_FORMAT_EXFAT			= 1,
	LIBFSFAT_FILE_SYSTEM_FORMAT_FAT12			= 2,
	LIBFSFAT_FILE_SYSTEM_FORMAT_FAT16			= 3,
	LIBFSFAT_FILE_SYSTEM_FORMAT_FAT32			= 4
};

/* The file attribute flags
 */
enum LIBFSFAT_FILE_ATTRIBUTE_FLAGS
{
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_READ_ONLY			= 0x01,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_HIDDEN			= 0x02,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_SYSTEM			= 0x04,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_VOLUME_LABEL		= 0x08,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_DIRECTORY			= 0x10,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_ARCHIVE			= 0x20,
	LIBFSFAT_FILE_ATTRIBUTE_FLAG_DEVICE			= 0x40
};

#endif /* !defined( HAVE_LOCAL_LIBFSFAT ) */

/* The directory entry types
 */
enum LIBFSFAT_DIRECTORY_ENTRY_TYPES
{
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_TERMINATOR		= 0,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_UNALLOCATED		= 1,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_SHORT_NAME		= 2,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_VFAT_LONG_NAME		= 3,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_ALLOCATION_BITMAP	= 4,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_DATA_STREAM 	= 5,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_FILE_ENTRY		= 6,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_FILE_ENTRY_NAME	= 7,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_UPCASE_TABLE	= 8,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_UNKNOWN		= 9,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_VOLUME_IDENTIFIER	= 10,
	LIBFSFAT_DIRECTORY_ENTRY_TYPE_EXFAT_VOLUME_LABEL	= 11
};

/* The file entry flag definitions
 */
enum LIBFSFAT_FILE_ENTRY_FLAGS
{
	LIBFSFAT_FILE_ENTRY_FLAG_MANAGE_DIRECTORY		= 0x01
};

#define LIBFSFAT_MAXIMUM_NUMBER_OF_CLUSTERS_IN_FAT		( ( (uint32_t) 256 * 1024 * 1024 ) / 4 )

#define LIBFSFAT_BLOCK_TREE_NUMBER_OF_SUB_NODES			256

#define LIBFSFAT_MAXIMUM_CACHE_ENTRIES_DIRECTORIES		32

#define LIBFSFAT_MAXIMUM_RECURSION_DEPTH			256

#endif /* !defined( _LIBFSFAT_INTERNAL_DEFINITIONS_H ) */

