/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#if !defined(_LFP_SOCKET_H_)
# define _LFP_SOCKET_H_

#include <lfp/aux.h>

CPLUSPLUS_GUARD

#include <sys/socket.h>

#include <inttypes.h>

int lfp_socket(int domain, int type, int protocol, uint64_t flags);

int lfp_accept(int             sockfd,
               struct sockaddr *addr,
               socklen_t       *addrlen,
               uint64_t        flags);

struct cmsghdr* lfp_cmsg_firsthdr(struct msghdr* msgh);

struct cmsghdr* lfp_cmsg_nxthdr(struct msghdr* msgh, struct cmsghdr* cmsg);

size_t lfp_cmsg_space(size_t length);

size_t lfp_cmsg_len(size_t length);

void* lfp_cmsg_data(struct cmsghdr* cmsg);

END_CPLUSPLUS_GUARD

#endif /* _LFP_SOCKET_H_ */
