/* vfs-file-monitor-impl-gnome-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-file-monitor-impl-gnome-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: File monitor implementation (with GNOME VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <libgnomevfs/gnome-vfs.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS (desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFS DesktopAgnosticVFSFileMonitorGnomeVFS;
typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFSClass DesktopAgnosticVFSFileMonitorGnomeVFSClass;
typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFSPrivate DesktopAgnosticVFSFileMonitorGnomeVFSPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS (desktop_agnostic_vfs_file_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileGnomeVFS DesktopAgnosticVFSFileGnomeVFS;
typedef struct _DesktopAgnosticVFSFileGnomeVFSClass DesktopAgnosticVFSFileGnomeVFSClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DesktopAgnosticVFSFileMonitorGnomeVFS {
	GObject parent_instance;
	DesktopAgnosticVFSFileMonitorGnomeVFSPrivate * priv;
};

struct _DesktopAgnosticVFSFileMonitorGnomeVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSFileMonitorGnomeVFSPrivate {
	gboolean _cancelled;
	GnomeVFSMonitorHandle* handle;
	DesktopAgnosticVFSFile* _file;
};


static gpointer desktop_agnostic_vfs_file_monitor_gnome_vfs_parent_class = NULL;
static DesktopAgnosticVFSFileMonitorIface* desktop_agnostic_vfs_file_monitor_gnome_vfs_desktop_agnostic_vfs_file_monitor_parent_iface = NULL;

GType desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CANCELLED
};
GType desktop_agnostic_vfs_file_gnome_vfs_get_type (void) G_GNUC_CONST;
DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_new (DesktopAgnosticVFSFileGnomeVFS* file);
DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_construct (GType object_type, DesktopAgnosticVFSFileGnomeVFS* file);
static void desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback (DesktopAgnosticVFSFileMonitorGnomeVFS* self, GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event);
static void _desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback_gnome_vfs_monitor_callback (GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type, gpointer self);
static void desktop_agnostic_vfs_file_monitor_gnome_vfs_real_emit (DesktopAgnosticVFSFileMonitor* base, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
static gboolean desktop_agnostic_vfs_file_monitor_gnome_vfs_real_cancel (DesktopAgnosticVFSFileMonitor* base);
static void desktop_agnostic_vfs_file_monitor_gnome_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_file_monitor_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback_gnome_vfs_monitor_callback (GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type, gpointer self) {
	desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback (self, handle, monitor_uri, info_uri, event_type);
}


DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_construct (GType object_type, DesktopAgnosticVFSFileGnomeVFS* file) {
	DesktopAgnosticVFSFileMonitorGnomeVFS * self = NULL;
	DesktopAgnosticVFSFile* _tmp0_;
	GnomeVFSMonitorType mt = 0;
	char* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (DesktopAgnosticVFSFileMonitorGnomeVFS*) g_object_new (object_type, NULL);
	self->priv->_file = (_tmp0_ = _g_object_ref0 ((DesktopAgnosticVFSFile*) file), _g_object_unref0 (self->priv->_file), _tmp0_);
	if (desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) file) == DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY) {
		mt = GNOME_VFS_MONITOR_DIRECTORY;
	} else {
		mt = GNOME_VFS_MONITOR_FILE;
	}
	gnome_vfs_monitor_add (&self->priv->handle, _tmp1_ = desktop_agnostic_vfs_file_get_uri ((DesktopAgnosticVFSFile*) file), mt, _desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback_gnome_vfs_monitor_callback, self);
	_g_free0 (_tmp1_);
	self->priv->_cancelled = FALSE;
	return self;
}


DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_new (DesktopAgnosticVFSFileGnomeVFS* file) {
	return desktop_agnostic_vfs_file_monitor_gnome_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, file);
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_monitor_callback (DesktopAgnosticVFSFileMonitorGnomeVFS* self, GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event) {
	DesktopAgnosticVFSFile* info_file;
	DesktopAgnosticVFSFileMonitorEvent da_event = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	g_return_if_fail (monitor_uri != NULL);
	g_return_if_fail (info_uri != NULL);
	info_file = NULL;
	if (info_uri != NULL) {
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		_tmp0_ = desktop_agnostic_vfs_file_new_for_uri (info_uri, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		info_file = (_tmp1_ = _tmp0_, _g_object_unref0 (info_file), _tmp1_);
	}
	switch (event) {
		case GNOME_VFS_MONITOR_EVENT_CHANGED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED;
			break;
		}
		case GNOME_VFS_MONITOR_EVENT_CREATED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED;
			break;
		}
		case GNOME_VFS_MONITOR_EVENT_DELETED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED;
			break;
		}
		case GNOME_VFS_MONITOR_EVENT_METADATA_CHANGED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED;
			break;
		}
		default:
		{
			_g_object_unref0 (info_file);
			return;
		}
	}
	g_signal_emit_by_name ((DesktopAgnosticVFSFileMonitor*) self, "changed", self->priv->_file, info_file, da_event);
	_g_object_unref0 (info_file);
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_real_emit (DesktopAgnosticVFSFileMonitor* base, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event) {
	DesktopAgnosticVFSFileMonitorGnomeVFS * self;
	self = (DesktopAgnosticVFSFileMonitorGnomeVFS*) base;
	g_signal_emit_by_name ((DesktopAgnosticVFSFileMonitor*) self, "changed", self->priv->_file, other, event);
}


static gboolean desktop_agnostic_vfs_file_monitor_gnome_vfs_real_cancel (DesktopAgnosticVFSFileMonitor* base) {
	DesktopAgnosticVFSFileMonitorGnomeVFS * self;
	gboolean result = FALSE;
	GnomeVFSResult res;
	self = (DesktopAgnosticVFSFileMonitorGnomeVFS*) base;
	res = gnome_vfs_monitor_cancel (self->priv->handle);
	self->priv->_cancelled = res == GNOME_VFS_OK;
	result = self->priv->_cancelled;
	return result;
}


static gboolean desktop_agnostic_vfs_file_monitor_gnome_vfs_real_get_cancelled (DesktopAgnosticVFSFileMonitor* base) {
	gboolean result;
	DesktopAgnosticVFSFileMonitorGnomeVFS* self;
	self = (DesktopAgnosticVFSFileMonitorGnomeVFS*) base;
	result = self->priv->_cancelled;
	return result;
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_class_init (DesktopAgnosticVFSFileMonitorGnomeVFSClass * klass) {
	desktop_agnostic_vfs_file_monitor_gnome_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSFileMonitorGnomeVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_monitor_gnome_vfs_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_file_monitor_gnome_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CANCELLED, "cancelled");
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_desktop_agnostic_vfs_file_monitor_interface_init (DesktopAgnosticVFSFileMonitorIface * iface) {
	desktop_agnostic_vfs_file_monitor_gnome_vfs_desktop_agnostic_vfs_file_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->emit = desktop_agnostic_vfs_file_monitor_gnome_vfs_real_emit;
	iface->cancel = desktop_agnostic_vfs_file_monitor_gnome_vfs_real_cancel;
	iface->get_cancelled = desktop_agnostic_vfs_file_monitor_gnome_vfs_real_get_cancelled;
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_instance_init (DesktopAgnosticVFSFileMonitorGnomeVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSFileMonitorGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS (obj);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (desktop_agnostic_vfs_file_monitor_gnome_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileMonitorGnomeVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_monitor_gnome_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFileMonitorGnomeVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_monitor_gnome_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_file_monitor_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_file_monitor_gnome_vfs_desktop_agnostic_vfs_file_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id;
		desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSFileMonitorGnomeVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, &desktop_agnostic_vfs_file_monitor_info);
		g_once_init_leave (&desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id__volatile, desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id);
	}
	return desktop_agnostic_vfs_file_monitor_gnome_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_file_monitor_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFileMonitorGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CANCELLED:
		g_value_set_boolean (value, desktop_agnostic_vfs_file_monitor_get_cancelled ((DesktopAgnosticVFSFileMonitor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




