/***************************************************************************
          cstring-compare.cpp  -  test CString::Compare() function
                             -------------------
    begin                : Thu Dec 18 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Because I re-arranged the code, compiled with optimization it probably
 * turns out the same anyway.
 */

#include <dclib/core/cstring.h>

#include <stdio.h>

int main( int /* argc */, char *[] /*argv[] */ )
{
	CString empty1;
	CString cs1 = "emily";
	CString cs2 = "martie";
	CString cs3 = "natalie";
	CString cs4 = "natalie";
	CString empty2;
	
	const char * s1 = "emily";
	const char * s2 = "martie";
	const char * s3 = "natalie";
	const char * nullstr = 0;
	
	int failed = 0;
	
	int res = cs1.Compare(cs2);
	if ( res >= 0 )
	{
		printf("failed 1: %d\n",res);
		++failed;
	}
	
	res = cs3.Compare(cs2);
	if ( res <= 0 )
	{
		printf("failed 2: %d\n",res);
		++failed;
	}
	
	res = cs3.Compare(cs4);
	if ( res != 0 )
	{
		printf("failed 3: %d\n",res);
		++failed;
	}
	
	res = cs1.Compare(s2);
	if ( res >= 0 )
	{
		printf("failed 4: %d\n",res);
		++failed;
	}
	
	res = cs3.Compare(s2);
	if ( res <= 0 )
	{
		printf("failed 5: %d\n",res);
		++failed;
	}
	
	res = cs2.Compare(s2);
	if ( res != 0 )
	{
		printf("failed 6: %d\n",res);
		++failed;
	}
	
	res = empty1.Compare(empty2);
	if ( res != 0 )
	{
		printf("failed 7: %d\n",res);
		++failed;
	}
	
	res = empty1.Compare(cs1);
	if ( res <= 0 )
	{
		printf("failed 8: %d\n",res);
		++failed;
	}
	
	res = empty1.Compare(nullstr);
	if ( res != 0 )
	{
		printf("failed 9: %d\n",res);
		++failed;
	}
	
	res = cs1.Compare(empty1);
	if ( res >= 0 )
	{
		printf("failed 10: %d\n",res);
		++failed;
	}
	
	res = cs1.Compare(nullstr);
	if ( res >= 0 )
	{
		printf("failed 11: %d\n",res);
		++failed;
	}
	
	/* CString::Compare() is not used directly, it's confusing. */
	/* The comparison operators are more useful. */
	
	if ( !((cs1 < cs2) && (cs1 < s2) && (s1 < cs2)) )
	{
		printf("failed 12\n");
		++failed;
	}
	
	if ( !((cs1 <= cs2) && (cs1 <= s2) && (s1 <= cs2)) )
	{
		printf("failed 13\n");
		++failed;
	}
	
	if ( !((cs3 <= cs4) && (cs2 <= s2) && (s1 <= cs1)) )
	{
		printf("failed 14\n");
		++failed;
	}
	
	if ( !((cs4 > cs2) && (cs4 > s2) && (s3 > cs1)) )
	{
		printf("failed 15\n");
		++failed;
	}
	
	if ( !((cs4 >= cs2) && (cs4 >= s2) && (s3 >= cs1)) )
	{
		printf("failed 16\n");
		++failed;
	}
	
	if ( !((cs3 >= cs4) && (cs2 >= s2) && (s1 >= cs1)) )
	{
		printf("failed 17\n");
		++failed;
	}
	
	return failed;
}
