
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "upload things to the CPAN",
  "AUTHOR" => "Ricardo SIGNES <rjbs\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "CPAN-Uploader",
  "EXE_FILES" => [
    "bin/cpan-upload"
  ],
  "LICENSE" => "perl",
  "NAME" => "CPAN::Uploader",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Data::Dumper" => 0,
    "File::Basename" => 0,
    "File::HomeDir" => 0,
    "File::Spec" => 0,
    "Getopt::Long::Descriptive" => "0.084",
    "HTTP::Request::Common" => 0,
    "HTTP::Status" => 0,
    "LWP::Protocol::https" => 1,
    "LWP::UserAgent" => 0,
    "Term::ReadKey" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => "0.96"
  },
  "VERSION" => "0.103006",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Carp" => 0,
  "Data::Dumper" => 0,
  "File::Basename" => 0,
  "File::HomeDir" => 0,
  "File::Spec" => 0,
  "Getopt::Long::Descriptive" => "0.084",
  "HTTP::Request::Common" => 0,
  "HTTP::Status" => 0,
  "LWP::Protocol::https" => 1,
  "LWP::UserAgent" => 0,
  "Term::ReadKey" => 0,
  "Test::More" => "0.96",
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



