/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.AntDownloadMonitor;
import org.apache.maven.artifact.ant.AntResolutionListener;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class DependenciesTask
extends AbstractArtifactTask {
    private List dependencies = new ArrayList();
    private List remoteRepositories = new ArrayList();
    private String pathId;
    private String filesetId;
    private String useScope;
    private String type;
    private boolean verbose;

    protected void doExecute() {
        ArtifactResolutionResult result;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        ArtifactFactory artifactFactory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        List dependencies = this.dependencies;
        Pom pom = this.buildPom(projectBuilder, localRepo);
        if (pom != null) {
            if (!dependencies.isEmpty()) {
                throw new BuildException("You cannot specify both dependencies and a pom in the dependencies task");
            }
            dependencies = pom.getDependencies();
            Iterator i = pom.getRepositories().iterator();
            while (i.hasNext()) {
                Repository pomRepository = (Repository)i.next();
                this.remoteRepositories.add(this.createAntRemoteRepository(pomRepository));
            }
        } else {
            pom = this.createDummyPom();
        }
        if (dependencies.isEmpty()) {
            this.log("There were no dependencies specified", 1);
        }
        this.log("Resolving dependencies...", 3);
        WagonManager wagonManager = (WagonManager)this.lookup(WagonManager.ROLE);
        wagonManager.setDownloadMonitor(new AntDownloadMonitor());
        try {
            Set artifacts = MavenMetadataSource.createArtifacts(artifactFactory, dependencies, null, null, null);
            Artifact pomArtifact = artifactFactory.createBuildArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getPackaging());
            List<AntResolutionListener> listeners = Collections.EMPTY_LIST;
            if (this.verbose) {
                listeners = Collections.singletonList(new AntResolutionListener(this.getProject()));
            }
            List remoteRepositories = this.getRemoteRepositories();
            RemoteRepository remoteRepository = AbstractArtifactTask.getDefaultRemoteRepository();
            remoteRepositories.add(remoteRepository);
            List remoteArtifactRepositories = this.createRemoteArtifactRepositories(remoteRepositories);
            Map managedDependencies = Collections.EMPTY_MAP;
            ArtifactFilter filter = null;
            if (this.useScope != null) {
                filter = new ScopeArtifactFilter(this.useScope);
            }
            if (this.type != null) {
                TypeArtifactFilter typeArtifactFilter = new TypeArtifactFilter(this.type);
                if (filter != null) {
                    AndArtifactFilter andFilter = new AndArtifactFilter();
                    andFilter.add(filter);
                    andFilter.add(typeArtifactFilter);
                    filter = andFilter;
                } else {
                    filter = typeArtifactFilter;
                }
            }
            result = resolver.resolveTransitively(artifacts, pomArtifact, managedDependencies, localRepo, remoteArtifactRepositories, metadataSource, filter, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Dependency not found: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        if (this.pathId != null && this.getProject().getReference(this.pathId) != null) {
            throw new BuildException("Reference ID " + this.pathId + " already exists");
        }
        if (this.filesetId != null && this.getProject().getReference(this.filesetId) != null) {
            throw new BuildException("Reference ID " + this.filesetId + " already exists");
        }
        FileList fileList = new FileList();
        fileList.setDir(this.getLocalRepository().getLocation());
        FileSet fileSet = new FileSet();
        fileSet.setDir(fileList.getDir(this.getProject()));
        if (result.getArtifacts().isEmpty()) {
            fileSet.createExclude().setName("**/**");
        } else {
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact artifact = (Artifact)i.next();
                String filename = localRepo.pathOf(artifact);
                FileList.FileName file = new FileList.FileName();
                file.setName(filename);
                fileList.addConfiguredFile(file);
                fileSet.createInclude().setName(filename);
            }
        }
        if (this.pathId != null) {
            Path path = new Path(this.getProject());
            path.addFilelist(fileList);
            this.getProject().addReference(this.pathId, (Object)path);
        }
        if (this.filesetId != null) {
            this.getProject().addReference(this.filesetId, (Object)fileSet);
        }
    }

    private List createRemoteArtifactRepositories(List remoteRepositories) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            list.add(this.createRemoteArtifactRepository((RemoteRepository)((Object)i.next())));
        }
        return list;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepositories.add(remoteRepository);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFilesetId() {
        return this.filesetId;
    }

    public void setFilesetId(String filesetId) {
        this.filesetId = filesetId;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setUseScope(String useScope) {
        this.useScope = useScope;
    }

    public void setType(String type) {
        this.type = type;
    }
}

