<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/**
 * This class manage current node attributes
 *
 * 9 aug 2004 - Nicolas Dufresne
 */

require_once 'Attribute.php';
require_once 'AttributeDef.php';
require_once 'dbFunctions.php';
require_once 'Permissions.php';
require_once 'functions.php';

class AttributesManager {
	var $attributes;
	var $isError;
	var $errors;
	var $allAttributes;
	var $attributeClass;
	var $nodeTypes;
	var $permissions;
	var $hardware;
	var $node;

	function AttributesManager($node, $attributeClass, $nodeTypes, $permissions) {
		/////////////////////////////
		// General construction
		////////////////////////////
		$this->permissions = $permissions;
		if (strtolower(get_class($node)) != "node"){
			$this->isError = true;
			return;
		}
		if ($node->isError) {
			$this->isError = true;
			return;
		}
		$this->attributeClass = $attributeClass;
		$this->nodeTypes = $nodeTypes;
		$this->isError = false;
		/////////////////////////
		// Node type validation
		/////////////////////////
		if(!in_array($node->nodetype,$nodeTypes)){
			$this->errors[] =getMessage("invalid_uga_node");
			$this->showAttributesView = "false";
			return NULL;
		}

		/////////////////////////
		// Actions
		/////////////////////////

		// Cancel
		if (isset($_POST['cancel'])) {
		    unset($GLOBALS['_POST']);
		}

		$this->attributes = $node->getAttributes();
		// remove attribute with cannot read permission
		if(!empty($this->attributes)){
			foreach ($this->attributes as $key=>$attribute) {
				$hasPermission = $this->permissions->canReadAttribute($attribute->getName(),$attribute->getAttClass());
				if($hasPermission==0){
					unset($this->attributes[$key]);
				}
			}
		}


		if (is_array($_POST['newAttributes'])) {
			foreach ($_POST['newAttributes'] as $attribute) {
				$this->attributes[$attribute] = new AttributeDef($attribute);
			}
		}

		// Add an attribute
		if (isset($_POST['add_attr'])) {
			$_POST['newAttributes'][] = $_POST['newAttribute'];
			$this->attributes[$_POST['newAttribute']] = new AttributeDef($_POST['newAttribute']);
			unset($_POST['newAttribute']);
		}

		// Deleting attributes
		if (isset($_POST['delete_attr'])) {
			if (is_array($_POST['selection'])) {
				//validate permission
				$hasPermission=-1;
				$cannotDelete="";
				foreach ($_POST['selection'] as $id) {
					if (strtolower(get_class($this->attributes[$id]))== "attribute") {
						$hasPermission = $permissions->canDeleteAttribute($this->attributes[$id]->getName(),$this->attributes[$id]->getAttClass());
						if($hasPermission == 0){
							$cannotDelete=$this->attributes[$id]->getName();
							break;
						}
					}
					//If the attribute is new (it is not save in database, you can delete it)
					if (strtolower(get_class($this->attributes[$id]))== "attributedef") {
						unset($this->attributes[$id]);
					}
				}
				if($hasPermission == 1){
					foreach ($_POST['selection'] as $id) {
						if (strtolower(get_class($this->attributes[$id]))== "attribute") {
							if ($error = $this->attributes[$id]->delete()) {
								$this->errors[] = $error;
								unset($error);
							}else{
								logAdminAccess(array("DELETE ATTRIBUTE","NODE ID : ".$this->attributes[$id]->getNodeID(),"ATTRIBUTE NAME : ".$this->attributes[$id]->getName()));
							}
						}
						unset($this->attributes[$id]);
					}
				}else if($hasPermission == 0){
					$this->errors[] = getMessage("no_permission_to_delete_attribute").$cannotDelete;
				}
			}
		}

		// Modify attributes
		if (isset($_POST['modify_attr']) && $this->attributes) {
			foreach($this->attributes as $id => $attr) {
				$postValue=$_POST[$attr->getName()];
				//get the list value (if selected)
				if (isset($_POST["list".$attr->getName()]) && $_POST["list".$attr->getName()]!="-1") {
					//Careful, the name is hardcoded with the string "list" in attributesManagerView
					$postValue=$_POST["list".$attr->getName()];
				}
				if (strtolower(get_class($attr))== "attribute") {
					//Check if any changes
					if($_POST["hidden".$attr->getName()] != $postValue){
						$hasPermission = $permissions->canWriteAttribute($attr->getName(),$attr->getAttClass());
						if($hasPermission == 1){
							if (!$this->attributes[$id]->setValue($postValue)) {
							    $this->errors[] = $this->attributes[$id]->lastError();
							}
							else {
								logAdminAccess(array("MODIFY ATTRIBUTE","NODE ID : ".$this->attributes[$id]->getNodeID(),"ATTRIBUTE NAME : ".$this->attributes[$id]->getName()));
							    unset($_POST[$attr->getName()]);
							}
						}else{
							$this->errors[] = getMessage("no_permission_to_write_attribute").$attr->getName();
							unset($_POST[$attr->getName()]);
						}
					}
				}
				elseif (strtolower(get_class($attr))== "attributedef") {
					if (!$realAttr = $this->attributes[$id]->buildAttribute($node,$postValue)) {
						$this->errors[] = $this->attributes[$id]->lastError();
					} else {
						logAdminAccess(array("ADD ATTRIBUTE","NODE ID : ".$realAttr->getNodeID(),"ATTRIBUTE NAME : ".$realAttr->getName()));
						$this->attributes[$realAttr->getAttributeDefID()] = $realAttr;
						unset($_POST[$realAttr->getName()]);
					}
				}
			}
		}
		// Generating all attribute list
		$this->allAttributes = $this->getAllAttributes($node->nodetype);
		if (is_array($this->attributes)) {
			foreach ($this->attributes as $attribute) {
				unset($this->allAttributes[$attribute->getAttributeDefID()]);
			}
		}
		//Show hardware specification
		if($node->nodetype == COMPUTER_TYPE){
			$this->hardware = $node->getHardware();
			$this->node = $node;
		}
	}

	function getAllAttributes($type) {
		//Generate IN condition
		$inCondition="";
		for ($index = 0; $index < sizeof($this->attributeClass); $index++) {
			$inCondition = $inCondition."".qstr($this->attributeClass[$index])."";
			if($index <(sizeof($this->attributeClass))-1){
				$inCondition = $inCondition.",";
			}
		}
		$attributes = select("SELECT id,name,attributeClass FROM attributesDef WHERE attributeclass IN(".$inCondition.") ORDER BY name");
		if (!is_null($attributes) && !is_array($attributes)) {
			$this->errors[] = getMessage('db_error').$attributes;
			$this->isError = true;
			return NULL;
		}
		if (is_array($attributes)) {
			foreach ($attributes as $attribute) {
				//Include only attribute with read and add permission
				$hasPermission = $this->permissions->canAddAttribute($attribute['name'],$attribute['attributeclass']);
				if($hasPermission==1){
					$attributesAssoc[$attribute['id']] = $attribute['name'];
				}
			}
		}
		return $attributesAssoc;
	}

	function isError() {
		return $this->isError;
	}

	function printErrors() {
		if (isset($this->errors[0])) print "<p>\n";
		else return;
		foreach ($this->errors as $error) {
			print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
		}
		print "</p>\n";
	}

	function printView() {
		if ($this->isError) {
			$this->printErrors();
			return;
		}
		if($this->showAttributesView != 'false')
			include 'attributesManagerView.php';
	}

}
?>

