#include "gl.h"
/* This file was auto-generated by Galogen */
#include <assert.h>
#if defined(_WIN32)
void* GalogenGetProcAddress(const char *name) {
  static HMODULE opengl32module = NULL;
  static PROC(WINAPI *wgl_get_proc_address)(LPCSTR name) = NULL;
  if (!wgl_get_proc_address) {
    if (!opengl32module) {
      opengl32module = LoadLibraryA("opengl32.dll");
    }
    wgl_get_proc_address = (PROC(WINAPI*)(LPCSTR))GetProcAddress(opengl32module, "wglGetProcAddress");
    assert(wgl_get_proc_address);
  }
  void *ptr = (void *)wgl_get_proc_address(name);
  if(ptr == 0 || (ptr == (void*)1) || (ptr == (void*)2) || (ptr == (void*)3) ||
     (ptr == (void*)-1) ) {
    if (opengl32module == NULL) {
      opengl32module = LoadLibraryA("opengl32.dll");
      assert(opengl32module);
    }
    ptr = (void *)GetProcAddress(opengl32module, name);
  }
  return ptr;
}

#elif defined(__APPLE__)
#include <dlfcn.h>

static void* GalogenGetProcAddress (const char *name)
{
  static void* lib = NULL;
  if (NULL == lib)
    lib = dlopen(
      "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL",
      RTLD_LAZY);
  return lib ? dlsym(lib, name) : NULL;
}
#elif defined(__ANDROID__)
#include <dlfcn.h>
#if GALOGEN_API_VER_MAJ == 3
#define GALOGEN_GLES_LIB "libGLESv3.so"
#elif GALOGEN_API_VER_MAJ == 2
#define GALOGEN_GLES_LIB "libGLESv2.so"
#else
#define GALOGEN_GLES_LIB "libGLESv1_CM.so"
#endif
static void* GalogenGetProcAddress(const char *name)
{
  static void* lib = NULL;
  if (NULL == lib) {
    lib = dlopen(GALOGEN_GLES_LIB, RTLD_LAZY);
    assert(lib);
  }
  return lib ? dlsym(lib, name) : NULL;
}

#else

#include <GL/glx.h>
#define GalogenGetProcAddress(name) (*glXGetProcAddressARB)((const GLubyte*)name)

#endif


static void  GL_APIENTRY _impl_glVertexAttribPointer (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void * pointer) {
  _glptr_glVertexAttribPointer = (PFN_glVertexAttribPointer)GalogenGetProcAddress("glVertexAttribPointer");
   _glptr_glVertexAttribPointer(index, size, type, normalized, stride, pointer);
}
PFN_glVertexAttribPointer _glptr_glVertexAttribPointer = _impl_glVertexAttribPointer;

static void  GL_APIENTRY _impl_glVertexAttrib3fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib3fv = (PFN_glVertexAttrib3fv)GalogenGetProcAddress("glVertexAttrib3fv");
   _glptr_glVertexAttrib3fv(index, v);
}
PFN_glVertexAttrib3fv _glptr_glVertexAttrib3fv = _impl_glVertexAttrib3fv;

static void  GL_APIENTRY _impl_glVertexAttrib3f (GLuint index, GLfloat x, GLfloat y, GLfloat z) {
  _glptr_glVertexAttrib3f = (PFN_glVertexAttrib3f)GalogenGetProcAddress("glVertexAttrib3f");
   _glptr_glVertexAttrib3f(index, x, y, z);
}
PFN_glVertexAttrib3f _glptr_glVertexAttrib3f = _impl_glVertexAttrib3f;

static void  GL_APIENTRY _impl_glVertexAttrib2fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib2fv = (PFN_glVertexAttrib2fv)GalogenGetProcAddress("glVertexAttrib2fv");
   _glptr_glVertexAttrib2fv(index, v);
}
PFN_glVertexAttrib2fv _glptr_glVertexAttrib2fv = _impl_glVertexAttrib2fv;

static void  GL_APIENTRY _impl_glVertexAttrib1fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib1fv = (PFN_glVertexAttrib1fv)GalogenGetProcAddress("glVertexAttrib1fv");
   _glptr_glVertexAttrib1fv(index, v);
}
PFN_glVertexAttrib1fv _glptr_glVertexAttrib1fv = _impl_glVertexAttrib1fv;

static void  GL_APIENTRY _impl_glValidateProgram (GLuint program) {
  _glptr_glValidateProgram = (PFN_glValidateProgram)GalogenGetProcAddress("glValidateProgram");
   _glptr_glValidateProgram(program);
}
PFN_glValidateProgram _glptr_glValidateProgram = _impl_glValidateProgram;

static void  GL_APIENTRY _impl_glUseProgram (GLuint program) {
  _glptr_glUseProgram = (PFN_glUseProgram)GalogenGetProcAddress("glUseProgram");
   _glptr_glUseProgram(program);
}
PFN_glUseProgram _glptr_glUseProgram = _impl_glUseProgram;

static void  GL_APIENTRY _impl_glUniformMatrix4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix4fv = (PFN_glUniformMatrix4fv)GalogenGetProcAddress("glUniformMatrix4fv");
   _glptr_glUniformMatrix4fv(location, count, transpose, value);
}
PFN_glUniformMatrix4fv _glptr_glUniformMatrix4fv = _impl_glUniformMatrix4fv;

static void  GL_APIENTRY _impl_glUniformMatrix3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix3fv = (PFN_glUniformMatrix3fv)GalogenGetProcAddress("glUniformMatrix3fv");
   _glptr_glUniformMatrix3fv(location, count, transpose, value);
}
PFN_glUniformMatrix3fv _glptr_glUniformMatrix3fv = _impl_glUniformMatrix3fv;

static void  GL_APIENTRY _impl_glUniformMatrix2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix2fv = (PFN_glUniformMatrix2fv)GalogenGetProcAddress("glUniformMatrix2fv");
   _glptr_glUniformMatrix2fv(location, count, transpose, value);
}
PFN_glUniformMatrix2fv _glptr_glUniformMatrix2fv = _impl_glUniformMatrix2fv;

static void  GL_APIENTRY _impl_glUniform4fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform4fv = (PFN_glUniform4fv)GalogenGetProcAddress("glUniform4fv");
   _glptr_glUniform4fv(location, count, value);
}
PFN_glUniform4fv _glptr_glUniform4fv = _impl_glUniform4fv;

static void  GL_APIENTRY _impl_glUniform3iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform3iv = (PFN_glUniform3iv)GalogenGetProcAddress("glUniform3iv");
   _glptr_glUniform3iv(location, count, value);
}
PFN_glUniform3iv _glptr_glUniform3iv = _impl_glUniform3iv;

static void  GL_APIENTRY _impl_glUniform3fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform3fv = (PFN_glUniform3fv)GalogenGetProcAddress("glUniform3fv");
   _glptr_glUniform3fv(location, count, value);
}
PFN_glUniform3fv _glptr_glUniform3fv = _impl_glUniform3fv;

static void  GL_APIENTRY _impl_glUniform2fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform2fv = (PFN_glUniform2fv)GalogenGetProcAddress("glUniform2fv");
   _glptr_glUniform2fv(location, count, value);
}
PFN_glUniform2fv _glptr_glUniform2fv = _impl_glUniform2fv;

static void  GL_APIENTRY _impl_glUniform1iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform1iv = (PFN_glUniform1iv)GalogenGetProcAddress("glUniform1iv");
   _glptr_glUniform1iv(location, count, value);
}
PFN_glUniform1iv _glptr_glUniform1iv = _impl_glUniform1iv;

static void  GL_APIENTRY _impl_glUniform1i (GLint location, GLint v0) {
  _glptr_glUniform1i = (PFN_glUniform1i)GalogenGetProcAddress("glUniform1i");
   _glptr_glUniform1i(location, v0);
}
PFN_glUniform1i _glptr_glUniform1i = _impl_glUniform1i;

static void  GL_APIENTRY _impl_glUniform1fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform1fv = (PFN_glUniform1fv)GalogenGetProcAddress("glUniform1fv");
   _glptr_glUniform1fv(location, count, value);
}
PFN_glUniform1fv _glptr_glUniform1fv = _impl_glUniform1fv;

static void  GL_APIENTRY _impl_glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexSubImage2D = (PFN_glTexSubImage2D)GalogenGetProcAddress("glTexSubImage2D");
   _glptr_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}
PFN_glTexSubImage2D _glptr_glTexSubImage2D = _impl_glTexSubImage2D;

static void  GL_APIENTRY _impl_glTexParameteri (GLenum target, GLenum pname, GLint param) {
  _glptr_glTexParameteri = (PFN_glTexParameteri)GalogenGetProcAddress("glTexParameteri");
   _glptr_glTexParameteri(target, pname, param);
}
PFN_glTexParameteri _glptr_glTexParameteri = _impl_glTexParameteri;

static void  GL_APIENTRY _impl_glUniform3f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
  _glptr_glUniform3f = (PFN_glUniform3f)GalogenGetProcAddress("glUniform3f");
   _glptr_glUniform3f(location, v0, v1, v2);
}
PFN_glUniform3f _glptr_glUniform3f = _impl_glUniform3f;

static void  GL_APIENTRY _impl_glTexParameterf (GLenum target, GLenum pname, GLfloat param) {
  _glptr_glTexParameterf = (PFN_glTexParameterf)GalogenGetProcAddress("glTexParameterf");
   _glptr_glTexParameterf(target, pname, param);
}
PFN_glTexParameterf _glptr_glTexParameterf = _impl_glTexParameterf;

static void  GL_APIENTRY _impl_glStencilOpSeparate (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) {
  _glptr_glStencilOpSeparate = (PFN_glStencilOpSeparate)GalogenGetProcAddress("glStencilOpSeparate");
   _glptr_glStencilOpSeparate(face, sfail, dpfail, dppass);
}
PFN_glStencilOpSeparate _glptr_glStencilOpSeparate = _impl_glStencilOpSeparate;

static void  GL_APIENTRY _impl_glStencilMask (GLuint mask) {
  _glptr_glStencilMask = (PFN_glStencilMask)GalogenGetProcAddress("glStencilMask");
   _glptr_glStencilMask(mask);
}
PFN_glStencilMask _glptr_glStencilMask = _impl_glStencilMask;

static void  GL_APIENTRY _impl_glStencilFunc (GLenum func, GLint ref, GLuint mask) {
  _glptr_glStencilFunc = (PFN_glStencilFunc)GalogenGetProcAddress("glStencilFunc");
   _glptr_glStencilFunc(func, ref, mask);
}
PFN_glStencilFunc _glptr_glStencilFunc = _impl_glStencilFunc;

static void  GL_APIENTRY _impl_glShaderSource (GLuint shader, GLsizei count, const GLchar *const* string, const GLint * length) {
  _glptr_glShaderSource = (PFN_glShaderSource)GalogenGetProcAddress("glShaderSource");
   _glptr_glShaderSource(shader, count, string, length);
}
PFN_glShaderSource _glptr_glShaderSource = _impl_glShaderSource;

static void  GL_APIENTRY _impl_glUniform1f (GLint location, GLfloat v0) {
  _glptr_glUniform1f = (PFN_glUniform1f)GalogenGetProcAddress("glUniform1f");
   _glptr_glUniform1f(location, v0);
}
PFN_glUniform1f _glptr_glUniform1f = _impl_glUniform1f;

static void  GL_APIENTRY _impl_glShaderBinary (GLsizei count, const GLuint * shaders, GLenum binaryformat, const void * binary, GLsizei length) {
  _glptr_glShaderBinary = (PFN_glShaderBinary)GalogenGetProcAddress("glShaderBinary");
   _glptr_glShaderBinary(count, shaders, binaryformat, binary, length);
}
PFN_glShaderBinary _glptr_glShaderBinary = _impl_glShaderBinary;

static void  GL_APIENTRY _impl_glHint (GLenum target, GLenum mode) {
  _glptr_glHint = (PFN_glHint)GalogenGetProcAddress("glHint");
   _glptr_glHint(target, mode);
}
PFN_glHint _glptr_glHint = _impl_glHint;

static void  GL_APIENTRY _impl_glScissor (GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glScissor = (PFN_glScissor)GalogenGetProcAddress("glScissor");
   _glptr_glScissor(x, y, width, height);
}
PFN_glScissor _glptr_glScissor = _impl_glScissor;

static void  GL_APIENTRY _impl_glGetBufferParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetBufferParameteriv = (PFN_glGetBufferParameteriv)GalogenGetProcAddress("glGetBufferParameteriv");
   _glptr_glGetBufferParameteriv(target, pname, params);
}
PFN_glGetBufferParameteriv _glptr_glGetBufferParameteriv = _impl_glGetBufferParameteriv;

static void  GL_APIENTRY _impl_glRenderbufferStorage (GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
  _glptr_glRenderbufferStorage = (PFN_glRenderbufferStorage)GalogenGetProcAddress("glRenderbufferStorage");
   _glptr_glRenderbufferStorage(target, internalformat, width, height);
}
PFN_glRenderbufferStorage _glptr_glRenderbufferStorage = _impl_glRenderbufferStorage;

static void  GL_APIENTRY _impl_glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels) {
  _glptr_glReadPixels = (PFN_glReadPixels)GalogenGetProcAddress("glReadPixels");
   _glptr_glReadPixels(x, y, width, height, format, type, pixels);
}
PFN_glReadPixels _glptr_glReadPixels = _impl_glReadPixels;

static void  GL_APIENTRY _impl_glPixelStorei (GLenum pname, GLint param) {
  _glptr_glPixelStorei = (PFN_glPixelStorei)GalogenGetProcAddress("glPixelStorei");
   _glptr_glPixelStorei(pname, param);
}
PFN_glPixelStorei _glptr_glPixelStorei = _impl_glPixelStorei;

static void  GL_APIENTRY _impl_glDeleteTextures (GLsizei n, const GLuint * textures) {
  _glptr_glDeleteTextures = (PFN_glDeleteTextures)GalogenGetProcAddress("glDeleteTextures");
   _glptr_glDeleteTextures(n, textures);
}
PFN_glDeleteTextures _glptr_glDeleteTextures = _impl_glDeleteTextures;

static GLboolean GL_APIENTRY _impl_glIsBuffer (GLuint buffer) {
  _glptr_glIsBuffer = (PFN_glIsBuffer)GalogenGetProcAddress("glIsBuffer");
  return _glptr_glIsBuffer(buffer);
}
PFN_glIsBuffer _glptr_glIsBuffer = _impl_glIsBuffer;

static void  GL_APIENTRY _impl_glLineWidth (GLfloat width) {
  _glptr_glLineWidth = (PFN_glLineWidth)GalogenGetProcAddress("glLineWidth");
   _glptr_glLineWidth(width);
}
PFN_glLineWidth _glptr_glLineWidth = _impl_glLineWidth;

static GLboolean GL_APIENTRY _impl_glIsEnabled (GLenum cap) {
  _glptr_glIsEnabled = (PFN_glIsEnabled)GalogenGetProcAddress("glIsEnabled");
  return _glptr_glIsEnabled(cap);
}
PFN_glIsEnabled _glptr_glIsEnabled = _impl_glIsEnabled;

static void  GL_APIENTRY _impl_glGetVertexAttribiv (GLuint index, GLenum pname, GLint * params) {
  _glptr_glGetVertexAttribiv = (PFN_glGetVertexAttribiv)GalogenGetProcAddress("glGetVertexAttribiv");
   _glptr_glGetVertexAttribiv(index, pname, params);
}
PFN_glGetVertexAttribiv _glptr_glGetVertexAttribiv = _impl_glGetVertexAttribiv;

static GLint GL_APIENTRY _impl_glGetUniformLocation (GLuint program, const GLchar * name) {
  _glptr_glGetUniformLocation = (PFN_glGetUniformLocation)GalogenGetProcAddress("glGetUniformLocation");
  return _glptr_glGetUniformLocation(program, name);
}
PFN_glGetUniformLocation _glptr_glGetUniformLocation = _impl_glGetUniformLocation;

static void  GL_APIENTRY _impl_glGetTexParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetTexParameteriv = (PFN_glGetTexParameteriv)GalogenGetProcAddress("glGetTexParameteriv");
   _glptr_glGetTexParameteriv(target, pname, params);
}
PFN_glGetTexParameteriv _glptr_glGetTexParameteriv = _impl_glGetTexParameteriv;

static void  GL_APIENTRY _impl_glGetVertexAttribPointerv (GLuint index, GLenum pname, void ** pointer) {
  _glptr_glGetVertexAttribPointerv = (PFN_glGetVertexAttribPointerv)GalogenGetProcAddress("glGetVertexAttribPointerv");
   _glptr_glGetVertexAttribPointerv(index, pname, pointer);
}
PFN_glGetVertexAttribPointerv _glptr_glGetVertexAttribPointerv = _impl_glGetVertexAttribPointerv;

static void  GL_APIENTRY _impl_glViewport (GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glViewport = (PFN_glViewport)GalogenGetProcAddress("glViewport");
   _glptr_glViewport(x, y, width, height);
}
PFN_glViewport _glptr_glViewport = _impl_glViewport;

static void  GL_APIENTRY _impl_glGetTexParameterfv (GLenum target, GLenum pname, GLfloat * params) {
  _glptr_glGetTexParameterfv = (PFN_glGetTexParameterfv)GalogenGetProcAddress("glGetTexParameterfv");
   _glptr_glGetTexParameterfv(target, pname, params);
}
PFN_glGetTexParameterfv _glptr_glGetTexParameterfv = _impl_glGetTexParameterfv;

static GLboolean GL_APIENTRY _impl_glIsTexture (GLuint texture) {
  _glptr_glIsTexture = (PFN_glIsTexture)GalogenGetProcAddress("glIsTexture");
  return _glptr_glIsTexture(texture);
}
PFN_glIsTexture _glptr_glIsTexture = _impl_glIsTexture;

static const GLubyte * GL_APIENTRY _impl_glGetString (GLenum name) {
  _glptr_glGetString = (PFN_glGetString)GalogenGetProcAddress("glGetString");
  return _glptr_glGetString(name);
}
PFN_glGetString _glptr_glGetString = _impl_glGetString;

static void  GL_APIENTRY _impl_glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
  _glptr_glCopyTexImage2D = (PFN_glCopyTexImage2D)GalogenGetProcAddress("glCopyTexImage2D");
   _glptr_glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}
PFN_glCopyTexImage2D _glptr_glCopyTexImage2D = _impl_glCopyTexImage2D;

static GLboolean GL_APIENTRY _impl_glIsProgram (GLuint program) {
  _glptr_glIsProgram = (PFN_glIsProgram)GalogenGetProcAddress("glIsProgram");
  return _glptr_glIsProgram(program);
}
PFN_glIsProgram _glptr_glIsProgram = _impl_glIsProgram;

static void  GL_APIENTRY _impl_glVertexAttrib4fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib4fv = (PFN_glVertexAttrib4fv)GalogenGetProcAddress("glVertexAttrib4fv");
   _glptr_glVertexAttrib4fv(index, v);
}
PFN_glVertexAttrib4fv _glptr_glVertexAttrib4fv = _impl_glVertexAttrib4fv;

static void  GL_APIENTRY _impl_glGetUniformiv (GLuint program, GLint location, GLint * params) {
  _glptr_glGetUniformiv = (PFN_glGetUniformiv)GalogenGetProcAddress("glGetUniformiv");
   _glptr_glGetUniformiv(program, location, params);
}
PFN_glGetUniformiv _glptr_glGetUniformiv = _impl_glGetUniformiv;

static void  GL_APIENTRY _impl_glUniform3i (GLint location, GLint v0, GLint v1, GLint v2) {
  _glptr_glUniform3i = (PFN_glUniform3i)GalogenGetProcAddress("glUniform3i");
   _glptr_glUniform3i(location, v0, v1, v2);
}
PFN_glUniform3i _glptr_glUniform3i = _impl_glUniform3i;

static void  GL_APIENTRY _impl_glGetShaderPrecisionFormat (GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision) {
  _glptr_glGetShaderPrecisionFormat = (PFN_glGetShaderPrecisionFormat)GalogenGetProcAddress("glGetShaderPrecisionFormat");
   _glptr_glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}
PFN_glGetShaderPrecisionFormat _glptr_glGetShaderPrecisionFormat = _impl_glGetShaderPrecisionFormat;

static void  GL_APIENTRY _impl_glGetShaderiv (GLuint shader, GLenum pname, GLint * params) {
  _glptr_glGetShaderiv = (PFN_glGetShaderiv)GalogenGetProcAddress("glGetShaderiv");
   _glptr_glGetShaderiv(shader, pname, params);
}
PFN_glGetShaderiv _glptr_glGetShaderiv = _impl_glGetShaderiv;

static void  GL_APIENTRY _impl_glGetRenderbufferParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetRenderbufferParameteriv = (PFN_glGetRenderbufferParameteriv)GalogenGetProcAddress("glGetRenderbufferParameteriv");
   _glptr_glGetRenderbufferParameteriv(target, pname, params);
}
PFN_glGetRenderbufferParameteriv _glptr_glGetRenderbufferParameteriv = _impl_glGetRenderbufferParameteriv;

static void  GL_APIENTRY _impl_glGetProgramiv (GLuint program, GLenum pname, GLint * params) {
  _glptr_glGetProgramiv = (PFN_glGetProgramiv)GalogenGetProcAddress("glGetProgramiv");
   _glptr_glGetProgramiv(program, pname, params);
}
PFN_glGetProgramiv _glptr_glGetProgramiv = _impl_glGetProgramiv;

static void  GL_APIENTRY _impl_glGetIntegerv (GLenum pname, GLint * data) {
  _glptr_glGetIntegerv = (PFN_glGetIntegerv)GalogenGetProcAddress("glGetIntegerv");
   _glptr_glGetIntegerv(pname, data);
}
PFN_glGetIntegerv _glptr_glGetIntegerv = _impl_glGetIntegerv;

static void  GL_APIENTRY _impl_glGetFloatv (GLenum pname, GLfloat * data) {
  _glptr_glGetFloatv = (PFN_glGetFloatv)GalogenGetProcAddress("glGetFloatv");
   _glptr_glGetFloatv(pname, data);
}
PFN_glGetFloatv _glptr_glGetFloatv = _impl_glGetFloatv;

static void  GL_APIENTRY _impl_glUniform2i (GLint location, GLint v0, GLint v1) {
  _glptr_glUniform2i = (PFN_glUniform2i)GalogenGetProcAddress("glUniform2i");
   _glptr_glUniform2i(location, v0, v1);
}
PFN_glUniform2i _glptr_glUniform2i = _impl_glUniform2i;

static GLenum GL_APIENTRY _impl_glGetError () {
  _glptr_glGetError = (PFN_glGetError)GalogenGetProcAddress("glGetError");
  return _glptr_glGetError();
}
PFN_glGetError _glptr_glGetError = _impl_glGetError;

static void  GL_APIENTRY _impl_glGetBooleanv (GLenum pname, GLboolean * data) {
  _glptr_glGetBooleanv = (PFN_glGetBooleanv)GalogenGetProcAddress("glGetBooleanv");
   _glptr_glGetBooleanv(pname, data);
}
PFN_glGetBooleanv _glptr_glGetBooleanv = _impl_glGetBooleanv;

static void  GL_APIENTRY _impl_glVertexAttrib4f (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
  _glptr_glVertexAttrib4f = (PFN_glVertexAttrib4f)GalogenGetProcAddress("glVertexAttrib4f");
   _glptr_glVertexAttrib4f(index, x, y, z, w);
}
PFN_glVertexAttrib4f _glptr_glVertexAttrib4f = _impl_glVertexAttrib4f;

static GLint GL_APIENTRY _impl_glGetAttribLocation (GLuint program, const GLchar * name) {
  _glptr_glGetAttribLocation = (PFN_glGetAttribLocation)GalogenGetProcAddress("glGetAttribLocation");
  return _glptr_glGetAttribLocation(program, name);
}
PFN_glGetAttribLocation _glptr_glGetAttribLocation = _impl_glGetAttribLocation;

static void  GL_APIENTRY _impl_glGetActiveUniform (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
  _glptr_glGetActiveUniform = (PFN_glGetActiveUniform)GalogenGetProcAddress("glGetActiveUniform");
   _glptr_glGetActiveUniform(program, index, bufSize, length, size, type, name);
}
PFN_glGetActiveUniform _glptr_glGetActiveUniform = _impl_glGetActiveUniform;

static void  GL_APIENTRY _impl_glTexParameteriv (GLenum target, GLenum pname, const GLint * params) {
  _glptr_glTexParameteriv = (PFN_glTexParameteriv)GalogenGetProcAddress("glTexParameteriv");
   _glptr_glTexParameteriv(target, pname, params);
}
PFN_glTexParameteriv _glptr_glTexParameteriv = _impl_glTexParameteriv;

static void  GL_APIENTRY _impl_glGetActiveAttrib (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
  _glptr_glGetActiveAttrib = (PFN_glGetActiveAttrib)GalogenGetProcAddress("glGetActiveAttrib");
   _glptr_glGetActiveAttrib(program, index, bufSize, length, size, type, name);
}
PFN_glGetActiveAttrib _glptr_glGetActiveAttrib = _impl_glGetActiveAttrib;

static void  GL_APIENTRY _impl_glStencilMaskSeparate (GLenum face, GLuint mask) {
  _glptr_glStencilMaskSeparate = (PFN_glStencilMaskSeparate)GalogenGetProcAddress("glStencilMaskSeparate");
   _glptr_glStencilMaskSeparate(face, mask);
}
PFN_glStencilMaskSeparate _glptr_glStencilMaskSeparate = _impl_glStencilMaskSeparate;

static void  GL_APIENTRY _impl_glGenRenderbuffers (GLsizei n, GLuint * renderbuffers) {
  _glptr_glGenRenderbuffers = (PFN_glGenRenderbuffers)GalogenGetProcAddress("glGenRenderbuffers");
   _glptr_glGenRenderbuffers(n, renderbuffers);
}
PFN_glGenRenderbuffers _glptr_glGenRenderbuffers = _impl_glGenRenderbuffers;

static void  GL_APIENTRY _impl_glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexSubImage2D = (PFN_glCompressedTexSubImage2D)GalogenGetProcAddress("glCompressedTexSubImage2D");
   _glptr_glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}
PFN_glCompressedTexSubImage2D _glptr_glCompressedTexSubImage2D = _impl_glCompressedTexSubImage2D;

static void  GL_APIENTRY _impl_glGetProgramInfoLog (GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
  _glptr_glGetProgramInfoLog = (PFN_glGetProgramInfoLog)GalogenGetProcAddress("glGetProgramInfoLog");
   _glptr_glGetProgramInfoLog(program, bufSize, length, infoLog);
}
PFN_glGetProgramInfoLog _glptr_glGetProgramInfoLog = _impl_glGetProgramInfoLog;

static void  GL_APIENTRY _impl_glDeleteShader (GLuint shader) {
  _glptr_glDeleteShader = (PFN_glDeleteShader)GalogenGetProcAddress("glDeleteShader");
   _glptr_glDeleteShader(shader);
}
PFN_glDeleteShader _glptr_glDeleteShader = _impl_glDeleteShader;

static void  GL_APIENTRY _impl_glGenBuffers (GLsizei n, GLuint * buffers) {
  _glptr_glGenBuffers = (PFN_glGenBuffers)GalogenGetProcAddress("glGenBuffers");
   _glptr_glGenBuffers(n, buffers);
}
PFN_glGenBuffers _glptr_glGenBuffers = _impl_glGenBuffers;

static void  GL_APIENTRY _impl_glSampleCoverage (GLfloat value, GLboolean invert) {
  _glptr_glSampleCoverage = (PFN_glSampleCoverage)GalogenGetProcAddress("glSampleCoverage");
   _glptr_glSampleCoverage(value, invert);
}
PFN_glSampleCoverage _glptr_glSampleCoverage = _impl_glSampleCoverage;

static void  GL_APIENTRY _impl_glGenTextures (GLsizei n, GLuint * textures) {
  _glptr_glGenTextures = (PFN_glGenTextures)GalogenGetProcAddress("glGenTextures");
   _glptr_glGenTextures(n, textures);
}
PFN_glGenTextures _glptr_glGenTextures = _impl_glGenTextures;

static void  GL_APIENTRY _impl_glGetVertexAttribfv (GLuint index, GLenum pname, GLfloat * params) {
  _glptr_glGetVertexAttribfv = (PFN_glGetVertexAttribfv)GalogenGetProcAddress("glGetVertexAttribfv");
   _glptr_glGetVertexAttribfv(index, pname, params);
}
PFN_glGetVertexAttribfv _glptr_glGetVertexAttribfv = _impl_glGetVertexAttribfv;

static void  GL_APIENTRY _impl_glUniform4iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform4iv = (PFN_glUniform4iv)GalogenGetProcAddress("glUniform4iv");
   _glptr_glUniform4iv(location, count, value);
}
PFN_glUniform4iv _glptr_glUniform4iv = _impl_glUniform4iv;

static void  GL_APIENTRY _impl_glFrontFace (GLenum mode) {
  _glptr_glFrontFace = (PFN_glFrontFace)GalogenGetProcAddress("glFrontFace");
   _glptr_glFrontFace(mode);
}
PFN_glFrontFace _glptr_glFrontFace = _impl_glFrontFace;

static void  GL_APIENTRY _impl_glUniform2iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform2iv = (PFN_glUniform2iv)GalogenGetProcAddress("glUniform2iv");
   _glptr_glUniform2iv(location, count, value);
}
PFN_glUniform2iv _glptr_glUniform2iv = _impl_glUniform2iv;

static GLboolean GL_APIENTRY _impl_glIsShader (GLuint shader) {
  _glptr_glIsShader = (PFN_glIsShader)GalogenGetProcAddress("glIsShader");
  return _glptr_glIsShader(shader);
}
PFN_glIsShader _glptr_glIsShader = _impl_glIsShader;

static void  GL_APIENTRY _impl_glBindFramebuffer (GLenum target, GLuint framebuffer) {
  _glptr_glBindFramebuffer = (PFN_glBindFramebuffer)GalogenGetProcAddress("glBindFramebuffer");
   _glptr_glBindFramebuffer(target, framebuffer);
}
PFN_glBindFramebuffer _glptr_glBindFramebuffer = _impl_glBindFramebuffer;

static void  GL_APIENTRY _impl_glFramebufferTexture2D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
  _glptr_glFramebufferTexture2D = (PFN_glFramebufferTexture2D)GalogenGetProcAddress("glFramebufferTexture2D");
   _glptr_glFramebufferTexture2D(target, attachment, textarget, texture, level);
}
PFN_glFramebufferTexture2D _glptr_glFramebufferTexture2D = _impl_glFramebufferTexture2D;

static void  GL_APIENTRY _impl_glUniform4i (GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
  _glptr_glUniform4i = (PFN_glUniform4i)GalogenGetProcAddress("glUniform4i");
   _glptr_glUniform4i(location, v0, v1, v2, v3);
}
PFN_glUniform4i _glptr_glUniform4i = _impl_glUniform4i;

static void  GL_APIENTRY _impl_glClearStencil (GLint s) {
  _glptr_glClearStencil = (PFN_glClearStencil)GalogenGetProcAddress("glClearStencil");
   _glptr_glClearStencil(s);
}
PFN_glClearStencil _glptr_glClearStencil = _impl_glClearStencil;

static void  GL_APIENTRY _impl_glDeleteRenderbuffers (GLsizei n, const GLuint * renderbuffers) {
  _glptr_glDeleteRenderbuffers = (PFN_glDeleteRenderbuffers)GalogenGetProcAddress("glDeleteRenderbuffers");
   _glptr_glDeleteRenderbuffers(n, renderbuffers);
}
PFN_glDeleteRenderbuffers _glptr_glDeleteRenderbuffers = _impl_glDeleteRenderbuffers;

static void  GL_APIENTRY _impl_glFinish () {
  _glptr_glFinish = (PFN_glFinish)GalogenGetProcAddress("glFinish");
   _glptr_glFinish();
}
PFN_glFinish _glptr_glFinish = _impl_glFinish;

static void  GL_APIENTRY _impl_glBlendFuncSeparate (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
  _glptr_glBlendFuncSeparate = (PFN_glBlendFuncSeparate)GalogenGetProcAddress("glBlendFuncSeparate");
   _glptr_glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}
PFN_glBlendFuncSeparate _glptr_glBlendFuncSeparate = _impl_glBlendFuncSeparate;

static void  GL_APIENTRY _impl_glBindAttribLocation (GLuint program, GLuint index, const GLchar * name) {
  _glptr_glBindAttribLocation = (PFN_glBindAttribLocation)GalogenGetProcAddress("glBindAttribLocation");
   _glptr_glBindAttribLocation(program, index, name);
}
PFN_glBindAttribLocation _glptr_glBindAttribLocation = _impl_glBindAttribLocation;

static void  GL_APIENTRY _impl_glClear (GLbitfield mask) {
  _glptr_glClear = (PFN_glClear)GalogenGetProcAddress("glClear");
   _glptr_glClear(mask);
}
PFN_glClear _glptr_glClear = _impl_glClear;

static void  GL_APIENTRY _impl_glEnableVertexAttribArray (GLuint index) {
  _glptr_glEnableVertexAttribArray = (PFN_glEnableVertexAttribArray)GalogenGetProcAddress("glEnableVertexAttribArray");
   _glptr_glEnableVertexAttribArray(index);
}
PFN_glEnableVertexAttribArray _glptr_glEnableVertexAttribArray = _impl_glEnableVertexAttribArray;

static void  GL_APIENTRY _impl_glStencilFuncSeparate (GLenum face, GLenum func, GLint ref, GLuint mask) {
  _glptr_glStencilFuncSeparate = (PFN_glStencilFuncSeparate)GalogenGetProcAddress("glStencilFuncSeparate");
   _glptr_glStencilFuncSeparate(face, func, ref, mask);
}
PFN_glStencilFuncSeparate _glptr_glStencilFuncSeparate = _impl_glStencilFuncSeparate;

static void  GL_APIENTRY _impl_glPolygonOffset (GLfloat factor, GLfloat units) {
  _glptr_glPolygonOffset = (PFN_glPolygonOffset)GalogenGetProcAddress("glPolygonOffset");
   _glptr_glPolygonOffset(factor, units);
}
PFN_glPolygonOffset _glptr_glPolygonOffset = _impl_glPolygonOffset;

static void  GL_APIENTRY _impl_glDisable (GLenum cap) {
  _glptr_glDisable = (PFN_glDisable)GalogenGetProcAddress("glDisable");
   _glptr_glDisable(cap);
}
PFN_glDisable _glptr_glDisable = _impl_glDisable;

static void  GL_APIENTRY _impl_glDetachShader (GLuint program, GLuint shader) {
  _glptr_glDetachShader = (PFN_glDetachShader)GalogenGetProcAddress("glDetachShader");
   _glptr_glDetachShader(program, shader);
}
PFN_glDetachShader _glptr_glDetachShader = _impl_glDetachShader;

static void  GL_APIENTRY _impl_glReleaseShaderCompiler () {
  _glptr_glReleaseShaderCompiler = (PFN_glReleaseShaderCompiler)GalogenGetProcAddress("glReleaseShaderCompiler");
   _glptr_glReleaseShaderCompiler();
}
PFN_glReleaseShaderCompiler _glptr_glReleaseShaderCompiler = _impl_glReleaseShaderCompiler;

static void  GL_APIENTRY _impl_glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexImage2D = (PFN_glCompressedTexImage2D)GalogenGetProcAddress("glCompressedTexImage2D");
   _glptr_glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}
PFN_glCompressedTexImage2D _glptr_glCompressedTexImage2D = _impl_glCompressedTexImage2D;

static void  GL_APIENTRY _impl_glBindRenderbuffer (GLenum target, GLuint renderbuffer) {
  _glptr_glBindRenderbuffer = (PFN_glBindRenderbuffer)GalogenGetProcAddress("glBindRenderbuffer");
   _glptr_glBindRenderbuffer(target, renderbuffer);
}
PFN_glBindRenderbuffer _glptr_glBindRenderbuffer = _impl_glBindRenderbuffer;

static void  GL_APIENTRY _impl_glDepthMask (GLboolean flag) {
  _glptr_glDepthMask = (PFN_glDepthMask)GalogenGetProcAddress("glDepthMask");
   _glptr_glDepthMask(flag);
}
PFN_glDepthMask _glptr_glDepthMask = _impl_glDepthMask;

static GLboolean GL_APIENTRY _impl_glIsFramebuffer (GLuint framebuffer) {
  _glptr_glIsFramebuffer = (PFN_glIsFramebuffer)GalogenGetProcAddress("glIsFramebuffer");
  return _glptr_glIsFramebuffer(framebuffer);
}
PFN_glIsFramebuffer _glptr_glIsFramebuffer = _impl_glIsFramebuffer;

static void  GL_APIENTRY _impl_glGetUniformfv (GLuint program, GLint location, GLfloat * params) {
  _glptr_glGetUniformfv = (PFN_glGetUniformfv)GalogenGetProcAddress("glGetUniformfv");
   _glptr_glGetUniformfv(program, location, params);
}
PFN_glGetUniformfv _glptr_glGetUniformfv = _impl_glGetUniformfv;

static void  GL_APIENTRY _impl_glUniform4f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
  _glptr_glUniform4f = (PFN_glUniform4f)GalogenGetProcAddress("glUniform4f");
   _glptr_glUniform4f(location, v0, v1, v2, v3);
}
PFN_glUniform4f _glptr_glUniform4f = _impl_glUniform4f;

static void  GL_APIENTRY _impl_glAttachShader (GLuint program, GLuint shader) {
  _glptr_glAttachShader = (PFN_glAttachShader)GalogenGetProcAddress("glAttachShader");
   _glptr_glAttachShader(program, shader);
}
PFN_glAttachShader _glptr_glAttachShader = _impl_glAttachShader;

static void  GL_APIENTRY _impl_glFramebufferRenderbuffer (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
  _glptr_glFramebufferRenderbuffer = (PFN_glFramebufferRenderbuffer)GalogenGetProcAddress("glFramebufferRenderbuffer");
   _glptr_glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}
PFN_glFramebufferRenderbuffer _glptr_glFramebufferRenderbuffer = _impl_glFramebufferRenderbuffer;

static void  GL_APIENTRY _impl_glStencilOp (GLenum fail, GLenum zfail, GLenum zpass) {
  _glptr_glStencilOp = (PFN_glStencilOp)GalogenGetProcAddress("glStencilOp");
   _glptr_glStencilOp(fail, zfail, zpass);
}
PFN_glStencilOp _glptr_glStencilOp = _impl_glStencilOp;

static void  GL_APIENTRY _impl_glDisableVertexAttribArray (GLuint index) {
  _glptr_glDisableVertexAttribArray = (PFN_glDisableVertexAttribArray)GalogenGetProcAddress("glDisableVertexAttribArray");
   _glptr_glDisableVertexAttribArray(index);
}
PFN_glDisableVertexAttribArray _glptr_glDisableVertexAttribArray = _impl_glDisableVertexAttribArray;

static GLboolean GL_APIENTRY _impl_glIsRenderbuffer (GLuint renderbuffer) {
  _glptr_glIsRenderbuffer = (PFN_glIsRenderbuffer)GalogenGetProcAddress("glIsRenderbuffer");
  return _glptr_glIsRenderbuffer(renderbuffer);
}
PFN_glIsRenderbuffer _glptr_glIsRenderbuffer = _impl_glIsRenderbuffer;

static void  GL_APIENTRY _impl_glDeleteProgram (GLuint program) {
  _glptr_glDeleteProgram = (PFN_glDeleteProgram)GalogenGetProcAddress("glDeleteProgram");
   _glptr_glDeleteProgram(program);
}
PFN_glDeleteProgram _glptr_glDeleteProgram = _impl_glDeleteProgram;

static void  GL_APIENTRY _impl_glDrawArrays (GLenum mode, GLint first, GLsizei count) {
  _glptr_glDrawArrays = (PFN_glDrawArrays)GalogenGetProcAddress("glDrawArrays");
   _glptr_glDrawArrays(mode, first, count);
}
PFN_glDrawArrays _glptr_glDrawArrays = _impl_glDrawArrays;

static void  GL_APIENTRY _impl_glBlendEquationSeparate (GLenum modeRGB, GLenum modeAlpha) {
  _glptr_glBlendEquationSeparate = (PFN_glBlendEquationSeparate)GalogenGetProcAddress("glBlendEquationSeparate");
   _glptr_glBlendEquationSeparate(modeRGB, modeAlpha);
}
PFN_glBlendEquationSeparate _glptr_glBlendEquationSeparate = _impl_glBlendEquationSeparate;

static void  GL_APIENTRY _impl_glCompileShader (GLuint shader) {
  _glptr_glCompileShader = (PFN_glCompileShader)GalogenGetProcAddress("glCompileShader");
   _glptr_glCompileShader(shader);
}
PFN_glCompileShader _glptr_glCompileShader = _impl_glCompileShader;

static void  GL_APIENTRY _impl_glVertexAttrib1f (GLuint index, GLfloat x) {
  _glptr_glVertexAttrib1f = (PFN_glVertexAttrib1f)GalogenGetProcAddress("glVertexAttrib1f");
   _glptr_glVertexAttrib1f(index, x);
}
PFN_glVertexAttrib1f _glptr_glVertexAttrib1f = _impl_glVertexAttrib1f;

static void  GL_APIENTRY _impl_glDeleteFramebuffers (GLsizei n, const GLuint * framebuffers) {
  _glptr_glDeleteFramebuffers = (PFN_glDeleteFramebuffers)GalogenGetProcAddress("glDeleteFramebuffers");
   _glptr_glDeleteFramebuffers(n, framebuffers);
}
PFN_glDeleteFramebuffers _glptr_glDeleteFramebuffers = _impl_glDeleteFramebuffers;

static void  GL_APIENTRY _impl_glDeleteBuffers (GLsizei n, const GLuint * buffers) {
  _glptr_glDeleteBuffers = (PFN_glDeleteBuffers)GalogenGetProcAddress("glDeleteBuffers");
   _glptr_glDeleteBuffers(n, buffers);
}
PFN_glDeleteBuffers _glptr_glDeleteBuffers = _impl_glDeleteBuffers;

static void  GL_APIENTRY _impl_glTexParameterfv (GLenum target, GLenum pname, const GLfloat * params) {
  _glptr_glTexParameterfv = (PFN_glTexParameterfv)GalogenGetProcAddress("glTexParameterfv");
   _glptr_glTexParameterfv(target, pname, params);
}
PFN_glTexParameterfv _glptr_glTexParameterfv = _impl_glTexParameterfv;

static void  GL_APIENTRY _impl_glLinkProgram (GLuint program) {
  _glptr_glLinkProgram = (PFN_glLinkProgram)GalogenGetProcAddress("glLinkProgram");
   _glptr_glLinkProgram(program);
}
PFN_glLinkProgram _glptr_glLinkProgram = _impl_glLinkProgram;

static void  GL_APIENTRY _impl_glGenerateMipmap (GLenum target) {
  _glptr_glGenerateMipmap = (PFN_glGenerateMipmap)GalogenGetProcAddress("glGenerateMipmap");
   _glptr_glGenerateMipmap(target);
}
PFN_glGenerateMipmap _glptr_glGenerateMipmap = _impl_glGenerateMipmap;

static void  GL_APIENTRY _impl_glCullFace (GLenum mode) {
  _glptr_glCullFace = (PFN_glCullFace)GalogenGetProcAddress("glCullFace");
   _glptr_glCullFace(mode);
}
PFN_glCullFace _glptr_glCullFace = _impl_glCullFace;

static void  GL_APIENTRY _impl_glVertexAttrib2f (GLuint index, GLfloat x, GLfloat y) {
  _glptr_glVertexAttrib2f = (PFN_glVertexAttrib2f)GalogenGetProcAddress("glVertexAttrib2f");
   _glptr_glVertexAttrib2f(index, x, y);
}
PFN_glVertexAttrib2f _glptr_glVertexAttrib2f = _impl_glVertexAttrib2f;

static void  GL_APIENTRY _impl_glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexImage2D = (PFN_glTexImage2D)GalogenGetProcAddress("glTexImage2D");
   _glptr_glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}
PFN_glTexImage2D _glptr_glTexImage2D = _impl_glTexImage2D;

static void  GL_APIENTRY _impl_glDrawElements (GLenum mode, GLsizei count, GLenum type, const void * indices) {
  _glptr_glDrawElements = (PFN_glDrawElements)GalogenGetProcAddress("glDrawElements");
   _glptr_glDrawElements(mode, count, type, indices);
}
PFN_glDrawElements _glptr_glDrawElements = _impl_glDrawElements;

static void  GL_APIENTRY _impl_glGenFramebuffers (GLsizei n, GLuint * framebuffers) {
  _glptr_glGenFramebuffers = (PFN_glGenFramebuffers)GalogenGetProcAddress("glGenFramebuffers");
   _glptr_glGenFramebuffers(n, framebuffers);
}
PFN_glGenFramebuffers _glptr_glGenFramebuffers = _impl_glGenFramebuffers;

static GLuint GL_APIENTRY _impl_glCreateShader (GLenum type) {
  _glptr_glCreateShader = (PFN_glCreateShader)GalogenGetProcAddress("glCreateShader");
  return _glptr_glCreateShader(type);
}
PFN_glCreateShader _glptr_glCreateShader = _impl_glCreateShader;

static void  GL_APIENTRY _impl_glGetFramebufferAttachmentParameteriv (GLenum target, GLenum attachment, GLenum pname, GLint * params) {
  _glptr_glGetFramebufferAttachmentParameteriv = (PFN_glGetFramebufferAttachmentParameteriv)GalogenGetProcAddress("glGetFramebufferAttachmentParameteriv");
   _glptr_glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}
PFN_glGetFramebufferAttachmentParameteriv _glptr_glGetFramebufferAttachmentParameteriv = _impl_glGetFramebufferAttachmentParameteriv;

static void  GL_APIENTRY _impl_glClearColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
  _glptr_glClearColor = (PFN_glClearColor)GalogenGetProcAddress("glClearColor");
   _glptr_glClearColor(red, green, blue, alpha);
}
PFN_glClearColor _glptr_glClearColor = _impl_glClearColor;

static GLuint GL_APIENTRY _impl_glCreateProgram () {
  _glptr_glCreateProgram = (PFN_glCreateProgram)GalogenGetProcAddress("glCreateProgram");
  return _glptr_glCreateProgram();
}
PFN_glCreateProgram _glptr_glCreateProgram = _impl_glCreateProgram;

static void  GL_APIENTRY _impl_glClearDepthf (GLfloat d) {
  _glptr_glClearDepthf = (PFN_glClearDepthf)GalogenGetProcAddress("glClearDepthf");
   _glptr_glClearDepthf(d);
}
PFN_glClearDepthf _glptr_glClearDepthf = _impl_glClearDepthf;

static void  GL_APIENTRY _impl_glBlendFunc (GLenum sfactor, GLenum dfactor) {
  _glptr_glBlendFunc = (PFN_glBlendFunc)GalogenGetProcAddress("glBlendFunc");
   _glptr_glBlendFunc(sfactor, dfactor);
}
PFN_glBlendFunc _glptr_glBlendFunc = _impl_glBlendFunc;

static void  GL_APIENTRY _impl_glBindBuffer (GLenum target, GLuint buffer) {
  _glptr_glBindBuffer = (PFN_glBindBuffer)GalogenGetProcAddress("glBindBuffer");
   _glptr_glBindBuffer(target, buffer);
}
PFN_glBindBuffer _glptr_glBindBuffer = _impl_glBindBuffer;

static void  GL_APIENTRY _impl_glGetShaderInfoLog (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
  _glptr_glGetShaderInfoLog = (PFN_glGetShaderInfoLog)GalogenGetProcAddress("glGetShaderInfoLog");
   _glptr_glGetShaderInfoLog(shader, bufSize, length, infoLog);
}
PFN_glGetShaderInfoLog _glptr_glGetShaderInfoLog = _impl_glGetShaderInfoLog;

static GLenum GL_APIENTRY _impl_glCheckFramebufferStatus (GLenum target) {
  _glptr_glCheckFramebufferStatus = (PFN_glCheckFramebufferStatus)GalogenGetProcAddress("glCheckFramebufferStatus");
  return _glptr_glCheckFramebufferStatus(target);
}
PFN_glCheckFramebufferStatus _glptr_glCheckFramebufferStatus = _impl_glCheckFramebufferStatus;

static void  GL_APIENTRY _impl_glBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, const void * data) {
  _glptr_glBufferSubData = (PFN_glBufferSubData)GalogenGetProcAddress("glBufferSubData");
   _glptr_glBufferSubData(target, offset, size, data);
}
PFN_glBufferSubData _glptr_glBufferSubData = _impl_glBufferSubData;

static void  GL_APIENTRY _impl_glActiveTexture (GLenum texture) {
  _glptr_glActiveTexture = (PFN_glActiveTexture)GalogenGetProcAddress("glActiveTexture");
   _glptr_glActiveTexture(texture);
}
PFN_glActiveTexture _glptr_glActiveTexture = _impl_glActiveTexture;

static void  GL_APIENTRY _impl_glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
  _glptr_glColorMask = (PFN_glColorMask)GalogenGetProcAddress("glColorMask");
   _glptr_glColorMask(red, green, blue, alpha);
}
PFN_glColorMask _glptr_glColorMask = _impl_glColorMask;

static void  GL_APIENTRY _impl_glBufferData (GLenum target, GLsizeiptr size, const void * data, GLenum usage) {
  _glptr_glBufferData = (PFN_glBufferData)GalogenGetProcAddress("glBufferData");
   _glptr_glBufferData(target, size, data, usage);
}
PFN_glBufferData _glptr_glBufferData = _impl_glBufferData;

static void  GL_APIENTRY _impl_glDepthFunc (GLenum func) {
  _glptr_glDepthFunc = (PFN_glDepthFunc)GalogenGetProcAddress("glDepthFunc");
   _glptr_glDepthFunc(func);
}
PFN_glDepthFunc _glptr_glDepthFunc = _impl_glDepthFunc;

static void  GL_APIENTRY _impl_glFlush () {
  _glptr_glFlush = (PFN_glFlush)GalogenGetProcAddress("glFlush");
   _glptr_glFlush();
}
PFN_glFlush _glptr_glFlush = _impl_glFlush;

static void  GL_APIENTRY _impl_glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glCopyTexSubImage2D = (PFN_glCopyTexSubImage2D)GalogenGetProcAddress("glCopyTexSubImage2D");
   _glptr_glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}
PFN_glCopyTexSubImage2D _glptr_glCopyTexSubImage2D = _impl_glCopyTexSubImage2D;

static void  GL_APIENTRY _impl_glGetAttachedShaders (GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders) {
  _glptr_glGetAttachedShaders = (PFN_glGetAttachedShaders)GalogenGetProcAddress("glGetAttachedShaders");
   _glptr_glGetAttachedShaders(program, maxCount, count, shaders);
}
PFN_glGetAttachedShaders _glptr_glGetAttachedShaders = _impl_glGetAttachedShaders;

static void  GL_APIENTRY _impl_glDepthRangef (GLfloat n, GLfloat f) {
  _glptr_glDepthRangef = (PFN_glDepthRangef)GalogenGetProcAddress("glDepthRangef");
   _glptr_glDepthRangef(n, f);
}
PFN_glDepthRangef _glptr_glDepthRangef = _impl_glDepthRangef;

static void  GL_APIENTRY _impl_glBlendEquation (GLenum mode) {
  _glptr_glBlendEquation = (PFN_glBlendEquation)GalogenGetProcAddress("glBlendEquation");
   _glptr_glBlendEquation(mode);
}
PFN_glBlendEquation _glptr_glBlendEquation = _impl_glBlendEquation;

static void  GL_APIENTRY _impl_glGetShaderSource (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source) {
  _glptr_glGetShaderSource = (PFN_glGetShaderSource)GalogenGetProcAddress("glGetShaderSource");
   _glptr_glGetShaderSource(shader, bufSize, length, source);
}
PFN_glGetShaderSource _glptr_glGetShaderSource = _impl_glGetShaderSource;

static void  GL_APIENTRY _impl_glEnable (GLenum cap) {
  _glptr_glEnable = (PFN_glEnable)GalogenGetProcAddress("glEnable");
   _glptr_glEnable(cap);
}
PFN_glEnable _glptr_glEnable = _impl_glEnable;

static void  GL_APIENTRY _impl_glBlendColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
  _glptr_glBlendColor = (PFN_glBlendColor)GalogenGetProcAddress("glBlendColor");
   _glptr_glBlendColor(red, green, blue, alpha);
}
PFN_glBlendColor _glptr_glBlendColor = _impl_glBlendColor;

static void  GL_APIENTRY _impl_glUniform2f (GLint location, GLfloat v0, GLfloat v1) {
  _glptr_glUniform2f = (PFN_glUniform2f)GalogenGetProcAddress("glUniform2f");
   _glptr_glUniform2f(location, v0, v1);
}
PFN_glUniform2f _glptr_glUniform2f = _impl_glUniform2f;

static void  GL_APIENTRY _impl_glBindTexture (GLenum target, GLuint texture) {
  _glptr_glBindTexture = (PFN_glBindTexture)GalogenGetProcAddress("glBindTexture");
   _glptr_glBindTexture(target, texture);
}
PFN_glBindTexture _glptr_glBindTexture = _impl_glBindTexture;
