# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p450 -iterations=1 < %s | FileCheck %s

lw t0, 0(a0)
ld t0, 0(a0)

flh ft0, 0(a0)
flw ft0, 0(a0)
fld ft0, 0(a0)

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      5
# CHECK-NEXT: Total Cycles:      12
# CHECK-NEXT: Total uOps:        5

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.42
# CHECK-NEXT: IPC:               0.42
# CHECK-NEXT: Block RThroughput: 5.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     1.00    *                   lw	t0, 0(a0)
# CHECK-NEXT:  1      4     1.00    *                   ld	t0, 0(a0)
# CHECK-NEXT:  1      5     1.00    *                   flh	ft0, 0(a0)
# CHECK-NEXT:  1      5     1.00    *                   flw	ft0, 0(a0)
# CHECK-NEXT:  1      5     1.00    *                   fld	ft0, 0(a0)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP400Div
# CHECK-NEXT: [1]   - SiFiveP400FEXQ0
# CHECK-NEXT: [2]   - SiFiveP400FloatDiv
# CHECK-NEXT: [3]   - SiFiveP400IEXQ0
# CHECK-NEXT: [4]   - SiFiveP400IEXQ1
# CHECK-NEXT: [5]   - SiFiveP400IEXQ2
# CHECK-NEXT: [6]   - SiFiveP400Load
# CHECK-NEXT: [7]   - SiFiveP400Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -      -      -      -      -     5.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lw	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     ld	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     flh	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     flw	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     fld	ft0, 0(a0)
