; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm-eabi -mattr=+neon | FileCheck %s --check-prefixes=CHECK,ALLOC,NOALLOC
; RUN: llc < %s -mtriple=arm-eabi -mattr=+neon -regalloc=basic | FileCheck %s --check-prefixes=CHECK,BASIC

define <8 x i8> @vcgts8(<8 x i8>* %A, <8 x i8>* %B) nounwind {
; ALLOC-LABEL: vcgts8:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.s8 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgts8:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.s8 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, <8 x i8>* %A
	%tmp2 = load <8 x i8>, <8 x i8>* %B
	%tmp3 = icmp sgt <8 x i8> %tmp1, %tmp2
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
	ret <8 x i8> %tmp4
}

define <4 x i16> @vcgts16(<4 x i16>* %A, <4 x i16>* %B) nounwind {
; ALLOC-LABEL: vcgts16:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.s16 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgts16:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.s16 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x i16>, <4 x i16>* %A
	%tmp2 = load <4 x i16>, <4 x i16>* %B
	%tmp3 = icmp sgt <4 x i16> %tmp1, %tmp2
	%tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
	ret <4 x i16> %tmp4
}

define <2 x i32> @vcgts32(<2 x i32>* %A, <2 x i32>* %B) nounwind {
; ALLOC-LABEL: vcgts32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.s32 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgts32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.s32 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <2 x i32>, <2 x i32>* %A
	%tmp2 = load <2 x i32>, <2 x i32>* %B
	%tmp3 = icmp sgt <2 x i32> %tmp1, %tmp2
	%tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
	ret <2 x i32> %tmp4
}

define <8 x i8> @vcgtu8(<8 x i8>* %A, <8 x i8>* %B) nounwind {
; ALLOC-LABEL: vcgtu8:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.u8 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtu8:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.u8 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, <8 x i8>* %A
	%tmp2 = load <8 x i8>, <8 x i8>* %B
	%tmp3 = icmp ugt <8 x i8> %tmp1, %tmp2
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
	ret <8 x i8> %tmp4
}

define <4 x i16> @vcgtu16(<4 x i16>* %A, <4 x i16>* %B) nounwind {
; ALLOC-LABEL: vcgtu16:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.u16 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtu16:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.u16 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x i16>, <4 x i16>* %A
	%tmp2 = load <4 x i16>, <4 x i16>* %B
	%tmp3 = icmp ugt <4 x i16> %tmp1, %tmp2
	%tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
	ret <4 x i16> %tmp4
}

define <2 x i32> @vcgtu32(<2 x i32>* %A, <2 x i32>* %B) nounwind {
; ALLOC-LABEL: vcgtu32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.u32 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtu32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.u32 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <2 x i32>, <2 x i32>* %A
	%tmp2 = load <2 x i32>, <2 x i32>* %B
	%tmp3 = icmp ugt <2 x i32> %tmp1, %tmp2
	%tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
	ret <2 x i32> %tmp4
}

define <2 x i32> @vcgtf32(<2 x float>* %A, <2 x float>* %B) nounwind {
; ALLOC-LABEL: vcgtf32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vcgt.f32 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtf32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vcgt.f32 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <2 x float>, <2 x float>* %A
	%tmp2 = load <2 x float>, <2 x float>* %B
	%tmp3 = fcmp ogt <2 x float> %tmp1, %tmp2
	%tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
	ret <2 x i32> %tmp4
}

define <16 x i8> @vcgtQs8(<16 x i8>* %A, <16 x i8>* %B) nounwind {
; ALLOC-LABEL: vcgtQs8:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.s8 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQs8:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.s8 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, <16 x i8>* %A
	%tmp2 = load <16 x i8>, <16 x i8>* %B
	%tmp3 = icmp sgt <16 x i8> %tmp1, %tmp2
	%tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
	ret <16 x i8> %tmp4
}

define <8 x i16> @vcgtQs16(<8 x i16>* %A, <8 x i16>* %B) nounwind {
; ALLOC-LABEL: vcgtQs16:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.s16 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQs16:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.s16 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, <8 x i16>* %A
	%tmp2 = load <8 x i16>, <8 x i16>* %B
	%tmp3 = icmp sgt <8 x i16> %tmp1, %tmp2
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
	ret <8 x i16> %tmp4
}

define <4 x i32> @vcgtQs32(<4 x i32>* %A, <4 x i32>* %B) nounwind {
; ALLOC-LABEL: vcgtQs32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.s32 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQs32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.s32 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x i32>, <4 x i32>* %A
	%tmp2 = load <4 x i32>, <4 x i32>* %B
	%tmp3 = icmp sgt <4 x i32> %tmp1, %tmp2
	%tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
	ret <4 x i32> %tmp4
}

define <16 x i8> @vcgtQu8(<16 x i8>* %A, <16 x i8>* %B) nounwind {
; ALLOC-LABEL: vcgtQu8:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.u8 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQu8:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.u8 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, <16 x i8>* %A
	%tmp2 = load <16 x i8>, <16 x i8>* %B
	%tmp3 = icmp ugt <16 x i8> %tmp1, %tmp2
	%tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
	ret <16 x i8> %tmp4
}

define <8 x i16> @vcgtQu16(<8 x i16>* %A, <8 x i16>* %B) nounwind {
; ALLOC-LABEL: vcgtQu16:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.u16 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQu16:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.u16 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, <8 x i16>* %A
	%tmp2 = load <8 x i16>, <8 x i16>* %B
	%tmp3 = icmp ugt <8 x i16> %tmp1, %tmp2
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
	ret <8 x i16> %tmp4
}

define <4 x i32> @vcgtQu32(<4 x i32>* %A, <4 x i32>* %B) nounwind {
; ALLOC-LABEL: vcgtQu32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.u32 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQu32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.u32 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x i32>, <4 x i32>* %A
	%tmp2 = load <4 x i32>, <4 x i32>* %B
	%tmp3 = icmp ugt <4 x i32> %tmp1, %tmp2
	%tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
	ret <4 x i32> %tmp4
}

define <4 x i32> @vcgtQf32(<4 x float>* %A, <4 x float>* %B) nounwind {
; ALLOC-LABEL: vcgtQf32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.f32 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgtQf32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.f32 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x float>, <4 x float>* %A
	%tmp2 = load <4 x float>, <4 x float>* %B
	%tmp3 = fcmp ogt <4 x float> %tmp1, %tmp2
	%tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
	ret <4 x i32> %tmp4
}

define <2 x i32> @vacgtf32(<2 x float>* %A, <2 x float>* %B) nounwind {
; ALLOC-LABEL: vacgtf32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vldr d16, [r1]
; ALLOC-NEXT:    vldr d17, [r0]
; ALLOC-NEXT:    vacgt.f32 d16, d17, d16
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vacgtf32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vldr d17, [r1]
; BASIC-NEXT:    vldr d16, [r0]
; BASIC-NEXT:    vacgt.f32 d16, d16, d17
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <2 x float>, <2 x float>* %A
	%tmp2 = load <2 x float>, <2 x float>* %B
	%tmp3 = call <2 x i32> @llvm.arm.neon.vacgt.v2i32.v2f32(<2 x float> %tmp1, <2 x float> %tmp2)
	ret <2 x i32> %tmp3
}

define <4 x i32> @vacgtQf32(<4 x float>* %A, <4 x float>* %B) nounwind {
; ALLOC-LABEL: vacgtQf32:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vacgt.f32 q8, q9, q8
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vacgtQf32:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vacgt.f32 q8, q8, q9
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x float>, <4 x float>* %A
	%tmp2 = load <4 x float>, <4 x float>* %B
	%tmp3 = call <4 x i32> @llvm.arm.neon.vacgt.v4i32.v4f32(<4 x float> %tmp1, <4 x float> %tmp2)
	ret <4 x i32> %tmp3
}

; rdar://7923010
define <4 x i32> @vcgt_zext(<4 x float>* %A, <4 x float>* %B) nounwind {
; ALLOC-LABEL: vcgt_zext:
; ALLOC:       @ %bb.0:
; ALLOC-NEXT:    vld1.64 {d16, d17}, [r1]
; ALLOC-NEXT:    vld1.64 {d18, d19}, [r0]
; ALLOC-NEXT:    vcgt.f32 q8, q9, q8
; ALLOC-NEXT:    vmov.i32 q9, #0x1
; ALLOC-NEXT:    vand q8, q8, q9
; ALLOC-NEXT:    vmov r0, r1, d16
; ALLOC-NEXT:    vmov r2, r3, d17
; ALLOC-NEXT:    mov pc, lr
;
; BASIC-LABEL: vcgt_zext:
; BASIC:       @ %bb.0:
; BASIC-NEXT:    vld1.64 {d18, d19}, [r1]
; BASIC-NEXT:    vld1.64 {d16, d17}, [r0]
; BASIC-NEXT:    vcgt.f32 q9, q8, q9
; BASIC-NEXT:    vmov.i32 q8, #0x1
; BASIC-NEXT:    vand q8, q9, q8
; BASIC-NEXT:    vmov r0, r1, d16
; BASIC-NEXT:    vmov r2, r3, d17
; BASIC-NEXT:    mov pc, lr
	%tmp1 = load <4 x float>, <4 x float>* %A
	%tmp2 = load <4 x float>, <4 x float>* %B
	%tmp3 = fcmp ogt <4 x float> %tmp1, %tmp2
	%tmp4 = zext <4 x i1> %tmp3 to <4 x i32>
	ret <4 x i32> %tmp4
}

declare <2 x i32> @llvm.arm.neon.vacgt.v2i32.v2f32(<2 x float>, <2 x float>) nounwind readnone
declare <4 x i32> @llvm.arm.neon.vacgt.v4i32.v4f32(<4 x float>, <4 x float>) nounwind readnone

define <8 x i8> @vcgti8Z(<8 x i8>* %A) nounwind {
; CHECK-LABEL: vcgti8Z:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vcgt.s8 d16, d16, #0
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, <8 x i8>* %A
	%tmp3 = icmp sgt <8 x i8> %tmp1, <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
	ret <8 x i8> %tmp4
}

define <8 x i8> @vclti8Z(<8 x i8>* %A) nounwind {
; CHECK-LABEL: vclti8Z:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vclt.s8 d16, d16, #0
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, <8 x i8>* %A
	%tmp3 = icmp slt <8 x i8> %tmp1, <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
	%tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
	ret <8 x i8> %tmp4
}
