package tests::functional::LrEnvironmentTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase/;

use Lire::Config::Build qw/ac_path/;

sub test_lr_environment {
    my $self = $_[0];

    my $result = $self->lire_run( ac_path( 'libexecdir', 'PACKAGE') .
                                  "/lr_environment" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert_matches( qr/lr_environment info started with no argument/,
                           $result->stderr() );
    $self->assert_does_not_match( qr/ (crit|err|warning) /, $result->stderr(),
                                  "There were warnings or error messages." );


    # Test some known default config variables
    $self->assert_matches( qr/lr_test_uid='1'/, $result->stdout() );
    $self->assert_matches( qr/lr_debug=''/,  $result->stdout() );
    $self->assert_matches( qr/lr_spool_interval='300'/, $result->stdout() );

}

sub test_shell_env {
    my $self = $_[0];

    my $lr_env = ac_path( 'libexecdir', 'PACKAGE') . "/lr_environment";
    my $result = $self->lire_run( qq{ eval `$lr_env`; echo "lr_debug=\$lr_debug"x; echo "lr_test_uid=\$lr_test_uid"x; echo "lr_spool_interval=\$lr_spool_interval"x } );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert_matches( qr/lr_test_uid=1x/, $result->stdout() );
    $self->assert_matches( qr/lr_debug=x/,  $result->stdout() );

}
1;
