package latexDraw.util;

import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;

import latexDraw.lang.LaTeXDrawLang;

/**
 * Contains all the icons and the labels used by latexdraw.<br>
 * 
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 09/21/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0
 * @since 2.0.0
 */
public abstract class LaTeXDrawResources
{
	/** The e-mail of the latexdraw developer */
	public static final String MAIL_ME = "arno_b@users.sourceforge.net"; //$NON-NLS-1$
	
	public static final String LABEL_ZOOM_CHANGE = "zoomChange";//$NON-NLS-1$

	/** The label of the menuItem zoomIn */
	public static final String LABEL_ZOOM_IN = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.57"); //$NON-NLS-1$
	
	/** The label of the menuItem zoomOut */
	public static final String LABEL_ZOOM_OUT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.58"); //$NON-NLS-1$
	
	/** The label of the menu item drawLineMenu */
	public final static String LABEL_LINE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.2"); //$NON-NLS-1$
	
	/** The label of the menu item drawRectMenu */
	public final static String LABEL_RECT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.3"); //$NON-NLS-1$
	
	/** The label of the menu item drawDotMenu */
	public final static String LABEL_DOT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.4"); //$NON-NLS-1$
	
	/** The label of the menu item drawRectMenu */
	public final static String LABEL_SQUARE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.5"); //$NON-NLS-1$
	
	/** The label of the menu item drawRhombMenu */
	public final static String LABEL_RHOMBUS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.6"); //$NON-NLS-1$
	
	/** The label of the menu item drawRhombMenu */
	public final static String LABEL_POINTS_AKIN = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.7"); //$NON-NLS-1$
	
	/** The label of the menu item drawTrianMenu */
	public final static String LABEL_TRIANGLE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.8"); //$NON-NLS-1$
	
	/** The label of the menu item drawJoinedLinesMenu */
	public final static String LABEL_JOINED_LINES = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.4");  //$NON-NLS-1$
	
	/** The label of the menu item drawCircleMenu */
	public final static String LABEL_CIRCLE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.9"); //$NON-NLS-1$
	
	/** The label of the menu item drawGridMenu */
	public final static String LABEL_GRID = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.10"); //$NON-NLS-1$
	
	public final static String LABEL_AXES = LaTeXDrawLang.getString1_8("LaTeXDrawFrame.0"); //$NON-NLS-1$
	
	/** The label of the menu item drawEllipseMenu */
	public final static String LABEL_ELLIPSE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.11"); //$NON-NLS-1$
	
	/** The label of the menu item drawPolyMenu */
	public final static String LABEL_POLY = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.12"); //$NON-NLS-1$
	
    /** The name of the choice dotChoice */
    public static final String CHOICE_DOT_NAME = "dotChoice";//$NON-NLS-1$
    
    /** The name of the choice lineChoice */
    public static final String CHOICE_LINE_NAME = "lineChoice";//$NON-NLS-1$
    
    /** The name of the choice lineArrowLChoice */
    public static final String CHOICE_ARROW_LEFT_NAME = "arrowLChoice";//$NON-NLS-1$
    
    public static final String CHOICE_ARROW_RIGHT_NAME = "arrowRChoice";//$NON-NLS-1$
    
    /** The name of the extension of LaTeXDraw filenames (LaTeXDraw Project)*/
    public final static String PROJECT_EXTENSION = ".ldp"; //$NON-NLS-1$
    
    /** The name of the extension of LaTeXDraw templates */
    public static final String TEMPLATE_EXTENSION = ".ldt";//$NON-NLS-1$
    
    /** The beginning of the action command of templates */
    public static final String TEMPLATE_START_ACTION_CMD = "template_";//$NON-NLS-1$
    
    public final static String LABEL_EXPORT_EPS_LATEX = "EPS_LATEX_EXPORT";//$NON-NLS-1$
    
    public final static String LABEL_EXPORT_PDF_LATEX = "PDF_LATEX_EXPORT";//$NON-NLS-1$
    
    public final static String LABEL_EXPORT_PDF_LATEX_CROP = "PDFCROP_LATEX_EXPORT";//$NON-NLS-1$
    	
    /** The name of the extension of GIF file */
	public static final String GIF_EXTENSION = ".gif";//$NON-NLS-1$
	
    /** The name of the extension of PPM file */
    public final static String PPM_EXTENSION = ".ppm";//$NON-NLS-1$
    
    /** The name of the extension of bmp file*/
    public final static String BMP_EXTENSION = ".bmp";//$NON-NLS-1$
    
    /** The name of the extension of png file */
    public final static String PNG_EXTENSION = ".png";//$NON-NLS-1$
    
    /** The name of the extension of jpg file */
    public final static String JPG_EXTENSION = ".jpg";//$NON-NLS-1$
    
    /** The name of the extension of EPS file */
    public final static String EPS_EXTENSION = ".eps";//$NON-NLS-1$
    
	/** The name of the application */
	public final static String LABEL_APP = "LaTeXDraw";//$NON-NLS-1$
	
	/** The label of the menu insert PSTricks code */
	public final static String LABEL_INSERT_CODE = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.0"); //$NON-NLS-1$

	/** The label of the menu insert picture */
	public final static String LABEL_INSERT_PIX = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.1"); //$NON-NLS-1$

	/** The label of the menu "convert picture" */
	public static final String LABEL_BATCH_CONVERT = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.2"); //$NON-NLS-1$
	
	/** The label of the button stop */
	public final static String LABEL_STOP = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.3"); //$NON-NLS-1$
	
	/** The label of the menu help */
	public final static String LABEL_HELP = LABEL_APP + LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.0"); //$NON-NLS-1$
	
	/** The label of the menu "aboutTexDraw" */
	public final static String LABEL_ABOUT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.1")+ LABEL_APP+ " ..."; //$NON-NLS-1$//$NON-NLS-2$

	/** The label of the menu item selectFigure */
	public final static String LABEL_SELECT_FIGURE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.13"); //$NON-NLS-1$
	
	/** The label of the menu item displayBorders */
	public final static String LABEL_DISPLAY_BORDERS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.14"); //$NON-NLS-1$
	
	/** The label of the menu item displayBorders */
	public final static String LABEL_AUTO_ADJUST_BORDERS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.15"); //$NON-NLS-1$
	
	/** The label of the menu export as */
	public final static String LABEL_EXPORT_AS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.16"); //$NON-NLS-1$
	
	/** The label of the menu import */
	public final static String LABEL_IMPORT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.229"); //$NON-NLS-1$
	
	/** The label of the menu item "import from TeX file" */
	public static final String LABEL_IMPORT_TEX = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.230"); //$NON-NLS-1$
	
	/** The label of the menu item deleteFigure */
	public final static String LABEL_DELETE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.17"); //$NON-NLS-1$
	
	/** The label of the menu item which allows the user to quit the application*/
	public final static String LABEL_QUIT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.18"); //$NON-NLS-1$
	
	/** The label of the exportCodeMenu item */
	public final static String LABEL_EXPORT_TRICKS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.19"); //$NON-NLS-1$
	
	/** The label of the exportAsPNMFile item */
	public final static String LABEL_EXPORT_PPM = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.5"); //$NON-NLS-1$
	
	/** The label of the exportAsBMPFile item */
	public final static String LABEL_EXPORT_BMP = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.6"); //$NON-NLS-1$
	
	/** The label of the exportAsPNGFile item */
	public final static String LABEL_EXPORT_PNG = LaTeXDrawLang.getString1_6("LaTeXDrawFrame.7"); //$NON-NLS-1$
	
	/** The label of the exportDrawMenu item */
	public final static String LABEL_EXPORT_JPG = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.20"); //$NON-NLS-1$
	
	/** The label of the exportEPSMenu item */
	public final static String LABEL_EXPORT_EPS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.21"); //$NON-NLS-1$
	
	/** The label of the menuItem redoMenu */
	public final static String LABEL_REDO = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.22"); //$NON-NLS-1$
	
	/** The label of the menuItem undoMenu */
	public final static String LABEL_UNDO = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.23"); //$NON-NLS-1$
	
	/** The name of the thickness field */
	public final static String NAME_THICKNESS_FIELD = "thicknessField"; //$NON-NLS-1$
	
	public final static String NAME_DOT_SIZE_FIELD = "dotSizeField"; //$NON-NLS-1$
	
	/** The label of the saveMenu item */
	public final static String LABEL_SAVE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.25"); //$NON-NLS-1$
	
	/** The label of the saveAsMenu item */
	public final static String LABEL_SAVE_AS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.26"); //$NON-NLS-1$

	public final static String LABEL_RECENT_FILES = LaTeXDrawLang.getString1_9("LaTeXDrawFrame.0"); //$NON-NLS-1$
	
	/** The label of the openMenu item */
	public final static String LABEL_OPEN = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.27"); //$NON-NLS-1$
	
	/** The label of the newMenu item */
	public final static String LABEL_NEW = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.28"); //$NON-NLS-1$
	
	public final static String LABEL_NEW_WITH_SEL =LaTeXDrawLang.getStringLaTeXDrawFrame("LFrame2.26"); //$NON-NLS-1$
	
	/** The label of the printCodeMenu item */
	public final static String LABEL_PRINT_CODE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.29"); //$NON-NLS-1$
	
	/** The label of the printDrawMenu item */
	public final static String LABEL_PRINT_DRAW = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.30"); //$NON-NLS-1$
	
	/** The label of the ImageButton behindSel */
	public static final String LABEL_BEHIND_SEL = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.31"); //$NON-NLS-1$
	
	/** The label of the ImageButton inFrontOfSel */
	public static final String LABEL_FRONT_SEL = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.32"); //$NON-NLS-1$
	
	/** The label of the button join */
	public static final String LABEL_JOIN = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.33"); //$NON-NLS-1$
	
	/** The label of the button separate */
	public static final String LABEL_SEPARATE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.34"); //$NON-NLS-1$
	
	/** The label of the arcMenu item */
	public final static String LABEL_ARC = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.35"); //$NON-NLS-1$
	
	/** The label of the wedgeMenu item */
	public final static String LABEL_WEDGE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.36"); //$NON-NLS-1$
	
	/** The label of the chordMenu item */
	public final static String LABEL_CHORD = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.37"); //$NON-NLS-1$
	
	/** The label of the menuItem displayXScale */
	public static final String LABEL_DISPLAY_XSCALE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.38"); //$NON-NLS-1$
	
	/** The label of the menuItem Y */
	public static final String LABEL_DISPLAY_YSCALE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.39"); //$NON-NLS-1$
	
	/** The label of the menu copy */
	public static final String LABEL_COPY = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.40"); //$NON-NLS-1$
	
	/** The label of the menuItem updateTemplates */
	public static final String LABEL_TEMPLATE_UPDATE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.41"); //$NON-NLS-1$
	
	/** The label of the menuItem exportAsTemplate */
	public static final String LABEL_TEMPLATE_EXPORT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.42"); //$NON-NLS-1$
	
	/** The label of the menu paste */
	public static final String LABEL_PASTE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.43"); //$NON-NLS-1$
	
	/** The label of the menu cut */
	public static final String LABEL_CUT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.44"); //$NON-NLS-1$
	
	public static final String LABEL_DISPLAY_PERSO_GRID = LaTeXDrawLang.getString1_8("PreferencesFrame.5"); //$NON-NLS-1$
	
	/** The label of the menuItem displayGrid */
	public static final String LABEL_DISPLAY_GRID = LaTeXDrawLang.getString1_8("PreferencesFrame.4"); //$NON-NLS-1$
	
	/** The label of the menuItem codePanel */
	public static final String LABEL_DISPLAY_CODE_PANEL = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.46"); //$NON-NLS-1$
	
	/** The label of the JButton buttonBordersColor */
	public static final String LABEL_COLOR_BUTTON = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.47"); //$NON-NLS-1$
	
	/** The label of the JButton buttonInteriorColor */
	public static final String LABEL_COLOR_INTERIOR_BUTTON = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.48"); //$NON-NLS-1$
	
	/** The label of the JButton buttonHatchColor */
	public static final String LABEL_COLOR_HATCH = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.49"); //$NON-NLS-1$
	
	/** The label of the JButton buttonDbleBoundColor */
	public static final String LABEL_COLOR_DBLE_BOUND = "dbleColBound"; //$NON-NLS-1$
	
	/** The label of the JButton buttonShadowColor. */
	public static final String LABEL_COLOR_SHADOW = LaTeXDrawLang.getString1_7("LaTeXDrawFrame.0"); //$NON-NLS-1$

	public static final String NAME_COLOR_SHADOW = "SHA_COL_BUT";//$NON-NLS-1$
	
	/** The label of the JCheckBox @see filledCheckBox */
	public static final String LABEL_FILLED_CHECKBOX = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.51"); //$NON-NLS-1$
	
	/** The label of the JCheckBox @see dbleBoundCheckBox */
	public static final String LABEL_DBLE_BOUND_CHECKBOX = LaTeXDrawLang.getDialogFrameString("AbstractParametersFrame.0"); //$NON-NLS-1$
	
	/** The label of the button which allows to choose the first colour of a gradient. */
	public static final String LABEL_COLOR_GRADIENT_FIRST = LaTeXDrawLang.getString1_7("LaTeXDrawFrame.1"); //$NON-NLS-1$
	
	/** The label of the button which allows to choose the second colour of a gradient. */
	public static final String LABEL_COLOR_GRADIENT_SECOND = LaTeXDrawLang.getString1_7("LaTeXDrawFrame.2"); //$NON-NLS-1$
	
	/** The label of the JCheckBox shadowCheckBox. */
	public static final String LABEL_SHADOW_CHECKBOX = LaTeXDrawLang.getString1_7("LaTeXDrawFrame.0"); //$NON-NLS-1$
	
	/** The label of the menu properties of the selected figure*/
	public static final String LABEL_FIGURE_PROPERTIES = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.53"); //$NON-NLS-1$
	
	/** The label of the menu properties of the drawing*/
	public static final String LABEL_DRAW_PROPERTIES = LaTeXDrawLang.getDialogFrameString("DrawPropertiesFrame.2"); //$NON-NLS-1$
		
	/** The label of the menu "addCommentsMenu" */
	public static final String LABEL_COMMENTS = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.55"); //$NON-NLS-1$
	
	/** The label of the menuItem "preferencesMenu" */
	public static final String LABEL_PREFERENCES = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.56"); //$NON-NLS-1$
	
	public static final String LABEL_MAGNETIC_CB = "MagneticCB";//$NON-NLS-1$
	
	public static final String LABEL_PERSO_GRID_GAP_FIELD = "PersoGridGapFD";//$NON-NLS-1$
	
	/** The label of the menuItem "bézier curve" */
	public static final String LABEL_BEZIER_CURVE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.63"); //$NON-NLS-1$
	
	public static final String LABEL_CLOSED_BEZIER_CURVE = LaTeXDrawLang.getString1_9("LaTeXDrawFrame.1"); //$NON-NLS-1$
	
	/** Allows the user the zoom at 100 % */
	public static final String LABEL_ZOOM_DEFAULT = "Zoom 100%"; //$NON-NLS-1$
	
	/** This token allows the program to identify LaTeXDraw template files */
	public static final String TOKEN_TEMPLATE_FILE = "LaTeXDraw template"; //$NON-NLS-1$
	
	public static final String LABEL_TEX_EDITOR = "texEditor";//$NON-NLS-1$
	
	/** The label of the menuItem menuText */
	public static final String LABEL_TEXT = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.60"); //$NON-NLS-1$
	
	/** The label of the menus which allow to put a figure in the foreground */
	public static final String LABEL_FOREGROUND = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.61"); //$NON-NLS-1$
	
	/** The label of the menus which allow to put a figure in the background */
	public static final String LABEL_BACKGROUND = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.62"); //$NON-NLS-1$
	
	/** The label of the button which allow to rotate a figure with the mouse */
	public static final String LABEL_ROTATE = LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.64"); //$NON-NLS-1$
	
	public static final String LABEL_ROTATE_90 = "rotation90"; //$NON-NLS-1$
	
	public static final String LABEL_ROTATE_180 = "rotation180"; //$NON-NLS-1$
	
	public static final String LABEL_ROTATE_270 = "rotation270"; //$NON-NLS-1$
	
	public static final String LABEL_MIRROR_H = "mirrorH"; //$NON-NLS-1$
	
	public static final String LABEL_MIRROR_V = "mirrorV"; //$NON-NLS-1$
	
	public static final String NAME_SLIDER_DELIMITOR = "sliderDel";//$NON-NLS-1$
	
	public final static ImageIcon pdfIcon ;
	public final static ImageIcon bezierCurveIcon; 			public final static ImageIcon chordIcon;
	public final static ImageIcon newIcon;					public final static ImageIcon lineStyleNoneIcon;
	public final static ImageIcon openIcon; 				public final static ImageIcon lineStyleDashedIcon;
	public final static ImageIcon saveIcon ;				public final static ImageIcon lineStyleDottedIcon;
	public final static ImageIcon saveAsIcon;  				public final static ImageIcon dotStyleNoneIcon;
	public final static ImageIcon circleIcon;				public final static ImageIcon dotStyleSquareIcon;
	public final static ImageIcon delIcon; 					public final static ImageIcon dotStyleSquareFIcon;
	public final static ImageIcon dotIcon; 					public final static ImageIcon dotStylePentagonIcon;
	public final static ImageIcon ellipseIcon; 				public final static ImageIcon dotStylePentagonFIcon;
	public final static ImageIcon emptyIcon;				public final static ImageIcon dotStyleTriangleIcon;
	public final static ImageIcon lineIcon; 				public final static ImageIcon dotStyleTriangleFIcon;
	public final static ImageIcon rectIcon;					public final static ImageIcon dotStyleBarIcon;
	public final static ImageIcon rhombusIcon; 				public final static ImageIcon dotStyleAsteriskIcon;
	public final static ImageIcon selectIcon; 				public final static ImageIcon dotStyleCrossIcon;
	public final static ImageIcon squareIcon; 				public final static ImageIcon dotStyleDiamondIcon;
	public final static ImageIcon triangleIcon;				public final static ImageIcon dotStyleDiamondFIcon;
	public final static ImageIcon propertiesIcon; 			public final static ImageIcon dotStyleOIcon;
	public final static ImageIcon printIcon;	 			public final static ImageIcon dotStyleOPlusIcon;
	public final static ImageIcon dotStyleOCrossIcon; 		public final static ImageIcon updateIcon;
	public final static ImageIcon bordersIcon;	 			public final static ImageIcon dotStylePlusIcon;
	public final static ImageIcon autoBordersIcon; 			public final static ImageIcon arrowStyleArcLIcon;
	public final static ImageIcon exportIcon;				public final static ImageIcon arrowStyleArcRIcon;
	public final static ImageIcon arrowStyleArcRRIcon; 		public final static ImageIcon arrowStyleArcLRIcon;
	public final static ImageIcon aboutIcon;				public final static ImageIcon arrowStyleArrowLIcon;
	public final static ImageIcon helpIcon;					public final static ImageIcon arrowStyleArrowRIcon;
	public final static ImageIcon preferencesIcon; 			public final static ImageIcon arrowStyleBarEndLIcon;
	public final static ImageIcon arrowStyleBarEndRIcon; 	public final static ImageIcon drawingPropIcon;
	public final static ImageIcon arcIcon;					public final static ImageIcon arrowStyleBarInLIcon;
	public final static ImageIcon wedgeIcon;				public final static ImageIcon arrowStyleBarInRIcon;
	public final static ImageIcon zoomInIcon;				public final static ImageIcon arrowStyleBrackLIcon;
	public final static ImageIcon arrowStyleBrackLRIcon; 	public final static ImageIcon arrowStyleBrackRRIcon;
	public final static ImageIcon zoomOutIcon;				public final static ImageIcon arrowStyleBrackRIcon;
	public final static ImageIcon zoomDefaultIcon; 			public final static ImageIcon arrowStyleCircleEndLIcon;
	public final static ImageIcon undoIcon;					public final static ImageIcon arrowStyleCircleEndRIcon;
	public final static ImageIcon redoIcon;					public final static ImageIcon arrowStyleCircleInLIcon;
	public final static ImageIcon backgroundIcon;   		public final static ImageIcon arrowStyleCircleInRIcon;
	public final static ImageIcon foregroundIcon;   		public final static ImageIcon arrowStyleDbleArrowLIcon;
	public final static ImageIcon behindSelIcon;	   		public final static ImageIcon arrowStyleDbleArrowRIcon;
	public final static ImageIcon inFrontOfSelIcon; 		public final static ImageIcon arrowStyleDiskEndLIcon;
	public final static ImageIcon rotateIcon;	 			public final static ImageIcon arrowStyleDiskEndRIcon;
	public final static ImageIcon polygonIcon;	 			public final static ImageIcon arrowStyleDiskInLIcon;
	public final static ImageIcon textIcon;		 			public final static ImageIcon arrowStyleDiskInRIcon;
	public final static ImageIcon pointsAkinIcon; 			public final static ImageIcon arrowStyleNoneLIcon;
	public final static ImageIcon arrowStyleNoneRIcon; 		public final static ImageIcon arrowStyleRDbleArrowLIcon;
	public final static ImageIcon arrowStyleRDbleArrowRIcon; public final static ImageIcon arrowStyleRArrowLIcon;
	public final static ImageIcon arrowStyleRArrowRIcon; 	public final static ImageIcon copyIcon;
	public final static ImageIcon pasteIcon;				public final static ImageIcon cutIcon;
	public final static ImageIcon arrowStyleRoundInLIcon;	public final static ImageIcon arrowStyleRoundInRIcon;
	public final static ImageIcon hatchNoneIcon;
	public final static ImageIcon hatchHorizIcon;			public final static ImageIcon hatchVertIcon;
	public final static ImageIcon hatchCrossIcon;			public final static ImageIcon gridIcon;
	public final static ImageIcon joinIcon;					public final static ImageIcon separateIcon;
	public final static ImageIcon middleIcon;				public final static ImageIcon innerIcon;
	public final static ImageIcon outerIcon;		    	public final static ImageIcon copySelIcon;
	public final static ImageIcon importIcon;				public final static ImageIcon commentIcon;
	public final static ImageIcon joinedLinesIcon; 			public final static ImageIcon latexdrawIcon;
	public final static ImageIcon okIcon;					public final static ImageIcon errIcon;
	public final static ImageIcon minusIcon;				public final static ImageIcon plusIcon;
	public final static ImageIcon stopIcon;					public final static ImageIcon reloadIcon;
	public final static ImageIcon insertPicIcon; 			public final static ImageIcon insertPSTricksIcon;
	public final static ImageIcon thicknessIcon; 			public final static ImageIcon gradientIcon;
	public final static ImageIcon displayGridIcon; 			public final static ImageIcon rotate270Icon;
	public final static ImageIcon rotate180Icon; 			public final static ImageIcon rotate90Icon;
	public final static ImageIcon mirrorVIcon;				public final static ImageIcon mirrorHIcon;
	public final static ImageIcon axesIcon;					public final static ImageIcon texEditorIcon;
	public final static ImageIcon delimitorIcon; 			public final static ImageIcon curvesFreehandIcon;
	public final static ImageIcon linesFreehandIcon; 		public final static ImageIcon closeLineIcon;
	public final static ImageIcon closeCurveIcon; 			public final static ImageIcon closedBezierIcon;
	public final static ImageIcon alignBottomIcon; 			public final static ImageIcon alignLeftIcon;
	public final static ImageIcon alignMiddleHorizIcon; 	public final static ImageIcon alignMiddleVertIcon;
	public final static ImageIcon alignRightIcon; 			public final static ImageIcon alignTopIcon;
	public final static ImageIcon distVertBottomIcon; 		public final static ImageIcon distHorizEqualIcon;
	public final static ImageIcon distVertMiddleIcon; 		public final static ImageIcon distVertTopIcon;
	public final static ImageIcon distVertEqualIcon; 		public final static ImageIcon distHorizMiddleIcon;
	public final static ImageIcon distHorizLeftIcon;		public final static ImageIcon distHorizRightIcon;
	
	
	static
	{
		hatchNoneIcon  = loadImageIcon("/res/hatch/hatch.none.png");//$NON-NLS-1$
		hatchVertIcon  = loadImageIcon("/res/hatch/hatch.vert.png");//$NON-NLS-1$
		hatchHorizIcon = loadImageIcon("/res/hatch/hatch.horiz.png");//$NON-NLS-1$
		hatchCrossIcon = loadImageIcon("/res/hatch/hatch.cross.png");//$NON-NLS-1$
		
		arrowStyleArcLIcon = loadImageIcon("/res/arrowStyles/line.arc.left.png");//$NON-NLS-1$
		arrowStyleArcRIcon = loadImageIcon("/res/arrowStyles/line.arc.right.png");//$NON-NLS-1$
		arrowStyleArcLRIcon = loadImageIcon("/res/arrowStyles/line.arc.r.left.png");//$NON-NLS-1$
		arrowStyleArcRRIcon = loadImageIcon("/res/arrowStyles/line.arc.r.right.png");//$NON-NLS-1$
		arrowStyleArrowLIcon = loadImageIcon("/res/arrowStyles/line.arrow.left.png");//$NON-NLS-1$
		arrowStyleArrowRIcon = loadImageIcon("/res/arrowStyles/line.arrow.right.png");//$NON-NLS-1$
		arrowStyleBarEndLIcon = loadImageIcon("/res/arrowStyles/line.barEnd.left.png");//$NON-NLS-1$
		arrowStyleBarEndRIcon = loadImageIcon("/res/arrowStyles/line.barEnd.right.png");//$NON-NLS-1$
		arrowStyleBarInLIcon = loadImageIcon("/res/arrowStyles/line.barIn.left.png");//$NON-NLS-1$
		arrowStyleBarInRIcon = loadImageIcon("/res/arrowStyles/line.barIn.right.png");//$NON-NLS-1$
		arrowStyleBrackLIcon = loadImageIcon("/res/arrowStyles/line.bracket.left.png");//$NON-NLS-1$
		arrowStyleBrackRIcon = loadImageIcon("/res/arrowStyles/line.bracket.right.png");//$NON-NLS-1$
		arrowStyleBrackLRIcon = loadImageIcon("/res/arrowStyles/line.bracket.r.left.png");//$NON-NLS-1$
		arrowStyleBrackRRIcon = loadImageIcon("/res/arrowStyles/line.bracket.r.right.png");//$NON-NLS-1$
		arrowStyleCircleEndLIcon = loadImageIcon("/res/arrowStyles/line.circle.end.left.png");//$NON-NLS-1$
		arrowStyleCircleEndRIcon = loadImageIcon("/res/arrowStyles/line.circle.end.right.png");//$NON-NLS-1$
		arrowStyleCircleInLIcon = loadImageIcon("/res/arrowStyles/line.circle.in.left.png");//$NON-NLS-1$
		arrowStyleCircleInRIcon = loadImageIcon("/res/arrowStyles/line.circle.in.right.png");//$NON-NLS-1$
		arrowStyleDbleArrowLIcon = loadImageIcon("/res/arrowStyles/line.dbleArrow.left.png");//$NON-NLS-1$
		arrowStyleDbleArrowRIcon = loadImageIcon("/res/arrowStyles/line.dbleArrow.right.png");//$NON-NLS-1$
		arrowStyleDiskEndLIcon = loadImageIcon("/res/arrowStyles/line.disk.end.left.png");//$NON-NLS-1$
		arrowStyleDiskEndRIcon = loadImageIcon("/res/arrowStyles/line.disk.end.right.png");//$NON-NLS-1$
		arrowStyleDiskInLIcon = loadImageIcon("/res/arrowStyles/line.disk.in.left.png");//$NON-NLS-1$
		arrowStyleDiskInRIcon = loadImageIcon("/res/arrowStyles/line.disk.in.right.png");//$NON-NLS-1$
		arrowStyleNoneLIcon = loadImageIcon("/res/arrowStyles/line.none.left.png");//$NON-NLS-1$
		arrowStyleNoneRIcon = loadImageIcon("/res/arrowStyles/line.none.right.png");//$NON-NLS-1$
		arrowStyleRArrowLIcon = loadImageIcon("/res/arrowStyles/line.rarrow.left.png");//$NON-NLS-1$
		arrowStyleRArrowRIcon = loadImageIcon("/res/arrowStyles/line.rarrow.right.png");//$NON-NLS-1$
		arrowStyleRDbleArrowLIcon = loadImageIcon("/res/arrowStyles/line.rdbleArrow.left.png");//$NON-NLS-1$
		arrowStyleRDbleArrowRIcon = loadImageIcon("/res/arrowStyles/line.rdbleArrow.right.png");//$NON-NLS-1$
		arrowStyleRoundInLIcon = loadImageIcon("/res/arrowStyles/line.roundIn.left.png");//$NON-NLS-1$
		arrowStyleRoundInRIcon = loadImageIcon("/res/arrowStyles/line.roundIn.right.png");//$NON-NLS-1$
		
		dotStyleAsteriskIcon = loadImageIcon("/res/dotStyles/dot.asterisk.png");//$NON-NLS-1$
		dotStyleNoneIcon = loadImageIcon("/res/dotStyles/dot.none.png");//$NON-NLS-1$
		dotStyleBarIcon = loadImageIcon("/res/dotStyles/dot.bar.png");//$NON-NLS-1$
		dotStyleOIcon = loadImageIcon("/res/dotStyles/dot.o.png");//$NON-NLS-1$
		dotStyleCrossIcon = loadImageIcon("/res/dotStyles/dot.cross.png");//$NON-NLS-1$
		dotStyleDiamondIcon = loadImageIcon("/res/dotStyles/dot.diamond.png");//$NON-NLS-1$
		dotStyleDiamondFIcon = loadImageIcon("/res/dotStyles/dot.diamondF.png");//$NON-NLS-1$
		dotStyleOCrossIcon = loadImageIcon("/res/dotStyles/dot.ocross.png");//$NON-NLS-1$
		dotStyleOPlusIcon = loadImageIcon("/res/dotStyles/dot.oplus.png");//$NON-NLS-1$
		dotStylePentagonIcon = loadImageIcon("/res/dotStyles/dot.pentagon.png");//$NON-NLS-1$
		dotStylePentagonFIcon = loadImageIcon("/res/dotStyles/dot.pentagonF.png");//$NON-NLS-1$
		dotStylePlusIcon = loadImageIcon("/res/dotStyles/dot.plus.png");//$NON-NLS-1$
		dotStyleSquareIcon = loadImageIcon("/res/dotStyles/dot.square.png");//$NON-NLS-1$
		dotStyleSquareFIcon = loadImageIcon("/res/dotStyles/dot.squareF.png");//$NON-NLS-1$
		dotStyleTriangleIcon = loadImageIcon("/res/dotStyles/dot.triangle.png");//$NON-NLS-1$
		dotStyleTriangleFIcon = loadImageIcon("/res/dotStyles/dot.triangleF.png");//$NON-NLS-1$

		lineStyleNoneIcon 	= loadImageIcon("/res/lineStyles/lineStyle.none.png");//$NON-NLS-1$
		lineStyleDashedIcon = loadImageIcon("/res/lineStyles/lineStyle.dashed.png");//$NON-NLS-1$
		lineStyleDottedIcon = loadImageIcon("/res/lineStyles/lineStyle.dotted.png");//$NON-NLS-1$

		middleIcon = loadImageIcon("/res/doubleBoundary/double.boundary.middle.png");//$NON-NLS-1$
		innerIcon  = loadImageIcon("/res/doubleBoundary/double.boundary.inner.png");//$NON-NLS-1$
		outerIcon  = loadImageIcon("/res/doubleBoundary/double.boundary.outer.png");//$NON-NLS-1$
		
		gridIcon		= loadImageIcon("/res/grid.png");//$NON-NLS-1$
		copyIcon  		= loadImageIcon("/res/Copy.png");//$NON-NLS-1$
		pasteIcon 		= loadImageIcon("/res/Paste.png");//$NON-NLS-1$
		cutIcon   		= loadImageIcon("/res/Cut.png");//$NON-NLS-1$
		pointsAkinIcon 	= loadImageIcon("/res/Draw.png");	//$NON-NLS-1$
		textIcon 		= loadImageIcon("/res/text.png");		//$NON-NLS-1$
		polygonIcon 	= loadImageIcon("/res/polygon.png");	//$NON-NLS-1$	
		rotateIcon 		= loadImageIcon("/res/rotation.png");	//$NON-NLS-1$	
		inFrontOfSelIcon= loadImageIcon("/res/InFrontSelect.png");	//$NON-NLS-1$	
		behindSelIcon 	= loadImageIcon("/res/behindSelect.png");	//$NON-NLS-1$	
		backgroundIcon 	= loadImageIcon("/res/background.png");	//$NON-NLS-1$	
		foregroundIcon 	= loadImageIcon("/res/foreground.png");//$NON-NLS-1$		
		undoIcon 		= loadImageIcon("/res/Undo.png");//$NON-NLS-1$
		redoIcon 		= loadImageIcon("/res/Redo.png");	//$NON-NLS-1$
		zoomDefaultIcon = loadImageIcon("/res/Magnify.png");	//$NON-NLS-1$	
		zoomInIcon 		= loadImageIcon("/res/MagnifyPlus.png");	//$NON-NLS-1$	
		zoomOutIcon 	= loadImageIcon("/res/MagnifyMinus.png");//$NON-NLS-1$		
		wedgeIcon 		= loadImageIcon("/res/wedge.png");//$NON-NLS-1$		
		arcIcon 		= loadImageIcon("/res/Arc.png");	//$NON-NLS-1$	
		preferencesIcon = loadImageIcon("/res/preferences-system.png");	//$NON-NLS-1$	
		newIcon 		= loadImageIcon("/res/New.png");	//$NON-NLS-1$		
		openIcon 		= loadImageIcon("/res/document-open.png");	//$NON-NLS-1$	
		saveIcon 		= loadImageIcon("/res/document-save.png");	//$NON-NLS-1$	
		saveAsIcon 		= loadImageIcon("/res/document-save-as.png");//$NON-NLS-1$		
		circleIcon 		= loadImageIcon("/res/circle.png");	//$NON-NLS-1$	
		delIcon 		= loadImageIcon("/res/del.png");		//$NON-NLS-1$
		dotIcon 		= loadImageIcon("/res/dot.png");	//$NON-NLS-1$	
		ellipseIcon 	= loadImageIcon("/res/ellipse.png");//$NON-NLS-1$		
		emptyIcon 		= loadImageIcon("/res/empty.png");	//$NON-NLS-1$	
		lineIcon 		= loadImageIcon("/res/line.png");	//$NON-NLS-1$	
		rectIcon 		= loadImageIcon("/res/rectangle.png");	//$NON-NLS-1$	
		rhombusIcon 	= loadImageIcon("/res/rhombus.png");//$NON-NLS-1$		
		selectIcon 		= loadImageIcon("/res/select.png");	//$NON-NLS-1$		
		squareIcon 		= loadImageIcon("/res/square.png");	//$NON-NLS-1$	
		triangleIcon 	= loadImageIcon("/res/triangle.png");//$NON-NLS-1$		
		propertiesIcon 	= loadImageIcon("/res/preferences-desktop-theme.png");	//$NON-NLS-1$	
		printIcon 		= loadImageIcon("/res/Print.png");//$NON-NLS-1$		
		bordersIcon 	= loadImageIcon("/res/Object.png");	//$NON-NLS-1$	
		helpIcon 		= loadImageIcon("/res/help-browser.png");	//$NON-NLS-1$	
		aboutIcon 		= loadImageIcon("/res/emblem-important.png");	//$NON-NLS-1$	
		autoBordersIcon = loadImageIcon("/res/AutoBorders.png");//$NON-NLS-1$		
		exportIcon 		= loadImageIcon("/res/go-previous.png");//$NON-NLS-1$
		joinIcon 		= loadImageIcon("/res/join.png");//$NON-NLS-1$
		separateIcon 	= loadImageIcon("/res/separate.png");//$NON-NLS-1$
		reloadIcon 		= loadImageIcon("/res/view-refresh.png");//$NON-NLS-1$
		bezierCurveIcon = loadImageIcon("/res/bezierCurve.png");//$NON-NLS-1$
		chordIcon 		= loadImageIcon("/res/chord.png"); //$NON-NLS-1$
		copySelIcon 	= loadImageIcon("/res/CopySel.png"); //$NON-NLS-1$
		importIcon 		= loadImageIcon("/res/go-next.png"); //$NON-NLS-1$
		commentIcon 	= loadImageIcon("/res/comment.png"); //$NON-NLS-1$
		joinedLinesIcon = loadImageIcon("/res/joinedLines.png"); //$NON-NLS-1$
		okIcon 			= loadImageIcon("/res/ok.png"); //$NON-NLS-1$
		errIcon 		= loadImageIcon("/res/emblem-unreadable.png"); //$NON-NLS-1$
		plusIcon 		= loadImageIcon("/res/list-add.png"); //$NON-NLS-1$
		minusIcon 		= loadImageIcon("/res/list-remove.png"); //$NON-NLS-1$
		stopIcon 		= loadImageIcon("/res/stop.png"); //$NON-NLS-1$
		insertPicIcon 	= loadImageIcon("/res/image-x-generic.png"); //$NON-NLS-1$
		insertPSTricksIcon = loadImageIcon("/res/text-x-generic.png"); //$NON-NLS-1$
		thicknessIcon 	= loadImageIcon("/res/thickness.png"); //$NON-NLS-1$
		gradientIcon 	= loadImageIcon("/res/hatch/gradient.png"); //$NON-NLS-1$
		displayGridIcon = loadImageIcon("/res/displayGrid.png"); //$NON-NLS-1$
		rotate180Icon 	= loadImageIcon("/res/rotation180.png"); //$NON-NLS-1$
		rotate90Icon 	= loadImageIcon("/res/rotation90.png"); //$NON-NLS-1$
		rotate270Icon 	= loadImageIcon("/res/rotation270.png"); //$NON-NLS-1$
		mirrorHIcon 	= loadImageIcon("/res/mirrorH.png"); //$NON-NLS-1$
		mirrorVIcon 	= loadImageIcon("/res/mirrorV.png"); //$NON-NLS-1$
		axesIcon		= loadImageIcon("/res/axes.png"); //$NON-NLS-1$
		texEditorIcon	= loadImageIcon("/res/texEditor.png"); //$NON-NLS-1$
		delimitorIcon	= loadImageIcon("/res/delimitor.png"); //$NON-NLS-1$
		curvesFreehandIcon	= loadImageIcon("/res/freehand/curve.png"); //$NON-NLS-1$
		linesFreehandIcon	= loadImageIcon("/res/freehand/line.png"); //$NON-NLS-1$
		closeCurveIcon		= loadImageIcon("/res/BezierCurves/closeCurve.png"); //$NON-NLS-1$
		closeLineIcon		= loadImageIcon("/res/BezierCurves/closeLine.png"); //$NON-NLS-1$
		closedBezierIcon	= loadImageIcon("/res/closedBezier.png"); //$NON-NLS-1$
		updateIcon			= loadImageIcon("/res/system-software-update.png"); //$NON-NLS-1$
		drawingPropIcon		= loadImageIcon("/res/document-properties.png"); //$NON-NLS-1$
		latexdrawIcon		= loadImageIcon("/res/LaTeXDrawIcon.png"); //$NON-NLS-1$
		pdfIcon				= loadImageIcon("/res/pdf.png"); //$NON-NLS-1$
		
		alignBottomIcon		= loadImageIcon("/res/align/alignBottom.png"); //$NON-NLS-1$
		alignLeftIcon		= loadImageIcon("/res/align/alignLeft.png"); //$NON-NLS-1$
		alignMiddleHorizIcon= loadImageIcon("/res/align/alignMiddleHoriz.png"); //$NON-NLS-1$
		alignMiddleVertIcon	= loadImageIcon("/res/align/alignMiddleVert.png"); //$NON-NLS-1$
		alignRightIcon		= loadImageIcon("/res/align/alignRight.png"); //$NON-NLS-1$
		alignTopIcon		= loadImageIcon("/res/align/alignTop.png"); //$NON-NLS-1$
		
		distVertBottomIcon	= loadImageIcon("/res/distrib/distVertBottom.png"); //$NON-NLS-1$
		distVertEqualIcon	= loadImageIcon("/res/distrib/distVertEqual.png"); //$NON-NLS-1$
		distVertMiddleIcon	= loadImageIcon("/res/distrib/distVertMiddle.png"); //$NON-NLS-1$
		distVertTopIcon		= loadImageIcon("/res/distrib/distVertTop.png"); //$NON-NLS-1$
		distHorizEqualIcon	= loadImageIcon("/res/distrib/distHorizEqual.png"); //$NON-NLS-1$
		distHorizMiddleIcon	= loadImageIcon("/res/distrib/distHorizMiddle.png"); //$NON-NLS-1$
		distHorizRightIcon	= loadImageIcon("/res/distrib/distHorizRight.png"); //$NON-NLS-1$
		distHorizLeftIcon	= loadImageIcon("/res/distrib/distHorizLeft.png"); //$NON-NLS-1$
	}
	
	
	
	/**
	 * Allows to load a image icon from a path.
	 * @param path The path.
	 * @return The image icon or null.
	 */
	public static ImageIcon loadImageIcon(String path)
	{
		URL url;
		
		try
		{
			url = Class.class.getResource(path);
			
			if(url==null)
				throw new MalformedURLException();
			
			return new ImageIcon(url);
		}
		catch(Exception e) 		
		{
			e.printStackTrace(); 
			return null; 
		}	
	}
}
