package latexDraw.figures.properties;

import latexDraw.figures.ArrowHead;

/** 
 * This class defines a property of figures: if a shape can have (two) arrows, this interface
 * defines the prototype of the methods for the management of these arrows.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 07/25/06<br>
 * @author Arnaud BLOUIN<br>
 * @since 1.8<br>
 * @version 2.0.0<br>
 */
public interface Arrowable
{
	/** Allows to get the style of the first arrow. */
	public String getArrow1Style();
	
	/** Allows to get the style of the second arrow. */
	public String getArrow2Style();
	
	/** Allows to get the first arrow. */
	public ArrowHead getArrowHead1();
	
	/** Allows to get the second arrow. */
	public ArrowHead getArrowHead2();
	
	/** Allows to set the first arrow. */
	public void setArrow1Style(String style);
	
	/** Allows to set the first arrow. */
	public void setArrow2Style(String style);
	
	/** Some figures like joined-lines, axes, Bézier curves, have not a left arrow and a right arrow but two left arrows. */
	public boolean hasTwoLeftArrows();
}
