/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.codeInsight.generate;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/codeInsight/generate/testFrameworkSupport")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class GenerateTestSupportMethodActionTestGenerated extends AbstractGenerateTestSupportMethodActionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInTestFrameworkSupport() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/generate/testFrameworkSupport"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JUnit4 extends AbstractGenerateTestSupportMethodActionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJUnit4() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataMethod.kt")
        public void testDataMethod() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/dataMethod.kt");
        }

        @TestMetadata("setUp.kt")
        public void testSetUp() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/setUp.kt");
        }

        @TestMetadata("setUpExists.kt")
        public void testSetUpExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/setUpExists.kt");
        }

        @TestMetadata("setUpOverrides.kt")
        public void testSetUpOverrides() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/setUpOverrides.kt");
        }

        @TestMetadata("tearDown.kt")
        public void testTearDown() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/tearDown.kt");
        }

        @TestMetadata("tearDownExists.kt")
        public void testTearDownExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/tearDownExists.kt");
        }

        @TestMetadata("testMethod.kt")
        public void testTestMethod() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/jUnit4/testMethod.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/generate/testFrameworkSupport/junit3")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Junit3 extends AbstractGenerateTestSupportMethodActionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJunit3() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/generate/testFrameworkSupport/junit3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("setUp.kt")
        public void testSetUp() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/junit3/setUp.kt");
        }

        @TestMetadata("setUpExists.kt")
        public void testSetUpExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/junit3/setUpExists.kt");
        }

        @TestMetadata("tearDown.kt")
        public void testTearDown() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/junit3/tearDown.kt");
        }

        @TestMetadata("tearDownExists.kt")
        public void testTearDownExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/junit3/tearDownExists.kt");
        }

        @TestMetadata("testMethod.kt")
        public void testTestMethod() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/junit3/testMethod.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/generate/testFrameworkSupport/testNG")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TestNG extends AbstractGenerateTestSupportMethodActionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTestNG() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/generate/testFrameworkSupport/testNG"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataMethod.kt")
        public void testDataMethod() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/dataMethod.kt");
        }

        @TestMetadata("setUp.kt")
        public void testSetUp() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/setUp.kt");
        }

        @TestMetadata("setUpExists.kt")
        public void testSetUpExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/setUpExists.kt");
        }

        @TestMetadata("setUpOverrides.kt")
        public void testSetUpOverrides() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/setUpOverrides.kt");
        }

        @TestMetadata("tearDown.kt")
        public void testTearDown() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/tearDown.kt");
        }

        @TestMetadata("tearDownExists.kt")
        public void testTearDownExists() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/tearDownExists.kt");
        }

        @TestMetadata("testMethod.kt")
        public void testTestMethod() throws Exception {
            runTest("idea/testData/codeInsight/generate/testFrameworkSupport/testNG/testMethod.kt");
        }
    }
}
