/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "CEquivalentDataPropertiesExpression.h"


namespace Konclude {

	namespace Parser {

		namespace Expression {


			CEquivalentDataPropertiesExpression::CEquivalentDataPropertiesExpression(CDataPropertyTermExpression *expression1, CDataPropertyTermExpression *expression2, CDataPropertyTermExpression *expression3) 
					: CListDataPropertyTermExpressionAssociator(expression1,expression2,expression3) {
			}

			CEquivalentDataPropertiesExpression::CEquivalentDataPropertiesExpression(const CEXPRESSIONLIST<CDataPropertyTermExpression*>& expressionList)
					: CListDataPropertyTermExpressionAssociator(expressionList) {
			}


			CEquivalentDataPropertiesExpression::~CEquivalentDataPropertiesExpression() {
			}


			cint64 CEquivalentDataPropertiesExpression::getStructuralHashValue() {
				cint64 hashValue = CExpressionHashMixer::getHashValueMixed((cint64)getType(),CListDataPropertyTermExpressionAssociator::getStructuralHashValue());
				return hashValue;
			}

			bool CEquivalentDataPropertiesExpression::compareStructuralEquivalence(CBuildExpression* compareExpression) {
				CEquivalentDataPropertiesExpression* compExpCast = dynamic_cast<CEquivalentDataPropertiesExpression*>(compareExpression);
				if (!compExpCast) {
					return false;
				} 
				return CListDataPropertyTermExpressionAssociator::compareStructuralEquivalence(*compExpCast);
			}


			CBuildExpression::ExpressionType CEquivalentDataPropertiesExpression::getType() {
				return BETEQUIVALENTDATAPROPERTIES;
			}

			bool CEquivalentDataPropertiesExpression::visitSubExpressions(CSubExpressionVisitor* subExpressionVisitor) {
				if (subExpressionVisitor) {
					CListDataPropertyTermExpressionAssociator::visitSubExpressions(this,subExpressionVisitor);
					return true;
				}
				return false;
			}


		}; // end namespace Expression

	}; // end namespace Parser

}; // end namespace Konclude
