/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "configappearance.h"

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

ConfigAppearance::ConfigAppearance(QWidget* parent)
    : QWidget(parent)
{
    m_ui.setupUi(this);

    m_ui.kcfg_HorizontalOffset->setSuffix(" " + i18np("pixel", "pixels", m_ui.kcfg_HorizontalOffset->value()));
    m_ui.kcfg_VerticalOffset->setSuffix(" " + i18np("pixel", "pixels", m_ui.kcfg_VerticalOffset->value()));
    m_ui.kcfg_PopupTimeout->setSuffix(" " + i18np("second", "seconds", m_ui.kcfg_PopupTimeout->value()));

    connect(m_ui.kcfg_HorizontalOffset, SIGNAL(valueChanged(int)), this, SLOT(slotValuesChanged()));
    connect(m_ui.kcfg_VerticalOffset, SIGNAL(valueChanged(int)), this, SLOT(slotValuesChanged()));
    connect(m_ui.kcfg_PopupTimeout, SIGNAL(valueChanged(int)), this, SLOT(slotValuesChanged()));
}

// ------------------------------------------------------------------------------------------------------------------- //

ConfigAppearance::~ConfigAppearance()
{
}

// ------------------------------------------------------------------------------------------------------------------- //

void ConfigAppearance::slotValuesChanged()
{
    m_ui.kcfg_HorizontalOffset->setSuffix(" " + i18np("pixel", "pixels", m_ui.kcfg_HorizontalOffset->value()));
    m_ui.kcfg_VerticalOffset->setSuffix(" " + i18np("pixel", "pixels", m_ui.kcfg_VerticalOffset->value()));
    m_ui.kcfg_PopupTimeout->setSuffix(" " + i18np("second", "seconds", m_ui.kcfg_PopupTimeout->value()));
}

// ------------------------------------------------------------------------------------------------------------------- //

#include "configappearance.moc"
