#***************************************************************************
# *   Copyright (C) 2003 by abdulhaq                                          *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                                             *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import plot

import logging
l = logging.getLogger(__name__)

class PlotImpl(QtGui.QDialog):
    def __init__(self,parent):
        QtGui.QDialog.__init__(self,parent)

        self.ui = plot.Ui_Dialog()
        self.ui.setupUi(self)

        self.connect(self.ui.pbOK,QtCore.SIGNAL("clicked()"),self,QtCore.SLOT("accept()"))
        self.connect(self.ui.pbCancel,QtCore.SIGNAL("clicked()"),self,QtCore.SLOT("reject()"))

        #self.ui.tblRange.setColumnCount(3)

        self.ui.tblRange.setColumnWidth(0,70)
        self.ui.tblRange.setColumnWidth(1,65)
        self.ui.tblRange.setColumnWidth(2,65)

    def usepm3d(self):
        if self.ui.cbPM3D.isChecked():
            return True
        else:
            return False

    def nomesh(self):
        if self.ui.cbNoMesh.isChecked():
            return True
        else:
            return False

    def surface(self):
        if self.ui.cbSurface.isChecked():
            return True
        else:
            return False

    def at(self):
        ret = ""
        if self.ui.cbAtB.isChecked():
            ret+="b"
        if self.ui.cbAtT.isChecked():
            ret+="t"
        if self.ui.cbAtS.isChecked():
            ret+="s"
        return ret

    def key(self):
        key = ""
       
        key += " bottom "
        return key

    def contour(self):
        if self.ui.cbContour.isChecked():
            return True
        else:
            return False

    def range(self):
        varRange = []
        num = self.ui.tblRange.rowCount()
        for i in range(num):
            varRange.append([str(self.ui.tblRange.item(i,0).text()),str(self.ui.tblRange.item(i,1).text()),str(self.ui.tblRange.item(i,2).text())])
        l.debug(repr(varRange))
        return varRange

    def showVars(self,vars):
        l.debug("vars are :" + repr(vars))
        self.ui.tblRange.setRowCount(len(vars))
        row = 0
        for var in vars:
            varItem = QtGui.QTableWidgetItem(var)
            varItem.setFlags(QtCore.Qt.ItemIsSelectable|QtCore.Qt.ItemIsEnabled)
            self.ui.tblRange.setItem(row,0,varItem)
            row += 1

    def clear(self):
        self.ui.tblRange.setRowCount(0)

    def getPlotOptions(self):
        range = self.range()
        usepm3d = self.usepm3d()
        nomesh = self.nomesh()
        contour = self.contour()
        surface = self.surface()
        at = self.at()
        key = self.key()
        return (range, usepm3d, nomesh, contour, surface, at, key)

    def getPlotCommand(self,equation, allVars, options, displayGnuPlot, sizeX=0, sizeY=0, fileName=''):
        # work out plot command
        range, usepm3d, nomesh, contour, surface, at, key = options
        #plotParameters = [range,usepm3d,nomesh]
        if len(allVars) > 1:
            plotCommand = "plot3d(" + equation
        else:
            plotCommand = "plot2d(" + equation
        for var in range:
            plotCommand += ",[" + var[0] + "," + var[1] + "," + var[2] + "]"
        if usepm3d == True:
            plotCommand += ",[gnuplot_pm3d,true],"

        preamble = "set mouse;" # I wanted mousing to work but ATM it doesn't. Perhaps I'll have to do the gnuplot interface myself
        if displayGnuPlot == False:
            #preamble += "set terminal png size " + str(sizeX) + "," + str(sizeY) + "; set output '" + fileName + "';"
            preamble += "set terminal postscript color ; set output '" + fileName + "';"
            #preamble += "set terminal pdf ; set output '" + fileName + "';"
        if surface == True:
            preamble += "set surface;"
        else:
            preamble += "unset surface;"
        if len(at) > 0:
            preamble += "set pm3d at " + at + ";"
        if len(key) > 0:
            preamble += "set key " + key + ";"
        if contour == True:
            preamble += "set contour"
        else:
            preamble += "unset contour"
        plotCommand += '[gnuplot_preamble,"' + preamble + '"]'
        plotCommand += ")"
        l.debug( repr(plotCommand))
        return plotCommand
