/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jexl.parser;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.Test;

import java.io.StringReader;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

/**
 * @since 1.0
 *
 */
public class ParserTest extends TestCase
{
    public static Test suite()
    {
        return new TestSuite(ParserTest.class);
    }

    public ParserTest(String testName)
    {
        super(testName);
    }

    /**
      *  parse test : see if we can parse a little script
      */
     public void testParse1()
         throws Exception
     {
         Parser parser = new Parser(new StringReader(";"));

         SimpleNode sn = parser.parse(new StringReader("foo = 1;"));

         JexlContext jc = JexlHelper.createContext();

         sn.interpret(jc);
     }

    public void testParse2()
        throws Exception
    {
        Parser parser = new Parser(new StringReader(";"));

        JexlContext jc = JexlHelper.createContext();

        SimpleNode sn = parser.parse(new StringReader("foo = \"bar\";"));
        sn.interpret(jc);
        sn = parser.parse(new StringReader("foo = 'bar';"));
        sn.interpret(jc);
    }

    public static void main(String[] args)
        throws Exception
    {
        ParserTest pt = new ParserTest("foo");

        pt.testParse1();
    }

}
