/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;

public class ArArchiveInputStream
extends ArchiveInputStream {
    private final InputStream input;
    private long offset = 0L;
    private boolean closed;
    private ArArchiveEntry currentEntry = null;
    private long entryOffset = -1L;

    public ArArchiveInputStream(InputStream pInput) {
        this.input = pInput;
        this.closed = false;
    }

    public ArArchiveEntry getNextArEntry() throws IOException {
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            while (this.offset < entryEnd) {
                int x = this.read();
                if (x != -1) continue;
                return null;
            }
            this.currentEntry = null;
        }
        if (this.offset == 0L) {
            byte[] expected = ArchiveUtils.toAsciiBytes("!<arch>\n");
            byte[] realized = new byte[expected.length];
            int read = this.read(realized);
            if (read != expected.length) {
                throw new IOException("failed to read header. Occured at byte: " + this.getCount());
            }
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == realized[i]) continue;
                throw new IOException("invalid header " + ArchiveUtils.toAsciiString(realized));
            }
        }
        if (this.offset % 2L != 0L && this.read() < 0) {
            return null;
        }
        if (this.input.available() == 0) {
            return null;
        }
        byte[] name = new byte[16];
        byte[] lastmodified = new byte[12];
        byte[] userid = new byte[6];
        byte[] groupid = new byte[6];
        byte[] filemode = new byte[8];
        byte[] length = new byte[10];
        this.read(name);
        this.read(lastmodified);
        this.read(userid);
        this.read(groupid);
        this.read(filemode);
        this.read(length);
        byte[] expected = ArchiveUtils.toAsciiBytes("`\n");
        byte[] realized = new byte[expected.length];
        int read = this.read(realized);
        if (read != expected.length) {
            throw new IOException("failed to read entry header. Occured at byte: " + this.getCount());
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == realized[i]) continue;
            throw new IOException("invalid entry header. not read the content? Occured at byte: " + this.getCount());
        }
        this.entryOffset = this.offset;
        String temp = ArchiveUtils.toAsciiString(name).trim();
        if (temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        this.currentEntry = new ArArchiveEntry(temp, Long.parseLong(new String(length).trim()));
        return this.currentEntry;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextArEntry();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
        this.currentEntry = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            if (len > 0 && entryEnd > this.offset) {
                toRead = (int)Math.min((long)len, entryEnd - this.offset);
            } else {
                return -1;
            }
        }
        int ret = this.input.read(b, off, toRead);
        this.count(ret);
        this.offset += (long)(ret > 0 ? ret : 0);
        return ret;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 8) {
            return false;
        }
        if (signature[0] != 33) {
            return false;
        }
        if (signature[1] != 60) {
            return false;
        }
        if (signature[2] != 97) {
            return false;
        }
        if (signature[3] != 114) {
            return false;
        }
        if (signature[4] != 99) {
            return false;
        }
        if (signature[5] != 104) {
            return false;
        }
        if (signature[6] != 62) {
            return false;
        }
        return signature[7] == 10;
    }
}

