/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum;

import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.algorithm.Adler32;
import jonelo.jacksum.algorithm.Adler32alt;
import jonelo.jacksum.algorithm.Cksum;
import jonelo.jacksum.algorithm.CombinedChecksum;
import jonelo.jacksum.algorithm.Crc16;
import jonelo.jacksum.algorithm.Crc32;
import jonelo.jacksum.algorithm.Crc32Mpeg2;
import jonelo.jacksum.algorithm.Crc64;
import jonelo.jacksum.algorithm.Crc8;
import jonelo.jacksum.algorithm.CrcGeneric;
import jonelo.jacksum.algorithm.Edonkey;
import jonelo.jacksum.algorithm.Elf;
import jonelo.jacksum.algorithm.FCS16;
import jonelo.jacksum.algorithm.FCS32;
import jonelo.jacksum.algorithm.MD;
import jonelo.jacksum.algorithm.MDTree;
import jonelo.jacksum.algorithm.MDbouncycastle;
import jonelo.jacksum.algorithm.MDgnu;
import jonelo.jacksum.algorithm.None;
import jonelo.jacksum.algorithm.Read;
import jonelo.jacksum.algorithm.Sum16;
import jonelo.jacksum.algorithm.Sum24;
import jonelo.jacksum.algorithm.Sum32;
import jonelo.jacksum.algorithm.Sum8;
import jonelo.jacksum.algorithm.SumBSD;
import jonelo.jacksum.algorithm.SumSysV;
import jonelo.jacksum.algorithm.Xor8;
import jonelo.jacksum.cli.Jacksum;
import jonelo.sugar.util.GeneralProgram;
import jonelo.sugar.util.GeneralString;
import jonelo.sugar.util.Version;

public class JacksumAPI {
    public static final String NAME = "Jacksum";
    public static final String VERSION = "1.7.0";

    public static final Version getVersion() {
        return new Version(VERSION);
    }

    public static final String getVersionString() {
        return VERSION;
    }

    public static final String getName() {
        return NAME;
    }

    public static void runCLI(String[] stringArray) {
        Jacksum.main(stringArray);
    }

    public static Map getAvailableEncodings() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("", "Default");
        treeMap.put("bin", "Binary");
        treeMap.put("dec", "Decimal");
        treeMap.put("oct", "Octal");
        treeMap.put("hex", "Hexadecimal (lowercase)");
        treeMap.put("hexup", "Hexadecimal (uppercase)");
        treeMap.put("base16", "Base 16");
        treeMap.put("base32", "Base 32");
        treeMap.put("base64", "Base 64");
        treeMap.put("bubblebabble", "BubbleBabble");
        return treeMap;
    }

    public static Map getAvailableAlgorithms() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("adler32", "Adler 32");
        treeMap.put("cksum", "cksum (Unix)");
        treeMap.put("crc8", "CRC-8 (FLAC)");
        treeMap.put("crc16", "CRC-16 (LHA/ARC)");
        treeMap.put("crc24", "CRC-24 (Open PGP)");
        treeMap.put("crc64", "CRC-64 (ISO 3309)");
        treeMap.put("crc32", "CRC-32 (FCS-32)");
        treeMap.put("crc32_mpeg2", "CRC-32 (MPEG-2)");
        treeMap.put("crc32_bzip2", "CRC-32 (BZIP2)");
        treeMap.put("ed2k", "ed2k");
        treeMap.put("elf", "Elf");
        treeMap.put("fcs16", "FCS-16");
        treeMap.put("gost", "GOST (R 34.11-94)");
        treeMap.put("has160", "HAS-160");
        treeMap.put("haval_128_3", "HAVAL 128 (3 rounds)");
        treeMap.put("haval_128_4", "HAVAL 128 (4 rounds)");
        treeMap.put("haval_128_5", "HAVAL 128 (5 rounds)");
        treeMap.put("haval_160_3", "HAVAL 160 (3 rounds)");
        treeMap.put("haval_160_4", "HAVAL 160 (4 rounds)");
        treeMap.put("haval_160_5", "HAVAL 160 (5 rounds)");
        treeMap.put("haval_192_3", "HAVAL 192 (3 rounds)");
        treeMap.put("haval_192_4", "HAVAL 192 (4 rounds)");
        treeMap.put("haval_192_5", "HAVAL 192 (5 rounds)");
        treeMap.put("haval_224_3", "HAVAL 224 (3 rounds)");
        treeMap.put("haval_224_4", "HAVAL 224 (4 rounds)");
        treeMap.put("haval_224_5", "HAVAL 224 (5 rounds)");
        treeMap.put("haval_256_3", "HAVAL 256 (3 rounds)");
        treeMap.put("haval_256_4", "HAVAL 256 (4 rounds)");
        treeMap.put("haval_256_5", "HAVAL 256 (5 rounds)");
        treeMap.put("md2", "MD2");
        treeMap.put("md4", "MD4");
        treeMap.put("md5", "MD5");
        treeMap.put("ripemd128", "RIPEMD-128");
        treeMap.put("ripemd160", "RIPEMD-160");
        treeMap.put("ripemd256", "RIPEMD-256");
        treeMap.put("ripemd320", "RIPEMD-320");
        treeMap.put("sha0", "SHA-0");
        treeMap.put("sha1", "SHA-1 (SHA-160)");
        treeMap.put("sha224", "SHA-2 (SHA-224)");
        treeMap.put("sha256", "SHA-2 (SHA-256)");
        treeMap.put("sha384", "SHA-2 (SHA-384)");
        treeMap.put("sha512", "SHA-2 (SHA-512)");
        treeMap.put("sumbsd", "sum (BSD Unix)");
        treeMap.put("sumsysv", "sum (System V Unix)");
        treeMap.put("sum8", "sum 8");
        treeMap.put("sum16", "sum 16");
        treeMap.put("sum24", "sum 24");
        treeMap.put("sum32", "sum 32");
        treeMap.put("tiger128", "Tiger/128");
        treeMap.put("tiger160", "Tiger/160");
        treeMap.put("tiger", "Tiger (Tiger/192)");
        treeMap.put("tiger2", "Tiger2");
        treeMap.put("tree:tiger", "Tiger Tree Hash");
        treeMap.put("tree:tiger2", "Tiger2 Tree Hash");
        treeMap.put("whirlpool0", "Whirlpool-0");
        treeMap.put("whirlpool1", "Whirlpool-1");
        treeMap.put("whirlpool2", "Whirlpool");
        treeMap.put("xor8", "XOR 8");
        return treeMap;
    }

    public static AbstractChecksum getChecksumInstance(String string) throws NoSuchAlgorithmException {
        return JacksumAPI.getChecksumInstance(string, false);
    }

    public static AbstractChecksum getChecksumInstance(String string, boolean bl) throws NoSuchAlgorithmException {
        AbstractChecksum abstractChecksum = null;
        if (string.indexOf("+") > -1) {
            String[] stringArray = GeneralString.split(string, "+");
            abstractChecksum = new CombinedChecksum(stringArray, bl);
        } else if (string.equals("sha1") || string.equals("sha") || string.equals("sha-1") || string.equals("sha160") || string.equals("sha-160")) {
            abstractChecksum = bl ? new MDgnu("sha-160") : new MD("SHA-1");
        } else if (string.equals("crc32") || string.equals("crc-32") || string.equals("fcs32") || string.equals("fcs-32")) {
            abstractChecksum = bl ? new FCS32() : new Crc32();
        } else if (string.equals("md5") || string.equals("md5sum")) {
            abstractChecksum = bl ? new MDgnu("md5") : new MD("MD5");
        } else if (string.equals("cksum")) {
            abstractChecksum = new Cksum();
        } else if (string.equals("sumbsd") || string.equals("bsd") || string.equals("bsdsum")) {
            abstractChecksum = new SumBSD();
        } else if (string.equals("sumsysv") || string.equals("sysv") || string.equals("sysvsum")) {
            abstractChecksum = new SumSysV();
        } else if (string.equals("adler32") || string.equals("adler-32")) {
            abstractChecksum = bl ? new Adler32alt() : new Adler32();
        } else if (string.equals("crc32_mpeg2") || string.equals("crc-32_mpeg-2")) {
            abstractChecksum = new Crc32Mpeg2();
        } else if (string.equals("sha256") || string.equals("sha-256")) {
            abstractChecksum = bl ? new MDgnu("sha-256") : (GeneralProgram.isSupportFor("1.4.2") ? new MD("SHA-256") : new MDgnu("sha-256"));
        } else if (string.equals("sha384") || string.equals("sha-384")) {
            abstractChecksum = bl ? new MDgnu("sha-384") : (GeneralProgram.isSupportFor("1.4.2") ? new MD("SHA-384") : new MDgnu("sha-384"));
        } else if (string.equals("sha512") || string.equals("sha-512")) {
            abstractChecksum = bl ? new MDgnu("sha-512") : (GeneralProgram.isSupportFor("1.4.2") ? new MD("SHA-512") : new MDgnu("sha-512"));
        } else if (string.equals("sha224") || string.equals("sha-224")) {
            abstractChecksum = new MDgnu("sha-224");
        } else if (string.equals("tiger") || string.equals("tiger192") || string.equals("tiger-192")) {
            abstractChecksum = new MDgnu("tiger");
        } else if (string.equals("tree:tiger")) {
            abstractChecksum = new MDTree("tiger");
        } else if (string.equals("tree:tiger2")) {
            abstractChecksum = new MDTree("tiger2");
        } else if (string.equals("tiger160") || string.equals("tiger-160")) {
            abstractChecksum = new MDgnu("tiger-160");
        } else if (string.equals("tiger128") || string.equals("tiger-128")) {
            abstractChecksum = new MDgnu("tiger-128");
        } else if (string.equals("tiger2")) {
            abstractChecksum = new MDgnu("tiger2");
        } else if (string.startsWith("haval")) {
            abstractChecksum = new MDgnu(string);
        } else if (string.equals("crc16") || string.equals("crc-16")) {
            abstractChecksum = new Crc16();
        } else if (string.equals("ripemd160") || string.equals("ripemd-160") || string.equals("ripe-md160") || string.equals("rmd160") || string.equals("rmd-160")) {
            abstractChecksum = new MDgnu("ripemd160");
        } else if (string.equals("ripemd128") || string.equals("ripemd-128") || string.equals("ripe-md128") || string.equals("rmd128") || string.equals("rmd-128")) {
            abstractChecksum = new MDgnu("ripemd128");
        } else if (string.equals("ripemd256") || string.equals("ripemd-256") || string.equals("ripe-md256") || string.equals("rmd256") || string.equals("rmd-256")) {
            abstractChecksum = new MDbouncycastle("ripemd256");
        } else if (string.equals("ripemd320") || string.equals("ripemd-320") || string.equals("ripe-md320") || string.equals("rmd320") || string.equals("rmd-320")) {
            abstractChecksum = new MDbouncycastle("ripemd320");
        } else if (string.equals("whirlpool0") || string.equals("whirlpool-0")) {
            abstractChecksum = new MDgnu("whirlpool_2000");
        } else if (string.equals("whirlpool1") || string.equals("whirlpool-1")) {
            abstractChecksum = new MDgnu("whirlpool");
        } else if (string.equals("whirlpool2") || string.equals("whirlpool-2") || string.equals("whirlpool")) {
            abstractChecksum = new MDgnu("whirlpool_2003");
        } else if (string.equals("crc64") || string.equals("crc-64")) {
            abstractChecksum = new Crc64();
        } else if (string.equals("ed2k") || string.equals("emule") || string.equals("edonkey")) {
            abstractChecksum = new Edonkey();
        } else if (string.equals("md4") || string.equals("md4sum")) {
            abstractChecksum = new MDgnu("md4");
        } else if (string.equals("md2") || string.equals("md2sum")) {
            abstractChecksum = new MDgnu("md2");
        } else if (string.equals("sha0") || string.equals("sha-0")) {
            abstractChecksum = new MDgnu("sha-0");
        } else if (string.equals("elf") || string.equals("elf32") || string.equals("elf-32")) {
            abstractChecksum = new Elf();
        } else if (string.equals("fcs16") || string.equals("fcs-16") || string.equals("crc16_x25") || string.equals("crc-16_x-25")) {
            abstractChecksum = new FCS16();
        } else if (string.equals("crc8") || string.equals("crc-8")) {
            abstractChecksum = new Crc8();
        } else if (string.equals("crc24") || string.equals("crc-24")) {
            abstractChecksum = new CrcGeneric(24, 8801531L, 11994318L, false, false, 0L);
        } else if (string.equals("sum8") || string.equals("sum-8")) {
            abstractChecksum = new Sum8();
        } else if (string.equals("sum16") || string.equals("sum-16")) {
            abstractChecksum = new Sum16();
        } else if (string.equals("sum24") || string.equals("sum-24")) {
            abstractChecksum = new Sum24();
        } else if (string.equals("sum32") || string.equals("sum-32")) {
            abstractChecksum = new Sum32();
        } else if (string.equals("xor8") || string.equals("xor-8")) {
            abstractChecksum = new Xor8();
        } else if (string.equals("gost")) {
            abstractChecksum = new MDbouncycastle("gost");
        } else if (string.equals("crc32_bzip2") || string.equals("crc-32_bzip-2")) {
            abstractChecksum = new CrcGeneric(32, 79764919L, 0xFFFFFFFFL, false, false, 0xFFFFFFFFL);
        } else if (string.equals("has160") || string.equals("has-160")) {
            abstractChecksum = new MDgnu("has-160");
        } else if (string.equals("none")) {
            abstractChecksum = new None();
        } else if (string.equals("read")) {
            abstractChecksum = new Read();
        } else if (string.startsWith("crc:")) {
            abstractChecksum = new CrcGeneric(string.substring(4));
        } else if (string.equals("all")) {
            Map map = JacksumAPI.getAvailableAlgorithms();
            Iterator iterator = map.entrySet().iterator();
            String[] stringArray = new String[map.entrySet().size()];
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                stringBuffer.append(string2);
                stringBuffer.append("+");
                stringArray[n++] = string2;
            }
            abstractChecksum = new CombinedChecksum(stringArray, bl);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            string = stringBuffer.toString();
        } else {
            throw new NoSuchAlgorithmException(string + " is an unknown algorithm.");
        }
        abstractChecksum.setName(string);
        return abstractChecksum;
    }
}

