/* freedesktop-interfaces.c generated by valac 0.17.6, the Vala compiler
 * generated from freedesktop-interfaces.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_FREE_DESKTOP_OBJECT (free_desktop_object_get_type ())
#define FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObject))
#define IS_FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_OBJECT))
#define FREE_DESKTOP_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObjectIface))

typedef struct _FreeDesktopObject FreeDesktopObject;
typedef struct _FreeDesktopObjectIface FreeDesktopObjectIface;

#define TYPE_FREE_DESKTOP_OBJECT_PROXY (free_desktop_object_proxy_get_type ())
typedef GDBusProxy FreeDesktopObjectProxy;
typedef GDBusProxyClass FreeDesktopObjectProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FREE_DESKTOP_INTROSPECTABLE (free_desktop_introspectable_get_type ())
#define FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectable))
#define IS_FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE))
#define FREE_DESKTOP_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectableIface))

typedef struct _FreeDesktopIntrospectable FreeDesktopIntrospectable;
typedef struct _FreeDesktopIntrospectableIface FreeDesktopIntrospectableIface;

#define TYPE_FREE_DESKTOP_INTROSPECTABLE_PROXY (free_desktop_introspectable_proxy_get_type ())
typedef GDBusProxy FreeDesktopIntrospectableProxy;
typedef GDBusProxyClass FreeDesktopIntrospectableProxyClass;

#define TYPE_FREE_DESKTOP_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopProperties))
#define IS_FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;

#define TYPE_FREE_DESKTOP_PROPERTIES_PROXY (free_desktop_properties_proxy_get_type ())
typedef GDBusProxy FreeDesktopPropertiesProxy;
typedef GDBusProxyClass FreeDesktopPropertiesProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _FreeDesktopObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _FreeDesktopIntrospectableIface {
	GTypeInterface parent_iface;
	gchar* (*Introspect) (FreeDesktopIntrospectable* self, GError** error);
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	XML_ERROR_FILE_NOT_FOUND,
	XML_ERROR_XML_DOCUMENT_EMPTY
} XmlError;
#define XML_ERROR xml_error_quark ()


GType free_desktop_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_object_get_type (void) G_GNUC_CONST;
void free_desktop_object_list_names (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** free_desktop_object_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void free_desktop_object_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_free_desktop_object_name_owner_changed (FreeDesktopObject* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void free_desktop_object_proxy_list_names_async (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** free_desktop_object_proxy_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_object_proxy_free_desktop_object_interface_init (FreeDesktopObjectIface* iface);
static void _dbus_free_desktop_object_list_names (FreeDesktopObject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_free_desktop_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void free_desktop_object_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* free_desktop_object_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean free_desktop_object_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_free_desktop_object_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data);
static void _free_desktop_object_unregister_object (gpointer user_data);
GType free_desktop_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_introspectable_get_type (void) G_GNUC_CONST;
gchar* free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GError** error);
static void free_desktop_introspectable_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* free_desktop_introspectable_proxy_Introspect (FreeDesktopIntrospectable* self, GError** error);
static void free_desktop_introspectable_proxy_free_desktop_introspectable_interface_init (FreeDesktopIntrospectableIface* iface);
static void _dbus_free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void free_desktop_introspectable_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* free_desktop_introspectable_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean free_desktop_introspectable_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _free_desktop_introspectable_unregister_object (gpointer user_data);
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
GType free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void free_desktop_properties_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, GVariant* parameters);
static void free_desktop_properties_proxy_free_desktop_properties_interface_init (FreeDesktopPropertiesIface* iface);
static void free_desktop_properties_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* free_desktop_properties_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean free_desktop_properties_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer* _data);
static void _free_desktop_properties_unregister_object (gpointer user_data);
GQuark xml_error_quark (void);
#define FREEDESKTOP_SERVICE "org.freedesktop.DBus"
#define FREEDESKTOP_OBJECT "/org/freedesktop/DBus"
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _free_desktop_object_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _free_desktop_object_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _free_desktop_object_dbus_arg_info_list_names_out[] = {&_free_desktop_object_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _free_desktop_object_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_free_desktop_object_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_free_desktop_object_dbus_arg_info_list_names_out)};
static const GDBusMethodInfo * const _free_desktop_object_dbus_method_info[] = {&_free_desktop_object_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _free_desktop_object_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _free_desktop_object_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s"};
static const GDBusArgInfo _free_desktop_object_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s"};
static const GDBusArgInfo * const _free_desktop_object_dbus_arg_info_name_owner_changed[] = {&_free_desktop_object_dbus_arg_info_name_owner_changed_name, &_free_desktop_object_dbus_arg_info_name_owner_changed_old_owner, &_free_desktop_object_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _free_desktop_object_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_free_desktop_object_dbus_arg_info_name_owner_changed)};
static const GDBusSignalInfo * const _free_desktop_object_dbus_signal_info[] = {&_free_desktop_object_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _free_desktop_object_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _free_desktop_object_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_free_desktop_object_dbus_method_info), (GDBusSignalInfo **) (&_free_desktop_object_dbus_signal_info), (GDBusPropertyInfo **) (&_free_desktop_object_dbus_property_info)};
static const GDBusInterfaceVTable _free_desktop_object_dbus_interface_vtable = {free_desktop_object_dbus_interface_method_call, free_desktop_object_dbus_interface_get_property, free_desktop_object_dbus_interface_set_property};
static const GDBusArgInfo _free_desktop_introspectable_dbus_arg_info_Introspect_result = {-1, "result", "s"};
static const GDBusArgInfo * const _free_desktop_introspectable_dbus_arg_info_Introspect_in[] = {NULL};
static const GDBusArgInfo * const _free_desktop_introspectable_dbus_arg_info_Introspect_out[] = {&_free_desktop_introspectable_dbus_arg_info_Introspect_result, NULL};
static const GDBusMethodInfo _free_desktop_introspectable_dbus_method_info_Introspect = {-1, "Introspect", (GDBusArgInfo **) (&_free_desktop_introspectable_dbus_arg_info_Introspect_in), (GDBusArgInfo **) (&_free_desktop_introspectable_dbus_arg_info_Introspect_out)};
static const GDBusMethodInfo * const _free_desktop_introspectable_dbus_method_info[] = {&_free_desktop_introspectable_dbus_method_info_Introspect, NULL};
static const GDBusSignalInfo * const _free_desktop_introspectable_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _free_desktop_introspectable_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _free_desktop_introspectable_dbus_interface_info = {-1, "org.freedesktop.DBus.Introspectable", (GDBusMethodInfo **) (&_free_desktop_introspectable_dbus_method_info), (GDBusSignalInfo **) (&_free_desktop_introspectable_dbus_signal_info), (GDBusPropertyInfo **) (&_free_desktop_introspectable_dbus_property_info)};
static const GDBusInterfaceVTable _free_desktop_introspectable_dbus_interface_vtable = {free_desktop_introspectable_dbus_interface_method_call, free_desktop_introspectable_dbus_interface_get_property, free_desktop_introspectable_dbus_interface_set_property};
static const GDBusMethodInfo * const _free_desktop_properties_dbus_method_info[] = {NULL};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_source = {-1, "source", "s"};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_changed_properties = {-1, "changed_properties", "a{sv}"};
static const GDBusArgInfo _free_desktop_properties_dbus_arg_info_properties_changed_invalid = {-1, "invalid", "as"};
static const GDBusArgInfo * const _free_desktop_properties_dbus_arg_info_properties_changed[] = {&_free_desktop_properties_dbus_arg_info_properties_changed_source, &_free_desktop_properties_dbus_arg_info_properties_changed_changed_properties, &_free_desktop_properties_dbus_arg_info_properties_changed_invalid, NULL};
static const GDBusSignalInfo _free_desktop_properties_dbus_signal_info_properties_changed = {-1, "PropertiesChanged", (GDBusArgInfo **) (&_free_desktop_properties_dbus_arg_info_properties_changed)};
static const GDBusSignalInfo * const _free_desktop_properties_dbus_signal_info[] = {&_free_desktop_properties_dbus_signal_info_properties_changed, NULL};
static const GDBusPropertyInfo * const _free_desktop_properties_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _free_desktop_properties_dbus_interface_info = {-1, "org.freedesktop.DBus.Properties", (GDBusMethodInfo **) (&_free_desktop_properties_dbus_method_info), (GDBusSignalInfo **) (&_free_desktop_properties_dbus_signal_info), (GDBusPropertyInfo **) (&_free_desktop_properties_dbus_property_info)};
static const GDBusInterfaceVTable _free_desktop_properties_dbus_interface_vtable = {free_desktop_properties_dbus_interface_method_call, free_desktop_properties_dbus_interface_get_property, free_desktop_properties_dbus_interface_set_property};

void free_desktop_object_list_names (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FREE_DESKTOP_OBJECT_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar** free_desktop_object_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return FREE_DESKTOP_OBJECT_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void free_desktop_object_base_init (FreeDesktopObjectIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", TYPE_FREE_DESKTOP_OBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType free_desktop_object_get_type (void) {
	static volatile gsize free_desktop_object_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopObjectIface), (GBaseInitFunc) free_desktop_object_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_object_type_id;
		free_desktop_object_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopObject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_object_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (free_desktop_object_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) free_desktop_object_proxy_get_type);
		g_type_set_qdata (free_desktop_object_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (free_desktop_object_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) free_desktop_object_register_object);
		g_once_init_leave (&free_desktop_object_type_id__volatile, free_desktop_object_type_id);
	}
	return free_desktop_object_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopObjectProxy, free_desktop_object_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_FREE_DESKTOP_OBJECT, free_desktop_object_proxy_free_desktop_object_interface_init) )
static void free_desktop_object_proxy_class_init (FreeDesktopObjectProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = free_desktop_object_proxy_g_signal;
}


static void _dbus_handle_free_desktop_object_name_owner_changed (FreeDesktopObject* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp77_;
	gchar* old_owner = NULL;
	GVariant* _tmp78_;
	gchar* new_owner = NULL;
	GVariant* _tmp79_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp77_, NULL);
	g_variant_unref (_tmp77_);
	_tmp78_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp78_, NULL);
	g_variant_unref (_tmp78_);
	_tmp79_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp79_, NULL);
	g_variant_unref (_tmp79_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


static void free_desktop_object_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_free_desktop_object_name_owner_changed ((FreeDesktopObject*) proxy, parameters);
	}
}


static void free_desktop_object_proxy_init (FreeDesktopObjectProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void free_desktop_object_proxy_list_names_async (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** free_desktop_object_proxy_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp80_;
	gchar** _tmp81_;
	int _tmp81__length;
	int _tmp81__size;
	int _tmp81__length1;
	GVariantIter _tmp82_;
	GVariant* _tmp83_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp80_ = g_variant_iter_next_value (&_reply_iter);
	_tmp81_ = g_new (gchar*, 5);
	_tmp81__length = 0;
	_tmp81__size = 4;
	_tmp81__length1 = 0;
	g_variant_iter_init (&_tmp82_, _tmp80_);
	for (; (_tmp83_ = g_variant_iter_next_value (&_tmp82_)) != NULL; _tmp81__length1++) {
		if (_tmp81__size == _tmp81__length) {
			_tmp81__size = 2 * _tmp81__size;
			_tmp81_ = g_renew (gchar*, _tmp81_, _tmp81__size + 1);
		}
		_tmp81_[_tmp81__length++] = g_variant_dup_string (_tmp83_, NULL);
		g_variant_unref (_tmp83_);
	}
	_result_length1 = _tmp81__length1;
	_tmp81_[_tmp81__length] = NULL;
	_result = _tmp81_;
	g_variant_unref (_tmp80_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void free_desktop_object_proxy_free_desktop_object_interface_init (FreeDesktopObjectIface* iface) {
	iface->list_names = free_desktop_object_proxy_list_names_async;
	iface->list_names_finish = free_desktop_object_proxy_list_names_finish;
}


static void _dbus_free_desktop_object_list_names (FreeDesktopObject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	free_desktop_object_list_names (self, (GAsyncReadyCallback) _dbus_free_desktop_object_list_names_ready, invocation);
}


static void _dbus_free_desktop_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp84_;
	GVariantBuilder _tmp85_;
	int _tmp86_;
	invocation = _user_data_;
	result = free_desktop_object_list_names_finish ((FreeDesktopObject*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp84_ = result;
	g_variant_builder_init (&_tmp85_, G_VARIANT_TYPE ("as"));
	for (_tmp86_ = 0; _tmp86_ < result_length1; _tmp86_++) {
		g_variant_builder_add_value (&_tmp85_, g_variant_new_string (*_tmp84_));
		_tmp84_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp85_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void free_desktop_object_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_free_desktop_object_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* free_desktop_object_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean free_desktop_object_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_free_desktop_object_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint free_desktop_object_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_free_desktop_object_dbus_interface_info), &_free_desktop_object_dbus_interface_vtable, data, _free_desktop_object_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_free_desktop_object_name_owner_changed, data);
	return result;
}


static void _free_desktop_object_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_free_desktop_object_name_owner_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gchar* free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return FREE_DESKTOP_INTROSPECTABLE_GET_INTERFACE (self)->Introspect (self, error);
}


static void free_desktop_introspectable_base_init (FreeDesktopIntrospectableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType free_desktop_introspectable_get_type (void) {
	static volatile gsize free_desktop_introspectable_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_introspectable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopIntrospectableIface), (GBaseInitFunc) free_desktop_introspectable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_introspectable_type_id;
		free_desktop_introspectable_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopIntrospectable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_introspectable_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (free_desktop_introspectable_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) free_desktop_introspectable_proxy_get_type);
		g_type_set_qdata (free_desktop_introspectable_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Introspectable");
		g_type_set_qdata (free_desktop_introspectable_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) free_desktop_introspectable_register_object);
		g_once_init_leave (&free_desktop_introspectable_type_id__volatile, free_desktop_introspectable_type_id);
	}
	return free_desktop_introspectable_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopIntrospectableProxy, free_desktop_introspectable_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_FREE_DESKTOP_INTROSPECTABLE, free_desktop_introspectable_proxy_free_desktop_introspectable_interface_init) )
static void free_desktop_introspectable_proxy_class_init (FreeDesktopIntrospectableProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = free_desktop_introspectable_proxy_g_signal;
}


static void free_desktop_introspectable_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void free_desktop_introspectable_proxy_init (FreeDesktopIntrospectableProxy* self) {
}


static gchar* free_desktop_introspectable_proxy_Introspect (FreeDesktopIntrospectable* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp87_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus.Introspectable", "Introspect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp87_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp87_, NULL);
	g_variant_unref (_tmp87_);
	g_object_unref (_reply_message);
	return _result;
}


static void free_desktop_introspectable_proxy_free_desktop_introspectable_interface_init (FreeDesktopIntrospectableIface* iface) {
	iface->Introspect = free_desktop_introspectable_proxy_Introspect;
}


static void _dbus_free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = free_desktop_introspectable_Introspect (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void free_desktop_introspectable_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Introspect") == 0) {
		_dbus_free_desktop_introspectable_Introspect (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* free_desktop_introspectable_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean free_desktop_introspectable_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint free_desktop_introspectable_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_free_desktop_introspectable_dbus_interface_info), &_free_desktop_introspectable_dbus_interface_vtable, data, _free_desktop_introspectable_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _free_desktop_introspectable_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void free_desktop_properties_base_init (FreeDesktopPropertiesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("properties_changed", TYPE_FREE_DESKTOP_PROPERTIES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_HASH_TABLE, G_TYPE_STRV, G_TYPE_INT);
	}
}


GType free_desktop_properties_get_type (void) {
	static volatile gsize free_desktop_properties_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopPropertiesIface), (GBaseInitFunc) free_desktop_properties_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_properties_type_id;
		free_desktop_properties_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopProperties", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_properties_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (free_desktop_properties_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) free_desktop_properties_proxy_get_type);
		g_type_set_qdata (free_desktop_properties_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Properties");
		g_type_set_qdata (free_desktop_properties_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) free_desktop_properties_register_object);
		g_once_init_leave (&free_desktop_properties_type_id__volatile, free_desktop_properties_type_id);
	}
	return free_desktop_properties_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopPropertiesProxy, free_desktop_properties_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_FREE_DESKTOP_PROPERTIES, free_desktop_properties_proxy_free_desktop_properties_interface_init) )
static void free_desktop_properties_proxy_class_init (FreeDesktopPropertiesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = free_desktop_properties_proxy_g_signal;
}


static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* source = NULL;
	GVariant* _tmp88_;
	GHashTable* changed_properties = NULL;
	GVariant* _tmp89_;
	GHashTable* _tmp90_;
	GVariantIter _tmp91_;
	GVariant* _tmp92_;
	GVariant* _tmp93_;
	gchar** invalid = NULL;
	int invalid_length1;
	GVariant* _tmp94_;
	gchar** _tmp95_;
	int _tmp95__length;
	int _tmp95__size;
	int _tmp95__length1;
	GVariantIter _tmp96_;
	GVariant* _tmp97_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp88_ = g_variant_iter_next_value (&_arguments_iter);
	source = g_variant_dup_string (_tmp88_, NULL);
	g_variant_unref (_tmp88_);
	_tmp89_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp90_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp91_, _tmp89_);
	while (g_variant_iter_loop (&_tmp91_, "{?*}", &_tmp92_, &_tmp93_)) {
		g_hash_table_insert (_tmp90_, g_variant_dup_string (_tmp92_, NULL), g_variant_get_variant (_tmp93_));
	}
	changed_properties = _tmp90_;
	g_variant_unref (_tmp89_);
	invalid_length1 = 0;
	_tmp94_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp95_ = g_new (gchar*, 5);
	_tmp95__length = 0;
	_tmp95__size = 4;
	_tmp95__length1 = 0;
	g_variant_iter_init (&_tmp96_, _tmp94_);
	for (; (_tmp97_ = g_variant_iter_next_value (&_tmp96_)) != NULL; _tmp95__length1++) {
		if (_tmp95__size == _tmp95__length) {
			_tmp95__size = 2 * _tmp95__size;
			_tmp95_ = g_renew (gchar*, _tmp95_, _tmp95__size + 1);
		}
		_tmp95_[_tmp95__length++] = g_variant_dup_string (_tmp97_, NULL);
		g_variant_unref (_tmp97_);
	}
	invalid_length1 = _tmp95__length1;
	_tmp95_[_tmp95__length] = NULL;
	invalid = _tmp95_;
	g_variant_unref (_tmp94_);
	g_signal_emit_by_name (self, "properties-changed", source, changed_properties, invalid, invalid_length1);
	_g_free0 (source);
	_g_hash_table_unref0 (changed_properties);
	invalid = (_vala_array_free (invalid, invalid_length1, (GDestroyNotify) g_free), NULL);
}


static void free_desktop_properties_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "PropertiesChanged") == 0) {
		_dbus_handle_free_desktop_properties_properties_changed ((FreeDesktopProperties*) proxy, parameters);
	}
}


static void free_desktop_properties_proxy_init (FreeDesktopPropertiesProxy* self) {
}


static void free_desktop_properties_proxy_free_desktop_properties_interface_init (FreeDesktopPropertiesIface* iface) {
}


static void free_desktop_properties_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* free_desktop_properties_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean free_desktop_properties_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp98_;
	GHashTableIter _tmp99_;
	gpointer _tmp100_;
	gpointer _tmp101_;
	gchar** _tmp102_;
	GVariantBuilder _tmp103_;
	int _tmp104_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (source));
	g_hash_table_iter_init (&_tmp99_, changed_properties);
	g_variant_builder_init (&_tmp98_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp99_, &_tmp100_, &_tmp101_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp100_;
		_value = (GVariant*) _tmp101_;
		g_variant_builder_add (&_tmp98_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp98_));
	_tmp102_ = invalid;
	g_variant_builder_init (&_tmp103_, G_VARIANT_TYPE ("as"));
	for (_tmp104_ = 0; _tmp104_ < invalid_length1; _tmp104_++) {
		g_variant_builder_add_value (&_tmp103_, g_variant_new_string (*_tmp102_));
		_tmp102_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp103_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus.Properties", "PropertiesChanged", _arguments, NULL);
}


guint free_desktop_properties_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_free_desktop_properties_dbus_interface_info), &_free_desktop_properties_dbus_interface_vtable, data, _free_desktop_properties_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_free_desktop_properties_properties_changed, data);
	return result;
}


static void _free_desktop_properties_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_free_desktop_properties_properties_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


GQuark xml_error_quark (void) {
	return g_quark_from_static_string ("xml_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



