/*
 * File:          bHYPRE_CGNR_Module.c
 * Symbol:        bHYPRE.CGNR-v1.0.0
 * Symbol Type:   class
 * Babel Version: 1.0.4
 * Description:   implement a C extension type for a sidl extendable
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 */

/*
 * THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL
 * COMPILER. DO NOT EDIT THIS!
 * 
 * This file contains the implementation of a Python C
 * extension type (i.e. a Python type implemented in C).
 * This extension type provides Python interface to the
 * sidl type bHYPRE.CGNR.
 */


/**
 * Symbol "bHYPRE.CGNR" (version 1.0.0)
 * 
 * CGNR solver.
 * This calls Babel-interface matrix and vector functions, so it will work
 * with any consistent matrix, vector, and preconditioner classes.
 */
#include <Python.h>
#include <stdlib.h>
#include <string.h>
#ifndef included_sidl_BaseClass_h
#include "sidl_BaseClass.h"
#endif
#ifndef included_sidl_ClassInfo_h
#include "sidl_ClassInfo.h"
#endif
#ifndef included_sidl_rmi_ProtocolFactory_h
#include "sidl_rmi_ProtocolFactory.h"
#endif
#ifndef included_sidl_rmi_InstanceRegistry_h
#include "sidl_rmi_InstanceRegistry.h"
#endif
#ifndef included_sidl_rmi_InstanceHandle_h
#include "sidl_rmi_InstanceHandle.h"
#endif
#ifndef included_sidl_rmi_Invocation_h
#include "sidl_rmi_Invocation.h"
#endif
#ifndef included_sidl_rmi_Response_h
#include "sidl_rmi_Response.h"
#endif
#ifndef included_sidl_rmi_ServerRegistry_h
#include "sidl_rmi_ServerRegistry.h"
#endif
#ifndef included_sidl_rmi_ConnectRegistry_h
#include "sidl_rmi_ConnectRegistry.h"
#endif
#ifndef included_sidl_io_Serializable_h
#include "sidl_io_Serializable.h"
#endif
#include "sidl_Exception.h"

#ifndef NULL
#define NULL 0
#endif

#include "sidl_thread.h"
#ifdef HAVE_PTHREAD
static struct sidl_recursive_mutex_t bHYPRE_CGNR__mutex= SIDL_RECURSIVE_MUTEX_INITIALIZER;
#define LOCK_STATIC_GLOBALS sidl_recursive_mutex_lock( &bHYPRE_CGNR__mutex )
#define UNLOCK_STATIC_GLOBALS sidl_recursive_mutex_unlock( &bHYPRE_CGNR__mutex )
/* #define HAVE_LOCKED_STATIC_GLOBALS (sidl_recursive_mutex_trylock( &bHYPRE_CGNR__mutex )==EDEADLOCK) */
#else
#define LOCK_STATIC_GLOBALS
#define UNLOCK_STATIC_GLOBALS
/* #define HAVE_LOCKED_STATIC_GLOBALS (1) */
#endif

#define bHYPRE_CGNR_INTERNAL 1
#include "bHYPRE_CGNR_Module.h"
#ifndef included_bHYPRE_CGNR_IOR_h
#include "bHYPRE_CGNR_IOR.h"
#endif
#include "sidlObjA.h"
#include "sidlPyArrays.h"
#include "Numeric/arrayobject.h"
#ifndef included_sidl_Loader_h
#include "sidl_Loader.h"
#endif
#ifndef included_sidl_header_h
#include "sidl_header.h"
#endif
#ifndef included_sidl_interface_IOR_h
#include "sidl_interface_IOR.h"
#endif
#include "sidl_rmi_NetworkException_Module.h"
#include "bHYPRE_MPICommunicator_Module.h"
#include "bHYPRE_Operator_Module.h"
#include "bHYPRE_PreconditionedSolver_Module.h"
#include "bHYPRE_Solver_Module.h"
#include "bHYPRE_Vector_Module.h"
#include "sidl_BaseClass_Module.h"
#include "sidl_BaseInterface_Module.h"
#include "sidl_ClassInfo_Module.h"
#include "sidl_RuntimeException_Module.h"
#include "sidl_rmi_Call_Module.h"
#include "sidl_rmi_Return_Module.h"
#include "sidl_rmi_Ticket_Module.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
 * connect_loaded is a boolean value showing if the IHConnect for this object has been loaded into the connectRegistry
 */

static int connect_loaded = 0;

/*
 * lang_inited is a boolean value showing if we have already imported all the nescessary modules
 */

static int lang_inited = 0;

#define LANG_SPECIFIC_INIT() if(!lang_inited) { \
  lang_inited = 1; \
  bHYPRE_CGNR__import(); \
  bHYPRE_MPICommunicator__import(); \
  bHYPRE_Operator__import(); \
  bHYPRE_PreconditionedSolver__import(); \
  bHYPRE_Solver__import(); \
  bHYPRE_Vector__import(); \
  sidl_BaseClass__import(); \
  sidl_BaseInterface__import(); \
  sidl_ClassInfo__import(); \
  sidl_RuntimeException__import(); \
  sidl_rmi_Ticket__import(); \
}
/**
 * Cast method for interface and class type conversions.
 */
struct bHYPRE_CGNR__object*
bHYPRE_CGNR__rmicast(
  void* obj, struct sidl_BaseInterface__object **_ex);

/**
 * RMI connector function for the class. (no addref)
 */
struct bHYPRE_CGNR__object*
bHYPRE_CGNR__connectI(const char * url, sidl_bool ar, struct                  \
  sidl_BaseInterface__object **_ex);

/* Static variables to hold version of IOR */
static const int32_t s_IOR_MAJOR_VERSION = 1;
static const int32_t s_IOR_MINOR_VERSION = 0;

/* Static variables for managing EPV initialization. */
static int s_remote_initialized = 0;

static struct bHYPRE_CGNR__epv s_rem_epv__bhypre_cgnr;

static struct bHYPRE_Operator__epv s_rem_epv__bhypre_operator;

static struct bHYPRE_PreconditionedSolver__epv                                \
  s_rem_epv__bhypre_preconditionedsolver;

static struct bHYPRE_Solver__epv s_rem_epv__bhypre_solver;

static struct sidl_BaseClass__epv  s_rem_epv__sidl_baseclass;

static struct sidl_BaseInterface__epv  s_rem_epv__sidl_baseinterface;


/* REMOTE CAST: dynamic type casting for remote objects. */
static void* remote_bHYPRE_CGNR__cast(
  struct bHYPRE_CGNR__object* self,
  const char* name, sidl_BaseInterface* _ex)
{
  int
    cmp0,
    cmp1,
    cmp2;
  void* cast = NULL;
  *_ex = NULL; /* default to no exception */
  cmp0 = strcmp(name, "bHYPRE.Solver");
  if (!cmp0) {
    (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
    cast = &((*self).d_bhypre_solver);
    return cast;
  }
  else if (cmp0 < 0) {
    cmp1 = strcmp(name, "bHYPRE.Operator");
    if (!cmp1) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = &((*self).d_bhypre_operator);
      return cast;
    }
    else if (cmp1 < 0) {
      cmp2 = strcmp(name, "bHYPRE.CGNR");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = ((struct bHYPRE_CGNR__object*)self);
        return cast;
      }
    }
    else if (cmp1 > 0) {
      cmp2 = strcmp(name, "bHYPRE.PreconditionedSolver");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = &((*self).d_bhypre_preconditionedsolver);
        return cast;
      }
    }
  }
  else if (cmp0 > 0) {
    cmp1 = strcmp(name, "sidl.BaseInterface");
    if (!cmp1) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = &((*self).d_sidl_baseclass.d_sidl_baseinterface);
      return cast;
    }
    else if (cmp1 < 0) {
      cmp2 = strcmp(name, "sidl.BaseClass");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = ((struct sidl_BaseClass__object*)self);
        return cast;
      }
    }
  }
  if ((*self->d_epv->f_isType)(self,name, _ex)) {
    void* (*func)(struct sidl_rmi_InstanceHandle__object*, struct             \
      sidl_BaseInterface__object**) = 
      (void* (*)(struct sidl_rmi_InstanceHandle__object*, struct              \
        sidl_BaseInterface__object**)) 
      sidl_rmi_ConnectRegistry_getConnect(name, _ex);SIDL_CHECK(*_ex);
    cast =  (*func)(((struct bHYPRE_CGNR__remote*)self->d_data)->d_ih, _ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/* REMOTE DELETE: call the remote destructor for the object. */
static void remote_bHYPRE_CGNR__delete(
  struct bHYPRE_CGNR__object* self,
  sidl_BaseInterface* _ex)
{
  *_ex = NULL;
  free((void*) self);
}

/* REMOTE GETURL: call the getURL function for the object. */
static char* remote_bHYPRE_CGNR__getURL(
  struct bHYPRE_CGNR__object* self, sidl_BaseInterface* _ex)
{
  struct sidl_rmi_InstanceHandle__object *conn = ((struct                     \
    bHYPRE_CGNR__remote*)self->d_data)->d_ih;
  *_ex = NULL;
  if(conn != NULL) {
    return sidl_rmi_InstanceHandle_getObjectURL(conn, _ex);
  }
  return NULL;
}

/* REMOTE ADDREF: For internal babel use only! Remote addRef. */
static void remote_bHYPRE_CGNR__raddRef(
  struct bHYPRE_CGNR__object* self,sidl_BaseInterface* _ex)
{
  sidl_BaseException netex = NULL;
  /* initialize a new invocation */
  sidl_BaseInterface _throwaway = NULL;
  struct sidl_rmi_InstanceHandle__object *_conn = ((struct                    \
    bHYPRE_CGNR__remote*)self->d_data)->d_ih;
  sidl_rmi_Response _rsvp = NULL;
  sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation( _conn, \
    "addRef", _ex ); SIDL_CHECK(*_ex);
  /* send actual RMI request */
  _rsvp = sidl_rmi_Invocation_invokeMethod(_inv,_ex);SIDL_CHECK(*_ex);
  /* Check for exceptions */
  netex = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);
  if(netex != NULL) {
    sidl_BaseInterface throwaway_exception = NULL;
    *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(netex,            \
      &throwaway_exception);
    return;
  }

  /* cleanup and return */
  EXIT:
  if(_inv) { sidl_rmi_Invocation_deleteRef(_inv,&_throwaway); }
  if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp,&_throwaway); }
  return;
}

/* REMOTE ISREMOTE: returns true if this object is Remote (it is). */
static sidl_bool
remote_bHYPRE_CGNR__isRemote(
    struct bHYPRE_CGNR__object* self, 
    sidl_BaseInterface *_ex) {
  *_ex = NULL;
  return TRUE;
}

/* REMOTE METHOD STUB:_set_hooks */
static void
remote_bHYPRE_CGNR__set_hooks(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ sidl_bool on,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_hooks", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "on", on, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR._set_hooks.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EXEC: call the exec function for the object. */
static void remote_bHYPRE_CGNR__exec(
  struct bHYPRE_CGNR__object* self,const char* methodName,
  sidl_rmi_Call inArgs,
  sidl_rmi_Return outArgs,
  sidl_BaseInterface* _ex)
{
  *_ex = NULL;
}

/* REMOTE METHOD STUB:addRef */
static void
remote_bHYPRE_CGNR_addRef(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct bHYPRE_CGNR__remote* r_obj = (struct                               \
      bHYPRE_CGNR__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount++;
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:deleteRef */
static void
remote_bHYPRE_CGNR_deleteRef(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct bHYPRE_CGNR__remote* r_obj = (struct                               \
      bHYPRE_CGNR__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount--;
    if(r_obj->d_refcount == 0) {
      sidl_rmi_InstanceHandle_deleteRef(r_obj->d_ih, _ex);
      free(r_obj);
      free(self);
    }
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:isSame */
static sidl_bool
remote_bHYPRE_CGNR_isSame(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct sidl_BaseInterface__object* iobj,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isSame", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(iobj){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)iobj,       \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "iobj", _url, _ex);SIDL_CHECK(    \
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "iobj", NULL, _ex);SIDL_CHECK(    \
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.isSame.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:isType */
static sidl_bool
remote_bHYPRE_CGNR_isType(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isType", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.isType.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getClassInfo */
static struct sidl_ClassInfo__object*
remote_bHYPRE_CGNR_getClassInfo(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char*_retval_str = NULL;
    struct sidl_ClassInfo__object* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getClassInfo", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.getClassInfo.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval_str,           \
      _ex);SIDL_CHECK(*_ex);
    _retval = sidl_ClassInfo__connectI(_retval_str, FALSE, _ex);SIDL_CHECK(   \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetPreconditioner */
static int32_t
remote_bHYPRE_CGNR_SetPreconditioner(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_Solver__object* s,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetPreconditioner", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(s){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)s,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "s", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "s", NULL, _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetPreconditioner.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:GetPreconditioner */
static int32_t
remote_bHYPRE_CGNR_GetPreconditioner(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct bHYPRE_Solver__object** s,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* s_str= NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "GetPreconditioner", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.GetPreconditioner.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackString( _rsvp, "s", &s_str, _ex);SIDL_CHECK(*_ex);
    *s = bHYPRE_Solver__connectI(s_str, FALSE, _ex);SIDL_CHECK(*_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:Clone */
static int32_t
remote_bHYPRE_CGNR_Clone(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct bHYPRE_PreconditionedSolver__object** x,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* x_str= NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "Clone", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.Clone.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackString( _rsvp, "x", &x_str, _ex);SIDL_CHECK(*_ex);
    *x = bHYPRE_PreconditionedSolver__connectI(x_str, FALSE, _ex);SIDL_CHECK( \
      *_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetOperator */
static int32_t
remote_bHYPRE_CGNR_SetOperator(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_Operator__object* A,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetOperator", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(A){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)A,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "A", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "A", NULL, _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetOperator.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetTolerance */
static int32_t
remote_bHYPRE_CGNR_SetTolerance(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ double tolerance,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetTolerance", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packDouble( _inv, "tolerance", tolerance,             \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetTolerance.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetMaxIterations */
static int32_t
remote_bHYPRE_CGNR_SetMaxIterations(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ int32_t max_iterations,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetMaxIterations", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packInt( _inv, "max_iterations", max_iterations,      \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetMaxIterations.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetLogging */
static int32_t
remote_bHYPRE_CGNR_SetLogging(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ int32_t level,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetLogging", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packInt( _inv, "level", level, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetLogging.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetPrintLevel */
static int32_t
remote_bHYPRE_CGNR_SetPrintLevel(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ int32_t level,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetPrintLevel", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packInt( _inv, "level", level, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetPrintLevel.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:GetNumIterations */
static int32_t
remote_bHYPRE_CGNR_GetNumIterations(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ int32_t* num_iterations,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "GetNumIterations", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.GetNumIterations.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackInt( _rsvp, "num_iterations", num_iterations,     \
      _ex);SIDL_CHECK(*_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:GetRelResidualNorm */
static int32_t
remote_bHYPRE_CGNR_GetRelResidualNorm(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ double* norm,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "GetRelResidualNorm", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.GetRelResidualNorm.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackDouble( _rsvp, "norm", norm, _ex);SIDL_CHECK(     \
      *_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetCommunicator */
static int32_t
remote_bHYPRE_CGNR_SetCommunicator(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_MPICommunicator__object* mpi_comm,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetCommunicator", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(mpi_comm){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)mpi_comm,   \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "mpi_comm", _url, _ex);SIDL_CHECK(\
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "mpi_comm", NULL, _ex);SIDL_CHECK(\
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetCommunicator.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:Destroy */
static void
remote_bHYPRE_CGNR_Destroy(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "Destroy", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.Destroy.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:SetIntParameter */
static int32_t
remote_bHYPRE_CGNR_SetIntParameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in */ int32_t value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetIntParameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packInt( _inv, "value", value, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetIntParameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetDoubleParameter */
static int32_t
remote_bHYPRE_CGNR_SetDoubleParameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in */ double value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetDoubleParameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packDouble( _inv, "value", value, _ex);SIDL_CHECK(    \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetDoubleParameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetStringParameter */
static int32_t
remote_bHYPRE_CGNR_SetStringParameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in */ const char* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetStringParameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packString( _inv, "value", value, _ex);SIDL_CHECK(    \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetStringParameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetIntArray1Parameter */
static int32_t
remote_bHYPRE_CGNR_SetIntArray1Parameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in rarray[nvalues] */ struct sidl_int__array* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetIntArray1Parameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packIntArray( _inv, "value", value,                   \
      sidl_column_major_order,1,0, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetIntArray1Parameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetIntArray2Parameter */
static int32_t
remote_bHYPRE_CGNR_SetIntArray2Parameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in array<int,2,column-major> */ struct sidl_int__array* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetIntArray2Parameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packIntArray( _inv, "value", value,                   \
      sidl_column_major_order,2,0, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetIntArray2Parameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetDoubleArray1Parameter */
static int32_t
remote_bHYPRE_CGNR_SetDoubleArray1Parameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in rarray[nvalues] */ struct sidl_double__array* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetDoubleArray1Parameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packDoubleArray( _inv, "value", value,                \
      sidl_column_major_order,1,0, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetDoubleArray1Parameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:SetDoubleArray2Parameter */
static int32_t
remote_bHYPRE_CGNR_SetDoubleArray2Parameter(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* in array<double,2,column-major> */ struct sidl_double__array* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "SetDoubleArray2Parameter", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packDoubleArray( _inv, "value", value,                \
      sidl_column_major_order,2,0, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.SetDoubleArray2Parameter.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:GetIntValue */
static int32_t
remote_bHYPRE_CGNR_GetIntValue(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* out */ int32_t* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "GetIntValue", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.GetIntValue.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackInt( _rsvp, "value", value, _ex);SIDL_CHECK(*_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:GetDoubleValue */
static int32_t
remote_bHYPRE_CGNR_GetDoubleValue(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ const char* name,
  /* out */ double* value,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "GetDoubleValue", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.GetDoubleValue.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackDouble( _rsvp, "value", value, _ex);SIDL_CHECK(   \
      *_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:Setup */
static int32_t
remote_bHYPRE_CGNR_Setup(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_Vector__object* b,
  /* in */ struct bHYPRE_Vector__object* x,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "Setup", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(b){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)b,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "b", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "b", NULL, _ex);SIDL_CHECK(*_ex);
    }
    if(x){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)x,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "x", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "x", NULL, _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.Setup.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:Apply */
static int32_t
remote_bHYPRE_CGNR_Apply(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_Vector__object* b,
  /* inout */ struct bHYPRE_Vector__object** x,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* x_str= NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "Apply", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(b){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)b,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "b", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "b", NULL, _ex);SIDL_CHECK(*_ex);
    }
    if(*x){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)*x,         \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "x", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "x", NULL, _ex);SIDL_CHECK(*_ex);
    }
    /* Transfer this reference */
    if(*x && sidl_BaseInterface__isRemote((sidl_BaseInterface)*x, _ex)) {
      SIDL_CHECK(*_ex);
      (*((sidl_BaseInterface)*x)->d_epv->f__raddRef)(((                       \
        sidl_BaseInterface)*x)->d_object, _ex);SIDL_CHECK(*_ex);
      sidl_BaseInterface_deleteRef((sidl_BaseInterface)*x, _ex);SIDL_CHECK(   \
        *_ex); 
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.Apply.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackString( _rsvp, "x", &x_str, _ex);SIDL_CHECK(*_ex);
    *x = bHYPRE_Vector__connectI(x_str, FALSE, _ex);SIDL_CHECK(*_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:ApplyAdjoint */
static int32_t
remote_bHYPRE_CGNR_ApplyAdjoint(
  /* in */ struct bHYPRE_CGNR__object* self ,
  /* in */ struct bHYPRE_Vector__object* b,
  /* inout */ struct bHYPRE_Vector__object** x,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* x_str= NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      bHYPRE_CGNR__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "ApplyAdjoint", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(b){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)b,          \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "b", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "b", NULL, _ex);SIDL_CHECK(*_ex);
    }
    if(*x){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)*x,         \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "x", _url, _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "x", NULL, _ex);SIDL_CHECK(*_ex);
    }
    /* Transfer this reference */
    if(*x && sidl_BaseInterface__isRemote((sidl_BaseInterface)*x, _ex)) {
      SIDL_CHECK(*_ex);
      (*((sidl_BaseInterface)*x)->d_epv->f__raddRef)(((                       \
        sidl_BaseInterface)*x)->d_object, _ex);SIDL_CHECK(*_ex);
      sidl_BaseInterface_deleteRef((sidl_BaseInterface)*x, _ex);SIDL_CHECK(   \
        *_ex); 
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from bHYPRE.CGNR.ApplyAdjoint.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */
    sidl_rmi_Response_unpackString( _rsvp, "x", &x_str, _ex);SIDL_CHECK(*_ex);
    *x = bHYPRE_Vector__connectI(x_str, FALSE, _ex);SIDL_CHECK(*_ex);

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE EPV: create remote entry point vectors (EPVs). */
static void bHYPRE_CGNR__init_remote_epv(void)
{
  /* assert( HAVE_LOCKED_STATIC_GLOBALS ); */
  struct bHYPRE_CGNR__epv*                 epv = &s_rem_epv__bhypre_cgnr;
  struct bHYPRE_Operator__epv*             e0  = &s_rem_epv__bhypre_operator;
  struct bHYPRE_PreconditionedSolver__epv* e1  =                              \
    &s_rem_epv__bhypre_preconditionedsolver;
  struct bHYPRE_Solver__epv*               e2  = &s_rem_epv__bhypre_solver;
  struct sidl_BaseClass__epv*              e3  = &s_rem_epv__sidl_baseclass;
  struct sidl_BaseInterface__epv*          e4  =                              \
    &s_rem_epv__sidl_baseinterface;

  epv->f__cast                         = remote_bHYPRE_CGNR__cast;
  epv->f__delete                       = remote_bHYPRE_CGNR__delete;
  epv->f__exec                         = remote_bHYPRE_CGNR__exec;
  epv->f__getURL                       = remote_bHYPRE_CGNR__getURL;
  epv->f__raddRef                      = remote_bHYPRE_CGNR__raddRef;
  epv->f__isRemote                     = remote_bHYPRE_CGNR__isRemote;
  epv->f__set_hooks                    = remote_bHYPRE_CGNR__set_hooks;
  epv->f__ctor                         = NULL;
  epv->f__ctor2                        = NULL;
  epv->f__dtor                         = NULL;
  epv->f_addRef                        = remote_bHYPRE_CGNR_addRef;
  epv->f_deleteRef                     = remote_bHYPRE_CGNR_deleteRef;
  epv->f_isSame                        = remote_bHYPRE_CGNR_isSame;
  epv->f_isType                        = remote_bHYPRE_CGNR_isType;
  epv->f_getClassInfo                  = remote_bHYPRE_CGNR_getClassInfo;
  epv->f_SetPreconditioner             = remote_bHYPRE_CGNR_SetPreconditioner;
  epv->f_GetPreconditioner             = remote_bHYPRE_CGNR_GetPreconditioner;
  epv->f_Clone                         = remote_bHYPRE_CGNR_Clone;
  epv->f_SetOperator                   = remote_bHYPRE_CGNR_SetOperator;
  epv->f_SetTolerance                  = remote_bHYPRE_CGNR_SetTolerance;
  epv->f_SetMaxIterations              = remote_bHYPRE_CGNR_SetMaxIterations;
  epv->f_SetLogging                    = remote_bHYPRE_CGNR_SetLogging;
  epv->f_SetPrintLevel                 = remote_bHYPRE_CGNR_SetPrintLevel;
  epv->f_GetNumIterations              = remote_bHYPRE_CGNR_GetNumIterations;
  epv->f_GetRelResidualNorm            =                                      \
    remote_bHYPRE_CGNR_GetRelResidualNorm;
  epv->f_SetCommunicator               = remote_bHYPRE_CGNR_SetCommunicator;
  epv->f_Destroy                       = remote_bHYPRE_CGNR_Destroy;
  epv->f_SetIntParameter               = remote_bHYPRE_CGNR_SetIntParameter;
  epv->f_SetDoubleParameter            =                                      \
    remote_bHYPRE_CGNR_SetDoubleParameter;
  epv->f_SetStringParameter            =                                      \
    remote_bHYPRE_CGNR_SetStringParameter;
  epv->f_SetIntArray1Parameter         =                                      \
    remote_bHYPRE_CGNR_SetIntArray1Parameter;
  epv->f_SetIntArray2Parameter         =                                      \
    remote_bHYPRE_CGNR_SetIntArray2Parameter;
  epv->f_SetDoubleArray1Parameter      =                                      \
    remote_bHYPRE_CGNR_SetDoubleArray1Parameter;
  epv->f_SetDoubleArray2Parameter      =                                      \
    remote_bHYPRE_CGNR_SetDoubleArray2Parameter;
  epv->f_GetIntValue                   = remote_bHYPRE_CGNR_GetIntValue;
  epv->f_GetDoubleValue                = remote_bHYPRE_CGNR_GetDoubleValue;
  epv->f_Setup                         = remote_bHYPRE_CGNR_Setup;
  epv->f_Apply                         = remote_bHYPRE_CGNR_Apply;
  epv->f_ApplyAdjoint                  = remote_bHYPRE_CGNR_ApplyAdjoint;

  e0->f__cast                    = (void* (*)(void*,const char*,              \
    sidl_BaseInterface*)) epv->f__cast;
  e0->f__delete                  = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__delete;
  e0->f__getURL                  = (char* (*)(void*,sidl_BaseInterface*))     \
    epv->f__getURL;
  e0->f__raddRef                 = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__raddRef;
  e0->f__isRemote                = (sidl_bool (*)(void*,sidl_BaseInterface*)) \
    epv->f__isRemote;
  e0->f__set_hooks               = (void (*)(void*,int32_t,                   \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e0->f__exec                    = (void (*)(void*,const char*,struct         \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e0->f_SetCommunicator          = (int32_t (*)(void*,struct                  \
    bHYPRE_MPICommunicator__object*,struct sidl_BaseInterface__object **))    \
    epv->f_SetCommunicator;
  e0->f_Destroy                  = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_Destroy;
  e0->f_SetIntParameter          = (int32_t (*)(void*,const char*,int32_t,    \
    struct sidl_BaseInterface__object **)) epv->f_SetIntParameter;
  e0->f_SetDoubleParameter       = (int32_t (*)(void*,const char*,double,     \
    struct sidl_BaseInterface__object **)) epv->f_SetDoubleParameter;
  e0->f_SetStringParameter       = (int32_t (*)(void*,const char*,const char*,\
    struct sidl_BaseInterface__object **)) epv->f_SetStringParameter;
  e0->f_SetIntArray1Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray1Parameter;
  e0->f_SetIntArray2Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray2Parameter;
  e0->f_SetDoubleArray1Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray1Parameter;
  e0->f_SetDoubleArray2Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray2Parameter;
  e0->f_GetIntValue              = (int32_t (*)(void*,const char*,int32_t*,   \
    struct sidl_BaseInterface__object **)) epv->f_GetIntValue;
  e0->f_GetDoubleValue           = (int32_t (*)(void*,const char*,double*,    \
    struct sidl_BaseInterface__object **)) epv->f_GetDoubleValue;
  e0->f_Setup                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object*,struct               \
    sidl_BaseInterface__object **)) epv->f_Setup;
  e0->f_Apply                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_Apply;
  e0->f_ApplyAdjoint             = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_ApplyAdjoint;
  e0->f_addRef                   = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e0->f_deleteRef                = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e0->f_isSame                   = (sidl_bool (*)(void*,struct                \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e0->f_isType                   = (sidl_bool (*)(void*,const char*,struct    \
    sidl_BaseInterface__object **)) epv->f_isType;
  e0->f_getClassInfo             = (struct sidl_ClassInfo__object* (*)(void*, \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e1->f__cast                    = (void* (*)(void*,const char*,              \
    sidl_BaseInterface*)) epv->f__cast;
  e1->f__delete                  = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__delete;
  e1->f__getURL                  = (char* (*)(void*,sidl_BaseInterface*))     \
    epv->f__getURL;
  e1->f__raddRef                 = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__raddRef;
  e1->f__isRemote                = (sidl_bool (*)(void*,sidl_BaseInterface*)) \
    epv->f__isRemote;
  e1->f__set_hooks               = (void (*)(void*,int32_t,                   \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e1->f__exec                    = (void (*)(void*,const char*,struct         \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e1->f_SetPreconditioner        = (int32_t (*)(void*,struct                  \
    bHYPRE_Solver__object*,struct sidl_BaseInterface__object **))             \
    epv->f_SetPreconditioner;
  e1->f_GetPreconditioner        = (int32_t (*)(void*,struct                  \
    bHYPRE_Solver__object**,struct sidl_BaseInterface__object **))            \
    epv->f_GetPreconditioner;
  e1->f_Clone                    = (int32_t (*)(void*,struct                  \
    bHYPRE_PreconditionedSolver__object**,struct sidl_BaseInterface__object   \
    **)) epv->f_Clone;
  e1->f_SetOperator              = (int32_t (*)(void*,struct                  \
    bHYPRE_Operator__object*,struct sidl_BaseInterface__object **))           \
    epv->f_SetOperator;
  e1->f_SetTolerance             = (int32_t (*)(void*,double,struct           \
    sidl_BaseInterface__object **)) epv->f_SetTolerance;
  e1->f_SetMaxIterations         = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetMaxIterations;
  e1->f_SetLogging               = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetLogging;
  e1->f_SetPrintLevel            = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetPrintLevel;
  e1->f_GetNumIterations         = (int32_t (*)(void*,int32_t*,struct         \
    sidl_BaseInterface__object **)) epv->f_GetNumIterations;
  e1->f_GetRelResidualNorm       = (int32_t (*)(void*,double*,struct          \
    sidl_BaseInterface__object **)) epv->f_GetRelResidualNorm;
  e1->f_SetCommunicator          = (int32_t (*)(void*,struct                  \
    bHYPRE_MPICommunicator__object*,struct sidl_BaseInterface__object **))    \
    epv->f_SetCommunicator;
  e1->f_Destroy                  = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_Destroy;
  e1->f_SetIntParameter          = (int32_t (*)(void*,const char*,int32_t,    \
    struct sidl_BaseInterface__object **)) epv->f_SetIntParameter;
  e1->f_SetDoubleParameter       = (int32_t (*)(void*,const char*,double,     \
    struct sidl_BaseInterface__object **)) epv->f_SetDoubleParameter;
  e1->f_SetStringParameter       = (int32_t (*)(void*,const char*,const char*,\
    struct sidl_BaseInterface__object **)) epv->f_SetStringParameter;
  e1->f_SetIntArray1Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray1Parameter;
  e1->f_SetIntArray2Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray2Parameter;
  e1->f_SetDoubleArray1Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray1Parameter;
  e1->f_SetDoubleArray2Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray2Parameter;
  e1->f_GetIntValue              = (int32_t (*)(void*,const char*,int32_t*,   \
    struct sidl_BaseInterface__object **)) epv->f_GetIntValue;
  e1->f_GetDoubleValue           = (int32_t (*)(void*,const char*,double*,    \
    struct sidl_BaseInterface__object **)) epv->f_GetDoubleValue;
  e1->f_Setup                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object*,struct               \
    sidl_BaseInterface__object **)) epv->f_Setup;
  e1->f_Apply                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_Apply;
  e1->f_ApplyAdjoint             = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_ApplyAdjoint;
  e1->f_addRef                   = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e1->f_deleteRef                = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e1->f_isSame                   = (sidl_bool (*)(void*,struct                \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e1->f_isType                   = (sidl_bool (*)(void*,const char*,struct    \
    sidl_BaseInterface__object **)) epv->f_isType;
  e1->f_getClassInfo             = (struct sidl_ClassInfo__object* (*)(void*, \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e2->f__cast                    = (void* (*)(void*,const char*,              \
    sidl_BaseInterface*)) epv->f__cast;
  e2->f__delete                  = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__delete;
  e2->f__getURL                  = (char* (*)(void*,sidl_BaseInterface*))     \
    epv->f__getURL;
  e2->f__raddRef                 = (void (*)(void*,sidl_BaseInterface*))      \
    epv->f__raddRef;
  e2->f__isRemote                = (sidl_bool (*)(void*,sidl_BaseInterface*)) \
    epv->f__isRemote;
  e2->f__set_hooks               = (void (*)(void*,int32_t,                   \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e2->f__exec                    = (void (*)(void*,const char*,struct         \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e2->f_SetOperator              = (int32_t (*)(void*,struct                  \
    bHYPRE_Operator__object*,struct sidl_BaseInterface__object **))           \
    epv->f_SetOperator;
  e2->f_SetTolerance             = (int32_t (*)(void*,double,struct           \
    sidl_BaseInterface__object **)) epv->f_SetTolerance;
  e2->f_SetMaxIterations         = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetMaxIterations;
  e2->f_SetLogging               = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetLogging;
  e2->f_SetPrintLevel            = (int32_t (*)(void*,int32_t,struct          \
    sidl_BaseInterface__object **)) epv->f_SetPrintLevel;
  e2->f_GetNumIterations         = (int32_t (*)(void*,int32_t*,struct         \
    sidl_BaseInterface__object **)) epv->f_GetNumIterations;
  e2->f_GetRelResidualNorm       = (int32_t (*)(void*,double*,struct          \
    sidl_BaseInterface__object **)) epv->f_GetRelResidualNorm;
  e2->f_SetCommunicator          = (int32_t (*)(void*,struct                  \
    bHYPRE_MPICommunicator__object*,struct sidl_BaseInterface__object **))    \
    epv->f_SetCommunicator;
  e2->f_Destroy                  = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_Destroy;
  e2->f_SetIntParameter          = (int32_t (*)(void*,const char*,int32_t,    \
    struct sidl_BaseInterface__object **)) epv->f_SetIntParameter;
  e2->f_SetDoubleParameter       = (int32_t (*)(void*,const char*,double,     \
    struct sidl_BaseInterface__object **)) epv->f_SetDoubleParameter;
  e2->f_SetStringParameter       = (int32_t (*)(void*,const char*,const char*,\
    struct sidl_BaseInterface__object **)) epv->f_SetStringParameter;
  e2->f_SetIntArray1Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray1Parameter;
  e2->f_SetIntArray2Parameter    = (int32_t (*)(void*,const char*,struct      \
    sidl_int__array*,struct sidl_BaseInterface__object **))                   \
    epv->f_SetIntArray2Parameter;
  e2->f_SetDoubleArray1Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray1Parameter;
  e2->f_SetDoubleArray2Parameter = (int32_t (*)(void*,const char*,struct      \
    sidl_double__array*,struct sidl_BaseInterface__object **))                \
    epv->f_SetDoubleArray2Parameter;
  e2->f_GetIntValue              = (int32_t (*)(void*,const char*,int32_t*,   \
    struct sidl_BaseInterface__object **)) epv->f_GetIntValue;
  e2->f_GetDoubleValue           = (int32_t (*)(void*,const char*,double*,    \
    struct sidl_BaseInterface__object **)) epv->f_GetDoubleValue;
  e2->f_Setup                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object*,struct               \
    sidl_BaseInterface__object **)) epv->f_Setup;
  e2->f_Apply                    = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_Apply;
  e2->f_ApplyAdjoint             = (int32_t (*)(void*,struct                  \
    bHYPRE_Vector__object*,struct bHYPRE_Vector__object**,struct              \
    sidl_BaseInterface__object **)) epv->f_ApplyAdjoint;
  e2->f_addRef                   = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e2->f_deleteRef                = (void (*)(void*,struct                     \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e2->f_isSame                   = (sidl_bool (*)(void*,struct                \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e2->f_isType                   = (sidl_bool (*)(void*,const char*,struct    \
    sidl_BaseInterface__object **)) epv->f_isType;
  e2->f_getClassInfo             = (struct sidl_ClassInfo__object* (*)(void*, \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e3->f__cast        = (void* (*)(struct sidl_BaseClass__object*,const char*, \
    sidl_BaseInterface*)) epv->f__cast;
  e3->f__delete      = (void (*)(struct sidl_BaseClass__object*,              \
    sidl_BaseInterface*)) epv->f__delete;
  e3->f__getURL      = (char* (*)(struct sidl_BaseClass__object*,             \
    sidl_BaseInterface*)) epv->f__getURL;
  e3->f__raddRef     = (void (*)(struct sidl_BaseClass__object*,              \
    sidl_BaseInterface*)) epv->f__raddRef;
  e3->f__isRemote    = (sidl_bool (*)(struct sidl_BaseClass__object*,         \
    sidl_BaseInterface*)) epv->f__isRemote;
  e3->f__set_hooks   = (void (*)(struct sidl_BaseClass__object*,int32_t,      \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e3->f__exec        = (void (*)(struct sidl_BaseClass__object*,const char*,  \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct      \
    sidl_BaseInterface__object **)) epv->f__exec;
  e3->f_addRef       = (void (*)(struct sidl_BaseClass__object*,struct        \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e3->f_deleteRef    = (void (*)(struct sidl_BaseClass__object*,struct        \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e3->f_isSame       = (sidl_bool (*)(struct sidl_BaseClass__object*,struct   \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e3->f_isType       = (sidl_bool (*)(struct sidl_BaseClass__object*,const    \
    char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e3->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct             \
    sidl_BaseClass__object*,struct sidl_BaseInterface__object **))            \
    epv->f_getClassInfo;

  e4->f__cast        = (void* (*)(void*,const char*,sidl_BaseInterface*))     \
    epv->f__cast;
  e4->f__delete      = (void (*)(void*,sidl_BaseInterface*)) epv->f__delete;
  e4->f__getURL      = (char* (*)(void*,sidl_BaseInterface*)) epv->f__getURL;
  e4->f__raddRef     = (void (*)(void*,sidl_BaseInterface*)) epv->f__raddRef;
  e4->f__isRemote    = (sidl_bool (*)(void*,sidl_BaseInterface*))             \
    epv->f__isRemote;
  e4->f__set_hooks   = (void (*)(void*,int32_t, sidl_BaseInterface*))         \
    epv->f__set_hooks;
  e4->f__exec        = (void (*)(void*,const char*,struct                     \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e4->f_addRef       = (void (*)(void*,struct sidl_BaseInterface__object **)) \
    epv->f_addRef;
  e4->f_deleteRef    = (void (*)(void*,struct sidl_BaseInterface__object **)) \
    epv->f_deleteRef;
  e4->f_isSame       = (sidl_bool (*)(void*,struct                            \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e4->f_isType       = (sidl_bool (*)(void*,const char*,struct                \
    sidl_BaseInterface__object **)) epv->f_isType;
  e4->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*,struct       \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  s_remote_initialized = 1;
}

/* Create an instance that connects to an existing remote object. */
static struct bHYPRE_CGNR__object*
bHYPRE_CGNR__remoteConnect(const char *url, sidl_bool ar, sidl_BaseInterface  \
  *_ex)
{
  struct bHYPRE_CGNR__object* self;

  struct bHYPRE_CGNR__object* s0;
  struct sidl_BaseClass__object* s1;

  struct bHYPRE_CGNR__remote* r_obj;
  sidl_rmi_InstanceHandle instance = NULL;
  char* objectID = NULL;
  objectID = NULL;
  *_ex = NULL;
  if(url == NULL) {return NULL;}
  objectID = sidl_rmi_ServerRegistry_isLocalObject(url, _ex);
  if(objectID) {
    sidl_BaseInterface bi = (                                                 \
      sidl_BaseInterface)sidl_rmi_InstanceRegistry_getInstanceByString(       \
      objectID, _ex); SIDL_CHECK(*_ex);
    return bHYPRE_CGNR__rmicast(bi,_ex);SIDL_CHECK(*_ex);
  }
  instance = sidl_rmi_ProtocolFactory_connectInstance(url, ar, _ex );         \
    SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct bHYPRE_CGNR__object*) malloc(
      sizeof(struct bHYPRE_CGNR__object));

  r_obj =
    (struct bHYPRE_CGNR__remote*) malloc(
      sizeof(struct bHYPRE_CGNR__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                          self;
  s1 =                          &s0->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    bHYPRE_CGNR__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s1->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s1->d_sidl_baseinterface.d_object = (void*) self;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_baseclass;

  s0->d_bhypre_operator.d_epv    = &s_rem_epv__bhypre_operator;
  s0->d_bhypre_operator.d_object = (void*) self;

  s0->d_bhypre_preconditionedsolver.d_epv    =                                \
    &s_rem_epv__bhypre_preconditionedsolver;
  s0->d_bhypre_preconditionedsolver.d_object = (void*) self;

  s0->d_bhypre_solver.d_epv    = &s_rem_epv__bhypre_solver;
  s0->d_bhypre_solver.d_object = (void*) self;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__bhypre_cgnr;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  return NULL;
}
/* Create an instance that uses an already existing  */
/* InstanceHandle to connect to an existing remote object. */
static struct bHYPRE_CGNR__object*
bHYPRE_CGNR__IHConnect(sidl_rmi_InstanceHandle instance, sidl_BaseInterface   \
  *_ex)
{
  struct bHYPRE_CGNR__object* self;

  struct bHYPRE_CGNR__object* s0;
  struct sidl_BaseClass__object* s1;

  struct bHYPRE_CGNR__remote* r_obj;
  self =
    (struct bHYPRE_CGNR__object*) malloc(
      sizeof(struct bHYPRE_CGNR__object));

  r_obj =
    (struct bHYPRE_CGNR__remote*) malloc(
      sizeof(struct bHYPRE_CGNR__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                          self;
  s1 =                          &s0->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    bHYPRE_CGNR__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s1->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s1->d_sidl_baseinterface.d_object = (void*) self;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_baseclass;

  s0->d_bhypre_operator.d_epv    = &s_rem_epv__bhypre_operator;
  s0->d_bhypre_operator.d_object = (void*) self;

  s0->d_bhypre_preconditionedsolver.d_epv    =                                \
    &s_rem_epv__bhypre_preconditionedsolver;
  s0->d_bhypre_preconditionedsolver.d_object = (void*) self;

  s0->d_bhypre_solver.d_epv    = &s_rem_epv__bhypre_solver;
  s0->d_bhypre_solver.d_object = (void*) self;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__bhypre_cgnr;

  self->d_data = (void*) r_obj;

  sidl_rmi_InstanceHandle_addRef(instance,_ex);SIDL_CHECK(*_ex);
  return self;
  EXIT:
  return NULL;
}
/* REMOTE: generate remote instance given URL string. */
static struct bHYPRE_CGNR__object*
bHYPRE_CGNR__remoteCreate(const char *url, sidl_BaseInterface *_ex)
{
  sidl_BaseInterface _throwaway_exception = NULL;
  struct bHYPRE_CGNR__object* self;

  struct bHYPRE_CGNR__object* s0;
  struct sidl_BaseClass__object* s1;

  struct bHYPRE_CGNR__remote* r_obj;
  sidl_rmi_InstanceHandle instance = sidl_rmi_ProtocolFactory_createInstance( \
    url, "bHYPRE.CGNR", _ex ); SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct bHYPRE_CGNR__object*) malloc(
      sizeof(struct bHYPRE_CGNR__object));

  r_obj =
    (struct bHYPRE_CGNR__remote*) malloc(
      sizeof(struct bHYPRE_CGNR__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                          self;
  s1 =                          &s0->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    bHYPRE_CGNR__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s1->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s1->d_sidl_baseinterface.d_object = (void*) self;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_baseclass;

  s0->d_bhypre_operator.d_epv    = &s_rem_epv__bhypre_operator;
  s0->d_bhypre_operator.d_object = (void*) self;

  s0->d_bhypre_preconditionedsolver.d_epv    =                                \
    &s_rem_epv__bhypre_preconditionedsolver;
  s0->d_bhypre_preconditionedsolver.d_object = (void*) self;

  s0->d_bhypre_solver.d_epv    = &s_rem_epv__bhypre_solver;
  s0->d_bhypre_solver.d_object = (void*) self;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__bhypre_cgnr;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  if(instance) { sidl_rmi_InstanceHandle_deleteRef(instance,                  \
    &_throwaway_exception); }
  return NULL;
}
/*
 * Cast method for interface and class type conversions.
 */

struct bHYPRE_CGNR__object*
bHYPRE_CGNR__rmicast(
  void* obj,
  sidl_BaseInterface* _ex)
{
  struct bHYPRE_CGNR__object* cast = NULL;

  *_ex = NULL;
  if(!connect_loaded) {
    sidl_rmi_ConnectRegistry_registerConnect("bHYPRE.CGNR", (                 \
      void*)bHYPRE_CGNR__IHConnect, _ex);
    connect_loaded = 1;
  }
  if (obj != NULL) {
    struct sidl_BaseInterface__object* base = (struct                         \
      sidl_BaseInterface__object*) obj;
    cast = (struct bHYPRE_CGNR__object*) (*base->d_epv->f__cast)(
      base->d_object,
      "bHYPRE.CGNR", _ex); SIDL_CHECK(*_ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/*
 * RMI connector function for the class.
 */

struct bHYPRE_CGNR__object*
bHYPRE_CGNR__connectI(const char* url, sidl_bool ar, struct                   \
  sidl_BaseInterface__object **_ex)
{
  return bHYPRE_CGNR__remoteConnect(url, ar, _ex);
}

static PyObject *
pStub_CGNR__connect(PyObject *_ignored, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object* self = NULL;
  char* url = NULL;
  struct sidl_BaseInterface__object *_exception = NULL;
  static char *_kwlist[] = {
    "url",
    NULL
  };
  int _okay;
  sidl_rmi_NetworkException__import();
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "z", _kwlist,
    &url);
  if (_okay) {
    self = bHYPRE_CGNR__remoteConnect(url,1,&_exception);
    if (_exception) {
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _eargs);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_eargs);
      }
    }
    else {
      _return_value = Py_BuildValue(
        "O&",
        (void *)bHYPRE_CGNR__wrap, self);
    }
  }
  return _return_value;
}

staticforward PyTypeObject _bHYPRE_CGNRType;

static struct bHYPRE_CGNR__sepv *_sepv = NULL;

static const struct bHYPRE_CGNR__external *_implEPV = NULL;

static PyObject *
pStub_CGNR_Create(PyObject *_ignored, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_MPICommunicator__object* mpi_comm = NULL;
  struct bHYPRE_Operator__object* A = NULL;
  struct sidl_BaseInterface__object *_exception = NULL;
  static char *_kwlist[] = {
    "mpi_comm",
    "A",
    NULL
  };
  int _okay;
  bHYPRE_MPICommunicator__import();
  bHYPRE_Operator__import();
  sidl_RuntimeException__import();
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "O&O&", _kwlist,
    (void *)bHYPRE_MPICommunicator__convert, &mpi_comm,
    (void *)bHYPRE_Operator__convert, &A);
  if (_okay) {
    struct bHYPRE_CGNR__object* _return = NULL;
    _return = (*(_sepv->f_Create))(mpi_comm, A, &_exception);
    if (_exception) {
      struct sidl_RuntimeException__object *_ex0;
      if ((_ex0 = (struct sidl_RuntimeException__object *)
      sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
        PyErr_SetObject(sidl_RuntimeException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_eargs);
      }
    }
    else {
      _return_value = Py_BuildValue(
        "O&",
        (void *)bHYPRE_CGNR__wrap, _return);
    }
    bHYPRE_MPICommunicator_deref(mpi_comm);
    bHYPRE_Operator_deref(A);
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__exec(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object *_self_ior =
    ((struct bHYPRE_CGNR__object *)
     sidl_Cast(_self, "bHYPRE.CGNR"));
  if (_self_ior) {
    char* methodName = NULL;
    struct sidl_rmi_Call__object* inArgs = NULL;
    struct sidl_rmi_Return__object* outArgs = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "methodName",
      "inArgs",
      "outArgs",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    sidl_rmi_Call__import();
    sidl_rmi_Return__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "zO&O&", _kwlist,
      &methodName,
      (void *)sidl_rmi_Call__convert, &inArgs,
      (void *)sidl_rmi_Return__convert, &outArgs);
    if (_okay) {
      (*(_self_ior->d_epv->f__exec))(_self_ior, methodName, inArgs, outArgs,  \
        &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
      sidl_rmi_Call_deref(inArgs);
      sidl_rmi_Return_deref(outArgs);
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a bHYPRE.CGNR");
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__getURL(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object *_self_ior =
    ((struct bHYPRE_CGNR__object *)
     sidl_Cast(_self, "bHYPRE.CGNR"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      char* _return = NULL;
      _return = (*(_self_ior->d_epv->f__getURL))(_self_ior, &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
        free((void *)_return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a bHYPRE.CGNR");
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__isLocal(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object *_self_ior =
    ((struct bHYPRE_CGNR__object *)
     sidl_Cast(_self, "bHYPRE.CGNR"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
      _return = !(*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a bHYPRE.CGNR");
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__isRemote(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object *_self_ior =
    ((struct bHYPRE_CGNR__object *)
     sidl_Cast(_self, "bHYPRE.CGNR"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
      _return = (*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a bHYPRE.CGNR");
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__set_hooks(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct bHYPRE_CGNR__object *_self_ior =
    ((struct bHYPRE_CGNR__object *)
     sidl_Cast(_self, "bHYPRE.CGNR"));
  if (_self_ior) {
    sidl_bool on = (sidl_bool) 0;
    struct sidl_BaseInterface__object *_exception = NULL;
    int _proxy_on;
    static char *_kwlist[] = {
      "on",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "i", _kwlist,
      &_proxy_on);
    if (_okay) {
      on = (_proxy_on ? (TRUE) : (FALSE));
      (*(_self_ior->d_epv->f__set_hooks))(_self_ior, on, &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a bHYPRE.CGNR");
  }
  return _return_value;
}

static PyObject *
pStub_CGNR__set_hooks_static(PyObject *_ignored, PyObject *_args, PyObject    \
  *_kwdict) {
  PyObject *_return_value = NULL;
  sidl_bool on = (sidl_bool) 0;
  struct sidl_BaseInterface__object *_exception = NULL;
  int _proxy_on;
  static char *_kwlist[] = {
    "on",
    NULL
  };
  int _okay;
  sidl_RuntimeException__import();
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "i", _kwlist,
    &_proxy_on);
  if (_okay) {
    on = (_proxy_on ? (TRUE) : (FALSE));
    (*(_sepv->f__set_hooks_static))(on, &_exception);
    if (_exception) {
      struct sidl_RuntimeException__object *_ex0;
      if ((_ex0 = (struct sidl_RuntimeException__object *)
      sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
        PyErr_SetObject(sidl_RuntimeException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_eargs);
      }
    }
    else {
      _return_value = Py_None;
      Py_INCREF(_return_value);
    }
  }
  if(_implEPV) {
    _sepv = (*_implEPV->getStaticEPV)();
  }
  return _return_value;
}

static int
bHYPRE_CGNR_createCast(PyObject *self, PyObject *args, PyObject *kwds) {
  struct bHYPRE_CGNR__object *optarg = NULL;
  char* url = NULL;
  PyObject * implObj = NULL;
  static char *_kwlist[] = {"sobj",  "url", "impl", NULL };
  int _okay = PyArg_ParseTupleAndKeywords(args, kwds, "|O&zO", _kwlist, (void \
    *)bHYPRE_CGNR__convert, &optarg, &url, &implObj);
  if (_okay) {
    if (!optarg && !url && !implObj) {
      struct sidl_BaseInterface__object *_exception;
      optarg = (*(_implEPV->createObject))(NULL,&_exception);
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_eargs = PyTuple_New(1);
            PyTuple_SetItem(_eargs, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
            Py_XDECREF(_eargs);
          }
          return -1;
        }
      }
    }
    else if (!optarg && !url && implObj) {
      struct sidl_BaseInterface__object *_exception;
      Py_INCREF(implObj);
      optarg = (*(_implEPV->createObject))((void*)implObj,&_exception);
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_eargs = PyTuple_New(1);
            PyTuple_SetItem(_eargs, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
            Py_XDECREF(_eargs);
          }
          return -1;
        }
      }
  }
  else if(url && !optarg && !implObj) {
    struct sidl_BaseInterface__object *_exception = NULL;
    optarg = bHYPRE_CGNR__remoteCreate(url,&_exception);
    if (_exception) {
      sidl_rmi_NetworkException__import();
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _eargs);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_eargs);
      }
      return -1;
    }
  }
  /* OK, but fall though */
  else if(!url && optarg && !implObj) {}
  /* Error case. */
  else {
    return -1;
  }
  return sidl_Object_Init(
    (SPObject *)self,
    (struct sidl_BaseInterface__object *)optarg,
    sidl_PyStealRef);
}
return -1;
}

static PyMethodDef _CGNRModuleMethods[] = {
  { "Create", (PyCFunction)pStub_CGNR_Create,
  (METH_VARARGS | METH_KEYWORDS),
"\
Create( in bHYPRE.MPICommunicator mpi_comm,\n\
        in bHYPRE.Operator A)\n\
RETURNS\n\
   (bHYPRE.CGNR _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
 This function is the preferred way to create a CGNR solver. "
   },
  { "_connect", (PyCFunction)pStub_CGNR__connect,
  (METH_VARARGS | METH_KEYWORDS),
"\
_connect( in string url)\n\
RETURNS\n\
   ( out bHYPRE.CGNR self)\n\
RAISES\n\
    sidl.rmi.NetworkException\n\
"
   },
  { "_set_hooks_static", (PyCFunction)pStub_CGNR__set_hooks_static,
  (METH_VARARGS | METH_KEYWORDS),
"\
_set_hooks_static( in bool on)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Static Method to set whether or not method hooks should be invoked."
   },
  { NULL, NULL }
};

static PyMethodDef _CGNRObjectMethods[] = {
  { "_exec", (PyCFunction)pStub_CGNR__exec,
  (METH_VARARGS | METH_KEYWORDS),
"\
_exec( in string methodName,\n\
       in sidl.rmi.Call inArgs,\n\
       in sidl.rmi.Return outArgs)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Select and execute a method by name"
   },
  { "_getURL", (PyCFunction)pStub_CGNR__getURL,
  (METH_VARARGS | METH_KEYWORDS),
"\
_getURL()\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Get the URL of the Implementation of this object (for RMI)"
   },
  { "_isLocal", (PyCFunction)pStub_CGNR__isLocal,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isLocal()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is local, false if remote"
   },
  { "_isRemote", (PyCFunction)pStub_CGNR__isRemote,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isRemote()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is remote, false if local"
   },
  { "_set_hooks", (PyCFunction)pStub_CGNR__set_hooks,
  (METH_VARARGS | METH_KEYWORDS),
"\
_set_hooks( in bool on)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Method to set whether or not method hooks should be invoked."
   },
  { NULL, NULL }
};

static PyTypeObject _bHYPRE_CGNRType = {
  PyObject_HEAD_INIT(NULL)
  0,      /* ob_size */
  "bHYPRE.CGNR.CGNR", /* tp_name */
  0,      /* tp_basicsize */
  0,      /* tp_itemsize */
  0,      /* tp_dealloc */
  0,      /* tp_print */
  0,      /* tp_getattr */
  0,      /* tp_setattr */
  0,      /* tp_compare */
  0,      /* tp_repr */
  0,      /* tp_as_number */
  0,      /* tp_as_sequence */
  0,      /* tp_as_mapping */
  0,      /* tp_hash  */
  0,      /* tp_call */
  0,      /* tp_str */
  0,      /* tp_getattro */
  0,      /* tp_setattro */
  0,      /* tp_as_buffer */
  Py_TPFLAGS_DEFAULT, /* tp_flags */
  "\
\
CGNR solver.\n\
This calls Babel-interface matrix and vector functions, so it will work\n\
with any consistent matrix, vector, and preconditioner classes.", /* tp_doc */
  0,      /* tp_traverse */
  0,       /* tp_clear */
  0,       /* tp_richcompare */
  0,       /* tp_weaklistoffset */
  0,       /* tp_iter */
  0,       /* tp_iternext */
  _CGNRObjectMethods, /* tp_methods */
  0,       /* tp_members */
  0,       /* tp_getset */
  0,       /* tp_base */
  0,       /* tp_dict */
  0,       /* tp_descr_get */
  0,       /* tp_descr_set */
  0,       /* tp_dictoffset */
  bHYPRE_CGNR_createCast,   /* tp_init */
  0,       /* tp_alloc */
  0,       /* tp_new */
};

bHYPRE_CGNR__wrap_RETURN
bHYPRE_CGNR__wrap bHYPRE_CGNR__wrap_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _bHYPRE_CGNRType.tp_new(&_bHYPRE_CGNRType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyStealRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

bHYPRE_CGNR__weakRef_RETURN
bHYPRE_CGNR__weakRef bHYPRE_CGNR__weakRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _bHYPRE_CGNRType.tp_new(&_bHYPRE_CGNRType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyWeakRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

bHYPRE_CGNR_deref_RETURN
bHYPRE_CGNR_deref bHYPRE_CGNR_deref_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_deleteRef))(sidlobj, &throwaway_exception);
  }
}

bHYPRE_CGNR__newRef_RETURN
bHYPRE_CGNR__newRef bHYPRE_CGNR__newRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _bHYPRE_CGNRType.tp_new(&_bHYPRE_CGNRType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyNewRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

bHYPRE_CGNR__addRef_RETURN
bHYPRE_CGNR__addRef bHYPRE_CGNR__addRef_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_addRef))(sidlobj, &throwaway_exception);
  }
}

bHYPRE_CGNR_PyType_RETURN
bHYPRE_CGNR_PyType bHYPRE_CGNR_PyType_PROTO {
  Py_INCREF(&_bHYPRE_CGNRType);
  return &_bHYPRE_CGNRType;
}

bHYPRE_CGNR__convert_RETURN
bHYPRE_CGNR__convert bHYPRE_CGNR__convert_PROTO {
  *sidlobj = sidl_Cast(obj, "bHYPRE.CGNR");
  if ((!(*sidlobj)) && (obj != Py_None)) {
    PyErr_SetString(PyExc_TypeError, 
      "argument is not a(n) bHYPRE.CGNR");
    return 0;
  }
  return 1;
}

static int
_convertPython(void *sidlarray, const int *ind, PyObject *pyobj)
{
  struct bHYPRE_CGNR__object *sidlobj;
  if (bHYPRE_CGNR__convert(pyobj, &sidlobj)) {
    sidl_interface__array_set((struct sidl_interface__array *)sidlarray,
    ind, (struct sidl_BaseInterface__object *)sidlobj);
    if (sidlobj) {
      struct sidl_BaseInterface__object *asInt = (struct                      \
        sidl_BaseInterface__object *)sidlobj;
      struct sidl_BaseInterface__object *throwaway_exception;
      (*asInt->d_epv->f_deleteRef)(asInt->d_object, &throwaway_exception);
    }
    return FALSE;
  }
  return TRUE;
}

bHYPRE_CGNR__convert_python_array_RETURN
bHYPRE_CGNR__convert_python_array bHYPRE_CGNR__convert_python_array_PROTO {
  int result = 0;
  *sidlarray = NULL;
  if (obj == Py_None) {
    result = TRUE;
  }
  else {
    PyObject *pya = PyArray_FromObject(obj, PyArray_OBJECT, 0, 0);
    if (pya) {
      if (PyArray_OBJECT == ((PyArrayObject *)pya)->descr->type_num) {
        int dimen, lower[SIDL_MAX_ARRAY_DIMENSION],
          upper[SIDL_MAX_ARRAY_DIMENSION],
          stride[SIDL_MAX_ARRAY_DIMENSION];
        if (sidl_array__extract_python_info
          (pya, &dimen, lower, upper, stride))
        {
            *sidlarray = (struct                                              \
              bHYPRE_CGNR__array*)sidl_interface__array_createRow
            (dimen, lower, upper);
          result = sidl_array__convert_python
            (pya, dimen, *sidlarray, _convertPython);
          if (*sidlarray && !result) {
            sidl_interface__array_deleteRef(
              (struct  sidl_interface__array *)*sidlarray);
            *sidlarray = NULL;
          }
        }
      }
      Py_DECREF(pya);
    }
  }
  return result;
}

static int
_convertSIDL(void *sidlarray, const int *ind, PyObject **dest)
{
  struct bHYPRE_CGNR__object *sidlobj = (struct bHYPRE_CGNR__object*)
  sidl_interface__array_get((struct sidl_interface__array *)
    sidlarray, ind);
  *dest = bHYPRE_CGNR__wrap(sidlobj);
  return (*dest == NULL);
}

bHYPRE_CGNR__convert_sidl_array_RETURN
bHYPRE_CGNR__convert_sidl_array bHYPRE_CGNR__convert_sidl_array_PROTO {
  PyObject *pya = NULL;
  if (sidlarray) {
    const int dimen = sidlArrayDim(sidlarray);
    int i;
    int *lower = (int *)malloc(sizeof(int) * dimen);
    int *upper = (int *)malloc(sizeof(int) * dimen);
    int *numelem = (int *)malloc(sizeof(int) * dimen);
    for(i = 0; i < dimen; ++i) {
      lower[i] = sidlLower(sidlarray, i);
      upper[i] = sidlUpper(sidlarray, i);
      numelem[i] = 1 + upper[i] - lower[i];
    }
    pya = PyArray_FromDims(dimen, numelem, PyArray_OBJECT);
    if (pya) {
      if (!sidl_array__convert_sidl(pya, dimen, lower, upper,
        numelem, sidlarray, _convertSIDL))
      {
        Py_DECREF(pya);
        pya = NULL;
      }
    }
    free(numelem);
    free(upper);
    free(lower);
  }
  else {
    Py_INCREF(Py_None);
    pya = Py_None;
  }
  return pya;
}

void
initCGNR(void) {
  PyObject *module, *dict, *c_api;
  static void *ExternalAPI[bHYPRE_CGNR__API_NUM];
  struct sidl_BaseInterface__object *throwaway_exception;
  sidl_DLL dll = NULL;
  struct bHYPRE_CGNR__external*(*_extFunc)(void) = NULL;
  module = Py_InitModule3("CGNR", _CGNRModuleMethods, "\
\
CGNR solver.\n\
This calls Babel-interface matrix and vector functions, so it will work\n\
with any consistent matrix, vector, and preconditioner classes."
  );
  dict = PyModule_GetDict(module);
  ExternalAPI[bHYPRE_CGNR__wrap_NUM] = (void*)bHYPRE_CGNR__wrap;
  ExternalAPI[bHYPRE_CGNR__convert_NUM] = (void*)bHYPRE_CGNR__convert;
  ExternalAPI[bHYPRE_CGNR__convert_python_array_NUM] = (                      \
    void*)bHYPRE_CGNR__convert_python_array;
  ExternalAPI[bHYPRE_CGNR__convert_sidl_array_NUM] = (                        \
    void*)bHYPRE_CGNR__convert_sidl_array;
  ExternalAPI[bHYPRE_CGNR__weakRef_NUM] = (void*)bHYPRE_CGNR__weakRef;
  ExternalAPI[bHYPRE_CGNR_deref_NUM] = (void*)bHYPRE_CGNR_deref;
  ExternalAPI[bHYPRE_CGNR__newRef_NUM] = (void*)bHYPRE_CGNR__newRef;
  ExternalAPI[bHYPRE_CGNR__addRef_NUM] = (void*)bHYPRE_CGNR__addRef;
  ExternalAPI[bHYPRE_CGNR_PyType_NUM] = (void*)bHYPRE_CGNR_PyType;
  ExternalAPI[bHYPRE_CGNR__connectI_NUM] = (void*)bHYPRE_CGNR__connectI;
  ExternalAPI[bHYPRE_CGNR__rmicast_NUM] = (void*)bHYPRE_CGNR__rmicast;
  import_SIDLObjA();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlObjA module.");
  }
  c_api = PyCObject_FromVoidPtr((void *)ExternalAPI, NULL);
  PyDict_SetItemString(dict, "_C_API", c_api);
  Py_XDECREF(c_api);
  import_SIDLPyArrays();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlPyArrays module.");
  }
  import_array();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing Numeric Python module.");
  }
  bHYPRE_PreconditionedSolver__import();
  sidl_BaseClass__import();
  _bHYPRE_CGNRType.tp_base = sidl_BaseClass_PyType();
  _bHYPRE_CGNRType.tp_bases = PyTuple_New(2);
  PyTuple_SetItem(_bHYPRE_CGNRType.tp_bases,0, (PyObject                      \
    *)sidl_BaseClass_PyType());
  PyTuple_SetItem(_bHYPRE_CGNRType.tp_bases,1, (PyObject                      \
    *)bHYPRE_PreconditionedSolver_PyType());
  if (PyType_Ready(&_bHYPRE_CGNRType) < 0) {
    PyErr_Print();
    fprintf(stderr, "PyType_Ready on bHYPRE.CGNR failed.\n");
    return;
  }
  Py_INCREF(&_bHYPRE_CGNRType);
  PyDict_SetItemString(dict, "CGNR", (PyObject *)&_bHYPRE_CGNRType);
  /* Load the implementation after initializing the module. */
  /* Try search global namespace first */
  dll = sidl_DLL__create(&throwaway_exception);
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE,                  \
    &throwaway_exception)) {
    _extFunc = (struct bHYPRE_CGNR__external*(*)(void))
      sidl_DLL_lookupSymbol(dll, "bHYPRE_CGNR__externals",                    \
        &throwaway_exception);
    if (_extFunc) {
      _implEPV = (*_extFunc)();
    }
  }
  if (dll) sidl_DLL_deleteRef(dll, &throwaway_exception);
  if (!_implEPV) {
    dll = sidl_Loader_findLibrary("bHYPRE.CGNR",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE, &throwaway_exception);
    if (dll) {
      _extFunc = (struct bHYPRE_CGNR__external*(*)(void))
        sidl_DLL_lookupSymbol(dll, "bHYPRE_CGNR__externals",                  \
          &throwaway_exception);
      if (_extFunc) {
        _implEPV = (*_extFunc)();
      }
      sidl_DLL_deleteRef(dll, &throwaway_exception);
    }
  }
  if (_implEPV) {
    _sepv = (*_implEPV->getStaticEPV)();
    if (PyErr_Occurred()) {
      Py_FatalError("Cannot initialize Python module bHYPRE.CGNR.");
    }
  }
  else {
    Py_FatalError("Cannot load implementation for sidl class bHYPRE.CGNR");
  }

  sidl_rmi_ConnectRegistry_registerConnect("bHYPRE.CGNR", (                   \
    void*)bHYPRE_CGNR__IHConnect, &throwaway_exception);
}
