<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://docs.hhvm.com/manual/en/class.spltempfileobject.php )
 *
 * The SplTempFileObject class offers an object oriented interface for a
 * temporary file.
 *
 */
class SplTempFileObject extends SplFileObject {

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/spltempfileobject.construct.php
   * )
   *
   * Construct a new temporary file object.
   *
   * @maxMemory  mixed   The maximum amount of memory (in bytes, default is 2
   *                     MB) for the temporary file to use. If the temporary
   *                     file exceeds this size, it will be moved to a file
   *                     in the system's temp directory.
   *
   *                     If max_memory is negative, only memory will be
   *                     used. If max_memory is zero, no memory will be used.
   *
   * @return     mixed   No value is returned.
   */
  public function __construct($maxMemory = null) {
    if ($maxMemory === null) {
      parent::__construct('php://temp', 'r+');
    } else {
      parent::__construct("php://temp/maxmemory:$maxMemory", 'r+');
    }
  }
}
