/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.html.docbook.DbtConstants;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Tbody;
import org.dbdoclet.trafo.tag.docbook.Tgroup;

public class TbodyEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		Script script = getTransformer().getScript();
		boolean decomposeTables = script.isParameterOn(DbtConstants.SECTION_DOCBOOK,
				DbtConstants.PARAM_DECOMPOSE_TABLES, DbtConstants.DEFAULT_DECOMPOSE_TABLES);

		if (decomposeTables) {
			traverse(true);
			return finalizeValues();
		}

		DocBookElement parent = getParent();
		
		if (parent != null && parent instanceof Tgroup) { 
		
			Tbody tbody = (Tbody) parent.getLastChild(Tbody.class);

			if (tbody == null) {

				setCurrent(dbfactory.createTbody());
				getCurrent().setParentNode(getParent());
				getParent().appendChild(getCurrent());

			} else {
				
				setCurrent(tbody);
			}
		}
		
		traverse(true);

		return finalizeValues();
	}
}
