/* testsms.c generated by valac 0.16.1, the Vala compiler
 * generated from testsms.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <smsutil.h>
#include <conversions.h>
#include <stdlib.h>
#include <string.h>
#include <util.h>
#include <fsogsm.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _sms_free0(var) ((var == NULL) ? NULL : (var = (sms_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _wrap_hex_pdu_unref0(var) ((var == NULL) ? NULL : (var = (wrap_hex_pdu_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern GSList* smslist;

void test_sms_decode_deliver_single_default_alphabet (void);
static guint8* _vala_array_dup1 (guint8* self, int length);
void test_sms_decode_deliver_single_concatenated_default_alphabet (void);
static guint8* _vala_array_dup2 (guint8* self, int length);
void test_sms_decode_deliver_multiple_concatenated_default_alphabet (void);
void test_sms_decode_deliver_whole_concatenated_default_alphabet (void);
void test_sms_decode_deliver_incoming_mms_control_message (void);
#define pdu5 "0791947106004034440B899421436587F900F501505102500280860605040B8423F061" \
"06226170706C69636174696F6E2F766E642E7761702E6D6D732D6D65737361676500AF" \
"848C82986B70684544414F637942008D908919802B3439313730323732303030332F54" \
"5950453D504C4D4E008A808E0261A88805810303F47983687474703A2F2F31302E3831" \
"2E302E373A383030322F6B70684544414F63794200"
#define pdulength5 153
void test_sms_decode_status_report (void);
#define pdu4 "079144999701903706990C91448748749999101151714000001011517140000000"
#define pdulength4 25
const gchar* sms_status_to_string (int self);
static const char* _sms_status_to_string (int value);
void test_sms_encode_submit_single_default_alphabet (void);
#define SHORT_TEXT "Hoffentlich diesmal mit ACKPDU"
static guint8* _vala_array_dup3 (guint8* self, int length);
void test_sms_encode_submit_concatenated_default_alphabet (void);
#define PHONE_NUMBER "+49123456789"
#define LONG_TEXT "freesmartphone.org is a collaboration platform for open source and ope" \
"n discussion software projects working on interoperability and shared " \
"technology for Linux-based SmartPhones. freesmartphone.org works on a " \
"service layer (middleware) that allows developers to concentrate on th" \
"eir application business logic rather than dealing with device specifi" \
"cs. freesmartphone.org honours and bases on specifications and softwar" \
"e created by the freedesktop.org community."
void _vala_main (gchar** args, int args_length1);
static void _test_sms_decode_deliver_single_default_alphabet_gcallback (void);
static void _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback (void);
static void _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback (void);
static void _test_sms_decode_status_report_gcallback (void);
static void _test_sms_encode_submit_single_default_alphabet_gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gint pdulengths1[11];
extern const gchar* pdus1[11];
extern const gchar* LONG_TEXT_PDUS[4];
extern const gint LONG_TEXT_PDULENS[4];

static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1455 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1456 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = self;
#line 1456 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 85 "testsms.c"
}


static struct sms* sms_newFromHexPdu (const gchar* hexpdu, gint tpdulen) {
	struct sms* result = NULL;
	glong items_written;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	glong _tmp3_ = 0L;
	glong _tmp4_;
	struct sms* _tmp5_;
	struct sms* sms;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	struct sms* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean res;
	gboolean _tmp10_;
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	g_return_val_if_fail (hexpdu != NULL, NULL);
#line 592 "../src/lib/fsogsm3rdparty.vapi"
	items_written = (glong) (-1);
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	_tmp0_ = g_new0 (gchar, 1024);
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	binpdu = _tmp0_;
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	binpdu_length1 = 1024;
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	_binpdu_size_ = binpdu_length1;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp1_ = hexpdu;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp2_ = binpdu;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp2__length1 = binpdu_length1;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	decode_hex_own_buf (_tmp1_, (glong) (-1), &_tmp3_, (gchar) 0, _tmp2_);
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	items_written = _tmp3_;
#line 595 "../src/lib/fsogsm3rdparty.vapi"
	_tmp4_ = items_written;
#line 595 "../src/lib/fsogsm3rdparty.vapi"
	g_assert (_tmp4_ != ((glong) (-1)));
#line 597 "../src/lib/fsogsm3rdparty.vapi"
	_tmp5_ = sms_new ();
#line 597 "../src/lib/fsogsm3rdparty.vapi"
	sms = _tmp5_;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp6_ = binpdu;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp6__length1 = binpdu_length1;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp7_ = tpdulen;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp8_ = sms;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp9_ = sms_decode (_tmp6_, _tmp6__length1, FALSE, _tmp7_, _tmp8_);
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	res = _tmp9_;
#line 600 "../src/lib/fsogsm3rdparty.vapi"
	_tmp10_ = res;
#line 600 "../src/lib/fsogsm3rdparty.vapi"
	if (!_tmp10_) {
#line 156 "testsms.c"
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp11_ = tpdulen;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp13_ = _tmp12_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp14_ = hexpdu;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp15_ = string_to_string (_tmp14_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp16_ = g_strconcat ("Sms.Message::newFromHexPdu: could not decode message w/ tpdulen ", _tmp13_, " and hexpdu ", _tmp15_, NULL);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp17_ = _tmp16_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		g_warning ("fsogsm3rdparty.vapi:602: %s", _tmp17_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_g_free0 (_tmp17_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_g_free0 (_tmp13_);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		result = NULL;
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		_sms_free0 (sms);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		binpdu = (g_free (binpdu), NULL);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		return result;
#line 192 "testsms.c"
	} else {
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		result = sms;
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		binpdu = (g_free (binpdu), NULL);
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		return result;
#line 200 "testsms.c"
	}
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	_sms_free0 (sms);
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	binpdu = (g_free (binpdu), NULL);
#line 206 "testsms.c"
}


static gchar* sms_number (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
#line 489 "../src/lib/fsogsm3rdparty.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 491 "../src/lib/fsogsm3rdparty.vapi"
	_tmp0_ = self->type;
#line 491 "../src/lib/fsogsm3rdparty.vapi"
	switch (_tmp0_) {
#line 491 "../src/lib/fsogsm3rdparty.vapi"
		case SMS_TYPE_DELIVER:
#line 221 "testsms.c"
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
#line 494 "../src/lib/fsogsm3rdparty.vapi"
			_tmp1_ = sms_address_to_string (&self->deliver.oaddr);
#line 494 "../src/lib/fsogsm3rdparty.vapi"
			_tmp2_ = g_strdup (_tmp1_);
#line 494 "../src/lib/fsogsm3rdparty.vapi"
			result = _tmp2_;
#line 494 "../src/lib/fsogsm3rdparty.vapi"
			return result;
#line 233 "testsms.c"
		}
#line 491 "../src/lib/fsogsm3rdparty.vapi"
		case SMS_TYPE_SUBMIT:
#line 237 "testsms.c"
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
#line 496 "../src/lib/fsogsm3rdparty.vapi"
			_tmp3_ = sms_address_to_string (&self->submit.daddr);
#line 496 "../src/lib/fsogsm3rdparty.vapi"
			_tmp4_ = g_strdup (_tmp3_);
#line 496 "../src/lib/fsogsm3rdparty.vapi"
			result = _tmp4_;
#line 496 "../src/lib/fsogsm3rdparty.vapi"
			return result;
#line 249 "testsms.c"
		}
#line 491 "../src/lib/fsogsm3rdparty.vapi"
		case SMS_TYPE_COMMAND:
#line 253 "testsms.c"
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
#line 498 "../src/lib/fsogsm3rdparty.vapi"
			_tmp5_ = sms_address_to_string (&self->command.daddr);
#line 498 "../src/lib/fsogsm3rdparty.vapi"
			_tmp6_ = g_strdup (_tmp5_);
#line 498 "../src/lib/fsogsm3rdparty.vapi"
			result = _tmp6_;
#line 498 "../src/lib/fsogsm3rdparty.vapi"
			return result;
#line 265 "testsms.c"
		}
#line 491 "../src/lib/fsogsm3rdparty.vapi"
		case SMS_TYPE_STATUS_REPORT:
#line 269 "testsms.c"
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
#line 500 "../src/lib/fsogsm3rdparty.vapi"
			_tmp7_ = sms_address_to_string (&self->status_report.raddr);
#line 500 "../src/lib/fsogsm3rdparty.vapi"
			_tmp8_ = g_strdup (_tmp7_);
#line 500 "../src/lib/fsogsm3rdparty.vapi"
			result = _tmp8_;
#line 500 "../src/lib/fsogsm3rdparty.vapi"
			return result;
#line 281 "testsms.c"
		}
		default:
		{
			gchar* _tmp9_;
#line 502 "../src/lib/fsogsm3rdparty.vapi"
			_tmp9_ = g_strdup ("unknown");
#line 502 "../src/lib/fsogsm3rdparty.vapi"
			result = _tmp9_;
#line 502 "../src/lib/fsogsm3rdparty.vapi"
			return result;
#line 292 "testsms.c"
		}
	}
}


static gchar* sms_to_string (struct sms* self) {
	gchar* result = NULL;
	GSList* list;
	GSList* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 482 "../src/lib/fsogsm3rdparty.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 484 "../src/lib/fsogsm3rdparty.vapi"
	list = NULL;
#line 485 "../src/lib/fsogsm3rdparty.vapi"
	list = g_slist_append (list, self);
#line 486 "../src/lib/fsogsm3rdparty.vapi"
	_tmp0_ = list;
#line 486 "../src/lib/fsogsm3rdparty.vapi"
	_tmp1_ = sms_decode_text (_tmp0_);
#line 486 "../src/lib/fsogsm3rdparty.vapi"
	result = _tmp1_;
#line 486 "../src/lib/fsogsm3rdparty.vapi"
	_g_slist_free0 (list);
#line 486 "../src/lib/fsogsm3rdparty.vapi"
	return result;
#line 319 "testsms.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 326 "testsms.c"
}


void test_sms_decode_deliver_single_default_alphabet (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	enum sms_type _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	struct sms_deliver _tmp5_;
	struct sms_scts _tmp6_;
	guint8 _tmp7_;
	struct sms_deliver _tmp8_;
	struct sms_scts _tmp9_;
	guint8 _tmp10_;
	struct sms_deliver _tmp11_;
	struct sms_scts _tmp12_;
	guint8 _tmp13_;
	struct sms_deliver _tmp14_;
	struct sms_scts _tmp15_;
	guint8 _tmp16_;
	struct sms_deliver _tmp17_;
	struct sms_scts _tmp18_;
	guint8 _tmp19_;
	struct sms_deliver _tmp20_;
	struct sms_scts _tmp21_;
	guint8 _tmp22_;
	struct sms_deliver _tmp23_;
	struct sms_scts _tmp24_;
	gint8 _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp28_ = FALSE;
	guint8 _tmp29_ = 0U;
	guint8 _tmp30_ = 0U;
	guint8 _tmp31_;
	guint8* _tmp32_ = NULL;
	guint8* _tmp33_;
	gint _tmp33__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
#line 27 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = sms_newFromHexPdu ("0791947106004034040D91947146093052F20000900192608270401EC8B7D95C76D3D9" \
"E9311A444E97E7ED301BD44ED341C1E1124AAC02", 47);
#line 27 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	sms = _tmp0_;
#line 29 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = sms->type;
#line 29 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp1_ == SMS_TYPE_DELIVER);
#line 30 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp2_ = sms_address_to_string (&sms->sc_addr);
#line 30 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp2_, "+491760000443") == 0);
#line 31 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp3_ = sms_number (sms);
#line 31 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp4_ = _tmp3_;
#line 31 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp4_, "+4917649003252") == 0);
#line 31 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp4_);
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = sms->deliver;
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = _tmp5_.scts;
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = _tmp6_.year;
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp7_) == 9);
#line 33 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = sms->deliver;
#line 33 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp9_ = _tmp8_.scts;
#line 33 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp10_ = _tmp9_.month;
#line 33 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp10_) == 10);
#line 34 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp11_ = sms->deliver;
#line 34 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp12_ = _tmp11_.scts;
#line 34 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp13_ = _tmp12_.day;
#line 34 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp13_) == 29);
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14_ = sms->deliver;
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp15_ = _tmp14_.scts;
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp16_ = _tmp15_.hour;
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp16_) == 6);
#line 36 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp17_ = sms->deliver;
#line 36 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp18_ = _tmp17_.scts;
#line 36 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp19_ = _tmp18_.minute;
#line 36 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp19_) == 28);
#line 37 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp20_ = sms->deliver;
#line 37 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp21_ = _tmp20_.scts;
#line 37 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp22_ = _tmp21_.second;
#line 37 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp22_) == 7);
#line 38 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp23_ = sms->deliver;
#line 38 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp24_ = _tmp23_.scts;
#line 38 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp25_ = _tmp24_.timezone;
#line 38 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp25_) == (+4));
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp26_ = sms_to_string (sms);
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp27_ = _tmp26_;
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp27_, "Hoffentlich diesmal mit ACKPDU") == 0);
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp27_);
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp32_ = sms_extract_common (sms, &_tmp28_, &_tmp29_, &_tmp31_, &_tmp30_);
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	udhi = _tmp28_;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	dcs = _tmp29_;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	max = _tmp30_;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup1 (_tmp32_, _tmp31_) : ((gpointer) _tmp32_);
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp33__length1 = _tmp31_;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = _tmp33_;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud_length1 = _tmp33__length1;
#line 45 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_ud_size_ = ud_length1;
#line 46 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud != NULL);
#line 47 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud_length1 == 30);
#line 48 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) dcs) == 0);
#line 49 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) max) == 140);
#line 50 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (!udhi);
#line 24 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = (g_free (ud), NULL);
#line 24 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_sms_free0 (sms);
#line 489 "testsms.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 496 "testsms.c"
}


void test_sms_decode_deliver_single_concatenated_default_alphabet (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	enum sms_type _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	struct sms_deliver _tmp5_;
	struct sms_scts _tmp6_;
	guint8 _tmp7_;
	struct sms_deliver _tmp8_;
	struct sms_scts _tmp9_;
	guint8 _tmp10_;
	struct sms_deliver _tmp11_;
	struct sms_scts _tmp12_;
	guint8 _tmp13_;
	struct sms_deliver _tmp14_;
	struct sms_scts _tmp15_;
	guint8 _tmp16_;
	struct sms_deliver _tmp17_;
	struct sms_scts _tmp18_;
	guint8 _tmp19_;
	struct sms_deliver _tmp20_;
	struct sms_scts _tmp21_;
	guint8 _tmp22_;
	struct sms_deliver _tmp23_;
	struct sms_scts _tmp24_;
	gint8 _tmp25_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp26_ = FALSE;
	guint8 _tmp27_ = 0U;
	guint8 _tmp28_ = 0U;
	guint8 _tmp29_;
	guint8* _tmp30_ = NULL;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
	guint16 ref_num = 0U;
	guint8 max_msgs = 0U;
	guint8 seq_num = 0U;
	guint16 _tmp32_ = 0U;
	guint8 _tmp33_ = 0U;
	guint8 _tmp34_ = 0U;
	gboolean _tmp35_ = FALSE;
#line 57 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = sms_newFromHexPdu ("0791947101670000440C91947120270030000090010321614440A0050003040B02C668" \
"3A885C978FD1A034DA0D4297E5E1FADC9C7693CB6ED09AEF7697DD2CD0BCCC16CFE9A0" \
"7BD9ED06CDD365505A7E2EBBC9F7B0DB0D9A97D36E50B41E96D3D36539A82C37BFD967" \
"79393D4683EC65F93DECD6D341E83D9D5E76BB14CCB79BFC06A1C3747A19242D8FD174" \
"1039DC4ED3592072D803B2A6E520F77B8C06B9D363341D242ECBCB", 159);
#line 57 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	sms = _tmp0_;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = sms->type;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp1_ == SMS_TYPE_DELIVER);
#line 60 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp2_ = sms_address_to_string (&sms->sc_addr);
#line 60 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp2_, "+491710760000") == 0);
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp3_ = sms_number (sms);
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp4_ = _tmp3_;
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp4_, "+491702720003") == 0);
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp4_);
#line 62 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = sms->deliver;
#line 62 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = _tmp5_.scts;
#line 62 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = _tmp6_.year;
#line 62 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp7_) == 9);
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = sms->deliver;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp9_ = _tmp8_.scts;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp10_ = _tmp9_.month;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp10_) == 10);
#line 64 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp11_ = sms->deliver;
#line 64 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp12_ = _tmp11_.scts;
#line 64 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp13_ = _tmp12_.day;
#line 64 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp13_) == 30);
#line 65 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14_ = sms->deliver;
#line 65 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp15_ = _tmp14_.scts;
#line 65 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp16_ = _tmp15_.hour;
#line 65 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp16_) == 12);
#line 66 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp17_ = sms->deliver;
#line 66 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp18_ = _tmp17_.scts;
#line 66 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp19_ = _tmp18_.minute;
#line 66 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp19_) == 16);
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp20_ = sms->deliver;
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp21_ = _tmp20_.scts;
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp22_ = _tmp21_.second;
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp22_) == 44);
#line 68 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp23_ = sms->deliver;
#line 68 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp24_ = _tmp23_.scts;
#line 68 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp25_ = _tmp24_.timezone;
#line 68 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) _tmp25_) == (+4));
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp30_ = sms_extract_common (sms, &_tmp26_, &_tmp27_, &_tmp29_, &_tmp28_);
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	udhi = _tmp26_;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	dcs = _tmp27_;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	max = _tmp28_;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup2 (_tmp30_, _tmp29_) : ((gpointer) _tmp30_);
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp31__length1 = _tmp29_;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = _tmp31_;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud_length1 = _tmp31__length1;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_ud_size_ = ud_length1;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud != NULL);
#line 76 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud_length1 == 160);
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) dcs) == 0);
#line 78 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) max) == 140);
#line 79 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (udhi);
#line 85 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp35_ = sms_extract_concatenation (sms, &_tmp32_, &_tmp33_, &_tmp34_);
#line 85 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ref_num = _tmp32_;
#line 85 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	max_msgs = _tmp33_;
#line 85 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	seq_num = _tmp34_;
#line 85 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp35_);
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) ref_num) == 4);
#line 87 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) max_msgs) == 11);
#line 88 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) seq_num) == 2);
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = (g_free (ud), NULL);
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_sms_free0 (sms);
#line 672 "testsms.c"
}


void test_sms_decode_deliver_multiple_concatenated_default_alphabet (void) {
	{
		gint i;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		i = 0;
#line 681 "testsms.c"
		{
			gboolean _tmp0_;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			_tmp0_ = TRUE;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			while (TRUE) {
#line 688 "testsms.c"
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				struct sms* _tmp8_ = NULL;
				struct sms* sms;
				guint16 ref_num = 0U;
				guint8 max_msgs = 0U;
				guint8 seq_num = 0U;
				struct sms* _tmp9_;
				guint16 _tmp10_ = 0U;
				guint8 _tmp11_ = 0U;
				guint8 _tmp12_ = 0U;
				gboolean _tmp13_ = FALSE;
				guint16 _tmp14_;
				guint8 _tmp15_;
				guint8 _tmp16_;
				gint _tmp17_;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp1_ = _tmp0_;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!_tmp1_) {
#line 713 "testsms.c"
					gint _tmp2_;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					_tmp2_ = i;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					i = _tmp2_ + 1;
#line 719 "testsms.c"
				}
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp0_ = FALSE;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp3_ = i;
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!(_tmp3_ < G_N_ELEMENTS (pdulengths1))) {
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					break;
#line 729 "testsms.c"
				}
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp4_ = i;
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp5_ = pdus1[_tmp4_];
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp6_ = i;
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp7_ = pdulengths1[_tmp6_];
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp8_ = sms_newFromHexPdu (_tmp5_, _tmp7_);
#line 107 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				sms = _tmp8_;
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp9_ = sms;
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp13_ = sms_extract_concatenation (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				ref_num = _tmp10_;
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				max_msgs = _tmp11_;
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				seq_num = _tmp12_;
#line 111 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				g_assert (_tmp13_);
#line 112 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp14_ = ref_num;
#line 112 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				g_assert (((gint) _tmp14_) == 4);
#line 113 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp15_ = max_msgs;
#line 113 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				g_assert (((gint) _tmp15_) == 11);
#line 114 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp16_ = seq_num;
#line 114 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp17_ = i;
#line 114 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				g_assert (((gint) _tmp16_) == (_tmp17_ + 1));
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_sms_free0 (sms);
#line 771 "testsms.c"
			}
		}
	}
}


void test_sms_decode_deliver_whole_concatenated_default_alphabet (void) {
	struct sms** _tmp0_ = NULL;
	struct sms** smses;
	gint smses_length1;
	gint _smses_size_;
	GSList* smslist;
	GSList* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* text;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
#line 122 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = g_new0 (struct sms*, G_N_ELEMENTS (pdulengths1) + 1);
#line 122 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	smses = _tmp0_;
#line 122 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	smses_length1 = G_N_ELEMENTS (pdulengths1);
#line 122 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_smses_size_ = smses_length1;
#line 799 "testsms.c"
	{
		gint i;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		i = 0;
#line 804 "testsms.c"
		{
			gboolean _tmp1_;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			_tmp1_ = TRUE;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			while (TRUE) {
#line 811 "testsms.c"
				gboolean _tmp2_;
				gint _tmp4_;
				struct sms** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				struct sms* _tmp11_ = NULL;
				struct sms* _tmp12_;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp2_ = _tmp1_;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!_tmp2_) {
#line 827 "testsms.c"
					gint _tmp3_;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					_tmp3_ = i;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					i = _tmp3_ + 1;
#line 833 "testsms.c"
				}
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp1_ = FALSE;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp4_ = i;
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!(_tmp4_ < G_N_ELEMENTS (pdulengths1))) {
#line 124 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					break;
#line 843 "testsms.c"
				}
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp5_ = smses;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp5__length1 = smses_length1;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp6_ = i;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp7_ = i;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp8_ = pdus1[_tmp7_];
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp9_ = i;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp10_ = pdulengths1[_tmp9_];
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp11_ = sms_newFromHexPdu (_tmp8_, _tmp10_);
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_sms_free0 (_tmp5_[_tmp6_]);
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp5_[_tmp6_] = _tmp11_;
#line 126 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp12_ = _tmp5_[_tmp6_];
#line 867 "testsms.c"
			}
		}
	}
#line 129 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	smslist = NULL;
#line 873 "testsms.c"
	{
		gint i;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		i = 0;
#line 878 "testsms.c"
		{
			gboolean _tmp13_;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			_tmp13_ = TRUE;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			while (TRUE) {
#line 885 "testsms.c"
				gboolean _tmp14_;
				gint _tmp16_;
				struct sms** _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				struct sms* _tmp19_;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp14_ = _tmp13_;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!_tmp14_) {
#line 896 "testsms.c"
					gint _tmp15_;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					_tmp15_ = i;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					i = _tmp15_ + 1;
#line 902 "testsms.c"
				}
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp13_ = FALSE;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp16_ = i;
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!(_tmp16_ < G_N_ELEMENTS (pdulengths1))) {
#line 130 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					break;
#line 912 "testsms.c"
				}
#line 132 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp17_ = smses;
#line 132 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp17__length1 = smses_length1;
#line 132 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp18_ = i;
#line 132 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 132 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				smslist = g_slist_append (smslist, _tmp19_);
#line 924 "testsms.c"
			}
		}
	}
#line 135 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp20_ = smslist;
#line 135 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp21_ = sms_decode_text (_tmp20_);
#line 135 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	text = _tmp21_;
#line 136 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp22_ = strlen (text);
#line 136 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp23_ = _tmp22_;
#line 136 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp23_ == 1562);
#line 137 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp24_ = g_str_has_prefix (text, "Wie haben die Drazi von der Beteiligung der Centauri erfahren?");
#line 137 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp24_);
#line 138 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp25_ = g_str_has_suffix (text, "zwischen Delenn und Lennier angedeutet zu werden.");
#line 138 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp25_);
#line 119 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (text);
#line 119 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_slist_free0 (smslist);
#line 119 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
#line 954 "testsms.c"
}


void test_sms_decode_deliver_incoming_mms_control_message (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	gint dst = 0;
	gint src = 0;
	gboolean is8bit = FALSE;
	struct sms* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean has_app_port;
	gboolean _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gchar* _tmp10_;
	gchar* contents;
	struct sms* _tmp11_;
	struct sms_deliver _tmp12_;
	guint8* ud;
	const gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
#line 145 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = sms_newFromHexPdu (pdu5, pdulength5);
#line 145 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	sms = _tmp0_;
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = sms;
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = sms_extract_app_port (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	dst = _tmp2_;
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	src = _tmp3_;
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	is8bit = _tmp4_;
#line 151 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	has_app_port = _tmp5_;
#line 153 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = has_app_port;
#line 153 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp6_);
#line 154 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = dst;
#line 154 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp7_ == 2948);
#line 155 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = src;
#line 155 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp8_ == 9200);
#line 156 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp9_ = is8bit;
#line 156 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (!_tmp9_);
#line 158 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp10_ = g_strdup ("");
#line 158 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	contents = _tmp10_;
#line 159 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp11_ = sms;
#line 159 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp12_ = _tmp11_->deliver;
#line 159 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = _tmp12_.ud;
#line 1025 "testsms.c"
	{
		gint i;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		i = 0;
#line 1030 "testsms.c"
		{
			gboolean _tmp13_;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			_tmp13_ = TRUE;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
			while (TRUE) {
#line 1037 "testsms.c"
				gboolean _tmp14_;
				gint _tmp16_;
				struct sms* _tmp17_;
				struct sms_deliver _tmp18_;
				guint8 _tmp19_;
				const gchar* _tmp20_;
				guint8* _tmp21_;
				gint _tmp22_;
				guint8 _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp14_ = _tmp13_;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!_tmp14_) {
#line 1054 "testsms.c"
					gint _tmp15_;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					_tmp15_ = i;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					i = _tmp15_ + 1;
#line 1060 "testsms.c"
				}
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp13_ = FALSE;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp16_ = i;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp17_ = sms;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp18_ = _tmp17_->deliver;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp19_ = _tmp18_.udl;
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				if (!(_tmp16_ < ((gint) _tmp19_))) {
#line 160 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
					break;
#line 1076 "testsms.c"
				}
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp20_ = contents;
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp21_ = ud;
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp22_ = i;
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp24_ = g_strdup_printf ("%c", (gint) _tmp23_);
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp25_ = _tmp24_;
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_tmp26_ = g_strconcat (_tmp20_, _tmp25_, NULL);
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_g_free0 (contents);
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				contents = _tmp26_;
#line 162 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
				_g_free0 (_tmp25_);
#line 1098 "testsms.c"
			}
		}
	}
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp27_ = contents;
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp28_ = string_to_string (_tmp27_);
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp29_ = g_strconcat ("content = ", _tmp28_, NULL);
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp30_ = _tmp29_;
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_debug ("testsms.vala:164: %s", _tmp30_);
#line 164 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp30_);
#line 166 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (FALSE);
#line 142 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (contents);
#line 142 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_sms_free0 (sms);
#line 1120 "testsms.c"
}


static const char* _sms_status_to_string (int value) {
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	switch (value) {
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_COMPLETED_RECEIVED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_COMPLETED_RECEIVED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_COMPLETED_UNABLE_TO_CONFIRM:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_COMPLETED_UNABLE_TO_CONFIRM";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_COMPLETED_REPLACED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_COMPLETED_REPLACED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_COMPLETED_LAST:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_COMPLETED_LAST";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_CONGESTION:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_CONGESTION";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_SME_BUSY:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_SME_BUSY";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_NO_RESPONSE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_NO_RESPONSE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_SERVICE_REJECTED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_SERVICE_REJECTED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_QOS_UNAVAILABLE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_QOS_UNAVAILABLE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_SME_ERROR:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_SME_ERROR";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPORARY_LAST:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPORARY_LAST";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_RP_ERROR:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_RP_ERROR";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_INVALID_DESTINATION:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_INVALID_DESTINATION";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_CONNECTION_REJECTED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_CONNECTION_REJECTED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_NOT_OBTAINABLE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_NOT_OBTAINABLE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_QOS_UNAVAILABLE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_QOS_UNAVAILABLE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_INTERWORKING_UNAVAILABLE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_INTERWORKING_UNAVAILABLE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_VALIDITY_PERIOD_EXPIRED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_VALIDITY_PERIOD_EXPIRED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_DELETED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_DELETED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_SC_ADMIN_DELETED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_SC_ADMIN_DELETED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_SM_DOES_NOT_EXIST:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_SM_DOES_NOT_EXIST";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_PERMANENT_LAST:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_PERMANENT_LAST";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_CONGESTION:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_CONGESTION";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_SME_BUSY:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_SME_BUSY";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_NO_RESPONSE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_NO_RESPONSE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_SERVICE_REJECTED:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_SERVICE_REJECTED";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_QOS_UNAVAILABLE:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_QOS_UNAVAILABLE";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_SME_ERROR:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_SME_ERROR";
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		case SMS_ST_TEMPFINAL_LAST:
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
		return "SMS_ST_TEMPFINAL_LAST";
#line 1243 "testsms.c"
	}
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	return NULL;
#line 1247 "testsms.c"
}


void test_sms_decode_status_report (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	gchar* _tmp1_ = NULL;
	gchar* number;
	struct sms_status_report _tmp2_;
	guint8 _tmp3_;
	guint8 reference;
	struct sms_status_report _tmp4_;
	int _tmp5_;
	int status;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
#line 173 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = sms_newFromHexPdu (pdu4, pdulength4);
#line 173 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	sms = _tmp0_;
#line 175 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = sms_number (sms);
#line 175 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	number = _tmp1_;
#line 176 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp2_ = sms->status_report;
#line 176 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp3_ = _tmp2_.mr;
#line 176 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	reference = _tmp3_;
#line 177 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp4_ = sms->status_report;
#line 177 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = _tmp4_.st;
#line 177 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	status = _tmp5_;
#line 179 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = string_to_string (number);
#line 179 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = g_strconcat ("sms report addr: ", _tmp6_, NULL);
#line 179 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = _tmp7_;
#line 179 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_debug ("testsms.vala:179: %s", _tmp8_);
#line 179 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp8_);
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp9_ = g_strdup_printf ("%hhu", reference);
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp10_ = _tmp9_;
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp11_ = g_strconcat ("sms report ref: ", _tmp10_, NULL);
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp12_ = _tmp11_;
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_debug ("testsms.vala:180: %s", _tmp12_);
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp12_);
#line 180 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp10_);
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp13_ = _sms_status_to_string (status);
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14_ = g_strconcat ("sms report status: ", _tmp13_, NULL);
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp15_ = _tmp14_;
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_debug ("testsms.vala:181: %s", _tmp15_);
#line 181 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp15_);
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp16_ = sms_to_string (sms);
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp17_ = _tmp16_;
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp18_ = g_strconcat ("sms report text: ", _tmp17_, NULL);
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp19_ = _tmp18_;
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_debug ("testsms.vala:182: %s", _tmp19_);
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp19_);
#line 182 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp17_);
#line 170 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (number);
#line 170 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_sms_free0 (sms);
#line 1348 "testsms.c"
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1355 "testsms.c"
}


void test_sms_encode_submit_single_default_alphabet (void) {
	gint offset = 0;
	gint _tmp0_ = 0;
	GSList* _tmp1_ = NULL;
	GSList* _tmp2_;
	guint _tmp3_ = 0U;
	GSList* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	struct sms* sms;
	enum sms_type _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp9_ = FALSE;
	guint8 _tmp10_ = 0U;
	guint8 _tmp11_ = 0U;
	guint8 _tmp12_;
	guint8* _tmp13_ = NULL;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
	gint _tmp15_;
	gint _tmp16_;
#line 190 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = sms_text_prepare (SHORT_TEXT, (guint16) 0, TRUE, &_tmp0_);
#line 190 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	offset = _tmp0_;
#line 190 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_slist_free0 (smslist);
#line 190 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	smslist = _tmp1_;
#line 191 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp2_ = smslist;
#line 191 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp3_ = g_slist_length (_tmp2_);
#line 191 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp3_ == ((guint) 1));
#line 192 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp4_ = smslist;
#line 192 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = g_slist_nth_data (_tmp4_, (guint) 0);
#line 192 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	sms = (struct sms*) ((struct sms*) _tmp5_);
#line 193 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = sms->type;
#line 193 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp6_ == SMS_TYPE_SUBMIT);
#line 194 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = sms_to_string (sms);
#line 194 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = _tmp7_;
#line 194 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp8_, SHORT_TEXT) == 0);
#line 194 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_free0 (_tmp8_);
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp13_ = sms_extract_common (sms, &_tmp9_, &_tmp10_, &_tmp12_, &_tmp11_);
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	udhi = _tmp9_;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	dcs = _tmp10_;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	max = _tmp11_;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup3 (_tmp13_, _tmp12_) : ((gpointer) _tmp13_);
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14__length1 = _tmp12_;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = _tmp14_;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud_length1 = _tmp14__length1;
#line 200 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_ud_size_ = ud_length1;
#line 201 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud != NULL);
#line 202 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp15_ = strlen (SHORT_TEXT);
#line 202 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp16_ = _tmp15_;
#line 202 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (ud_length1 == _tmp16_);
#line 203 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) dcs) == 0);
#line 204 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (((gint) max) == 140);
#line 205 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (!udhi);
#line 186 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	ud = (g_free (ud), NULL);
#line 1452 "testsms.c"
}


void test_sms_encode_submit_concatenated_default_alphabet (void) {
	FsoGsmAtSmsHandler* _tmp0_;
	FsoGsmSmsHandler* handler;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* pdu;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	WrapHexPdu* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	WrapHexPdu* _tmp9_;
	guint _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_ = NULL;
	WrapHexPdu* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	WrapHexPdu* _tmp17_;
	guint _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_ = NULL;
	WrapHexPdu* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	WrapHexPdu* _tmp25_;
	guint _tmp26_;
	gint _tmp27_;
	gpointer _tmp28_ = NULL;
	WrapHexPdu* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gpointer _tmp32_ = NULL;
	WrapHexPdu* _tmp33_;
	guint _tmp34_;
	gint _tmp35_;
#line 212 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp0_ = fso_gsm_at_sms_handler_new (NULL);
#line 212 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	handler = (FsoGsmSmsHandler*) _tmp0_;
#line 213 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp1_ = fso_gsm_sms_handler_formatTextMessage (handler, PHONE_NUMBER, LONG_TEXT, FALSE);
#line 213 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	pdu = _tmp1_;
#line 214 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) pdu);
#line 214 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp3_ = _tmp2_;
#line 214 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp3_ == 4);
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 0);
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp5_ = (WrapHexPdu*) _tmp4_;
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp6_ = _tmp5_->hexpdu;
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp7_ = LONG_TEXT_PDUS[0];
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp6_, _tmp7_) == 0);
#line 216 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp5_);
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 0);
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp9_ = (WrapHexPdu*) _tmp8_;
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp10_ = _tmp9_->tpdulen;
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp11_ = LONG_TEXT_PDULENS[0];
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp10_ == ((guint) _tmp11_));
#line 217 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp9_);
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 1);
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp13_ = (WrapHexPdu*) _tmp12_;
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp14_ = _tmp13_->hexpdu;
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp15_ = LONG_TEXT_PDUS[1];
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp14_, _tmp15_) == 0);
#line 218 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp13_);
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 1);
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp17_ = (WrapHexPdu*) _tmp16_;
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp18_ = _tmp17_->tpdulen;
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp19_ = LONG_TEXT_PDULENS[1];
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp18_ == ((guint) _tmp19_));
#line 219 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp17_);
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 2);
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp21_ = (WrapHexPdu*) _tmp20_;
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp22_ = _tmp21_->hexpdu;
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp23_ = LONG_TEXT_PDUS[2];
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp22_, _tmp23_) == 0);
#line 220 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp21_);
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 2);
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp25_ = (WrapHexPdu*) _tmp24_;
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp26_ = _tmp25_->tpdulen;
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp27_ = LONG_TEXT_PDULENS[2];
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp26_ == ((guint) _tmp27_));
#line 221 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp25_);
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 3);
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp29_ = (WrapHexPdu*) _tmp28_;
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp30_ = _tmp29_->hexpdu;
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp31_ = LONG_TEXT_PDUS[3];
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (g_strcmp0 (_tmp30_, _tmp31_) == 0);
#line 222 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp29_);
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 3);
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp33_ = (WrapHexPdu*) _tmp32_;
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp34_ = _tmp33_->tpdulen;
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_tmp35_ = LONG_TEXT_PDULENS[3];
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_assert (_tmp34_ == ((guint) _tmp35_));
#line 223 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_wrap_hex_pdu_unref0 (_tmp33_);
#line 209 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_object_unref0 (pdu);
#line 209 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_g_object_unref0 (handler);
#line 1609 "testsms.c"
}


static void _test_sms_decode_deliver_single_default_alphabet_gcallback (void) {
#line 232 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	test_sms_decode_deliver_single_default_alphabet ();
#line 1616 "testsms.c"
}


static void _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback (void) {
#line 233 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	test_sms_decode_deliver_single_concatenated_default_alphabet ();
#line 1623 "testsms.c"
}


static void _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback (void) {
#line 234 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	test_sms_decode_deliver_multiple_concatenated_default_alphabet ();
#line 1630 "testsms.c"
}


static void _test_sms_decode_status_report_gcallback (void) {
#line 237 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	test_sms_decode_status_report ();
#line 1637 "testsms.c"
}


static void _test_sms_encode_submit_single_default_alphabet_gcallback (void) {
#line 239 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	test_sms_encode_submit_single_default_alphabet ();
#line 1644 "testsms.c"
}


void _vala_main (gchar** args, int args_length1) {
#line 230 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_init (&args_length1, &args, NULL);
#line 232 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Single/DefaultAlphabet", _test_sms_decode_deliver_single_default_alphabet_gcallback);
#line 233 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Single/Concatenated/DefaultAlphabet", _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback);
#line 234 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Multiple/Concatenated/DefaultAlphabet", _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback);
#line 237 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_add_func ("/3rdparty/Sms/Decode/StatusReport", _test_sms_decode_status_report_gcallback);
#line 239 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_add_func ("/3rdparty/Sms/Encode/Submit/Single/DefaultAlphabet", _test_sms_encode_submit_single_default_alphabet_gcallback);
#line 242 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_test_run ();
#line 1663 "testsms.c"
}


int main (int argc, char ** argv) {
#line 227 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	g_type_init ();
#line 227 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	_vala_main (argv, argc);
#line 227 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsms.vala"
	return 0;
#line 1674 "testsms.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



