/*******************************************************
 * Copyright (c) 2015-2019, ArrayFire
 * All rights reserved.
 *
 * This file is distributed under 3-clause BSD license.
 * The complete license agreement can be obtained at:
 * http://arrayfire.com/licenses/BSD-3-Clause
 ********************************************************/

#pragma once

/**
 * Color maps: heat, rainbow are pulled from the following resource:
 *
 * http://www.paraview.org/Wiki/Colormaps
 * */

/* grayscale */
float cmap_default[] =
{
        0.0000f,    0.0000f,    0.0000f,    1.0000f,
        0.0039f,    0.0039f,    0.0039f,    1.0000f,
        0.0078f,    0.0078f,    0.0078f,    1.0000f,
        0.0118f,    0.0118f,    0.0118f,    1.0000f,
        0.0157f,    0.0157f,    0.0157f,    1.0000f,
        0.0196f,    0.0196f,    0.0196f,    1.0000f,
        0.0235f,    0.0235f,    0.0235f,    1.0000f,
        0.0275f,    0.0275f,    0.0275f,    1.0000f,
        0.0314f,    0.0314f,    0.0314f,    1.0000f,
        0.0353f,    0.0353f,    0.0353f,    1.0000f,
        0.0392f,    0.0392f,    0.0392f,    1.0000f,
        0.0431f,    0.0431f,    0.0431f,    1.0000f,
        0.0471f,    0.0471f,    0.0471f,    1.0000f,
        0.0510f,    0.0510f,    0.0510f,    1.0000f,
        0.0549f,    0.0549f,    0.0549f,    1.0000f,
        0.0588f,    0.0588f,    0.0588f,    1.0000f,
        0.0627f,    0.0627f,    0.0627f,    1.0000f,
        0.0667f,    0.0667f,    0.0667f,    1.0000f,
        0.0706f,    0.0706f,    0.0706f,    1.0000f,
        0.0745f,    0.0745f,    0.0745f,    1.0000f,
        0.0784f,    0.0784f,    0.0784f,    1.0000f,
        0.0824f,    0.0824f,    0.0824f,    1.0000f,
        0.0863f,    0.0863f,    0.0863f,    1.0000f,
        0.0902f,    0.0902f,    0.0902f,    1.0000f,
        0.0941f,    0.0941f,    0.0941f,    1.0000f,
        0.0980f,    0.0980f,    0.0980f,    1.0000f,
        0.1020f,    0.1020f,    0.1020f,    1.0000f,
        0.1059f,    0.1059f,    0.1059f,    1.0000f,
        0.1098f,    0.1098f,    0.1098f,    1.0000f,
        0.1137f,    0.1137f,    0.1137f,    1.0000f,
        0.1176f,    0.1176f,    0.1176f,    1.0000f,
        0.1216f,    0.1216f,    0.1216f,    1.0000f,
        0.1255f,    0.1255f,    0.1255f,    1.0000f,
        0.1294f,    0.1294f,    0.1294f,    1.0000f,
        0.1333f,    0.1333f,    0.1333f,    1.0000f,
        0.1373f,    0.1373f,    0.1373f,    1.0000f,
        0.1412f,    0.1412f,    0.1412f,    1.0000f,
        0.1451f,    0.1451f,    0.1451f,    1.0000f,
        0.1490f,    0.1490f,    0.1490f,    1.0000f,
        0.1529f,    0.1529f,    0.1529f,    1.0000f,
        0.1569f,    0.1569f,    0.1569f,    1.0000f,
        0.1608f,    0.1608f,    0.1608f,    1.0000f,
        0.1647f,    0.1647f,    0.1647f,    1.0000f,
        0.1686f,    0.1686f,    0.1686f,    1.0000f,
        0.1725f,    0.1725f,    0.1725f,    1.0000f,
        0.1765f,    0.1765f,    0.1765f,    1.0000f,
        0.1804f,    0.1804f,    0.1804f,    1.0000f,
        0.1843f,    0.1843f,    0.1843f,    1.0000f,
        0.1882f,    0.1882f,    0.1882f,    1.0000f,
        0.1922f,    0.1922f,    0.1922f,    1.0000f,
        0.1961f,    0.1961f,    0.1961f,    1.0000f,
        0.2000f,    0.2000f,    0.2000f,    1.0000f,
        0.2039f,    0.2039f,    0.2039f,    1.0000f,
        0.2078f,    0.2078f,    0.2078f,    1.0000f,
        0.2118f,    0.2118f,    0.2118f,    1.0000f,
        0.2157f,    0.2157f,    0.2157f,    1.0000f,
        0.2196f,    0.2196f,    0.2196f,    1.0000f,
        0.2235f,    0.2235f,    0.2235f,    1.0000f,
        0.2275f,    0.2275f,    0.2275f,    1.0000f,
        0.2314f,    0.2314f,    0.2314f,    1.0000f,
        0.2353f,    0.2353f,    0.2353f,    1.0000f,
        0.2392f,    0.2392f,    0.2392f,    1.0000f,
        0.2431f,    0.2431f,    0.2431f,    1.0000f,
        0.2471f,    0.2471f,    0.2471f,    1.0000f,
        0.2510f,    0.2510f,    0.2510f,    1.0000f,
        0.2549f,    0.2549f,    0.2549f,    1.0000f,
        0.2588f,    0.2588f,    0.2588f,    1.0000f,
        0.2627f,    0.2627f,    0.2627f,    1.0000f,
        0.2667f,    0.2667f,    0.2667f,    1.0000f,
        0.2706f,    0.2706f,    0.2706f,    1.0000f,
        0.2745f,    0.2745f,    0.2745f,    1.0000f,
        0.2784f,    0.2784f,    0.2784f,    1.0000f,
        0.2824f,    0.2824f,    0.2824f,    1.0000f,
        0.2863f,    0.2863f,    0.2863f,    1.0000f,
        0.2902f,    0.2902f,    0.2902f,    1.0000f,
        0.2941f,    0.2941f,    0.2941f,    1.0000f,
        0.2980f,    0.2980f,    0.2980f,    1.0000f,
        0.3020f,    0.3020f,    0.3020f,    1.0000f,
        0.3059f,    0.3059f,    0.3059f,    1.0000f,
        0.3098f,    0.3098f,    0.3098f,    1.0000f,
        0.3137f,    0.3137f,    0.3137f,    1.0000f,
        0.3176f,    0.3176f,    0.3176f,    1.0000f,
        0.3216f,    0.3216f,    0.3216f,    1.0000f,
        0.3255f,    0.3255f,    0.3255f,    1.0000f,
        0.3294f,    0.3294f,    0.3294f,    1.0000f,
        0.3333f,    0.3333f,    0.3333f,    1.0000f,
        0.3373f,    0.3373f,    0.3373f,    1.0000f,
        0.3412f,    0.3412f,    0.3412f,    1.0000f,
        0.3451f,    0.3451f,    0.3451f,    1.0000f,
        0.3490f,    0.3490f,    0.3490f,    1.0000f,
        0.3529f,    0.3529f,    0.3529f,    1.0000f,
        0.3569f,    0.3569f,    0.3569f,    1.0000f,
        0.3608f,    0.3608f,    0.3608f,    1.0000f,
        0.3647f,    0.3647f,    0.3647f,    1.0000f,
        0.3686f,    0.3686f,    0.3686f,    1.0000f,
        0.3725f,    0.3725f,    0.3725f,    1.0000f,
        0.3765f,    0.3765f,    0.3765f,    1.0000f,
        0.3804f,    0.3804f,    0.3804f,    1.0000f,
        0.3843f,    0.3843f,    0.3843f,    1.0000f,
        0.3882f,    0.3882f,    0.3882f,    1.0000f,
        0.3922f,    0.3922f,    0.3922f,    1.0000f,
        0.3961f,    0.3961f,    0.3961f,    1.0000f,
        0.4000f,    0.4000f,    0.4000f,    1.0000f,
        0.4039f,    0.4039f,    0.4039f,    1.0000f,
        0.4078f,    0.4078f,    0.4078f,    1.0000f,
        0.4118f,    0.4118f,    0.4118f,    1.0000f,
        0.4157f,    0.4157f,    0.4157f,    1.0000f,
        0.4196f,    0.4196f,    0.4196f,    1.0000f,
        0.4235f,    0.4235f,    0.4235f,    1.0000f,
        0.4275f,    0.4275f,    0.4275f,    1.0000f,
        0.4314f,    0.4314f,    0.4314f,    1.0000f,
        0.4353f,    0.4353f,    0.4353f,    1.0000f,
        0.4392f,    0.4392f,    0.4392f,    1.0000f,
        0.4431f,    0.4431f,    0.4431f,    1.0000f,
        0.4471f,    0.4471f,    0.4471f,    1.0000f,
        0.4510f,    0.4510f,    0.4510f,    1.0000f,
        0.4549f,    0.4549f,    0.4549f,    1.0000f,
        0.4588f,    0.4588f,    0.4588f,    1.0000f,
        0.4627f,    0.4627f,    0.4627f,    1.0000f,
        0.4667f,    0.4667f,    0.4667f,    1.0000f,
        0.4706f,    0.4706f,    0.4706f,    1.0000f,
        0.4745f,    0.4745f,    0.4745f,    1.0000f,
        0.4784f,    0.4784f,    0.4784f,    1.0000f,
        0.4824f,    0.4824f,    0.4824f,    1.0000f,
        0.4863f,    0.4863f,    0.4863f,    1.0000f,
        0.4902f,    0.4902f,    0.4902f,    1.0000f,
        0.4941f,    0.4941f,    0.4941f,    1.0000f,
        0.4980f,    0.4980f,    0.4980f,    1.0000f,
        0.5020f,    0.5020f,    0.5020f,    1.0000f,
        0.5059f,    0.5059f,    0.5059f,    1.0000f,
        0.5098f,    0.5098f,    0.5098f,    1.0000f,
        0.5137f,    0.5137f,    0.5137f,    1.0000f,
        0.5176f,    0.5176f,    0.5176f,    1.0000f,
        0.5216f,    0.5216f,    0.5216f,    1.0000f,
        0.5255f,    0.5255f,    0.5255f,    1.0000f,
        0.5294f,    0.5294f,    0.5294f,    1.0000f,
        0.5333f,    0.5333f,    0.5333f,    1.0000f,
        0.5373f,    0.5373f,    0.5373f,    1.0000f,
        0.5412f,    0.5412f,    0.5412f,    1.0000f,
        0.5451f,    0.5451f,    0.5451f,    1.0000f,
        0.5490f,    0.5490f,    0.5490f,    1.0000f,
        0.5529f,    0.5529f,    0.5529f,    1.0000f,
        0.5569f,    0.5569f,    0.5569f,    1.0000f,
        0.5608f,    0.5608f,    0.5608f,    1.0000f,
        0.5647f,    0.5647f,    0.5647f,    1.0000f,
        0.5686f,    0.5686f,    0.5686f,    1.0000f,
        0.5725f,    0.5725f,    0.5725f,    1.0000f,
        0.5765f,    0.5765f,    0.5765f,    1.0000f,
        0.5804f,    0.5804f,    0.5804f,    1.0000f,
        0.5843f,    0.5843f,    0.5843f,    1.0000f,
        0.5882f,    0.5882f,    0.5882f,    1.0000f,
        0.5922f,    0.5922f,    0.5922f,    1.0000f,
        0.5961f,    0.5961f,    0.5961f,    1.0000f,
        0.6000f,    0.6000f,    0.6000f,    1.0000f,
        0.6039f,    0.6039f,    0.6039f,    1.0000f,
        0.6078f,    0.6078f,    0.6078f,    1.0000f,
        0.6118f,    0.6118f,    0.6118f,    1.0000f,
        0.6157f,    0.6157f,    0.6157f,    1.0000f,
        0.6196f,    0.6196f,    0.6196f,    1.0000f,
        0.6235f,    0.6235f,    0.6235f,    1.0000f,
        0.6275f,    0.6275f,    0.6275f,    1.0000f,
        0.6314f,    0.6314f,    0.6314f,    1.0000f,
        0.6353f,    0.6353f,    0.6353f,    1.0000f,
        0.6392f,    0.6392f,    0.6392f,    1.0000f,
        0.6431f,    0.6431f,    0.6431f,    1.0000f,
        0.6471f,    0.6471f,    0.6471f,    1.0000f,
        0.6510f,    0.6510f,    0.6510f,    1.0000f,
        0.6549f,    0.6549f,    0.6549f,    1.0000f,
        0.6588f,    0.6588f,    0.6588f,    1.0000f,
        0.6627f,    0.6627f,    0.6627f,    1.0000f,
        0.6667f,    0.6667f,    0.6667f,    1.0000f,
        0.6706f,    0.6706f,    0.6706f,    1.0000f,
        0.6745f,    0.6745f,    0.6745f,    1.0000f,
        0.6784f,    0.6784f,    0.6784f,    1.0000f,
        0.6824f,    0.6824f,    0.6824f,    1.0000f,
        0.6863f,    0.6863f,    0.6863f,    1.0000f,
        0.6902f,    0.6902f,    0.6902f,    1.0000f,
        0.6941f,    0.6941f,    0.6941f,    1.0000f,
        0.6980f,    0.6980f,    0.6980f,    1.0000f,
        0.7020f,    0.7020f,    0.7020f,    1.0000f,
        0.7059f,    0.7059f,    0.7059f,    1.0000f,
        0.7098f,    0.7098f,    0.7098f,    1.0000f,
        0.7137f,    0.7137f,    0.7137f,    1.0000f,
        0.7176f,    0.7176f,    0.7176f,    1.0000f,
        0.7216f,    0.7216f,    0.7216f,    1.0000f,
        0.7255f,    0.7255f,    0.7255f,    1.0000f,
        0.7294f,    0.7294f,    0.7294f,    1.0000f,
        0.7333f,    0.7333f,    0.7333f,    1.0000f,
        0.7373f,    0.7373f,    0.7373f,    1.0000f,
        0.7412f,    0.7412f,    0.7412f,    1.0000f,
        0.7451f,    0.7451f,    0.7451f,    1.0000f,
        0.7490f,    0.7490f,    0.7490f,    1.0000f,
        0.7529f,    0.7529f,    0.7529f,    1.0000f,
        0.7569f,    0.7569f,    0.7569f,    1.0000f,
        0.7608f,    0.7608f,    0.7608f,    1.0000f,
        0.7647f,    0.7647f,    0.7647f,    1.0000f,
        0.7686f,    0.7686f,    0.7686f,    1.0000f,
        0.7725f,    0.7725f,    0.7725f,    1.0000f,
        0.7765f,    0.7765f,    0.7765f,    1.0000f,
        0.7804f,    0.7804f,    0.7804f,    1.0000f,
        0.7843f,    0.7843f,    0.7843f,    1.0000f,
        0.7882f,    0.7882f,    0.7882f,    1.0000f,
        0.7922f,    0.7922f,    0.7922f,    1.0000f,
        0.7961f,    0.7961f,    0.7961f,    1.0000f,
        0.8000f,    0.8000f,    0.8000f,    1.0000f,
        0.8039f,    0.8039f,    0.8039f,    1.0000f,
        0.8078f,    0.8078f,    0.8078f,    1.0000f,
        0.8118f,    0.8118f,    0.8118f,    1.0000f,
        0.8157f,    0.8157f,    0.8157f,    1.0000f,
        0.8196f,    0.8196f,    0.8196f,    1.0000f,
        0.8235f,    0.8235f,    0.8235f,    1.0000f,
        0.8275f,    0.8275f,    0.8275f,    1.0000f,
        0.8314f,    0.8314f,    0.8314f,    1.0000f,
        0.8353f,    0.8353f,    0.8353f,    1.0000f,
        0.8392f,    0.8392f,    0.8392f,    1.0000f,
        0.8431f,    0.8431f,    0.8431f,    1.0000f,
        0.8471f,    0.8471f,    0.8471f,    1.0000f,
        0.8510f,    0.8510f,    0.8510f,    1.0000f,
        0.8549f,    0.8549f,    0.8549f,    1.0000f,
        0.8588f,    0.8588f,    0.8588f,    1.0000f,
        0.8627f,    0.8627f,    0.8627f,    1.0000f,
        0.8667f,    0.8667f,    0.8667f,    1.0000f,
        0.8706f,    0.8706f,    0.8706f,    1.0000f,
        0.8745f,    0.8745f,    0.8745f,    1.0000f,
        0.8784f,    0.8784f,    0.8784f,    1.0000f,
        0.8824f,    0.8824f,    0.8824f,    1.0000f,
        0.8863f,    0.8863f,    0.8863f,    1.0000f,
        0.8902f,    0.8902f,    0.8902f,    1.0000f,
        0.8941f,    0.8941f,    0.8941f,    1.0000f,
        0.8980f,    0.8980f,    0.8980f,    1.0000f,
        0.9020f,    0.9020f,    0.9020f,    1.0000f,
        0.9059f,    0.9059f,    0.9059f,    1.0000f,
        0.9098f,    0.9098f,    0.9098f,    1.0000f,
        0.9137f,    0.9137f,    0.9137f,    1.0000f,
        0.9176f,    0.9176f,    0.9176f,    1.0000f,
        0.9216f,    0.9216f,    0.9216f,    1.0000f,
        0.9255f,    0.9255f,    0.9255f,    1.0000f,
        0.9294f,    0.9294f,    0.9294f,    1.0000f,
        0.9333f,    0.9333f,    0.9333f,    1.0000f,
        0.9373f,    0.9373f,    0.9373f,    1.0000f,
        0.9412f,    0.9412f,    0.9412f,    1.0000f,
        0.9451f,    0.9451f,    0.9451f,    1.0000f,
        0.9490f,    0.9490f,    0.9490f,    1.0000f,
        0.9529f,    0.9529f,    0.9529f,    1.0000f,
        0.9569f,    0.9569f,    0.9569f,    1.0000f,
        0.9608f,    0.9608f,    0.9608f,    1.0000f,
        0.9647f,    0.9647f,    0.9647f,    1.0000f,
        0.9686f,    0.9686f,    0.9686f,    1.0000f,
        0.9725f,    0.9725f,    0.9725f,    1.0000f,
        0.9765f,    0.9765f,    0.9765f,    1.0000f,
        0.9804f,    0.9804f,    0.9804f,    1.0000f,
        0.9843f,    0.9843f,    0.9843f,    1.0000f,
        0.9882f,    0.9882f,    0.9882f,    1.0000f,
        0.9922f,    0.9922f,    0.9922f,    1.0000f,
        0.9961f,    0.9961f,    0.9961f,    1.0000f,
        1.0000f,    1.0000f,    1.0000f,    1.0000f,
};

/**
 * Reference: https://en.wikipedia.org/wiki/SRGB#The_forward_transformation_.28CIE_xyY_or_CIE_XYZ_to_sRGB.29
 *
 * CIE XYZ LMS fundamental values are created using tool at the following URL
 *
 * http://cvrl.ioo.ucl.ac.uk/cmfs.htm
 *
 * The following octave script is used to generate the
 * spectrum (wavelength range of 390nm to 830nm) color map values.
 *
 * ```
 *      lin2012xyz2e_5_7sf = csvread("lin2012xyz2e_1_7sf.csv");
 *      lambda = transpose(lin2012xyz2e_5_7sf(:,1));
 *      lms = transpose(lin2012xyz2e_5_7sf(:,2:4));
 *      XYZ_to_sRGB = [  3.2404542, -1.5371385, -0.4985314;
 *                      -0.9692660,  1.8760108,  0.0415560;
 *                       0.0556434, -0.2040259,  1.0572252];
 *      lrgb = XYZ_to_sRGB * lms;
 *      crgb = lrgb / max(max(lrgb));
 *      crgb = (crgb > 0.0) .* crgb;
 *      bt = (abs(crgb) <= 0.0031308)*12.92.*abs(crgb);
 *      at = (abs(crgb) > 0.0031308).*(1.055*(abs(crgb).^(1/2.4))-0.055);
 *      srgb = bt+at;
 *
 *      wvl_2s = 390:1.72:830;
 *
 *      rInter = spline(lambda, srgb(1, :), wvl_2s);
 *      gInter = spline(lambda, srgb(2, :), wvl_2s);
 *      bInter = spline(lambda, srgb(3, :), wvl_2s);
 *
 *      rgb = [rInter; gInter; bInter];
 *
 *      rgb = (rgb > 0.0) .* rgb;
 * ```
 * */
float cmap_spectrum[] =
{
    0.01127986   , 0             , 0.08038571    , 1.0 ,
    0.01541133   , 4.283736e-43  , 0.0994883     , 1.0 ,
    0.02097097   , 4.675581e-42  , 0.1211598     , 1.0 ,
    0.02837203   , 2.314546e-41  , 0.1455531     , 1.0 ,
    0.03811155   , -0            , 0.1727644     , 1.0 ,
    0.04989037   , -0            , 0.2028092     , 1.0 ,
    0.06264411   , -0            , 0.235596      , 1.0 ,
    0.07631406   , -0            , 0.2709367     , 1.0 ,
    0.09082561   , 2.530498e-36  , 0.3085978     , 1.0 ,
    0.1060682    , 3.623732e-35  , 0.3482384     , 1.0 ,
    0.1217975    , 2.164607e-34  , 0.3893565     , 1.0 ,
    0.1375286    , -0            , 0.4312382     , 1.0 ,
    0.1526427    , -0            , 0.4729976     , 1.0 ,
    0.166727     , -0            , 0.5139013     , 1.0 ,
    0.1798212    , -0            , 0.5536313     , 1.0 ,
    0.192078     , 1.678153e-29  , 0.5919745     , 1.0 ,
    0.2032983    , 2.7707e-28    , 0.628283      , 1.0 ,
    0.2127799    , 1.928899e-27  , 0.6612911     , 1.0 ,
    0.2197537    , -0            , 0.6897002     , 1.0 ,
    0.2242968    , -0            , 0.7138056     , 1.0 ,
    0.2273781    , -0            , 0.735532      , 1.0 ,
    0.2300782    , -0            , 0.7569831     , 1.0 ,
    0.2323746    , 1.064461e-22  , 0.7783009     , 1.0 ,
    0.2333157    , 2.08705e-21   , 0.7981219     , 1.0 ,
    0.2318672    , 1.659222e-20  , 0.8151398     , 1.0 ,
    0.2282162    , 0             , 0.8298212     , 1.0 ,
    0.2234862    , -0            , 0.8436805     , 1.0 ,
    0.2189124    , -0            , 0.857939      , 1.0 ,
    0.2139276    , -0            , 0.8711407     , 1.0 ,
    0.20688      , 6.308637e-16  , 0.8806263     , 1.0 ,
    0.196124     , 1.548245e-14  , 0.8843348     , 1.0 ,
    0.1817944    , 1.388462e-13  , 0.8836006     , 1.0 ,
    0.1646237    , 2.019828e-13  , 0.8808589     , 1.0 ,
    0.1448725    , -0            , 0.87777       , 1.0 ,
    0.1206251    , -0            , 0.8730883     , 1.0 ,
    0.08744735   , -0            , 0.8649303     , 1.0 ,
    0.02884395   , 3.313162e-09  , 0.852481      , 1.0 ,
    -0           , 1.130061e-07  , 0.8377385     , 1.0 ,
    -0           , 1.135899e-06  , 0.8230781     , 1.0 ,
    -0           , 3.104831e-06  , 0.8101432     , 1.0 ,
    9.696992e-07 , -0            , 0.7992217     , 1.0 ,
    1.623357e-07 , -0            , 0.7904213     , 1.0 ,
    1.133611e-08 , 0.03271853    , 0.7830682     , 1.0 ,
    -0           , 0.1042402     , 0.775201      , 1.0 ,
    -0           , 0.1493461     , 0.7648243     , 1.0 ,
    -0           , 0.1862506     , 0.7508291     , 1.0 ,
    -0           , 0.218295      , 0.7332213     , 1.0 ,
    1.036851e-13 , 0.24667       , 0.7121434     , 1.0 ,
    2.091245e-14 , 0.2720625     , 0.6880738     , 1.0 ,
    1.655202e-15 , 0.2950642     , 0.6617792     , 1.0 ,
    0            , 0.316165      , 0.6339956     , 1.0 ,
    -0           , 0.335616      , 0.6055155     , 1.0 ,
    -0           , 0.3535343     , 0.5771365     , 1.0 ,
    -0           , 0.3700778     , 0.5494901     , 1.0 ,
    1.03101e-20  , 0.3854382     , 0.5224723     , 1.0 ,
    2.651547e-21 , 0.3997472     , 0.4955986     , 1.0 ,
    2.356953e-22 , 0.4131009     , 0.4685543     , 1.0 ,
    3.785627e-24 , 0.4259492     , 0.4419153     , 1.0 ,
    -0           , 0.4389883     , 0.4165396     , 1.0 ,
    -0           , 0.4528801     , 0.39298       , 1.0 ,
    -0           , 0.4676521     , 0.3708999     , 1.0 ,
    9.032476e-28 , 0.4830383     , 0.3497093     , 1.0 ,
    3.304511e-28 , 0.4987859     , 0.3288291     , 1.0 ,
    3.286476e-29 , 0.5149212     , 0.3074874     , 1.0 ,
    9.348463e-31 , 0.5315348     , 0.2848347     , 1.0 ,
    3.681496e-31 , 0.5486496     , 0.2600424     , 1.0 ,
    1.011684e-29 , 0.5661069     , 0.2324497     , 1.0 ,
    7.071628e-29 , 0.5836924     , 0.2011177     , 1.0 ,
    -0           , 0.6011751     , 0.1647146     , 1.0 ,
    -0           , 0.6183319     , 0.1210504     , 1.0 ,
    -0           , 0.6349509     , 0.06055694    , 1.0 ,
    -0           , 0.6509092     , -0            , 1.0 ,
    3.902632e-24 , 0.6662545     , 0.0001858718  , 1.0 ,
    7.651746e-23 , 0.6810419     , 3.748884e-05  , 1.0 ,
    6.083201e-22 , 0.6950991     , 2.967208e-06  , 1.0 ,
    0            , 0.7078848     , 0             , 1.0 ,
    -0           , 0.7188129     , -0            , 1.0 ,
    -0           , 0.7277558     , -0            , 1.0 ,
    -0           , 0.7351898     , -0            , 1.0 ,
    2.312934e-17 , 0.7416417     , 1.848247e-11  , 1.0 ,
    5.676326e-16 , 0.747321      , 4.753313e-12  , 1.0 ,
    5.090515e-15 , 0.7521157     , 4.225207e-13  , 1.0 ,
    7.405291e-15 , 0.7559187     , 6.786328e-15  , 1.0 ,
    -0           , 0.7588835     , -0            , 1.0 ,
    -0           , 0.7613638     , -0            , 1.0 ,
    -0           , 0.7636751     , -0            , 1.0 ,
    1.214704e-10 , 0.7656616     , 1.619213e-18  , 1.0 ,
    4.143139e-09 , 0.7668859     , 5.923872e-19  , 1.0 ,
    4.164544e-08 , 0.7669441     , 5.893425e-20  , 1.0 ,
    1.138323e-07 , 0.7657159     , 1.72786e-21   , 1.0 ,
    -0           , 0.763215      , -0            , 1.0 ,
    -0           , 0.7595283     , -0            , 1.0 ,
    -0           , 0.7551301     , -0            , 1.0 ,
    0.000477086  , 0.7506213     , 1.053369e-25  , 1.0 ,
    0.05939901   , 0.7463866     , 7.241023e-26  , 1.0 ,
    0.202861     , 0.7419336     , 8.074312e-27  , 1.0 ,
    0.2856093    , 0.7365457     , 3.290042e-28  , 1.0 ,
    0.3508833    , 0.729783      , -0            , 1.0 ,
    0.4059397    , 0.7220666     , -0            , 1.0 ,
    0.453527     , 0.7139808     , -0            , 1.0 ,
    0.4956772    , 0.7058158     , 0             , 1.0 ,
    0.5347564    , 0.6971628     , 8.653073e-33  , 1.0 ,
    0.5723221    , 0.6875168     , 1.088426e-33  , 1.0 ,
    0.6088265    , 0.676611      , 5.551314e-35  , 1.0 ,
    0.6436856    , 0.6646189     , -0            , 1.0 ,
    0.6764169    , 0.6517598     , -0            , 1.0 ,
    0.7069315    , 0.638036      , -0            , 1.0 ,
    0.7354506    , 0.6231365     , -0            , 1.0 ,
    0.7620698    , 0.6067575     , 1.005948e-39  , 1.0 ,
    0.7871517    , 0.5889929     , 1.444958e-40  , 1.0 ,
    0.8115048    , 0.5703457     , 8.751802e-42  , 1.0 ,
    0.8359523    , 0.5512596     , -0            , 1.0 ,
    0.8601499    , 0.5318565     , -0            , 1.0 ,
    0.882742     , 0.5120416     , -0            , 1.0 ,
    0.9025234    , 0.4917644     , -0            , 1.0 ,
    0.9195204    , 0.470838      , 1.128873e-46  , 1.0 ,
    0.9345009    , 0.4489329     , 1.889827e-47  , 1.0 ,
    0.9480608    , 0.4257168     , 1.31969e-48   , 1.0 ,
    0.9601983    , 0.4011625     , -0            , 1.0 ,
    0.9706579    , 0.3754125     , -0            , 1.0 ,
    0.9792892    , 0.3485489     , -0            , 1.0 ,
    0.9862737    , 0.3203481     , -0            , 1.0 ,
    0.9918932    , 0.2903512     , 1.207048e-53  , 1.0 ,
    0.9963008    , 0.257945      , 2.434517e-54  , 1.0 ,
    0.9991509    , 0.2225878     , 1.926899e-55  , 1.0 ,
    1            , 0.1833567     , 0             , 1.0 ,
    0.9985792    , 0.1379186     , -0            , 1.0 ,
    0.9950785    , 0.07789979    , -0            , 1.0 ,
    0.9897852    , -0            , -0            , 1.0 ,
    0.9829172    , 0.0002535774  , 1.200248e-60  , 1.0 ,
    0.9745285    , 6.521493e-05  , 3.086791e-61  , 1.0 ,
    0.9646424    , 5.796938e-06  , 2.743841e-62  , 1.0 ,
    0.9533994    , 9.310768e-08  , 4.407027e-64  , 1.0 ,
    0.9411956    , -0            , -0            , 1.0 ,
    0.9284233    , -0            , -0            , 1.0 ,
    0.9150054    , -0            , -0            , 1.0 ,
    0.9001256    , 2.221542e-11  , 1.051513e-67  , 1.0 ,
    0.8830108    , 8.127488e-12  , 3.846951e-68  , 1.0 ,
    0.8636108    , 8.085714e-13  , 3.827178e-69  , 1.0 ,
    0.8427338    , 2.370605e-14  , 1.122069e-70  , 1.0 ,
    0.8211542    , -0            , -0            , 1.0 ,
    0.7993154    , -0            , -0            , 1.0 ,
    0.7773565    , -0            , -0            , 1.0 ,
    0.7553974    , 1.44521e-18   , 6.840554e-75  , 1.0 ,
    0.733615     , 9.934605e-19  , 4.702305e-75  , 1.0 ,
    0.7122149    , 1.107787e-19  , 5.243442e-76  , 1.0 ,
    0.6913219    , 4.513902e-21  , 2.136547e-77  , 1.0 ,
    0.6704993    , -0            , -0            , 1.0 ,
    0.6490373    , -0            , -0            , 1.0 ,
    0.6264233    , -0            , -0            , 1.0 ,
    0.6029169    , 0             , 0             , 1.0 ,
    0.5790875    , 1.187192e-25  , 5.619288e-82  , 1.0 ,
    0.555396     , 1.493308e-26  , 7.068214e-83  , 1.0 ,
    0.5320582    , 7.616342e-28  , 3.605012e-84  , 1.0 ,
    0.5091932    , -0            , -0            , 1.0 ,
    0.4868896    , -0            , -0            , 1.0 ,
    0.4651525    , -0            , -0            , 1.0 ,
    0.4439647    , -0            , -0            , 1.0 ,
    0.4233143    , 1.380149e-32  , 6.532603e-89  , 1.0 ,
    0.4031979    , 1.982467e-33  , 9.38353e-90   , 1.0 ,
    0.3836147    , 1.200738e-34  , 5.683402e-91  , 1.0 ,
    0.364568     , -0            , -0            , 1.0 ,
    0.3460668    , -0            , -0            , 1.0 ,
    0.328118     , -0            , -0            , 1.0 ,
    0.31072      , -0            , -0            , 1.0 ,
    0.2938603    , 1.548801e-39  , 7.330877e-96  , 1.0 ,
    0.2775262    , 2.592822e-40  , 1.22725e-96   , 1.0 ,
    0.2617186    , 1.8106e-41    , 8.57004e-98   , 1.0 ,
    0.2464574    , -0            , -0            , 1.0 ,
    0.2317579    , -0            , -0            , 1.0 ,
    0.2175854    , -0            , -0            , 1.0 ,
    0.2038544    , -0            , -0            , 1.0 ,
    0.1904974    , 1.656057e-46  , 7.838545e-103 , 1.0 ,
    0.1776063    , 3.340131e-47  , 1.580971e-103 , 1.0 ,
    0.1653964    , 2.643684e-48  , 1.251324e-104 , 1.0 ,
    0.154031     , 0             , 0             , 1.0 ,
    0.1434617    , -0            , -0            , 1.0 ,
    0.1335096    , -0            , -0            , 1.0 ,
    0.1240279    , -0            , -0            , 1.0 ,
    0.1149732    , 1.646727e-53  , 7.794384e-110 , 1.0 ,
    0.1063548    , 4.235044e-54  , 2.004556e-110 , 1.0 ,
    0.09817205   , 3.76452e-55   , 1.781845e-111 , 1.0 ,
    0.09037656   , 6.046394e-57  , 2.861915e-113 , 1.0 ,
    0.08290515   , -0            , -0            , 1.0 ,
    0.07571368   , -0            , -0            , 1.0 ,
    0.06881608   , -0            , -0            , 1.0 ,
    0.06224029   , 1.442665e-60  , 6.828506e-117 , 1.0 ,
    0.05600614   , 5.277974e-61  , 2.498202e-117 , 1.0 ,
    0.05012488   , 5.250846e-62  , 2.485361e-118 , 1.0 ,
    0.04460194   , 1.539466e-63  , 7.286692e-120 , 1.0 ,
    0.03941653   , -0            , -0            , 1.0 ,
    0.03471122   , -0            , -0            , 1.0 ,
    0.03057      , -0            , -0            , 1.0 ,
    0.02691357   , 9.385166e-68  , 4.442242e-124 , 1.0 ,
    0.02369874   , 6.451512e-68  , 3.053667e-124 , 1.0 ,
    0.0208857    , 7.193945e-69  , 3.40508e-125  , 1.0 ,
    0.01842852   , 2.931319e-70  , 1.387469e-126 , 1.0 ,
    0.01627408   , -0            , -0            , 1.0 ,
    0.01437737   , -0            , -0            , 1.0 ,
    0.01270179   , -0            , -0            , 1.0 ,
    0.01121754   , 0             , 0             , 1.0 ,
    0.009899972  , 7.709602e-75  , 3.649154e-131 , 1.0 ,
    0.008734158  , 9.697513e-76  , 4.590084e-132 , 1.0 ,
    0.007712007  , 4.946037e-77  , 2.341087e-133 , 1.0 ,
    0.006823059  , -0            , -0            , 1.0 ,
    0.006048222  , -0            , -0            , 1.0 ,
    0.005364949  , -0            , -0            , 1.0 ,
    0.004756176  , -0            , -0            , 1.0 ,
    0.004213659  , 8.96266e-82   , 4.242259e-138 , 1.0 ,
    0.003733352  , 1.28741e-82   , 6.093645e-139 , 1.0 ,
    0.003310483  , 7.797566e-84  , 3.69079e-140  , 1.0 ,
    0.002938437  , -0            , -0            , 1.0 ,
    0.00261044   , -0            , -0            , 1.0 ,
    0.002320674  , -0            , -0            , 1.0 ,
    0.002063942  , -0            , -0            , 1.0 ,
    0.001835774  , 1.005788e-88  , 4.760656e-145 , 1.0 ,
    0.001632613  , 1.683773e-89  , 7.969734e-146 , 1.0 ,
    0.001452329  , 1.1758e-90    , 5.565367e-147 , 1.0 ,
    0.001293112  , -0            , -0            , 1.0 ,
    0.001152818  , -0            , -0            , 1.0 ,
    0.001028356  , -0            , -0            , 1.0 ,
    0.0009169919 , -0            , -0            , 1.0 ,
    0.0008169642 , 1.07544e-95   , 5.090335e-152 , 1.0 ,
    0.0007278915 , 2.169074e-96  , 1.026679e-152 , 1.0 ,
    0.0006493738 , 1.716803e-97  , 8.126072e-154 , 1.0 ,
    0.0005804669 , 0             , 0             , 1.0 ,
    0.0005195018 , -0            , -0            , 1.0 ,
    0.0004650555 , -0            , -0            , 1.0 ,
    0.0004161944 , -0            , -0            , 1.0 ,
    0.0003724622 , 1.069381e-102 , 5.061657e-159 , 1.0 ,
    0.0003334429 , 2.750229e-103 , 1.301755e-159 , 1.0 ,
    0.0002986586 , 2.444671e-104 , 1.157126e-160 , 1.0 ,
    0.0002675824 , 3.926516e-106 , 1.858521e-162 , 1.0 ,
    0.0002397598 , -0            , -0            , 1.0 ,
    0.000214852  , -0            , -0            , 1.0 ,
    0.0001926076 , -0            , -0            , 1.0 ,
    0.0001727859 , 9.368637e-110 , 4.434418e-166 , 1.0 ,
    0.0001551329 , 3.427506e-110 , 1.622327e-166 , 1.0 ,
    0.0001393986 , 3.409889e-111 , 1.613989e-167 , 1.0 ,
    0.0001253597 , 9.997262e-113 , 4.731963e-169 , 1.0 ,
    0.0001127865 , -0            , -0            , 1.0 ,
    0.0001014646 , -0            , -0            , 1.0 ,
    9.122623e-05 , -0            , -0            , 1.0 ,
    8.19908e-05  , 6.094707e-117 , 2.884783e-173 , 1.0 ,
    7.370771e-05 , 4.189599e-117 , 1.983045e-173 , 1.0 ,
    6.631398e-05 , 4.671733e-118 , 2.211252e-174 , 1.0 ,
    5.972128e-05 , 1.903592e-119 , 9.010195e-176 , 1.0 ,
    5.384015e-05 , -0            , -0            , 1.0 ,
    4.858824e-05 , -0            , -0            , 1.0 ,
    4.387946e-05 , -0            , -0            , 1.0 ,
    3.963764e-05 , 0             , 0             , 1.0 ,
    3.580377e-05 , 5.0066e-124   , 2.369753e-180 , 1.0 ,
    3.234196e-05 , 6.297548e-125 , 2.980792e-181 , 1.0 ,
    2.92219e-05  , 3.212085e-126 , 1.520363e-182 , 1.0 ,
    2.641456e-05 , -0            , -0            , 1.0 ,
    2.389238e-05 , -0            , -0            , 1.0 ,
};

float cmap_rainbow[] =
{
    1.000000, 0.000000, 0.164706, 1.0,
    1.000000, 0.000000, 0.142745, 1.0,
    1.000000, 0.000000, 0.124183, 1.0,
    1.000000, 0.000000, 0.105882, 1.0,
    1.000000, 0.000000, 0.084706, 1.0,
    1.000000, 0.000000, 0.065359, 1.0,
    1.000000, 0.000000, 0.047059, 1.0,
    1.000000, 0.000000, 0.026667, 1.0,
    1.000000, 0.009150, 0.008366, 1.0,
    1.000000, 0.029020, 0.000000, 1.0,
    1.000000, 0.049673, 0.000000, 1.0,
    1.000000, 0.069020, 0.000000, 1.0,
    1.000000, 0.090196, 0.000000, 1.0,
    1.000000, 0.108497, 0.000000, 1.0,
    1.000000, 0.127059, 0.000000, 1.0,
    1.000000, 0.149020, 0.000000, 1.0,
    1.000000, 0.167320, 0.000000, 1.0,
    1.000000, 0.185621, 0.000000, 1.0,
    1.000000, 0.207059, 0.000000, 1.0,
    1.000000, 0.226144, 0.000000, 1.0,
    1.000000, 0.247059, 0.000000, 1.0,
    1.000000, 0.266667, 0.000000, 1.0,
    1.000000, 0.284967, 0.000000, 1.0,
    1.000000, 0.305098, 0.000000, 1.0,
    1.000000, 0.333333, 0.000000, 1.0,
    1.000000, 0.364706, 0.000000, 1.0,
    1.000000, 0.385621, 0.000000, 1.0,
    1.000000, 0.404706, 0.000000, 1.0,
    1.000000, 0.426144, 0.000000, 1.0,
    1.000000, 0.444444, 0.000000, 1.0,
    1.000000, 0.462745, 0.000000, 1.0,
    1.000000, 0.484706, 0.000000, 1.0,
    1.000000, 0.503268, 0.000000, 1.0,
    1.000000, 0.524706, 0.000000, 1.0,
    1.000000, 0.543791, 0.000000, 1.0,
    1.000000, 0.562091, 0.000000, 1.0,
    1.000000, 0.582745, 0.000000, 1.0,
    1.000000, 0.602614, 0.000000, 1.0,
    1.000000, 0.620915, 0.000000, 1.0,
    1.000000, 0.640784, 0.000000, 1.0,
    1.000000, 0.669281, 0.000000, 1.0,
    1.000000, 0.703268, 0.000000, 1.0,
    1.000000, 0.721569, 0.000000, 1.0,
    1.000000, 0.740392, 0.000000, 1.0,
    1.000000, 0.762091, 0.000000, 1.0,
    1.000000, 0.780392, 0.000000, 1.0,
    1.000000, 0.798693, 0.000000, 1.0,
    1.000000, 0.820392, 0.000000, 1.0,
    1.000000, 0.839216, 0.000000, 1.0,
    1.000000, 0.860392, 0.000000, 1.0,
    1.000000, 0.879739, 0.000000, 1.0,
    1.000000, 0.898039, 0.000000, 1.0,
    1.000000, 0.918431, 0.000000, 1.0,
    1.000000, 0.938562, 0.000000, 1.0,
    1.000000, 0.956863, 0.000000, 1.0,
    1.000000, 0.976471, 0.000000, 1.0,
    0.989543, 0.994248, 0.000000, 1.0,
    0.956863, 1.000000, 0.000000, 1.0,
    0.938562, 1.000000, 0.000000, 1.0,
    0.920000, 1.000000, 0.000000, 1.0,
    0.898039, 1.000000, 0.000000, 1.0,
    0.879739, 1.000000, 0.000000, 1.0,
    0.861438, 1.000000, 0.000000, 1.0,
    0.840000, 1.000000, 0.000000, 1.0,
    0.820915, 1.000000, 0.000000, 1.0,
    0.800000, 1.000000, 0.000000, 1.0,
    0.780392, 1.000000, 0.000000, 1.0,
    0.762092, 1.000000, 0.000000, 1.0,
    0.741961, 1.000000, 0.000000, 1.0,
    0.721569, 1.000000, 0.000000, 1.0,
    0.701961, 1.000000, 0.000000, 1.0,
    0.681046, 1.000000, 0.000000, 1.0,
    0.658039, 1.000000, 0.000000, 1.0,
    0.620915, 1.000000, 0.000000, 1.0,
    0.602614, 1.000000, 0.000000, 1.0,
    0.584314, 1.000000, 0.000000, 1.0,
    0.562353, 1.000000, 0.000000, 1.0,
    0.543791, 1.000000, 0.000000, 1.0,
    0.522353, 1.000000, 0.000000, 1.0,
    0.503268, 1.000000, 0.000000, 1.0,
    0.484967, 1.000000, 0.000000, 1.0,
    0.464314, 1.000000, 0.000000, 1.0,
    0.444444, 1.000000, 0.000000, 1.0,
    0.426144, 1.000000, 0.000000, 1.0,
    0.406275, 1.000000, 0.000000, 1.0,
    0.385621, 1.000000, 0.000000, 1.0,
    0.366275, 1.000000, 0.000000, 1.0,
    0.345098, 1.000000, 0.000000, 1.0,
    0.323660, 1.000000, 0.000000, 1.0,
    0.284967, 1.000000, 0.000000, 1.0,
    0.266667, 1.000000, 0.000000, 1.0,
    0.248366, 1.000000, 0.000000, 1.0,
    0.226667, 1.000000, 0.000000, 1.0,
    0.207843, 1.000000, 0.000000, 1.0,
    0.186667, 1.000000, 0.000000, 1.0,
    0.167320, 1.000000, 0.000000, 1.0,
    0.149020, 1.000000, 0.000000, 1.0,
    0.128627, 1.000000, 0.000000, 1.0,
    0.108497, 1.000000, 0.000000, 1.0,
    0.088627, 1.000000, 0.000000, 1.0,
    0.067974, 1.000000, 0.000000, 1.0,
    0.049673, 1.000000, 0.000000, 1.0,
    0.030588, 1.000000, 0.000000, 1.0,
    0.010196, 1.000000, 0.000523, 1.0,
    0.000000, 1.000000, 0.006797, 1.0,
    0.000000, 1.000000, 0.047059, 1.0,
    0.000000, 1.000000, 0.065359, 1.0,
    0.000000, 1.000000, 0.087059, 1.0,
    0.000000, 1.000000, 0.105882, 1.0,
    0.000000, 1.000000, 0.124183, 1.0,
    0.000000, 1.000000, 0.145098, 1.0,
    0.000000, 1.000000, 0.164706, 1.0,
    0.000000, 1.000000, 0.183007, 1.0,
    0.000000, 1.000000, 0.203137, 1.0,
    0.000000, 1.000000, 0.223529, 1.0,
    0.000000, 1.000000, 0.243137, 1.0,
    0.000000, 1.000000, 0.264052, 1.0,
    0.000000, 1.000000, 0.282353, 1.0,
    0.000000, 1.000000, 0.301176, 1.0,
    0.000000, 1.000000, 0.322876, 1.0,
    0.000000, 1.000000, 0.341176, 1.0,
    0.000000, 1.000000, 0.381438, 1.0,
    0.000000, 1.000000, 0.401307, 1.0,
    0.000000, 1.000000, 0.422745, 1.0,
    0.000000, 1.000000, 0.441830, 1.0,
    0.000000, 1.000000, 0.460131, 1.0,
    0.000000, 1.000000, 0.480784, 1.0,
    0.000000, 1.000000, 0.500654, 1.0,
    0.000000, 1.000000, 0.518954, 1.0,
    0.000000, 1.000000, 0.538823, 1.0,
    0.000000, 1.000000, 0.559477, 1.0,
    0.000000, 1.000000, 0.578823, 1.0,
    0.000000, 1.000000, 0.600000, 1.0,
    0.000000, 1.000000, 0.618301, 1.0,
    0.000000, 1.000000, 0.636863, 1.0,
    0.000000, 1.000000, 0.658823, 1.0,
    0.000000, 1.000000, 0.677124, 1.0,
    0.000000, 1.000000, 0.715817, 1.0,
    0.000000, 1.000000, 0.737255, 1.0,
    0.000000, 1.000000, 0.758431, 1.0,
    0.000000, 1.000000, 0.777778, 1.0,
    0.000000, 1.000000, 0.796078, 1.0,
    0.000000, 1.000000, 0.816471, 1.0,
    0.000000, 1.000000, 0.836601, 1.0,
    0.000000, 1.000000, 0.856471, 1.0,
    0.000000, 1.000000, 0.877124, 1.0,
    0.000000, 1.000000, 0.895425, 1.0,
    0.000000, 1.000000, 0.914510, 1.0,
    0.000000, 1.000000, 0.935948, 1.0,
    0.000000, 1.000000, 0.954248, 1.0,
    0.000000, 1.000000, 0.972549, 1.0,
    0.000000, 1.000000, 0.994510, 1.0,
    0.000000, 0.983007, 0.999477, 1.0,
    0.000000, 0.945882, 1.000000, 1.0,
    0.000000, 0.922876, 1.000000, 1.0,
    0.000000, 0.901961, 1.000000, 1.0,
    0.000000, 0.882353, 1.000000, 1.0,
    0.000000, 0.864052, 1.000000, 1.0,
    0.000000, 0.843922, 1.000000, 1.0,
    0.000000, 0.823529, 1.000000, 1.0,
    0.000000, 0.803922, 1.000000, 1.0,
    0.000000, 0.783007, 1.000000, 1.0,
    0.000000, 0.764706, 1.000000, 1.0,
    0.000000, 0.745882, 1.000000, 1.0,
    0.000000, 0.724183, 1.000000, 1.0,
    0.000000, 0.705882, 1.000000, 1.0,
    0.000000, 0.683922, 1.000000, 1.0,
    0.000000, 0.665360, 1.000000, 1.0,
    0.000000, 0.647059, 1.000000, 1.0,
    0.000000, 0.611503, 1.000000, 1.0,
    0.000000, 0.586928, 1.000000, 1.0,
    0.000000, 0.566275, 1.000000, 1.0,
    0.000000, 0.546405, 1.000000, 1.0,
    0.000000, 0.526275, 1.000000, 1.0,
    0.000000, 0.505882, 1.000000, 1.0,
    0.000000, 0.487582, 1.000000, 1.0,
    0.000000, 0.468235, 1.000000, 1.0,
    0.000000, 0.447059, 1.000000, 1.0,
    0.000000, 0.428758, 1.000000, 1.0,
    0.000000, 0.410196, 1.000000, 1.0,
    0.000000, 0.388235, 1.000000, 1.0,
    0.000000, 0.369935, 1.000000, 1.0,
    0.000000, 0.348235, 1.000000, 1.0,
    0.000000, 0.329412, 1.000000, 1.0,
    0.000000, 0.311111, 1.000000, 1.0,
    0.000000, 0.277124, 1.000000, 1.0,
    0.000000, 0.250980, 1.000000, 1.0,
    0.000000, 0.230588, 1.000000, 1.0,
    0.000000, 0.210458, 1.000000, 1.0,
    0.000000, 0.190588, 1.000000, 1.0,
    0.000000, 0.169935, 1.000000, 1.0,
    0.000000, 0.151634, 1.000000, 1.0,
    0.000000, 0.132549, 1.000000, 1.0,
    0.000000, 0.111111, 1.000000, 1.0,
    0.000000, 0.092549, 1.000000, 1.0,
    0.000000, 0.070588, 1.000000, 1.0,
    0.000000, 0.052288, 1.000000, 1.0,
    0.000000, 0.033987, 1.000000, 1.0,
    0.000000, 0.012549, 1.000000, 1.0,
    0.005752, 0.002092, 1.000000, 1.0,
    0.020915, 0.000000, 1.000000, 1.0,
    0.053333, 0.000000, 1.000000, 1.0,
    0.083137, 0.000000, 1.000000, 1.0,
    0.103268, 0.000000, 1.000000, 1.0,
    0.121569, 0.000000, 1.000000, 1.0,
    0.141177, 0.000000, 1.000000, 1.0,
    0.162091, 0.000000, 1.000000, 1.0,
    0.180392, 0.000000, 1.000000, 1.0,
    0.199216, 0.000000, 1.000000, 1.0,
    0.220915, 0.000000, 1.000000, 1.0,
    0.239216, 0.000000, 1.000000, 1.0,
    0.261177, 0.000000, 1.000000, 1.0,
    0.279739, 0.000000, 1.000000, 1.0,
    0.298039, 0.000000, 1.000000, 1.0,
    0.319216, 0.000000, 1.000000, 1.0,
    0.338562, 0.000000, 1.000000, 1.0,
    0.356863, 0.000000, 1.000000, 1.0,
    0.387712, 0.000000, 1.000000, 1.0,
    0.418824, 0.000000, 1.000000, 1.0,
    0.439216, 0.000000, 1.000000, 1.0,
    0.457516, 0.000000, 1.000000, 1.0,
    0.476863, 0.000000, 1.000000, 1.0,
    0.498039, 0.000000, 1.000000, 1.0,
    0.516340, 0.000000, 1.000000, 1.0,
    0.534902, 0.000000, 1.000000, 1.0,
    0.556863, 0.000000, 1.000000, 1.0,
    0.575164, 0.000000, 1.000000, 1.0,
    0.596863, 0.000000, 1.000000, 1.0,
    0.615686, 0.000000, 1.000000, 1.0,
    0.633987, 0.000000, 1.000000, 1.0,
    0.654902, 0.000000, 1.000000, 1.0,
    0.674510, 0.000000, 1.000000, 1.0,
    0.694902, 0.000000, 1.000000, 1.0,
    0.724183, 0.000000, 1.000000, 1.0,
    0.754510, 0.000000, 1.000000, 1.0,
    0.775163, 0.000000, 1.000000, 1.0,
    0.793464, 0.000000, 1.000000, 1.0,
    0.812549, 0.000000, 1.000000, 1.0,
    0.833987, 0.000000, 1.000000, 1.0,
    0.852549, 0.000000, 1.000000, 1.0,
    0.874510, 0.000000, 1.000000, 1.0,
    0.892811, 0.000000, 1.000000, 1.0,
    0.911111, 0.000000, 1.000000, 1.0,
    0.932549, 0.000000, 1.000000, 1.0,
    0.951634, 0.000000, 1.000000, 1.0,
    0.969935, 0.000000, 1.000000, 1.0,
    0.990588, 0.000000, 0.997647, 1.0,
    1.000000, 0.000000, 0.985621, 1.0,
    1.000000, 0.000000, 0.965490, 1.0,
    1.000000, 0.000000, 0.937255, 1.0,
    1.000000, 0.000000, 0.905882, 1.0,
    1.000000, 0.000000, 0.884967, 1.0,
    1.000000, 0.000000, 0.866667, 1.0,
    1.000000, 0.000000, 0.847843, 1.0,
    1.000000, 0.000000, 0.826144, 1.0,
    1.000000, 0.000000, 0.807843, 1.0,
};

float cmap_red[] =
{
        1.0000000000f,      1.0000000000f,      1.0000000000f,      1.0000f,
        1.0000000000f,      1.0000000000f,      0.9921568627f,      1.0000f,
        1.0000000000f,      0.9960784314f,      0.9843137255f,      1.0000f,
        1.0000000000f,      0.9960784314f,      0.9764705882f,      1.0000f,
        1.0000000000f,      0.9921568627f,      0.9686274510f,      1.0000f,
        1.0000000000f,      0.9921568627f,      0.9607843137f,      1.0000f,
        1.0000000000f,      0.9921568627f,      0.9529411765f,      1.0000f,
        1.0000000000f,      0.9882352941f,      0.9490196078f,      1.0000f,
        1.0000000000f,      0.9882352941f,      0.9411764706f,      1.0000f,
        0.9960784314f,      0.9882352941f,      0.9333333333f,      1.0000f,
        0.9960784314f,      0.9843137255f,      0.9254901961f,      1.0000f,
        0.9960784314f,      0.9843137255f,      0.9176470588f,      1.0000f,
        0.9960784314f,      0.9803921569f,      0.9098039216f,      1.0000f,
        0.9960784314f,      0.9803921569f,      0.9019607843f,      1.0000f,
        0.9960784314f,      0.9803921569f,      0.8941176471f,      1.0000f,
        0.9960784314f,      0.9764705882f,      0.8862745098f,      1.0000f,
        0.9960784314f,      0.9764705882f,      0.8784313725f,      1.0000f,
        0.9960784314f,      0.9725490196f,      0.8705882353f,      1.0000f,
        0.9960784314f,      0.9725490196f,      0.8627450980f,      1.0000f,
        0.9960784314f,      0.9725490196f,      0.8549019608f,      1.0000f,
        0.9960784314f,      0.9686274510f,      0.8509803922f,      1.0000f,
        0.9960784314f,      0.9686274510f,      0.8431372549f,      1.0000f,
        0.9960784314f,      0.9686274510f,      0.8352941176f,      1.0000f,
        0.9960784314f,      0.9647058824f,      0.8274509804f,      1.0000f,
        0.9960784314f,      0.9647058824f,      0.8196078431f,      1.0000f,
        0.9960784314f,      0.9607843137f,      0.8117647059f,      1.0000f,
        0.9960784314f,      0.9607843137f,      0.8039215686f,      1.0000f,
        0.9921568627f,      0.9607843137f,      0.7960784314f,      1.0000f,
        0.9921568627f,      0.9568627451f,      0.7882352941f,      1.0000f,
        0.9921568627f,      0.9568627451f,      0.7803921569f,      1.0000f,
        0.9921568627f,      0.9529411765f,      0.7725490196f,      1.0000f,
        0.9921568627f,      0.9529411765f,      0.7647058824f,      1.0000f,
        0.9921568627f,      0.9529411765f,      0.7568627451f,      1.0000f,
        0.9921568627f,      0.9490196078f,      0.7529411765f,      1.0000f,
        0.9921568627f,      0.9490196078f,      0.7450980392f,      1.0000f,
        0.9921568627f,      0.9490196078f,      0.7372549020f,      1.0000f,
        0.9921568627f,      0.9450980392f,      0.7294117647f,      1.0000f,
        0.9921568627f,      0.9450980392f,      0.7215686275f,      1.0000f,
        0.9921568627f,      0.9411764706f,      0.7137254902f,      1.0000f,
        0.9921568627f,      0.9411764706f,      0.7058823529f,      1.0000f,
        0.9921568627f,      0.9411764706f,      0.6980392157f,      1.0000f,
        0.9921568627f,      0.9372549020f,      0.6901960784f,      1.0000f,
        0.9921568627f,      0.9372549020f,      0.6823529412f,      1.0000f,
        0.9921568627f,      0.9333333333f,      0.6745098039f,      1.0000f,
        0.9882352941f,      0.9333333333f,      0.6666666667f,      1.0000f,
        0.9882352941f,      0.9333333333f,      0.6588235294f,      1.0000f,
        0.9882352941f,      0.9294117647f,      0.6549019608f,      1.0000f,
        0.9882352941f,      0.9294117647f,      0.6470588235f,      1.0000f,
        0.9882352941f,      0.9294117647f,      0.6392156863f,      1.0000f,
        0.9882352941f,      0.9254901961f,      0.6313725490f,      1.0000f,
        0.9882352941f,      0.9254901961f,      0.6235294118f,      1.0000f,
        0.9882352941f,      0.9215686275f,      0.6078431373f,      1.0000f,
        0.9882352941f,      0.9176470588f,      0.6000000000f,      1.0000f,
        0.9882352941f,      0.9137254902f,      0.5921568627f,      1.0000f,
        0.9882352941f,      0.9098039216f,      0.5843137255f,      1.0000f,
        0.9882352941f,      0.9019607843f,      0.5764705882f,      1.0000f,
        0.9882352941f,      0.8980392157f,      0.5686274510f,      1.0000f,
        0.9882352941f,      0.8941176471f,      0.5607843137f,      1.0000f,
        0.9882352941f,      0.8901960784f,      0.5529411765f,      1.0000f,
        0.9882352941f,      0.8862745098f,      0.5450980392f,      1.0000f,
        0.9882352941f,      0.8823529412f,      0.5372549020f,      1.0000f,
        0.9882352941f,      0.8784313725f,      0.5294117647f,      1.0000f,
        0.9882352941f,      0.8745098039f,      0.5215686275f,      1.0000f,
        0.9882352941f,      0.8666666667f,      0.5137254902f,      1.0000f,
        0.9921568627f,      0.8627450980f,      0.5058823529f,      1.0000f,
        0.9921568627f,      0.8588235294f,      0.4980392157f,      1.0000f,
        0.9921568627f,      0.8549019608f,      0.4901960784f,      1.0000f,
        0.9921568627f,      0.8509803922f,      0.4823529412f,      1.0000f,
        0.9921568627f,      0.8470588235f,      0.4745098039f,      1.0000f,
        0.9921568627f,      0.8431372549f,      0.4666666667f,      1.0000f,
        0.9921568627f,      0.8352941176f,      0.4588235294f,      1.0000f,
        0.9921568627f,      0.8313725490f,      0.4509803922f,      1.0000f,
        0.9921568627f,      0.8274509804f,      0.4431372549f,      1.0000f,
        0.9921568627f,      0.8235294118f,      0.4352941176f,      1.0000f,
        0.9921568627f,      0.8196078431f,      0.4274509804f,      1.0000f,
        0.9921568627f,      0.8156862745f,      0.4196078431f,      1.0000f,
        0.9921568627f,      0.8117647059f,      0.4117647059f,      1.0000f,
        0.9921568627f,      0.8078431373f,      0.4039215686f,      1.0000f,
        0.9921568627f,      0.8000000000f,      0.3921568627f,      1.0000f,
        0.9921568627f,      0.7960784314f,      0.3843137255f,      1.0000f,
        0.9921568627f,      0.7921568627f,      0.3764705882f,      1.0000f,
        0.9921568627f,      0.7882352941f,      0.3686274510f,      1.0000f,
        0.9921568627f,      0.7843137255f,      0.3607843137f,      1.0000f,
        0.9921568627f,      0.7803921569f,      0.3529411765f,      1.0000f,
        0.9921568627f,      0.7764705882f,      0.3450980392f,      1.0000f,
        0.9921568627f,      0.7686274510f,      0.3372549020f,      1.0000f,
        0.9921568627f,      0.7647058824f,      0.3294117647f,      1.0000f,
        0.9921568627f,      0.7607843137f,      0.3215686275f,      1.0000f,
        0.9921568627f,      0.7568627451f,      0.3137254902f,      1.0000f,
        0.9921568627f,      0.7529411765f,      0.3058823529f,      1.0000f,
        0.9960784314f,      0.7490196078f,      0.2980392157f,      1.0000f,
        0.9960784314f,      0.7450980392f,      0.2901960784f,      1.0000f,
        0.9960784314f,      0.7372549020f,      0.2823529412f,      1.0000f,
        0.9960784314f,      0.7333333333f,      0.2745098039f,      1.0000f,
        0.9960784314f,      0.7294117647f,      0.2666666667f,      1.0000f,
        0.9960784314f,      0.7254901961f,      0.2588235294f,      1.0000f,
        0.9960784314f,      0.7215686275f,      0.2509803922f,      1.0000f,
        0.9960784314f,      0.7176470588f,      0.2431372549f,      1.0000f,
        0.9960784314f,      0.7137254902f,      0.2352941176f,      1.0000f,
        0.9960784314f,      0.7098039216f,      0.2274509804f,      1.0000f,
        0.9960784314f,      0.7019607843f,      0.2196078431f,      1.0000f,
        0.9960784314f,      0.6901960784f,      0.1960784314f,      1.0000f,
        0.9960784314f,      0.6862745098f,      0.1960784314f,      1.0000f,
        0.9960784314f,      0.6784313725f,      0.1960784314f,      1.0000f,
        0.9921568627f,      0.6745098039f,      0.1921568627f,      1.0000f,
        0.9921568627f,      0.6705882353f,      0.1921568627f,      1.0000f,
        0.9921568627f,      0.6627450980f,      0.1921568627f,      1.0000f,
        0.9921568627f,      0.6588235294f,      0.1921568627f,      1.0000f,
        0.9921568627f,      0.6549019608f,      0.1921568627f,      1.0000f,
        0.9921568627f,      0.6470588235f,      0.1921568627f,      1.0000f,
        0.9882352941f,      0.6431372549f,      0.1882352941f,      1.0000f,
        0.9882352941f,      0.6392156863f,      0.1882352941f,      1.0000f,
        0.9882352941f,      0.6313725490f,      0.1882352941f,      1.0000f,
        0.9882352941f,      0.6274509804f,      0.1882352941f,      1.0000f,
        0.9882352941f,      0.6235294118f,      0.1882352941f,      1.0000f,
        0.9882352941f,      0.6156862745f,      0.1882352941f,      1.0000f,
        0.9843137255f,      0.6117647059f,      0.1843137255f,      1.0000f,
        0.9843137255f,      0.6039215686f,      0.1843137255f,      1.0000f,
        0.9843137255f,      0.6000000000f,      0.1843137255f,      1.0000f,
        0.9843137255f,      0.5960784314f,      0.1843137255f,      1.0000f,
        0.9843137255f,      0.5882352941f,      0.1843137255f,      1.0000f,
        0.9843137255f,      0.5843137255f,      0.1843137255f,      1.0000f,
        0.9803921569f,      0.5803921569f,      0.1803921569f,      1.0000f,
        0.9803921569f,      0.5725490196f,      0.1803921569f,      1.0000f,
        0.9803921569f,      0.5686274510f,      0.1803921569f,      1.0000f,
        0.9803921569f,      0.5647058824f,      0.1803921569f,      1.0000f,
        0.9803921569f,      0.5568627451f,      0.1803921569f,      1.0000f,
        0.9803921569f,      0.5529411765f,      0.1803921569f,      1.0000f,
        0.9764705882f,      0.5490196078f,      0.1764705882f,      1.0000f,
        0.9764705882f,      0.5411764706f,      0.1764705882f,      1.0000f,
        0.9764705882f,      0.5372549020f,      0.1764705882f,      1.0000f,
        0.9764705882f,      0.5333333333f,      0.1764705882f,      1.0000f,
        0.9764705882f,      0.5254901961f,      0.1764705882f,      1.0000f,
        0.9725490196f,      0.5215686275f,      0.1725490196f,      1.0000f,
        0.9725490196f,      0.5176470588f,      0.1725490196f,      1.0000f,
        0.9725490196f,      0.5098039216f,      0.1725490196f,      1.0000f,
        0.9725490196f,      0.5058823529f,      0.1725490196f,      1.0000f,
        0.9725490196f,      0.5019607843f,      0.1725490196f,      1.0000f,
        0.9725490196f,      0.4941176471f,      0.1725490196f,      1.0000f,
        0.9686274510f,      0.4901960784f,      0.1686274510f,      1.0000f,
        0.9686274510f,      0.4862745098f,      0.1686274510f,      1.0000f,
        0.9686274510f,      0.4784313725f,      0.1686274510f,      1.0000f,
        0.9686274510f,      0.4745098039f,      0.1686274510f,      1.0000f,
        0.9686274510f,      0.4666666667f,      0.1686274510f,      1.0000f,
        0.9686274510f,      0.4627450980f,      0.1686274510f,      1.0000f,
        0.9647058824f,      0.4588235294f,      0.1647058824f,      1.0000f,
        0.9647058824f,      0.4509803922f,      0.1647058824f,      1.0000f,
        0.9647058824f,      0.4470588235f,      0.1647058824f,      1.0000f,
        0.9647058824f,      0.4431372549f,      0.1647058824f,      1.0000f,
        0.9647058824f,      0.4352941176f,      0.1647058824f,      1.0000f,
        0.9647058824f,      0.4313725490f,      0.1647058824f,      1.0000f,
        0.9607843137f,      0.4274509804f,      0.1607843137f,      1.0000f,
        0.9607843137f,      0.4156862745f,      0.1607843137f,      1.0000f,
        0.9568627451f,      0.4117647059f,      0.1607843137f,      1.0000f,
        0.9568627451f,      0.4039215686f,      0.1607843137f,      1.0000f,
        0.9529411765f,      0.4000000000f,      0.1607843137f,      1.0000f,
        0.9490196078f,      0.3921568627f,      0.1607843137f,      1.0000f,
        0.9490196078f,      0.3882352941f,      0.1607843137f,      1.0000f,
        0.9450980392f,      0.3803921569f,      0.1607843137f,      1.0000f,
        0.9411764706f,      0.3764705882f,      0.1607843137f,      1.0000f,
        0.9411764706f,      0.3686274510f,      0.1607843137f,      1.0000f,
        0.9372549020f,      0.3647058824f,      0.1607843137f,      1.0000f,
        0.9333333333f,      0.3607843137f,      0.1607843137f,      1.0000f,
        0.9333333333f,      0.3529411765f,      0.1607843137f,      1.0000f,
        0.9294117647f,      0.3490196078f,      0.1607843137f,      1.0000f,
        0.9294117647f,      0.3411764706f,      0.1607843137f,      1.0000f,
        0.9254901961f,      0.3372549020f,      0.1607843137f,      1.0000f,
        0.9215686275f,      0.3294117647f,      0.1607843137f,      1.0000f,
        0.9215686275f,      0.3254901961f,      0.1607843137f,      1.0000f,
        0.9176470588f,      0.3176470588f,      0.1607843137f,      1.0000f,
        0.9137254902f,      0.3137254902f,      0.1607843137f,      1.0000f,
        0.9137254902f,      0.3098039216f,      0.1607843137f,      1.0000f,
        0.9098039216f,      0.3019607843f,      0.1607843137f,      1.0000f,
        0.9058823529f,      0.2980392157f,      0.1607843137f,      1.0000f,
        0.9058823529f,      0.2901960784f,      0.1607843137f,      1.0000f,
        0.9019607843f,      0.2862745098f,      0.1607843137f,      1.0000f,
        0.8980392157f,      0.2784313725f,      0.1607843137f,      1.0000f,
        0.8980392157f,      0.2745098039f,      0.1607843137f,      1.0000f,
        0.8941176471f,      0.2705882353f,      0.1607843137f,      1.0000f,
        0.8901960784f,      0.2627450980f,      0.1568627451f,      1.0000f,
        0.8901960784f,      0.2588235294f,      0.1568627451f,      1.0000f,
        0.8862745098f,      0.2509803922f,      0.1568627451f,      1.0000f,
        0.8823529412f,      0.2470588235f,      0.1568627451f,      1.0000f,
        0.8823529412f,      0.2392156863f,      0.1568627451f,      1.0000f,
        0.8784313725f,      0.2352941176f,      0.1568627451f,      1.0000f,
        0.8745098039f,      0.2274509804f,      0.1568627451f,      1.0000f,
        0.8745098039f,      0.2235294118f,      0.1568627451f,      1.0000f,
        0.8705882353f,      0.2196078431f,      0.1568627451f,      1.0000f,
        0.8666666667f,      0.2117647059f,      0.1568627451f,      1.0000f,
        0.8666666667f,      0.2078431373f,      0.1568627451f,      1.0000f,
        0.8627450980f,      0.2000000000f,      0.1568627451f,      1.0000f,
        0.8627450980f,      0.1960784314f,      0.1568627451f,      1.0000f,
        0.8588235294f,      0.1882352941f,      0.1568627451f,      1.0000f,
        0.8549019608f,      0.1843137255f,      0.1568627451f,      1.0000f,
        0.8549019608f,      0.1764705882f,      0.1568627451f,      1.0000f,
        0.8509803922f,      0.1725490196f,      0.1568627451f,      1.0000f,
        0.8470588235f,      0.1686274510f,      0.1568627451f,      1.0000f,
        0.8470588235f,      0.1607843137f,      0.1568627451f,      1.0000f,
        0.8431372549f,      0.1568627451f,      0.1568627451f,      1.0000f,
        0.8392156863f,      0.1490196078f,      0.1568627451f,      1.0000f,
        0.8392156863f,      0.1450980392f,      0.1568627451f,      1.0000f,
        0.8352941176f,      0.1372549020f,      0.1568627451f,      1.0000f,
        0.8274509804f,      0.1215686275f,      0.1568627451f,      1.0000f,
        0.8235294118f,      0.1215686275f,      0.1568627451f,      1.0000f,
        0.8196078431f,      0.1215686275f,      0.1529411765f,      1.0000f,
        0.8117647059f,      0.1176470588f,      0.1529411765f,      1.0000f,
        0.8078431373f,      0.1176470588f,      0.1529411765f,      1.0000f,
        0.8039215686f,      0.1176470588f,      0.1529411765f,      1.0000f,
        0.8000000000f,      0.1176470588f,      0.1490196078f,      1.0000f,
        0.7921568627f,      0.1176470588f,      0.1490196078f,      1.0000f,
        0.7882352941f,      0.1137254902f,      0.1490196078f,      1.0000f,
        0.7843137255f,      0.1137254902f,      0.1450980392f,      1.0000f,
        0.7803921569f,      0.1137254902f,      0.1450980392f,      1.0000f,
        0.7725490196f,      0.1137254902f,      0.1450980392f,      1.0000f,
        0.7686274510f,      0.1137254902f,      0.1450980392f,      1.0000f,
        0.7647058824f,      0.1137254902f,      0.1411764706f,      1.0000f,
        0.7607843137f,      0.1098039216f,      0.1411764706f,      1.0000f,
        0.7529411765f,      0.1098039216f,      0.1411764706f,      1.0000f,
        0.7490196078f,      0.1098039216f,      0.1372549020f,      1.0000f,
        0.7450980392f,      0.1098039216f,      0.1372549020f,      1.0000f,
        0.7411764706f,      0.1098039216f,      0.1372549020f,      1.0000f,
        0.7333333333f,      0.1058823529f,      0.1372549020f,      1.0000f,
        0.7294117647f,      0.1058823529f,      0.1333333333f,      1.0000f,
        0.7254901961f,      0.1058823529f,      0.1333333333f,      1.0000f,
        0.7215686275f,      0.1058823529f,      0.1333333333f,      1.0000f,
        0.7137254902f,      0.1058823529f,      0.1294117647f,      1.0000f,
        0.7098039216f,      0.1019607843f,      0.1294117647f,      1.0000f,
        0.7058823529f,      0.1019607843f,      0.1294117647f,      1.0000f,
        0.7019607843f,      0.1019607843f,      0.1294117647f,      1.0000f,
        0.6941176471f,      0.1019607843f,      0.1254901961f,      1.0000f,
        0.6901960784f,      0.1019607843f,      0.1254901961f,      1.0000f,
        0.6862745098f,      0.0980392157f,      0.1254901961f,      1.0000f,
        0.6823529412f,      0.0980392157f,      0.1215686275f,      1.0000f,
        0.6745098039f,      0.0980392157f,      0.1215686275f,      1.0000f,
        0.6705882353f,      0.0980392157f,      0.1215686275f,      1.0000f,
        0.6666666667f,      0.0980392157f,      0.1176470588f,      1.0000f,
        0.6627450980f,      0.0941176471f,      0.1176470588f,      1.0000f,
        0.6549019608f,      0.0941176471f,      0.1176470588f,      1.0000f,
        0.6509803922f,      0.0941176471f,      0.1176470588f,      1.0000f,
        0.6470588235f,      0.0941176471f,      0.1137254902f,      1.0000f,
        0.6431372549f,      0.0941176471f,      0.1137254902f,      1.0000f,
        0.6352941176f,      0.0941176471f,      0.1137254902f,      1.0000f,
        0.6313725490f,      0.0901960784f,      0.1098039216f,      1.0000f,
        0.6274509804f,      0.0901960784f,      0.1098039216f,      1.0000f,
        0.6235294118f,      0.0901960784f,      0.1098039216f,      1.0000f,
        0.6156862745f,      0.0901960784f,      0.1098039216f,      1.0000f,
        0.6117647059f,      0.0901960784f,      0.1058823529f,      1.0000f,
        0.6078431373f,      0.0862745098f,      0.1058823529f,      1.0000f,
        0.6039215686f,      0.0862745098f,      0.1058823529f,      1.0000f,
        0.5960784314f,      0.0862745098f,      0.1019607843f,      1.0000f,
        0.5921568627f,      0.0862745098f,      0.1019607843f,      1.0000f,
        0.5882352941f,      0.0862745098f,      0.1019607843f,      1.0000f,
        0.5843137255f,      0.0823529412f,      0.1019607843f,      1.0000f,
        0.5725490196f,      0.0823529412f,      0.0980392157f,      1.0000f,
};

/*-- http://mycarta.wordpress.com/2013/03/06/perceptual-rainbow-palette-the-goodies/ */
float cmap_mood[] =
{
        0.5151f,    0.0482f,    0.6697f,    1.0000,
        0.5159f,    0.0561f,    0.6785f,    1.0000,
        0.5166f,    0.0639f,    0.6872f,    1.0000,
        0.5172f,    0.0717f,    0.6959f,    1.0000,
        0.5178f,    0.0795f,    0.7045f,    1.0000,
        0.5182f,    0.0872f,    0.7130f,    1.0000,
        0.5186f,    0.0949f,    0.7214f,    1.0000,
        0.5189f,    0.1025f,    0.7297f,    1.0000,
        0.5192f,    0.1101f,    0.7380f,    1.0000,
        0.5194f,    0.1176f,    0.7461f,    1.0000,
        0.5196f,    0.1251f,    0.7542f,    1.0000,
        0.5197f,    0.1326f,    0.7622f,    1.0000,
        0.5198f,    0.1400f,    0.7701f,    1.0000,
        0.5198f,    0.1473f,    0.7780f,    1.0000,
        0.5199f,    0.1546f,    0.7857f,    1.0000,
        0.5199f,    0.1618f,    0.7933f,    1.0000,
        0.5199f,    0.1690f,    0.8009f,    1.0000,
        0.5199f,    0.1762f,    0.8083f,    1.0000,
        0.5197f,    0.1833f,    0.8157f,    1.0000,
        0.5192f,    0.1904f,    0.8232f,    1.0000,
        0.5184f,    0.1975f,    0.8306f,    1.0000,
        0.5172f,    0.2046f,    0.8381f,    1.0000,
        0.5158f,    0.2116f,    0.8455f,    1.0000,
        0.5142f,    0.2186f,    0.8528f,    1.0000,
        0.5124f,    0.2256f,    0.8601f,    1.0000,
        0.5103f,    0.2325f,    0.8673f,    1.0000,
        0.5082f,    0.2393f,    0.8743f,    1.0000,
        0.5059f,    0.2461f,    0.8812f,    1.0000,
        0.5035f,    0.2528f,    0.8879f,    1.0000,
        0.5010f,    0.2594f,    0.8945f,    1.0000,
        0.4985f,    0.2660f,    0.9008f,    1.0000,
        0.4959f,    0.2724f,    0.9068f,    1.0000,
        0.4934f,    0.2788f,    0.9127f,    1.0000,
        0.4909f,    0.2850f,    0.9182f,    1.0000,
        0.4884f,    0.2912f,    0.9234f,    1.0000,
        0.4858f,    0.2972f,    0.9286f,    1.0000,
        0.4830f,    0.3032f,    0.9339f,    1.0000,
        0.4799f,    0.3090f,    0.9394f,    1.0000,
        0.4766f,    0.3147f,    0.9449f,    1.0000,
        0.4731f,    0.3203f,    0.9503f,    1.0000,
        0.4694f,    0.3259f,    0.9557f,    1.0000,
        0.4657f,    0.3314f,    0.9610f,    1.0000,
        0.4618f,    0.3368f,    0.9661f,    1.0000,
        0.4580f,    0.3423f,    0.9709f,    1.0000,
        0.4541f,    0.3476f,    0.9753f,    1.0000,
        0.4502f,    0.3530f,    0.9794f,    1.0000,
        0.4465f,    0.3584f,    0.9830f,    1.0000,
        0.4428f,    0.3637f,    0.9861f,    1.0000,
        0.4392f,    0.3691f,    0.9886f,    1.0000,
        0.4358f,    0.3745f,    0.9905f,    1.0000,
        0.4326f,    0.3800f,    0.9917f,    1.0000,
        0.4297f,    0.3855f,    0.9921f,    1.0000,
        0.4270f,    0.3910f,    0.9920f,    1.0000,
        0.4243f,    0.3966f,    0.9918f,    1.0000,
        0.4218f,    0.4022f,    0.9915f,    1.0000,
        0.4194f,    0.4078f,    0.9911f,    1.0000,
        0.4171f,    0.4134f,    0.9905f,    1.0000,
        0.4149f,    0.4189f,    0.9899f,    1.0000,
        0.4126f,    0.4245f,    0.9891f,    1.0000,
        0.4105f,    0.4301f,    0.9883f,    1.0000,
        0.4083f,    0.4357f,    0.9874f,    1.0000,
        0.4061f,    0.4412f,    0.9863f,    1.0000,
        0.4039f,    0.4468f,    0.9853f,    1.0000,
        0.4017f,    0.4523f,    0.9841f,    1.0000,
        0.3994f,    0.4577f,    0.9829f,    1.0000,
        0.3970f,    0.4632f,    0.9816f,    1.0000,
        0.3945f,    0.4686f,    0.9803f,    1.0000,
        0.3920f,    0.4739f,    0.9789f,    1.0000,
        0.3893f,    0.4792f,    0.9775f,    1.0000,
        0.3865f,    0.4845f,    0.9758f,    1.0000,
        0.3836f,    0.4897f,    0.9734f,    1.0000,
        0.3805f,    0.4949f,    0.9706f,    1.0000,
        0.3774f,    0.5001f,    0.9672f,    1.0000,
        0.3742f,    0.5053f,    0.9635f,    1.0000,
        0.3709f,    0.5104f,    0.9594f,    1.0000,
        0.3676f,    0.5155f,    0.9549f,    1.0000,
        0.3642f,    0.5206f,    0.9502f,    1.0000,
        0.3608f,    0.5257f,    0.9453f,    1.0000,
        0.3574f,    0.5307f,    0.9403f,    1.0000,
        0.3539f,    0.5357f,    0.9352f,    1.0000,
        0.3505f,    0.5407f,    0.9300f,    1.0000,
        0.3471f,    0.5456f,    0.9249f,    1.0000,
        0.3437f,    0.5505f,    0.9198f,    1.0000,
        0.3403f,    0.5554f,    0.9149f,    1.0000,
        0.3370f,    0.5602f,    0.9101f,    1.0000,
        0.3337f,    0.5650f,    0.9056f,    1.0000,
        0.3305f,    0.5698f,    0.9012f,    1.0000,
        0.3273f,    0.5745f,    0.8969f,    1.0000,
        0.3241f,    0.5792f,    0.8926f,    1.0000,
        0.3209f,    0.5838f,    0.8883f,    1.0000,
        0.3178f,    0.5884f,    0.8840f,    1.0000,
        0.3146f,    0.5930f,    0.8797f,    1.0000,
        0.3115f,    0.5976f,    0.8754f,    1.0000,
        0.3083f,    0.6021f,    0.8711f,    1.0000,
        0.3052f,    0.6067f,    0.8667f,    1.0000,
        0.3020f,    0.6111f,    0.8622f,    1.0000,
        0.2989f,    0.6156f,    0.8577f,    1.0000,
        0.2957f,    0.6200f,    0.8531f,    1.0000,
        0.2925f,    0.6245f,    0.8484f,    1.0000,
        0.2893f,    0.6288f,    0.8437f,    1.0000,
        0.2861f,    0.6332f,    0.8388f,    1.0000,
        0.2828f,    0.6376f,    0.8338f,    1.0000,
        0.2795f,    0.6419f,    0.8287f,    1.0000,
        0.2760f,    0.6462f,    0.8234f,    1.0000,
        0.2721f,    0.6506f,    0.8179f,    1.0000,
        0.2679f,    0.6550f,    0.8123f,    1.0000,
        0.2636f,    0.6594f,    0.8065f,    1.0000,
        0.2590f,    0.6638f,    0.8006f,    1.0000,
        0.2545f,    0.6682f,    0.7945f,    1.0000,
        0.2499f,    0.6726f,    0.7884f,    1.0000,
        0.2454f,    0.6769f,    0.7821f,    1.0000,
        0.2411f,    0.6812f,    0.7758f,    1.0000,
        0.2370f,    0.6854f,    0.7695f,    1.0000,
        0.2332f,    0.6896f,    0.7632f,    1.0000,
        0.2298f,    0.6936f,    0.7568f,    1.0000,
        0.2268f,    0.6976f,    0.7505f,    1.0000,
        0.2244f,    0.7015f,    0.7442f,    1.0000,
        0.2226f,    0.7052f,    0.7380f,    1.0000,
        0.2214f,    0.7088f,    0.7319f,    1.0000,
        0.2210f,    0.7123f,    0.7258f,    1.0000,
        0.2212f,    0.7156f,    0.7198f,    1.0000,
        0.2216f,    0.7188f,    0.7139f,    1.0000,
        0.2224f,    0.7220f,    0.7081f,    1.0000,
        0.2233f,    0.7250f,    0.7022f,    1.0000,
        0.2245f,    0.7279f,    0.6964f,    1.0000,
        0.2259f,    0.7308f,    0.6906f,    1.0000,
        0.2275f,    0.7336f,    0.6849f,    1.0000,
        0.2292f,    0.7363f,    0.6791f,    1.0000,
        0.2310f,    0.7391f,    0.6732f,    1.0000,
        0.2330f,    0.7418f,    0.6674f,    1.0000,
        0.2350f,    0.7445f,    0.6615f,    1.0000,
        0.2370f,    0.7472f,    0.6556f,    1.0000,
        0.2390f,    0.7499f,    0.6496f,    1.0000,
        0.2411f,    0.7527f,    0.6435f,    1.0000,
        0.2430f,    0.7554f,    0.6374f,    1.0000,
        0.2450f,    0.7583f,    0.6311f,    1.0000,
        0.2468f,    0.7612f,    0.6248f,    1.0000,
        0.2486f,    0.7642f,    0.6183f,    1.0000,
        0.2505f,    0.7672f,    0.6117f,    1.0000,
        0.2525f,    0.7703f,    0.6050f,    1.0000,
        0.2545f,    0.7735f,    0.5982f,    1.0000,
        0.2566f,    0.7766f,    0.5913f,    1.0000,
        0.2588f,    0.7798f,    0.5843f,    1.0000,
        0.2609f,    0.7830f,    0.5772f,    1.0000,
        0.2631f,    0.7862f,    0.5701f,    1.0000,
        0.2654f,    0.7893f,    0.5630f,    1.0000,
        0.2676f,    0.7925f,    0.5559f,    1.0000,
        0.2699f,    0.7956f,    0.5487f,    1.0000,
        0.2722f,    0.7986f,    0.5416f,    1.0000,
        0.2744f,    0.8015f,    0.5346f,    1.0000,
        0.2767f,    0.8044f,    0.5275f,    1.0000,
        0.2789f,    0.8072f,    0.5206f,    1.0000,
        0.2811f,    0.8099f,    0.5137f,    1.0000,
        0.2833f,    0.8125f,    0.5069f,    1.0000,
        0.2854f,    0.8150f,    0.5002f,    1.0000,
        0.2876f,    0.8174f,    0.4935f,    1.0000,
        0.2897f,    0.8197f,    0.4868f,    1.0000,
        0.2918f,    0.8219f,    0.4801f,    1.0000,
        0.2939f,    0.8241f,    0.4735f,    1.0000,
        0.2960f,    0.8262f,    0.4668f,    1.0000,
        0.2981f,    0.8283f,    0.4602f,    1.0000,
        0.3003f,    0.8304f,    0.4536f,    1.0000,
        0.3024f,    0.8324f,    0.4471f,    1.0000,
        0.3045f,    0.8344f,    0.4405f,    1.0000,
        0.3066f,    0.8365f,    0.4340f,    1.0000,
        0.3088f,    0.8385f,    0.4276f,    1.0000,
        0.3110f,    0.8406f,    0.4211f,    1.0000,
        0.3131f,    0.8427f,    0.4147f,    1.0000,
        0.3153f,    0.8448f,    0.4083f,    1.0000,
        0.3176f,    0.8470f,    0.4019f,    1.0000,
        0.3198f,    0.8492f,    0.3956f,    1.0000,
        0.3220f,    0.8515f,    0.3890f,    1.0000,
        0.3242f,    0.8539f,    0.3818f,    1.0000,
        0.3263f,    0.8564f,    0.3742f,    1.0000,
        0.3283f,    0.8589f,    0.3663f,    1.0000,
        0.3304f,    0.8614f,    0.3582f,    1.0000,
        0.3324f,    0.8640f,    0.3501f,    1.0000,
        0.3345f,    0.8666f,    0.3420f,    1.0000,
        0.3366f,    0.8692f,    0.3342f,    1.0000,
        0.3388f,    0.8717f,    0.3266f,    1.0000,
        0.3410f,    0.8742f,    0.3195f,    1.0000,
        0.3433f,    0.8767f,    0.3129f,    1.0000,
        0.3458f,    0.8791f,    0.3070f,    1.0000,
        0.3483f,    0.8814f,    0.3019f,    1.0000,
        0.3510f,    0.8837f,    0.2977f,    1.0000,
        0.3539f,    0.8858f,    0.2946f,    1.0000,
        0.3570f,    0.8878f,    0.2926f,    1.0000,
        0.3602f,    0.8896f,    0.2919f,    1.0000,
        0.3638f,    0.8914f,    0.2920f,    1.0000,
        0.3677f,    0.8931f,    0.2921f,    1.0000,
        0.3720f,    0.8948f,    0.2923f,    1.0000,
        0.3766f,    0.8964f,    0.2927f,    1.0000,
        0.3816f,    0.8980f,    0.2931f,    1.0000,
        0.3868f,    0.8996f,    0.2936f,    1.0000,
        0.3924f,    0.9012f,    0.2941f,    1.0000,
        0.3981f,    0.9026f,    0.2947f,    1.0000,
        0.4041f,    0.9041f,    0.2954f,    1.0000,
        0.4102f,    0.9055f,    0.2961f,    1.0000,
        0.4166f,    0.9068f,    0.2968f,    1.0000,
        0.4231f,    0.9081f,    0.2976f,    1.0000,
        0.4297f,    0.9093f,    0.2984f,    1.0000,
        0.4364f,    0.9105f,    0.2992f,    1.0000,
        0.4431f,    0.9116f,    0.3001f,    1.0000,
        0.4500f,    0.9126f,    0.3009f,    1.0000,
        0.4568f,    0.9136f,    0.3018f,    1.0000,
        0.4639f,    0.9145f,    0.3028f,    1.0000,
        0.4716f,    0.9155f,    0.3040f,    1.0000,
        0.4797f,    0.9165f,    0.3054f,    1.0000,
        0.4882f,    0.9175f,    0.3070f,    1.0000,
        0.4970f,    0.9184f,    0.3087f,    1.0000,
        0.5061f,    0.9194f,    0.3105f,    1.0000,
        0.5154f,    0.9203f,    0.3124f,    1.0000,
        0.5247f,    0.9211f,    0.3144f,    1.0000,
        0.5342f,    0.9219f,    0.3164f,    1.0000,
        0.5436f,    0.9227f,    0.3184f,    1.0000,
        0.5529f,    0.9234f,    0.3203f,    1.0000,
        0.5621f,    0.9240f,    0.3222f,    1.0000,
        0.5710f,    0.9245f,    0.3239f,    1.0000,
        0.5797f,    0.9249f,    0.3256f,    1.0000,
        0.5880f,    0.9252f,    0.3271f,    1.0000,
        0.5959f,    0.9254f,    0.3284f,    1.0000,
        0.6033f,    0.9255f,    0.3295f,    1.0000,
        0.6103f,    0.9255f,    0.3304f,    1.0000,
        0.6172f,    0.9255f,    0.3313f,    1.0000,
        0.6238f,    0.9255f,    0.3322f,    1.0000,
        0.6303f,    0.9255f,    0.3330f,    1.0000,
        0.6366f,    0.9255f,    0.3337f,    1.0000,
        0.6428f,    0.9255f,    0.3344f,    1.0000,
        0.6489f,    0.9255f,    0.3351f,    1.0000,
        0.6549f,    0.9255f,    0.3358f,    1.0000,
        0.6608f,    0.9255f,    0.3364f,    1.0000,
        0.6666f,    0.9255f,    0.3370f,    1.0000,
        0.6723f,    0.9255f,    0.3376f,    1.0000,
        0.6781f,    0.9255f,    0.3382f,    1.0000,
        0.6838f,    0.9255f,    0.3388f,    1.0000,
        0.6895f,    0.9255f,    0.3394f,    1.0000,
        0.6951f,    0.9255f,    0.3401f,    1.0000,
        0.7009f,    0.9255f,    0.3407f,    1.0000,
        0.7066f,    0.9255f,    0.3414f,    1.0000,
        0.7124f,    0.9255f,    0.3421f,    1.0000,
        0.7181f,    0.9255f,    0.3428f,    1.0000,
        0.7238f,    0.9255f,    0.3435f,    1.0000,
        0.7294f,    0.9255f,    0.3441f,    1.0000,
        0.7351f,    0.9255f,    0.3448f,    1.0000,
        0.7407f,    0.9255f,    0.3455f,    1.0000,
        0.7462f,    0.9255f,    0.3462f,    1.0000,
        0.7518f,    0.9255f,    0.3469f,    1.0000,
        0.7573f,    0.9255f,    0.3475f,    1.0000,
        0.7627f,    0.9255f,    0.3482f,    1.0000,
        0.7681f,    0.9255f,    0.3489f,    1.0000,
        0.7735f,    0.9255f,    0.3496f,    1.0000,
        0.7789f,    0.9255f,    0.3502f,    1.0000,
        0.7842f,    0.9255f,    0.3509f,    1.0000,
        0.7895f,    0.9255f,    0.3516f,    1.0000,
        0.7948f,    0.9255f,    0.3522f,    1.0000,
        0.8000f,    0.9255f,    0.3529f,    1.0000,
};

float cmap_heat[] =
{
    0.000000, 0.000000, 0.000000, 1.0,
    0.003660, 0.000000, 0.000000, 1.0,
    0.007320, 0.000000, 0.000000, 1.0,
    0.014118, 0.000000, 0.000000, 1.0,
    0.018562, 0.000000, 0.000000, 1.0,
    0.024837, 0.000000, 0.000000, 1.0,
    0.029804, 0.000000, 0.000000, 1.0,
    0.035556, 0.000000, 0.000000, 1.0,
    0.041046, 0.000000, 0.000000, 1.0,
    0.046275, 0.000000, 0.000000, 1.0,
    0.053595, 0.000000, 0.000000, 1.0,
    0.060915, 0.000000, 0.000000, 1.0,
    0.067451, 0.000000, 0.000000, 1.0,
    0.071634, 0.000000, 0.000000, 1.0,
    0.078693, 0.000000, 0.000000, 1.0,
    0.082353, 0.000000, 0.000000, 1.0,
    0.089673, 0.000000, 0.000000, 1.0,
    0.093595, 0.000000, 0.000000, 1.0,
    0.100392, 0.000000, 0.000000, 1.0,
    0.104837, 0.000000, 0.000000, 1.0,
    0.108497, 0.000000, 0.000000, 1.0,
    0.114510, 0.000000, 0.000000, 1.0,
    0.119739, 0.000000, 0.000000, 1.0,
    0.125229, 0.000000, 0.000000, 1.0,
    0.130980, 0.000000, 0.000000, 1.0,
    0.135948, 0.000000, 0.000000, 1.0,
    0.142222, 0.000000, 0.000000, 1.0,
    0.146667, 0.000000, 0.000000, 1.0,
    0.153464, 0.000000, 0.000000, 1.0,
    0.157386, 0.000000, 0.000000, 1.0,
    0.164706, 0.000000, 0.000000, 1.0,
    0.168366, 0.000000, 0.000000, 1.0,
    0.178824, 0.000000, 0.000000, 1.0,
    0.183529, 0.000000, 0.000000, 1.0,
    0.190065, 0.000000, 0.000000, 1.0,
    0.194771, 0.000000, 0.000000, 1.0,
    0.200784, 0.000000, 0.000000, 1.0,
    0.206013, 0.000000, 0.000000, 1.0,
    0.211503, 0.000000, 0.000000, 1.0,
    0.217255, 0.000000, 0.000000, 1.0,
    0.220915, 0.000000, 0.000000, 1.0,
    0.225621, 0.000000, 0.000000, 1.0,
    0.232157, 0.000000, 0.000000, 1.0,
    0.236340, 0.000000, 0.000000, 1.0,
    0.243399, 0.000000, 0.000000, 1.0,
    0.247059, 0.000000, 0.000000, 1.0,
    0.254379, 0.000000, 0.000000, 1.0,
    0.258301, 0.000000, 0.000000, 1.0,
    0.265098, 0.000000, 0.000000, 1.0,
    0.269542, 0.000000, 0.000000, 1.0,
    0.273203, 0.000000, 0.000000, 1.0,
    0.279216, 0.000000, 0.000000, 1.0,
    0.284444, 0.000000, 0.000000, 1.0,
    0.291765, 0.000000, 0.000000, 1.0,
    0.301176, 0.000000, 0.000000, 1.0,
    0.307190, 0.000000, 0.000000, 1.0,
    0.311895, 0.000000, 0.000000, 1.0,
    0.318431, 0.000000, 0.000000, 1.0,
    0.322614, 0.000000, 0.000000, 1.0,
    0.329673, 0.000000, 0.000000, 1.0,
    0.333333, 0.000000, 0.000000, 1.0,
    0.336993, 0.000000, 0.000000, 1.0,
    0.344052, 0.000000, 0.000000, 1.0,
    0.348235, 0.000000, 0.000000, 1.0,
    0.357647, 0.000000, 0.000000, 1.0,
    0.366013, 0.000000, 0.000000, 1.0,
    0.370980, 0.000000, 0.000000, 1.0,
    0.376732, 0.000000, 0.000000, 1.0,
    0.382222, 0.000000, 0.000000, 1.0,
    0.385882, 0.000000, 0.000000, 1.0,
    0.390850, 0.000000, 0.000000, 1.0,
    0.397124, 0.000000, 0.000000, 1.0,
    0.401569, 0.000000, 0.000000, 1.0,
    0.408366, 0.000000, 0.000000, 1.0,
    0.412549, 0.000000, 0.000000, 1.0,
    0.423529, 0.000000, 0.000000, 1.0,
    0.430850, 0.000000, 0.000000, 1.0,
    0.434771, 0.000000, 0.000000, 1.0,
    0.441569, 0.000000, 0.000000, 1.0,
    0.446013, 0.000000, 0.000000, 1.0,
    0.449673, 0.000000, 0.000000, 1.0,
    0.455686, 0.000000, 0.000000, 1.0,
    0.460915, 0.000000, 0.000000, 1.0,
    0.466405, 0.000000, 0.000000, 1.0,
    0.472157, 0.000000, 0.000000, 1.0,
    0.477124, 0.000000, 0.000000, 1.0,
    0.483399, 0.000000, 0.000000, 1.0,
    0.487843, 0.000000, 0.000000, 1.0,
    0.494641, 0.000000, 0.000000, 1.0,
    0.498301, 0.000000, 0.000000, 1.0,
    0.501961, 0.000000, 0.000000, 1.0,
    0.509281, 0.000000, 0.000000, 1.0,
    0.513203, 0.000000, 0.000000, 1.0,
    0.520000, 0.000000, 0.000000, 1.0,
    0.524444, 0.000000, 0.000000, 1.0,
    0.530719, 0.000000, 0.000000, 1.0,
    0.540392, 0.000000, 0.000000, 1.0,
    0.547190, 0.000000, 0.000000, 1.0,
    0.550850, 0.000000, 0.000000, 1.0,
    0.556078, 0.000000, 0.000000, 1.0,
    0.562092, 0.000000, 0.000000, 1.0,
    0.566797, 0.000000, 0.000000, 1.0,
    0.573333, 0.000000, 0.000000, 1.0,
    0.577516, 0.000000, 0.000000, 1.0,
    0.584575, 0.000000, 0.000000, 1.0,
    0.588235, 0.000000, 0.000000, 1.0,
    0.595556, 0.000000, 0.000000, 1.0,
    0.599477, 0.000000, 0.000000, 1.0,
    0.606275, 0.000000, 0.000000, 1.0,
    0.610719, 0.000000, 0.000000, 1.0,
    0.614379, 0.000000, 0.000000, 1.0,
    0.620392, 0.000000, 0.000000, 1.0,
    0.625621, 0.000000, 0.000000, 1.0,
    0.631111, 0.000000, 0.000000, 1.0,
    0.636863, 0.000000, 0.000000, 1.0,
    0.641830, 0.000000, 0.000000, 1.0,
    0.648105, 0.000000, 0.000000, 1.0,
    0.653333, 0.000000, 0.000000, 1.0,
    0.663268, 0.000000, 0.000000, 1.0,
    0.667190, 0.000000, 0.000000, 1.0,
    0.674510, 0.000000, 0.000000, 1.0,
    0.678170, 0.000000, 0.000000, 1.0,
    0.685229, 0.003399, 0.000000, 1.0,
    0.689412, 0.010196, 0.000000, 1.0,
    0.695948, 0.017516, 0.000000, 1.0,
    0.700654, 0.024837, 0.000000, 1.0,
    0.706667, 0.032157, 0.000000, 1.0,
    0.711895, 0.039477, 0.000000, 1.0,
    0.719216, 0.050457, 0.000000, 1.0,
    0.727059, 0.061961, 0.000000, 1.0,
    0.732026, 0.067974, 0.000000, 1.0,
    0.738301, 0.072680, 0.000000, 1.0,
    0.742745, 0.080000, 0.000000, 1.0,
    0.749542, 0.087320, 0.000000, 1.0,
    0.753464, 0.094641, 0.000000, 1.0,
    0.760784, 0.101961, 0.000000, 1.0,
    0.764444, 0.109281, 0.000000, 1.0,
    0.771503, 0.116601, 0.000000, 1.0,
    0.775686, 0.123922, 0.000000, 1.0,
    0.785098, 0.134118, 0.000000, 1.0,
    0.790850, 0.142484, 0.000000, 1.0,
    0.796863, 0.149804, 0.000000, 1.0,
    0.802092, 0.157124, 0.000000, 1.0,
    0.807582, 0.164444, 0.000000, 1.0,
    0.813333, 0.171765, 0.000000, 1.0,
    0.818301, 0.179085, 0.000000, 1.0,
    0.824575, 0.186405, 0.000000, 1.0,
    0.828235, 0.193725, 0.000000, 1.0,
    0.832418, 0.200523, 0.000000, 1.0,
    0.839477, 0.204444, 0.000000, 1.0,
    0.843137, 0.211765, 0.000000, 1.0,
    0.850458, 0.219085, 0.000000, 1.0,
    0.854379, 0.226405, 0.000000, 1.0,
    0.861176, 0.233725, 0.000000, 1.0,
    0.865621, 0.241046, 0.000000, 1.0,
    0.871895, 0.248366, 0.000000, 1.0,
    0.876863, 0.255686, 0.000000, 1.0,
    0.882614, 0.263007, 0.000000, 1.0,
    0.888105, 0.268497, 0.000000, 1.0,
    0.891765, 0.273725, 0.000000, 1.0,
    0.898039, 0.283660, 0.000000, 1.0,
    0.907974, 0.296209, 0.000000, 1.0,
    0.914510, 0.303529, 0.000000, 1.0,
    0.918693, 0.310850, 0.000000, 1.0,
    0.925752, 0.318170, 0.000000, 1.0,
    0.929412, 0.325490, 0.000000, 1.0,
    0.936732, 0.332810, 0.000000, 1.0,
    0.940654, 0.336732, 0.000000, 1.0,
    0.944314, 0.343529, 0.000000, 1.0,
    0.950850, 0.350850, 0.000000, 1.0,
    0.955556, 0.358170, 0.000000, 1.0,
    0.961569, 0.365490, 0.000000, 1.0,
    0.966797, 0.372810, 0.000000, 1.0,
    0.972288, 0.380131, 0.000000, 1.0,
    0.978039, 0.387451, 0.000000, 1.0,
    0.983007, 0.394771, 0.000000, 1.0,
    0.989281, 0.401046, 0.000000, 1.0,
    0.993726, 0.405490, 0.000000, 1.0,
    1.000000, 0.412810, 0.000000, 1.0,
    1.000000, 0.420131, 0.000000, 1.0,
    1.000000, 0.427451, 0.000000, 1.0,
    1.000000, 0.434771, 0.000000, 1.0,
    1.000000, 0.448889, 0.000000, 1.0,
    1.000000, 0.457255, 0.000000, 1.0,
    1.000000, 0.464575, 0.000000, 1.0,
    1.000000, 0.469281, 0.000000, 1.0,
    1.000000, 0.475294, 0.000000, 1.0,
    1.000000, 0.482614, 0.000000, 1.0,
    1.000000, 0.489935, 0.000000, 1.0,
    1.000000, 0.497255, 0.000000, 1.0,
    1.000000, 0.504575, 0.000000, 1.0,
    1.000000, 0.511895, 0.000000, 1.0,
    1.000000, 0.520784, 0.005490, 1.0,
    1.000000, 0.533856, 0.029542, 1.0,
    1.000000, 0.537778, 0.044183, 1.0,
    1.000000, 0.545098, 0.058823, 1.0,
    1.000000, 0.552418, 0.073464, 1.0,
    1.000000, 0.559739, 0.088105, 1.0,
    1.000000, 0.567059, 0.102745, 1.0,
    1.000000, 0.574379, 0.117386, 1.0,
    1.000000, 0.581699, 0.132026, 1.0,
    1.000000, 0.589020, 0.146667, 1.0,
    1.000000, 0.596340, 0.161307, 1.0,
    1.000000, 0.605490, 0.183268, 1.0,
    1.000000, 0.614902, 0.204706, 1.0,
    1.000000, 0.622222, 0.216993, 1.0,
    1.000000, 0.629542, 0.231634, 1.0,
    1.000000, 0.636863, 0.246275, 1.0,
    1.000000, 0.644183, 0.260915, 1.0,
    1.000000, 0.651503, 0.275556, 1.0,
    1.000000, 0.658824, 0.290196, 1.0,
    1.000000, 0.666144, 0.304837, 1.0,
    1.000000, 0.670065, 0.319477, 1.0,
    1.000000, 0.676863, 0.334118, 1.0,
    1.000000, 0.684183, 0.348758, 1.0,
    1.000000, 0.691503, 0.363399, 1.0,
    1.000000, 0.698824, 0.378039, 1.0,
    1.000000, 0.706144, 0.392680, 1.0,
    1.000000, 0.713464, 0.405490, 1.0,
    1.000000, 0.720784, 0.418039, 1.0,
    1.000000, 0.728105, 0.432680, 1.0,
    1.000000, 0.734379, 0.447320, 1.0,
    1.000000, 0.738824, 0.461961, 1.0,
    1.000000, 0.746144, 0.476601, 1.0,
    1.000000, 0.753987, 0.492288, 1.0,
    1.000000, 0.768627, 0.521569, 1.0,
    1.000000, 0.775948, 0.536209, 1.0,
    1.000000, 0.783268, 0.550850, 1.0,
    1.000000, 0.790588, 0.565490, 1.0,
    1.000000, 0.797909, 0.580131, 1.0,
    1.000000, 0.802614, 0.594771, 1.0,
    1.000000, 0.808627, 0.607059, 1.0,
    1.000000, 0.815948, 0.620131, 1.0,
    1.000000, 0.823268, 0.634771, 1.0,
    1.000000, 0.830588, 0.649412, 1.0,
    1.000000, 0.837909, 0.664052, 1.0,
    1.000000, 0.845229, 0.678693, 1.0,
    1.000000, 0.852549, 0.693333, 1.0,
    1.000000, 0.859869, 0.707974, 1.0,
    1.000000, 0.866928, 0.722614, 1.0,
    1.000000, 0.870588, 0.737255, 1.0,
    1.000000, 0.877909, 0.751896, 1.0,
    1.000000, 0.885229, 0.766536, 1.0,
    1.000000, 0.892549, 0.781177, 1.0,
    1.000000, 0.899869, 0.795817, 1.0,
    1.000000, 0.907190, 0.807843, 1.0,
    1.000000, 0.919216, 0.830588, 1.0,
    1.000000, 0.929673, 0.851503, 1.0,
    1.000000, 0.935163, 0.866144, 1.0,
    1.000000, 0.940392, 0.880784, 1.0,
    1.000000, 0.947712, 0.895425, 1.0,
    1.000000, 0.955033, 0.910065, 1.0,
    1.000000, 0.962353, 0.924706, 1.0,
    1.000000, 0.969673, 0.939346, 1.0,
    1.000000, 0.976994, 0.953987, 1.0,
    1.000000, 0.984314, 0.968627, 1.0,
};

float cmap_blue[] =
{
    0.968627, 0.984314, 1.000000, 1.0,
    0.965552, 0.982345, 0.999016, 1.0,
    0.962476, 0.980377, 0.998032, 1.0,
    0.959400, 0.978408, 0.997047, 1.0,
    0.956324, 0.976440, 0.996063, 1.0,
    0.953249, 0.974471, 0.995079, 1.0,
    0.950173, 0.972503, 0.994095, 1.0,
    0.947097, 0.970534, 0.993110, 1.0,
    0.944022, 0.968566, 0.992126, 1.0,
    0.940946, 0.966597, 0.991142, 1.0,
    0.937870, 0.964629, 0.990158, 1.0,
    0.934794, 0.962661, 0.989173, 1.0,
    0.931719, 0.960692, 0.988189, 1.0,
    0.928643, 0.958724, 0.987205, 1.0,
    0.925567, 0.956755, 0.986221, 1.0,
    0.922491, 0.954787, 0.985236, 1.0,
    0.919416, 0.952818, 0.984252, 1.0,
    0.916340, 0.950850, 0.983268, 1.0,
    0.913264, 0.948881, 0.982284, 1.0,
    0.910188, 0.946913, 0.981300, 1.0,
    0.907113, 0.944944, 0.980315, 1.0,
    0.904037, 0.942976, 0.979331, 1.0,
    0.900961, 0.941007, 0.978347, 1.0,
    0.897885, 0.939039, 0.977363, 1.0,
    0.894810, 0.937070, 0.976378, 1.0,
    0.891734, 0.935102, 0.975394, 1.0,
    0.888658, 0.933133, 0.974410, 1.0,
    0.885582, 0.931165, 0.973426, 1.0,
    0.882507, 0.929196, 0.972441, 1.0,
    0.879431, 0.927228, 0.971457, 1.0,
    0.876355, 0.925260, 0.970473, 1.0,
    0.873280, 0.923291, 0.969489, 1.0,
    0.870219, 0.921323, 0.968504, 1.0,
    0.867266, 0.919354, 0.967520, 1.0,
    0.864314, 0.917386, 0.966536, 1.0,
    0.861361, 0.915417, 0.965552, 1.0,
    0.858408, 0.913449, 0.964567, 1.0,
    0.855456, 0.911480, 0.963583, 1.0,
    0.852503, 0.909512, 0.962599, 1.0,
    0.849550, 0.907543, 0.961615, 1.0,
    0.846597, 0.905575, 0.960631, 1.0,
    0.843645, 0.903606, 0.959646, 1.0,
    0.840692, 0.901638, 0.958662, 1.0,
    0.837739, 0.899669, 0.957678, 1.0,
    0.834787, 0.897701, 0.956694, 1.0,
    0.831834, 0.895732, 0.955709, 1.0,
    0.828881, 0.893764, 0.954725, 1.0,
    0.825928, 0.891795, 0.953741, 1.0,
    0.822976, 0.889827, 0.952757, 1.0,
    0.820023, 0.887859, 0.951772, 1.0,
    0.817070, 0.885890, 0.950788, 1.0,
    0.814118, 0.883922, 0.949804, 1.0,
    0.811165, 0.881953, 0.948820, 1.0,
    0.808212, 0.879985, 0.947835, 1.0,
    0.805260, 0.878016, 0.946851, 1.0,
    0.802307, 0.876048, 0.945867, 1.0,
    0.799354, 0.874079, 0.944883, 1.0,
    0.796401, 0.872111, 0.943899, 1.0,
    0.793449, 0.870142, 0.942914, 1.0,
    0.790496, 0.868174, 0.941930, 1.0,
    0.787543, 0.866205, 0.940946, 1.0,
    0.784591, 0.864237, 0.939962, 1.0,
    0.781638, 0.862268, 0.938977, 1.0,
    0.778685, 0.860300, 0.937993, 1.0,
    0.775240, 0.858301, 0.936824, 1.0,
    0.770319, 0.856209, 0.935102, 1.0,
    0.765398, 0.854118, 0.933379, 1.0,
    0.760477, 0.852026, 0.931657, 1.0,
    0.755556, 0.849935, 0.929935, 1.0,
    0.750634, 0.847843, 0.928212, 1.0,
    0.745713, 0.845752, 0.926490, 1.0,
    0.740792, 0.843660, 0.924767, 1.0,
    0.735871, 0.841569, 0.923045, 1.0,
    0.730950, 0.839477, 0.921323, 1.0,
    0.726028, 0.837386, 0.919600, 1.0,
    0.721107, 0.835294, 0.917878, 1.0,
    0.716186, 0.833203, 0.916155, 1.0,
    0.711265, 0.831111, 0.914433, 1.0,
    0.706344, 0.829020, 0.912711, 1.0,
    0.701423, 0.826928, 0.910988, 1.0,
    0.696501, 0.824837, 0.909266, 1.0,
    0.691580, 0.822745, 0.907543, 1.0,
    0.686659, 0.820654, 0.905821, 1.0,
    0.681738, 0.818562, 0.904098, 1.0,
    0.676817, 0.816471, 0.902376, 1.0,
    0.671895, 0.814379, 0.900654, 1.0,
    0.666974, 0.812288, 0.898931, 1.0,
    0.662053, 0.810196, 0.897209, 1.0,
    0.657132, 0.808105, 0.895486, 1.0,
    0.652211, 0.806013, 0.893764, 1.0,
    0.647290, 0.803922, 0.892042, 1.0,
    0.642368, 0.801830, 0.890319, 1.0,
    0.637447, 0.799739, 0.888597, 1.0,
    0.632526, 0.797647, 0.886874, 1.0,
    0.627605, 0.795556, 0.885152, 1.0,
    0.622684, 0.793464, 0.883429, 1.0,
    0.617255, 0.790865, 0.881845, 1.0,
    0.610980, 0.787420, 0.880492, 1.0,
    0.604706, 0.783975, 0.879139, 1.0,
    0.598431, 0.780531, 0.877785, 1.0,
    0.592157, 0.777086, 0.876432, 1.0,
    0.585882, 0.773641, 0.875079, 1.0,
    0.579608, 0.770196, 0.873725, 1.0,
    0.573333, 0.766751, 0.872372, 1.0,
    0.567059, 0.763306, 0.871019, 1.0,
    0.560784, 0.759862, 0.869666, 1.0,
    0.554510, 0.756417, 0.868312, 1.0,
    0.548235, 0.752972, 0.866959, 1.0,
    0.541961, 0.749527, 0.865606, 1.0,
    0.535686, 0.746082, 0.864252, 1.0,
    0.529412, 0.742637, 0.862899, 1.0,
    0.523137, 0.739193, 0.861546, 1.0,
    0.516863, 0.735748, 0.860192, 1.0,
    0.510588, 0.732303, 0.858839, 1.0,
    0.504314, 0.728858, 0.857486, 1.0,
    0.498039, 0.725413, 0.856132, 1.0,
    0.491765, 0.721968, 0.854779, 1.0,
    0.485490, 0.718524, 0.853426, 1.0,
    0.479216, 0.715079, 0.852072, 1.0,
    0.472941, 0.711634, 0.850719, 1.0,
    0.466667, 0.708189, 0.849366, 1.0,
    0.460392, 0.704744, 0.848012, 1.0,
    0.454118, 0.701300, 0.846659, 1.0,
    0.447843, 0.697855, 0.845306, 1.0,
    0.441569, 0.694410, 0.843952, 1.0,
    0.435294, 0.690965, 0.842599, 1.0,
    0.429020, 0.687520, 0.841246, 1.0,
    0.422745, 0.684075, 0.839892, 1.0,
    0.417086, 0.680631, 0.838231, 1.0,
    0.412042, 0.677186, 0.836263, 1.0,
    0.406997, 0.673741, 0.834295, 1.0,
    0.401953, 0.670296, 0.832326, 1.0,
    0.396909, 0.666851, 0.830358, 1.0,
    0.391865, 0.663406, 0.828389, 1.0,
    0.386820, 0.659962, 0.826421, 1.0,
    0.381776, 0.656517, 0.824452, 1.0,
    0.376732, 0.653072, 0.822484, 1.0,
    0.371688, 0.649627, 0.820515, 1.0,
    0.366644, 0.646182, 0.818547, 1.0,
    0.361599, 0.642737, 0.816578, 1.0,
    0.356555, 0.639293, 0.814610, 1.0,
    0.351511, 0.635848, 0.812641, 1.0,
    0.346467, 0.632403, 0.810673, 1.0,
    0.341423, 0.628958, 0.808704, 1.0,
    0.336378, 0.625513, 0.806736, 1.0,
    0.331334, 0.622068, 0.804767, 1.0,
    0.326290, 0.618624, 0.802799, 1.0,
    0.321246, 0.615179, 0.800830, 1.0,
    0.316201, 0.611734, 0.798862, 1.0,
    0.311157, 0.608289, 0.796894, 1.0,
    0.306113, 0.604844, 0.794925, 1.0,
    0.301069, 0.601399, 0.792957, 1.0,
    0.296025, 0.597955, 0.790988, 1.0,
    0.290980, 0.594510, 0.789020, 1.0,
    0.285936, 0.591065, 0.787051, 1.0,
    0.280892, 0.587620, 0.785083, 1.0,
    0.275848, 0.584175, 0.783114, 1.0,
    0.270804, 0.580731, 0.781146, 1.0,
    0.265759, 0.577286, 0.779177, 1.0,
    0.260715, 0.573841, 0.777209, 1.0,
    0.256286, 0.570012, 0.775163, 1.0,
    0.252226, 0.565952, 0.773072, 1.0,
    0.248166, 0.561892, 0.770980, 1.0,
    0.244106, 0.557832, 0.768889, 1.0,
    0.240046, 0.553772, 0.766797, 1.0,
    0.235986, 0.549712, 0.764706, 1.0,
    0.231926, 0.545652, 0.762614, 1.0,
    0.227866, 0.541592, 0.760523, 1.0,
    0.223806, 0.537532, 0.758431, 1.0,
    0.219746, 0.533472, 0.756340, 1.0,
    0.215686, 0.529412, 0.754248, 1.0,
    0.211626, 0.525352, 0.752157, 1.0,
    0.207566, 0.521292, 0.750065, 1.0,
    0.203506, 0.517232, 0.747974, 1.0,
    0.199446, 0.513172, 0.745882, 1.0,
    0.195386, 0.509112, 0.743791, 1.0,
    0.191326, 0.505052, 0.741699, 1.0,
    0.187266, 0.500992, 0.739608, 1.0,
    0.183206, 0.496932, 0.737516, 1.0,
    0.179146, 0.492872, 0.735425, 1.0,
    0.175087, 0.488812, 0.733333, 1.0,
    0.171027, 0.484752, 0.731242, 1.0,
    0.166967, 0.480692, 0.729150, 1.0,
    0.162907, 0.476632, 0.727059, 1.0,
    0.158847, 0.472572, 0.724967, 1.0,
    0.154787, 0.468512, 0.722876, 1.0,
    0.150727, 0.464452, 0.720784, 1.0,
    0.146667, 0.460392, 0.718693, 1.0,
    0.142607, 0.456332, 0.716601, 1.0,
    0.138547, 0.452272, 0.714510, 1.0,
    0.134487, 0.448212, 0.712418, 1.0,
    0.130427, 0.444152, 0.710327, 1.0,
    0.127105, 0.440185, 0.707497, 1.0,
    0.124029, 0.436248, 0.704421, 1.0,
    0.120953, 0.432311, 0.701346, 1.0,
    0.117878, 0.428374, 0.698270, 1.0,
    0.114802, 0.424437, 0.695194, 1.0,
    0.111726, 0.420500, 0.692118, 1.0,
    0.108651, 0.416563, 0.689043, 1.0,
    0.105575, 0.412626, 0.685967, 1.0,
    0.102499, 0.408689, 0.682891, 1.0,
    0.099423, 0.404752, 0.679815, 1.0,
    0.096348, 0.400815, 0.676740, 1.0,
    0.093272, 0.396878, 0.673664, 1.0,
    0.090196, 0.392941, 0.670588, 1.0,
    0.087120, 0.389004, 0.667513, 1.0,
    0.084045, 0.385067, 0.664437, 1.0,
    0.080969, 0.381130, 0.661361, 1.0,
    0.077893, 0.377193, 0.658285, 1.0,
    0.074817, 0.373256, 0.655210, 1.0,
    0.071742, 0.369320, 0.652134, 1.0,
    0.068666, 0.365383, 0.649058, 1.0,
    0.065590, 0.361446, 0.645982, 1.0,
    0.062514, 0.357509, 0.642907, 1.0,
    0.059439, 0.353572, 0.639831, 1.0,
    0.056363, 0.349635, 0.636755, 1.0,
    0.053287, 0.345698, 0.633679, 1.0,
    0.050211, 0.341761, 0.630604, 1.0,
    0.047136, 0.337824, 0.627528, 1.0,
    0.044060, 0.333887, 0.624452, 1.0,
    0.040984, 0.329950, 0.621376, 1.0,
    0.037908, 0.326013, 0.618301, 1.0,
    0.034833, 0.322076, 0.615225, 1.0,
    0.031757, 0.318139, 0.612149, 1.0,
    0.031373, 0.314095, 0.606490, 1.0,
    0.031373, 0.310035, 0.600461, 1.0,
    0.031373, 0.305975, 0.594433, 1.0,
    0.031373, 0.301915, 0.588404, 1.0,
    0.031373, 0.297855, 0.582376, 1.0,
    0.031373, 0.293795, 0.576348, 1.0,
    0.031373, 0.289735, 0.570319, 1.0,
    0.031373, 0.285675, 0.564291, 1.0,
    0.031373, 0.281615, 0.558262, 1.0,
    0.031373, 0.277555, 0.552234, 1.0,
    0.031373, 0.273495, 0.546205, 1.0,
    0.031373, 0.269435, 0.540177, 1.0,
    0.031373, 0.265375, 0.534148, 1.0,
    0.031373, 0.261315, 0.528120, 1.0,
    0.031373, 0.257255, 0.522092, 1.0,
    0.031373, 0.253195, 0.516063, 1.0,
    0.031373, 0.249135, 0.510035, 1.0,
    0.031373, 0.245075, 0.504006, 1.0,
    0.031373, 0.241015, 0.497978, 1.0,
    0.031373, 0.236955, 0.491949, 1.0,
    0.031373, 0.232895, 0.485921, 1.0,
    0.031373, 0.228835, 0.479892, 1.0,
    0.031373, 0.224775, 0.473864, 1.0,
    0.031373, 0.220715, 0.467835, 1.0,
    0.031373, 0.216655, 0.461807, 1.0,
    0.031373, 0.212595, 0.455779, 1.0,
    0.031373, 0.208535, 0.449750, 1.0,
    0.031373, 0.204475, 0.443722, 1.0,
    0.031373, 0.200415, 0.437693, 1.0,
    0.031373, 0.196355, 0.431665, 1.0,
    0.031373, 0.192295, 0.425636, 1.0,
    0.031373, 0.188235, 0.419608, 1.0,
};

/// Next four colormaps: inferno, magma, plasma and viridis are matplotlib
/// colormaps by Nathaniel J. Smith, Stefan van der Walt, and
/// (in the case of viridis) Eric Firing.
///
/// These colormaps are released under the CC0 license / public domain dedication.
/// We would appreciate credit if you use or redistribute these colormaps,
/// but do not impose any legal restrictions.
///
/// To the extent possible under law, the persons who associated CC0 with
/// mpl-colormaps have waived all copyright and related or neighboring rights
/// to mpl-colormaps.
///
/// You should have received a copy of the CC0 legalcode along with this
/// work.  If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.

/// inferno  perceptually uniform shades of black-red-yellow
float cmap_inferno[] =
{
    0.001462, 0.000466, 0.013866, 1.0,
    0.002267, 0.001270, 0.018570, 1.0,
    0.003299, 0.002249, 0.024239, 1.0,
    0.004547, 0.003392, 0.030909, 1.0,
    0.006006, 0.004692, 0.038558, 1.0,
    0.007676, 0.006136, 0.046836, 1.0,
    0.009561, 0.007713, 0.055143, 1.0,
    0.011663, 0.009417, 0.063460, 1.0,
    0.013995, 0.011225, 0.071862, 1.0,
    0.016561, 0.013136, 0.080282, 1.0,
    0.019373, 0.015133, 0.088767, 1.0,
    0.022447, 0.017199, 0.097327, 1.0,
    0.025793, 0.019331, 0.105930, 1.0,
    0.029432, 0.021503, 0.114621, 1.0,
    0.033385, 0.023702, 0.123397, 1.0,
    0.037668, 0.025921, 0.132232, 1.0,
    0.042253, 0.028139, 0.141141, 1.0,
    0.046915, 0.030324, 0.150164, 1.0,
    0.051644, 0.032474, 0.159254, 1.0,
    0.056449, 0.034569, 0.168414, 1.0,
    0.061340, 0.036590, 0.177642, 1.0,
    0.066331, 0.038504, 0.186962, 1.0,
    0.071429, 0.040294, 0.196354, 1.0,
    0.076637, 0.041905, 0.205799, 1.0,
    0.081962, 0.043328, 0.215289, 1.0,
    0.087411, 0.044556, 0.224813, 1.0,
    0.092990, 0.045583, 0.234358, 1.0,
    0.098702, 0.046402, 0.243904, 1.0,
    0.104551, 0.047008, 0.253430, 1.0,
    0.110536, 0.047399, 0.262912, 1.0,
    0.116656, 0.047574, 0.272321, 1.0,
    0.122908, 0.047536, 0.281624, 1.0,
    0.129285, 0.047293, 0.290788, 1.0,
    0.135778, 0.046856, 0.299776, 1.0,
    0.142378, 0.046242, 0.308553, 1.0,
    0.149073, 0.045468, 0.317085, 1.0,
    0.155850, 0.044559, 0.325338, 1.0,
    0.162689, 0.043554, 0.333277, 1.0,
    0.169575, 0.042489, 0.340874, 1.0,
    0.176493, 0.041402, 0.348111, 1.0,
    0.183429, 0.040329, 0.354971, 1.0,
    0.190367, 0.039309, 0.361447, 1.0,
    0.197297, 0.038400, 0.367535, 1.0,
    0.204209, 0.037632, 0.373238, 1.0,
    0.211095, 0.037030, 0.378563, 1.0,
    0.217949, 0.036615, 0.383522, 1.0,
    0.224763, 0.036405, 0.388129, 1.0,
    0.231538, 0.036405, 0.392400, 1.0,
    0.238273, 0.036621, 0.396353, 1.0,
    0.244967, 0.037055, 0.400007, 1.0,
    0.251620, 0.037705, 0.403378, 1.0,
    0.258234, 0.038571, 0.406485, 1.0,
    0.264810, 0.039647, 0.409345, 1.0,
    0.271347, 0.040922, 0.411976, 1.0,
    0.277850, 0.042353, 0.414392, 1.0,
    0.284321, 0.043933, 0.416608, 1.0,
    0.290763, 0.045644, 0.418637, 1.0,
    0.297178, 0.047470, 0.420491, 1.0,
    0.303568, 0.049396, 0.422182, 1.0,
    0.309935, 0.051407, 0.423721, 1.0,
    0.316282, 0.053490, 0.425116, 1.0,
    0.322610, 0.055634, 0.426377, 1.0,
    0.328921, 0.057827, 0.427511, 1.0,
    0.335217, 0.060060, 0.428524, 1.0,
    0.341500, 0.062325, 0.429425, 1.0,
    0.347771, 0.064616, 0.430217, 1.0,
    0.354032, 0.066925, 0.430906, 1.0,
    0.360284, 0.069247, 0.431497, 1.0,
    0.366529, 0.071579, 0.431994, 1.0,
    0.372768, 0.073915, 0.432400, 1.0,
    0.379001, 0.076253, 0.432719, 1.0,
    0.385228, 0.078591, 0.432955, 1.0,
    0.391453, 0.080927, 0.433109, 1.0,
    0.397674, 0.083257, 0.433183, 1.0,
    0.403894, 0.085580, 0.433179, 1.0,
    0.410113, 0.087896, 0.433098, 1.0,
    0.416331, 0.090203, 0.432943, 1.0,
    0.422549, 0.092501, 0.432714, 1.0,
    0.428768, 0.094790, 0.432412, 1.0,
    0.434987, 0.097069, 0.432039, 1.0,
    0.441207, 0.099338, 0.431594, 1.0,
    0.447428, 0.101597, 0.431080, 1.0,
    0.453651, 0.103848, 0.430498, 1.0,
    0.459875, 0.106089, 0.429846, 1.0,
    0.466100, 0.108322, 0.429125, 1.0,
    0.472328, 0.110547, 0.428334, 1.0,
    0.478558, 0.112764, 0.427475, 1.0,
    0.484789, 0.114974, 0.426548, 1.0,
    0.491022, 0.117179, 0.425552, 1.0,
    0.497257, 0.119379, 0.424488, 1.0,
    0.503493, 0.121575, 0.423356, 1.0,
    0.509730, 0.123769, 0.422156, 1.0,
    0.515967, 0.125960, 0.420887, 1.0,
    0.522206, 0.128150, 0.419549, 1.0,
    0.528444, 0.130341, 0.418142, 1.0,
    0.534683, 0.132534, 0.416667, 1.0,
    0.540920, 0.134729, 0.415123, 1.0,
    0.547157, 0.136929, 0.413511, 1.0,
    0.553392, 0.139134, 0.411829, 1.0,
    0.559624, 0.141346, 0.410078, 1.0,
    0.565854, 0.143567, 0.408258, 1.0,
    0.572081, 0.145797, 0.406369, 1.0,
    0.578304, 0.148039, 0.404411, 1.0,
    0.584521, 0.150294, 0.402385, 1.0,
    0.590734, 0.152563, 0.400290, 1.0,
    0.596940, 0.154848, 0.398125, 1.0,
    0.603139, 0.157151, 0.395891, 1.0,
    0.609330, 0.159474, 0.393589, 1.0,
    0.615513, 0.161817, 0.391219, 1.0,
    0.621685, 0.164184, 0.388781, 1.0,
    0.627847, 0.166575, 0.386276, 1.0,
    0.633998, 0.168992, 0.383704, 1.0,
    0.640135, 0.171438, 0.381065, 1.0,
    0.646260, 0.173914, 0.378359, 1.0,
    0.652369, 0.176421, 0.375586, 1.0,
    0.658463, 0.178962, 0.372748, 1.0,
    0.664540, 0.181539, 0.369846, 1.0,
    0.670599, 0.184153, 0.366879, 1.0,
    0.676638, 0.186807, 0.363849, 1.0,
    0.682656, 0.189501, 0.360757, 1.0,
    0.688653, 0.192239, 0.357603, 1.0,
    0.694627, 0.195021, 0.354388, 1.0,
    0.700576, 0.197851, 0.351113, 1.0,
    0.706500, 0.200728, 0.347777, 1.0,
    0.712396, 0.203656, 0.344383, 1.0,
    0.718264, 0.206636, 0.340931, 1.0,
    0.724103, 0.209670, 0.337424, 1.0,
    0.729909, 0.212759, 0.333861, 1.0,
    0.735683, 0.215906, 0.330245, 1.0,
    0.741423, 0.219112, 0.326576, 1.0,
    0.747127, 0.222378, 0.322856, 1.0,
    0.752794, 0.225706, 0.319085, 1.0,
    0.758422, 0.229097, 0.315266, 1.0,
    0.764010, 0.232554, 0.311399, 1.0,
    0.769556, 0.236077, 0.307485, 1.0,
    0.775059, 0.239667, 0.303526, 1.0,
    0.780517, 0.243327, 0.299523, 1.0,
    0.785929, 0.247056, 0.295477, 1.0,
    0.791293, 0.250856, 0.291390, 1.0,
    0.796607, 0.254728, 0.287264, 1.0,
    0.801871, 0.258674, 0.283099, 1.0,
    0.807082, 0.262692, 0.278898, 1.0,
    0.812239, 0.266786, 0.274661, 1.0,
    0.817341, 0.270954, 0.270390, 1.0,
    0.822386, 0.275197, 0.266085, 1.0,
    0.827372, 0.279517, 0.261750, 1.0,
    0.832299, 0.283913, 0.257383, 1.0,
    0.837165, 0.288385, 0.252988, 1.0,
    0.841969, 0.292933, 0.248564, 1.0,
    0.846709, 0.297559, 0.244113, 1.0,
    0.851384, 0.302260, 0.239636, 1.0,
    0.855992, 0.307038, 0.235133, 1.0,
    0.860533, 0.311892, 0.230606, 1.0,
    0.865006, 0.316822, 0.226055, 1.0,
    0.869409, 0.321827, 0.221482, 1.0,
    0.873741, 0.326906, 0.216886, 1.0,
    0.878001, 0.332060, 0.212268, 1.0,
    0.882188, 0.337287, 0.207628, 1.0,
    0.886302, 0.342586, 0.202968, 1.0,
    0.890341, 0.347957, 0.198286, 1.0,
    0.894305, 0.353399, 0.193584, 1.0,
    0.898192, 0.358911, 0.188860, 1.0,
    0.902003, 0.364492, 0.184116, 1.0,
    0.905735, 0.370140, 0.179350, 1.0,
    0.909390, 0.375856, 0.174563, 1.0,
    0.912966, 0.381636, 0.169755, 1.0,
    0.916462, 0.387481, 0.164924, 1.0,
    0.919879, 0.393389, 0.160070, 1.0,
    0.923215, 0.399359, 0.155193, 1.0,
    0.926470, 0.405389, 0.150292, 1.0,
    0.929644, 0.411479, 0.145367, 1.0,
    0.932737, 0.417627, 0.140417, 1.0,
    0.935747, 0.423831, 0.135440, 1.0,
    0.938675, 0.430091, 0.130438, 1.0,
    0.941521, 0.436405, 0.125409, 1.0,
    0.944285, 0.442772, 0.120354, 1.0,
    0.946965, 0.449191, 0.115272, 1.0,
    0.949562, 0.455660, 0.110164, 1.0,
    0.952075, 0.462178, 0.105031, 1.0,
    0.954506, 0.468744, 0.099874, 1.0,
    0.956852, 0.475356, 0.094695, 1.0,
    0.959114, 0.482014, 0.089499, 1.0,
    0.961293, 0.488716, 0.084289, 1.0,
    0.963387, 0.495462, 0.079073, 1.0,
    0.965397, 0.502249, 0.073859, 1.0,
    0.967322, 0.509078, 0.068659, 1.0,
    0.969163, 0.515946, 0.063488, 1.0,
    0.970919, 0.522853, 0.058367, 1.0,
    0.972590, 0.529798, 0.053324, 1.0,
    0.974176, 0.536780, 0.048392, 1.0,
    0.975677, 0.543798, 0.043618, 1.0,
    0.977092, 0.550850, 0.039050, 1.0,
    0.978422, 0.557937, 0.034931, 1.0,
    0.979666, 0.565057, 0.031409, 1.0,
    0.980824, 0.572209, 0.028508, 1.0,
    0.981895, 0.579392, 0.026250, 1.0,
    0.982881, 0.586606, 0.024661, 1.0,
    0.983779, 0.593849, 0.023770, 1.0,
    0.984591, 0.601122, 0.023606, 1.0,
    0.985315, 0.608422, 0.024202, 1.0,
    0.985952, 0.615750, 0.025592, 1.0,
    0.986502, 0.623105, 0.027814, 1.0,
    0.986964, 0.630485, 0.030908, 1.0,
    0.987337, 0.637890, 0.034916, 1.0,
    0.987622, 0.645320, 0.039886, 1.0,
    0.987819, 0.652773, 0.045581, 1.0,
    0.987926, 0.660250, 0.051750, 1.0,
    0.987945, 0.667748, 0.058329, 1.0,
    0.987874, 0.675267, 0.065257, 1.0,
    0.987714, 0.682807, 0.072489, 1.0,
    0.987464, 0.690366, 0.079990, 1.0,
    0.987124, 0.697944, 0.087731, 1.0,
    0.986694, 0.705540, 0.095694, 1.0,
    0.986175, 0.713153, 0.103863, 1.0,
    0.985566, 0.720782, 0.112229, 1.0,
    0.984865, 0.728427, 0.120785, 1.0,
    0.984075, 0.736087, 0.129527, 1.0,
    0.983196, 0.743758, 0.138453, 1.0,
    0.982228, 0.751442, 0.147565, 1.0,
    0.981173, 0.759135, 0.156863, 1.0,
    0.980032, 0.766837, 0.166353, 1.0,
    0.978806, 0.774545, 0.176037, 1.0,
    0.977497, 0.782258, 0.185923, 1.0,
    0.976108, 0.789974, 0.196018, 1.0,
    0.974638, 0.797692, 0.206332, 1.0,
    0.973088, 0.805409, 0.216877, 1.0,
    0.971468, 0.813122, 0.227658, 1.0,
    0.969783, 0.820825, 0.238686, 1.0,
    0.968041, 0.828515, 0.249972, 1.0,
    0.966243, 0.836191, 0.261534, 1.0,
    0.964394, 0.843848, 0.273391, 1.0,
    0.962517, 0.851476, 0.285546, 1.0,
    0.960626, 0.859069, 0.298010, 1.0,
    0.958720, 0.866624, 0.310820, 1.0,
    0.956834, 0.874129, 0.323974, 1.0,
    0.954997, 0.881569, 0.337475, 1.0,
    0.953215, 0.888942, 0.351369, 1.0,
    0.951546, 0.896226, 0.365627, 1.0,
    0.950018, 0.903409, 0.380271, 1.0,
    0.948683, 0.910473, 0.395289, 1.0,
    0.947594, 0.917399, 0.410665, 1.0,
    0.946809, 0.924168, 0.426373, 1.0,
    0.946392, 0.930761, 0.442367, 1.0,
    0.946403, 0.937159, 0.458592, 1.0,
    0.946903, 0.943348, 0.474970, 1.0,
    0.947937, 0.949318, 0.491426, 1.0,
    0.949545, 0.955063, 0.507860, 1.0,
    0.951740, 0.960587, 0.524203, 1.0,
    0.954529, 0.965896, 0.540361, 1.0,
    0.957896, 0.971003, 0.556275, 1.0,
    0.961812, 0.975924, 0.571925, 1.0,
    0.966249, 0.980678, 0.587206, 1.0,
    0.971162, 0.985282, 0.602154, 1.0,
    0.976511, 0.989753, 0.616760, 1.0,
    0.982257, 0.994109, 0.631017, 1.0,
    0.988362, 0.998364, 0.644924, 1.0,
};

/// magma    perceptually uniform shades of black-red-white
float cmap_magma[] =
{
    0.001462, 0.000466, 0.013866, 1.0,
    0.002258, 0.001295, 0.018331, 1.0,
    0.003279, 0.002305, 0.023708, 1.0,
    0.004512, 0.003490, 0.029965, 1.0,
    0.005950, 0.004843, 0.037130, 1.0,
    0.007588, 0.006356, 0.044973, 1.0,
    0.009426, 0.008022, 0.052844, 1.0,
    0.011465, 0.009828, 0.060750, 1.0,
    0.013708, 0.011771, 0.068667, 1.0,
    0.016156, 0.013840, 0.076603, 1.0,
    0.018815, 0.016026, 0.084584, 1.0,
    0.021692, 0.018320, 0.092610, 1.0,
    0.024792, 0.020715, 0.100676, 1.0,
    0.028123, 0.023201, 0.108787, 1.0,
    0.031696, 0.025765, 0.116965, 1.0,
    0.035520, 0.028397, 0.125209, 1.0,
    0.039608, 0.031090, 0.133515, 1.0,
    0.043830, 0.033830, 0.141886, 1.0,
    0.048062, 0.036607, 0.150327, 1.0,
    0.052320, 0.039407, 0.158841, 1.0,
    0.056615, 0.042160, 0.167446, 1.0,
    0.060949, 0.044794, 0.176129, 1.0,
    0.065330, 0.047318, 0.184892, 1.0,
    0.069764, 0.049726, 0.193735, 1.0,
    0.074257, 0.052017, 0.202660, 1.0,
    0.078815, 0.054184, 0.211667, 1.0,
    0.083446, 0.056225, 0.220755, 1.0,
    0.088155, 0.058133, 0.229922, 1.0,
    0.092949, 0.059904, 0.239164, 1.0,
    0.097833, 0.061531, 0.248477, 1.0,
    0.102815, 0.063010, 0.257854, 1.0,
    0.107899, 0.064335, 0.267289, 1.0,
    0.113094, 0.065492, 0.276784, 1.0,
    0.118405, 0.066479, 0.286321, 1.0,
    0.123833, 0.067295, 0.295879, 1.0,
    0.129380, 0.067935, 0.305443, 1.0,
    0.135053, 0.068391, 0.315000, 1.0,
    0.140858, 0.068654, 0.324538, 1.0,
    0.146785, 0.068738, 0.334011, 1.0,
    0.152839, 0.068637, 0.343404, 1.0,
    0.159018, 0.068354, 0.352688, 1.0,
    0.165308, 0.067911, 0.361816, 1.0,
    0.171713, 0.067305, 0.370771, 1.0,
    0.178212, 0.066576, 0.379497, 1.0,
    0.184801, 0.065732, 0.387973, 1.0,
    0.191460, 0.064818, 0.396152, 1.0,
    0.198177, 0.063862, 0.404009, 1.0,
    0.204935, 0.062907, 0.411514, 1.0,
    0.211718, 0.061992, 0.418647, 1.0,
    0.218512, 0.061158, 0.425392, 1.0,
    0.225302, 0.060445, 0.431742, 1.0,
    0.232077, 0.059889, 0.437695, 1.0,
    0.238826, 0.059517, 0.443256, 1.0,
    0.245543, 0.059352, 0.448436, 1.0,
    0.252220, 0.059415, 0.453248, 1.0,
    0.258857, 0.059706, 0.457710, 1.0,
    0.265447, 0.060237, 0.461840, 1.0,
    0.271994, 0.060994, 0.465660, 1.0,
    0.278493, 0.061978, 0.469190, 1.0,
    0.284951, 0.063168, 0.472451, 1.0,
    0.291366, 0.064553, 0.475462, 1.0,
    0.297740, 0.066117, 0.478243, 1.0,
    0.304081, 0.067835, 0.480812, 1.0,
    0.310382, 0.069702, 0.483186, 1.0,
    0.316654, 0.071690, 0.485380, 1.0,
    0.322899, 0.073782, 0.487408, 1.0,
    0.329114, 0.075972, 0.489287, 1.0,
    0.335308, 0.078236, 0.491024, 1.0,
    0.341482, 0.080564, 0.492631, 1.0,
    0.347636, 0.082946, 0.494121, 1.0,
    0.353773, 0.085373, 0.495501, 1.0,
    0.359898, 0.087831, 0.496778, 1.0,
    0.366012, 0.090314, 0.497960, 1.0,
    0.372116, 0.092816, 0.499053, 1.0,
    0.378211, 0.095332, 0.500067, 1.0,
    0.384299, 0.097855, 0.501002, 1.0,
    0.390384, 0.100379, 0.501864, 1.0,
    0.396467, 0.102902, 0.502658, 1.0,
    0.402548, 0.105420, 0.503386, 1.0,
    0.408629, 0.107930, 0.504052, 1.0,
    0.414709, 0.110431, 0.504662, 1.0,
    0.420791, 0.112920, 0.505215, 1.0,
    0.426877, 0.115395, 0.505714, 1.0,
    0.432967, 0.117855, 0.506160, 1.0,
    0.439062, 0.120298, 0.506555, 1.0,
    0.445163, 0.122724, 0.506901, 1.0,
    0.451271, 0.125132, 0.507198, 1.0,
    0.457386, 0.127522, 0.507448, 1.0,
    0.463508, 0.129893, 0.507652, 1.0,
    0.469640, 0.132245, 0.507809, 1.0,
    0.475780, 0.134577, 0.507921, 1.0,
    0.481929, 0.136891, 0.507989, 1.0,
    0.488088, 0.139186, 0.508011, 1.0,
    0.494258, 0.141462, 0.507988, 1.0,
    0.500438, 0.143719, 0.507920, 1.0,
    0.506629, 0.145958, 0.507806, 1.0,
    0.512831, 0.148179, 0.507648, 1.0,
    0.519045, 0.150383, 0.507443, 1.0,
    0.525270, 0.152569, 0.507192, 1.0,
    0.531507, 0.154739, 0.506895, 1.0,
    0.537755, 0.156894, 0.506551, 1.0,
    0.544015, 0.159033, 0.506159, 1.0,
    0.550287, 0.161158, 0.505719, 1.0,
    0.556571, 0.163269, 0.505230, 1.0,
    0.562866, 0.165368, 0.504692, 1.0,
    0.569172, 0.167454, 0.504105, 1.0,
    0.575490, 0.169530, 0.503466, 1.0,
    0.581819, 0.171596, 0.502777, 1.0,
    0.588158, 0.173652, 0.502035, 1.0,
    0.594508, 0.175701, 0.501241, 1.0,
    0.600868, 0.177743, 0.500394, 1.0,
    0.607238, 0.179779, 0.499492, 1.0,
    0.613617, 0.181811, 0.498536, 1.0,
    0.620005, 0.183840, 0.497524, 1.0,
    0.626401, 0.185867, 0.496456, 1.0,
    0.632805, 0.187893, 0.495332, 1.0,
    0.639216, 0.189921, 0.494150, 1.0,
    0.645633, 0.191952, 0.492910, 1.0,
    0.652056, 0.193986, 0.491611, 1.0,
    0.658483, 0.196027, 0.490253, 1.0,
    0.664915, 0.198075, 0.488836, 1.0,
    0.671349, 0.200133, 0.487358, 1.0,
    0.677786, 0.202203, 0.485819, 1.0,
    0.684224, 0.204286, 0.484219, 1.0,
    0.690661, 0.206384, 0.482558, 1.0,
    0.697098, 0.208501, 0.480835, 1.0,
    0.703532, 0.210638, 0.479049, 1.0,
    0.709962, 0.212797, 0.477201, 1.0,
    0.716387, 0.214982, 0.475290, 1.0,
    0.722805, 0.217194, 0.473316, 1.0,
    0.729216, 0.219437, 0.471279, 1.0,
    0.735616, 0.221713, 0.469180, 1.0,
    0.742004, 0.224025, 0.467018, 1.0,
    0.748378, 0.226377, 0.464794, 1.0,
    0.754737, 0.228772, 0.462509, 1.0,
    0.761077, 0.231214, 0.460162, 1.0,
    0.767398, 0.233705, 0.457755, 1.0,
    0.773695, 0.236249, 0.455289, 1.0,
    0.779968, 0.238851, 0.452765, 1.0,
    0.786212, 0.241514, 0.450184, 1.0,
    0.792427, 0.244242, 0.447543, 1.0,
    0.798608, 0.247040, 0.444848, 1.0,
    0.804752, 0.249911, 0.442102, 1.0,
    0.810855, 0.252861, 0.439305, 1.0,
    0.816914, 0.255895, 0.436461, 1.0,
    0.822926, 0.259016, 0.433573, 1.0,
    0.828886, 0.262229, 0.430644, 1.0,
    0.834791, 0.265540, 0.427671, 1.0,
    0.840636, 0.268953, 0.424666, 1.0,
    0.846416, 0.272473, 0.421631, 1.0,
    0.852126, 0.276106, 0.418573, 1.0,
    0.857763, 0.279857, 0.415496, 1.0,
    0.863320, 0.283729, 0.412403, 1.0,
    0.868793, 0.287728, 0.409303, 1.0,
    0.874176, 0.291859, 0.406205, 1.0,
    0.879464, 0.296125, 0.403118, 1.0,
    0.884651, 0.300530, 0.400047, 1.0,
    0.889731, 0.305079, 0.397002, 1.0,
    0.894700, 0.309773, 0.393995, 1.0,
    0.899552, 0.314616, 0.391037, 1.0,
    0.904281, 0.319610, 0.388137, 1.0,
    0.908884, 0.324755, 0.385308, 1.0,
    0.913354, 0.330052, 0.382563, 1.0,
    0.917689, 0.335500, 0.379915, 1.0,
    0.921884, 0.341098, 0.377376, 1.0,
    0.925937, 0.346844, 0.374959, 1.0,
    0.929845, 0.352734, 0.372677, 1.0,
    0.933606, 0.358764, 0.370541, 1.0,
    0.937221, 0.364929, 0.368567, 1.0,
    0.940687, 0.371224, 0.366762, 1.0,
    0.944006, 0.377643, 0.365136, 1.0,
    0.947180, 0.384178, 0.363701, 1.0,
    0.950210, 0.390820, 0.362468, 1.0,
    0.953099, 0.397563, 0.361438, 1.0,
    0.955849, 0.404400, 0.360619, 1.0,
    0.958464, 0.411324, 0.360014, 1.0,
    0.960949, 0.418323, 0.359630, 1.0,
    0.963310, 0.425390, 0.359469, 1.0,
    0.965549, 0.432519, 0.359529, 1.0,
    0.967671, 0.439703, 0.359810, 1.0,
    0.969680, 0.446936, 0.360311, 1.0,
    0.971582, 0.454210, 0.361030, 1.0,
    0.973381, 0.461520, 0.361965, 1.0,
    0.975082, 0.468861, 0.363111, 1.0,
    0.976690, 0.476226, 0.364466, 1.0,
    0.978210, 0.483612, 0.366025, 1.0,
    0.979645, 0.491014, 0.367783, 1.0,
    0.981000, 0.498428, 0.369734, 1.0,
    0.982279, 0.505851, 0.371874, 1.0,
    0.983485, 0.513280, 0.374198, 1.0,
    0.984622, 0.520713, 0.376698, 1.0,
    0.985693, 0.528148, 0.379371, 1.0,
    0.986700, 0.535582, 0.382210, 1.0,
    0.987646, 0.543015, 0.385210, 1.0,
    0.988533, 0.550446, 0.388365, 1.0,
    0.989363, 0.557873, 0.391671, 1.0,
    0.990138, 0.565296, 0.395122, 1.0,
    0.990871, 0.572706, 0.398714, 1.0,
    0.991558, 0.580107, 0.402441, 1.0,
    0.992196, 0.587502, 0.406299, 1.0,
    0.992785, 0.594891, 0.410283, 1.0,
    0.993326, 0.602275, 0.414390, 1.0,
    0.993834, 0.609644, 0.418613, 1.0,
    0.994309, 0.616999, 0.422950, 1.0,
    0.994738, 0.624350, 0.427397, 1.0,
    0.995122, 0.631696, 0.431951, 1.0,
    0.995480, 0.639027, 0.436607, 1.0,
    0.995810, 0.646344, 0.441361, 1.0,
    0.996096, 0.653659, 0.446213, 1.0,
    0.996341, 0.660969, 0.451160, 1.0,
    0.996580, 0.668256, 0.456192, 1.0,
    0.996775, 0.675541, 0.461314, 1.0,
    0.996925, 0.682828, 0.466526, 1.0,
    0.997077, 0.690088, 0.471811, 1.0,
    0.997186, 0.697349, 0.477182, 1.0,
    0.997254, 0.704611, 0.482635, 1.0,
    0.997325, 0.711848, 0.488154, 1.0,
    0.997351, 0.719089, 0.493755, 1.0,
    0.997351, 0.726324, 0.499428, 1.0,
    0.997341, 0.733545, 0.505167, 1.0,
    0.997285, 0.740772, 0.510983, 1.0,
    0.997228, 0.747981, 0.516859, 1.0,
    0.997138, 0.755190, 0.522806, 1.0,
    0.997019, 0.762398, 0.528821, 1.0,
    0.996898, 0.769591, 0.534892, 1.0,
    0.996727, 0.776795, 0.541039, 1.0,
    0.996571, 0.783977, 0.547233, 1.0,
    0.996369, 0.791167, 0.553499, 1.0,
    0.996162, 0.798348, 0.559820, 1.0,
    0.995932, 0.805527, 0.566202, 1.0,
    0.995680, 0.812706, 0.572645, 1.0,
    0.995424, 0.819875, 0.579140, 1.0,
    0.995131, 0.827052, 0.585701, 1.0,
    0.994851, 0.834213, 0.592307, 1.0,
    0.994524, 0.841387, 0.598983, 1.0,
    0.994222, 0.848540, 0.605696, 1.0,
    0.993866, 0.855711, 0.612482, 1.0,
    0.993545, 0.862859, 0.619299, 1.0,
    0.993170, 0.870024, 0.626189, 1.0,
    0.992831, 0.877168, 0.633109, 1.0,
    0.992440, 0.884330, 0.640099, 1.0,
    0.992089, 0.891470, 0.647116, 1.0,
    0.991688, 0.898627, 0.654202, 1.0,
    0.991332, 0.905763, 0.661309, 1.0,
    0.990930, 0.912915, 0.668481, 1.0,
    0.990570, 0.920049, 0.675675, 1.0,
    0.990175, 0.927196, 0.682926, 1.0,
    0.989815, 0.934329, 0.690198, 1.0,
    0.989434, 0.941470, 0.697519, 1.0,
    0.989077, 0.948604, 0.704863, 1.0,
    0.988717, 0.955742, 0.712242, 1.0,
    0.988367, 0.962878, 0.719649, 1.0,
    0.988033, 0.970012, 0.727077, 1.0,
    0.987691, 0.977154, 0.734536, 1.0,
    0.987387, 0.984288, 0.742002, 1.0,
    0.987053, 0.991438, 0.749504, 1.0,
};

/// plasma   perceptually uniform shades of blue-red-yellow
float cmap_plasma[] =
{
    0.050383, 0.029803, 0.527975, 1.0,
    0.063536, 0.028426, 0.533124, 1.0,
    0.075353, 0.027206, 0.538007, 1.0,
    0.086222, 0.026125, 0.542658, 1.0,
    0.096379, 0.025165, 0.547103, 1.0,
    0.105980, 0.024309, 0.551368, 1.0,
    0.115124, 0.023556, 0.555468, 1.0,
    0.123903, 0.022878, 0.559423, 1.0,
    0.132381, 0.022258, 0.563250, 1.0,
    0.140603, 0.021687, 0.566959, 1.0,
    0.148607, 0.021154, 0.570562, 1.0,
    0.156421, 0.020651, 0.574065, 1.0,
    0.164070, 0.020171, 0.577478, 1.0,
    0.171574, 0.019706, 0.580806, 1.0,
    0.178950, 0.019252, 0.584054, 1.0,
    0.186213, 0.018803, 0.587228, 1.0,
    0.193374, 0.018354, 0.590330, 1.0,
    0.200445, 0.017902, 0.593364, 1.0,
    0.207435, 0.017442, 0.596333, 1.0,
    0.214350, 0.016973, 0.599239, 1.0,
    0.221197, 0.016497, 0.602083, 1.0,
    0.227983, 0.016007, 0.604867, 1.0,
    0.234715, 0.015502, 0.607592, 1.0,
    0.241396, 0.014979, 0.610259, 1.0,
    0.248032, 0.014439, 0.612868, 1.0,
    0.254627, 0.013882, 0.615419, 1.0,
    0.261183, 0.013308, 0.617911, 1.0,
    0.267703, 0.012716, 0.620346, 1.0,
    0.274191, 0.012109, 0.622722, 1.0,
    0.280648, 0.011488, 0.625038, 1.0,
    0.287076, 0.010855, 0.627295, 1.0,
    0.293478, 0.010213, 0.629490, 1.0,
    0.299855, 0.009561, 0.631624, 1.0,
    0.306210, 0.008902, 0.633694, 1.0,
    0.312543, 0.008239, 0.635700, 1.0,
    0.318856, 0.007576, 0.637640, 1.0,
    0.325150, 0.006915, 0.639512, 1.0,
    0.331426, 0.006261, 0.641316, 1.0,
    0.337683, 0.005618, 0.643049, 1.0,
    0.343925, 0.004991, 0.644710, 1.0,
    0.350150, 0.004382, 0.646298, 1.0,
    0.356359, 0.003798, 0.647810, 1.0,
    0.362553, 0.003243, 0.649245, 1.0,
    0.368733, 0.002724, 0.650601, 1.0,
    0.374897, 0.002245, 0.651876, 1.0,
    0.381047, 0.001814, 0.653068, 1.0,
    0.387183, 0.001434, 0.654177, 1.0,
    0.393304, 0.001114, 0.655199, 1.0,
    0.399411, 0.000859, 0.656133, 1.0,
    0.405503, 0.000678, 0.656977, 1.0,
    0.411580, 0.000577, 0.657730, 1.0,
    0.417642, 0.000564, 0.658390, 1.0,
    0.423689, 0.000646, 0.658956, 1.0,
    0.429719, 0.000831, 0.659425, 1.0,
    0.435734, 0.001127, 0.659797, 1.0,
    0.441732, 0.001540, 0.660069, 1.0,
    0.447714, 0.002080, 0.660240, 1.0,
    0.453677, 0.002755, 0.660310, 1.0,
    0.459623, 0.003574, 0.660277, 1.0,
    0.465550, 0.004545, 0.660139, 1.0,
    0.471457, 0.005678, 0.659897, 1.0,
    0.477344, 0.006980, 0.659549, 1.0,
    0.483210, 0.008460, 0.659095, 1.0,
    0.489055, 0.010127, 0.658534, 1.0,
    0.494877, 0.011990, 0.657865, 1.0,
    0.500678, 0.014055, 0.657088, 1.0,
    0.506454, 0.016333, 0.656202, 1.0,
    0.512206, 0.018833, 0.655209, 1.0,
    0.517933, 0.021563, 0.654109, 1.0,
    0.523633, 0.024532, 0.652901, 1.0,
    0.529306, 0.027747, 0.651586, 1.0,
    0.534952, 0.031217, 0.650165, 1.0,
    0.540570, 0.034950, 0.648640, 1.0,
    0.546157, 0.038954, 0.647010, 1.0,
    0.551715, 0.043136, 0.645277, 1.0,
    0.557243, 0.047331, 0.643443, 1.0,
    0.562738, 0.051545, 0.641509, 1.0,
    0.568201, 0.055778, 0.639477, 1.0,
    0.573632, 0.060028, 0.637349, 1.0,
    0.579029, 0.064296, 0.635126, 1.0,
    0.584391, 0.068579, 0.632812, 1.0,
    0.589719, 0.072878, 0.630408, 1.0,
    0.595011, 0.077190, 0.627917, 1.0,
    0.600266, 0.081516, 0.625342, 1.0,
    0.605485, 0.085854, 0.622686, 1.0,
    0.610667, 0.090204, 0.619951, 1.0,
    0.615812, 0.094564, 0.617140, 1.0,
    0.620919, 0.098934, 0.614257, 1.0,
    0.625987, 0.103312, 0.611305, 1.0,
    0.631017, 0.107699, 0.608287, 1.0,
    0.636008, 0.112092, 0.605205, 1.0,
    0.640959, 0.116492, 0.602065, 1.0,
    0.645872, 0.120898, 0.598867, 1.0,
    0.650746, 0.125309, 0.595617, 1.0,
    0.655580, 0.129725, 0.592317, 1.0,
    0.660374, 0.134144, 0.588971, 1.0,
    0.665129, 0.138566, 0.585582, 1.0,
    0.669845, 0.142992, 0.582154, 1.0,
    0.674522, 0.147419, 0.578688, 1.0,
    0.679160, 0.151848, 0.575189, 1.0,
    0.683758, 0.156278, 0.571660, 1.0,
    0.688318, 0.160709, 0.568103, 1.0,
    0.692840, 0.165141, 0.564522, 1.0,
    0.697324, 0.169573, 0.560919, 1.0,
    0.701769, 0.174005, 0.557296, 1.0,
    0.706178, 0.178437, 0.553657, 1.0,
    0.710549, 0.182868, 0.550004, 1.0,
    0.714883, 0.187299, 0.546338, 1.0,
    0.719181, 0.191729, 0.542663, 1.0,
    0.723444, 0.196158, 0.538981, 1.0,
    0.727670, 0.200586, 0.535293, 1.0,
    0.731862, 0.205013, 0.531601, 1.0,
    0.736019, 0.209439, 0.527908, 1.0,
    0.740143, 0.213864, 0.524216, 1.0,
    0.744232, 0.218288, 0.520524, 1.0,
    0.748289, 0.222711, 0.516834, 1.0,
    0.752312, 0.227133, 0.513149, 1.0,
    0.756304, 0.231555, 0.509468, 1.0,
    0.760264, 0.235976, 0.505794, 1.0,
    0.764193, 0.240396, 0.502126, 1.0,
    0.768090, 0.244817, 0.498465, 1.0,
    0.771958, 0.249237, 0.494813, 1.0,
    0.775796, 0.253658, 0.491171, 1.0,
    0.779604, 0.258078, 0.487539, 1.0,
    0.783383, 0.262500, 0.483918, 1.0,
    0.787133, 0.266922, 0.480307, 1.0,
    0.790855, 0.271345, 0.476706, 1.0,
    0.794549, 0.275770, 0.473117, 1.0,
    0.798216, 0.280197, 0.469538, 1.0,
    0.801855, 0.284626, 0.465971, 1.0,
    0.805467, 0.289057, 0.462415, 1.0,
    0.809052, 0.293491, 0.458870, 1.0,
    0.812612, 0.297928, 0.455338, 1.0,
    0.816144, 0.302368, 0.451816, 1.0,
    0.819651, 0.306812, 0.448306, 1.0,
    0.823132, 0.311261, 0.444806, 1.0,
    0.826588, 0.315714, 0.441316, 1.0,
    0.830018, 0.320172, 0.437836, 1.0,
    0.833422, 0.324635, 0.434366, 1.0,
    0.836801, 0.329105, 0.430905, 1.0,
    0.840155, 0.333580, 0.427455, 1.0,
    0.843484, 0.338062, 0.424013, 1.0,
    0.846788, 0.342551, 0.420579, 1.0,
    0.850066, 0.347048, 0.417153, 1.0,
    0.853319, 0.351553, 0.413734, 1.0,
    0.856547, 0.356066, 0.410322, 1.0,
    0.859750, 0.360588, 0.406917, 1.0,
    0.862927, 0.365119, 0.403519, 1.0,
    0.866078, 0.369660, 0.400126, 1.0,
    0.869203, 0.374212, 0.396738, 1.0,
    0.872303, 0.378774, 0.393355, 1.0,
    0.875376, 0.383347, 0.389976, 1.0,
    0.878423, 0.387932, 0.386600, 1.0,
    0.881443, 0.392529, 0.383229, 1.0,
    0.884436, 0.397139, 0.379860, 1.0,
    0.887402, 0.401762, 0.376494, 1.0,
    0.890340, 0.406398, 0.373130, 1.0,
    0.893250, 0.411048, 0.369768, 1.0,
    0.896131, 0.415712, 0.366407, 1.0,
    0.898984, 0.420392, 0.363047, 1.0,
    0.901807, 0.425087, 0.359688, 1.0,
    0.904601, 0.429797, 0.356329, 1.0,
    0.907365, 0.434524, 0.352970, 1.0,
    0.910098, 0.439268, 0.349610, 1.0,
    0.912800, 0.444029, 0.346251, 1.0,
    0.915471, 0.448807, 0.342890, 1.0,
    0.918109, 0.453603, 0.339529, 1.0,
    0.920714, 0.458417, 0.336166, 1.0,
    0.923287, 0.463251, 0.332801, 1.0,
    0.925825, 0.468103, 0.329435, 1.0,
    0.928329, 0.472975, 0.326067, 1.0,
    0.930798, 0.477867, 0.322697, 1.0,
    0.933232, 0.482780, 0.319325, 1.0,
    0.935630, 0.487712, 0.315952, 1.0,
    0.937990, 0.492667, 0.312575, 1.0,
    0.940313, 0.497642, 0.309197, 1.0,
    0.942598, 0.502639, 0.305816, 1.0,
    0.944844, 0.507658, 0.302433, 1.0,
    0.947051, 0.512699, 0.299049, 1.0,
    0.949217, 0.517763, 0.295662, 1.0,
    0.951344, 0.522850, 0.292275, 1.0,
    0.953428, 0.527960, 0.288883, 1.0,
    0.955470, 0.533093, 0.285490, 1.0,
    0.957469, 0.538250, 0.282096, 1.0,
    0.959424, 0.543431, 0.278701, 1.0,
    0.961336, 0.548636, 0.275305, 1.0,
    0.963203, 0.553865, 0.271909, 1.0,
    0.965024, 0.559118, 0.268513, 1.0,
    0.966798, 0.564396, 0.265118, 1.0,
    0.968526, 0.569700, 0.261721, 1.0,
    0.970205, 0.575028, 0.258325, 1.0,
    0.971835, 0.580382, 0.254931, 1.0,
    0.973416, 0.585761, 0.251540, 1.0,
    0.974947, 0.591165, 0.248151, 1.0,
    0.976428, 0.596595, 0.244767, 1.0,
    0.977856, 0.602051, 0.241387, 1.0,
    0.979233, 0.607532, 0.238013, 1.0,
    0.980556, 0.613039, 0.234646, 1.0,
    0.981826, 0.618572, 0.231287, 1.0,
    0.983041, 0.624131, 0.227937, 1.0,
    0.984199, 0.629718, 0.224595, 1.0,
    0.985301, 0.635330, 0.221265, 1.0,
    0.986345, 0.640969, 0.217948, 1.0,
    0.987332, 0.646633, 0.214648, 1.0,
    0.988260, 0.652325, 0.211364, 1.0,
    0.989128, 0.658043, 0.208100, 1.0,
    0.989935, 0.663787, 0.204859, 1.0,
    0.990681, 0.669558, 0.201642, 1.0,
    0.991365, 0.675355, 0.198453, 1.0,
    0.991985, 0.681179, 0.195295, 1.0,
    0.992541, 0.687030, 0.192170, 1.0,
    0.993032, 0.692907, 0.189084, 1.0,
    0.993456, 0.698810, 0.186041, 1.0,
    0.993814, 0.704741, 0.183043, 1.0,
    0.994103, 0.710698, 0.180097, 1.0,
    0.994324, 0.716681, 0.177208, 1.0,
    0.994474, 0.722691, 0.174381, 1.0,
    0.994553, 0.728728, 0.171622, 1.0,
    0.994561, 0.734791, 0.168938, 1.0,
    0.994495, 0.740880, 0.166335, 1.0,
    0.994355, 0.746995, 0.163821, 1.0,
    0.994141, 0.753137, 0.161404, 1.0,
    0.993851, 0.759304, 0.159092, 1.0,
    0.993482, 0.765499, 0.156891, 1.0,
    0.993033, 0.771720, 0.154808, 1.0,
    0.992505, 0.777967, 0.152855, 1.0,
    0.991897, 0.784239, 0.151042, 1.0,
    0.991209, 0.790537, 0.149377, 1.0,
    0.990439, 0.796859, 0.147870, 1.0,
    0.989587, 0.803205, 0.146529, 1.0,
    0.988648, 0.809579, 0.145357, 1.0,
    0.987621, 0.815978, 0.144363, 1.0,
    0.986509, 0.822401, 0.143557, 1.0,
    0.985314, 0.828846, 0.142945, 1.0,
    0.984031, 0.835315, 0.142528, 1.0,
    0.982653, 0.841812, 0.142303, 1.0,
    0.981190, 0.848329, 0.142279, 1.0,
    0.979644, 0.854866, 0.142453, 1.0,
    0.977995, 0.861432, 0.142808, 1.0,
    0.976265, 0.868016, 0.143351, 1.0,
    0.974443, 0.874622, 0.144061, 1.0,
    0.972530, 0.881250, 0.144923, 1.0,
    0.970533, 0.887896, 0.145919, 1.0,
    0.968443, 0.894564, 0.147014, 1.0,
    0.966271, 0.901249, 0.148180, 1.0,
    0.964021, 0.907950, 0.149370, 1.0,
    0.961681, 0.914672, 0.150520, 1.0,
    0.959276, 0.921407, 0.151566, 1.0,
    0.956808, 0.928152, 0.152409, 1.0,
    0.954287, 0.934908, 0.152921, 1.0,
    0.951726, 0.941671, 0.152925, 1.0,
    0.949151, 0.948435, 0.152178, 1.0,
    0.946602, 0.955190, 0.150328, 1.0,
    0.944152, 0.961916, 0.146861, 1.0,
    0.941896, 0.968590, 0.140956, 1.0,
    0.940015, 0.975158, 0.131326, 1.0,
};

/// viridis  perceptually uniform shades of blue-green-yellow
float cmap_viridis[] =
{
    0.267004, 0.004874, 0.329415, 1.0,
    0.268510, 0.009605, 0.335427, 1.0,
    0.269944, 0.014625, 0.341379, 1.0,
    0.271305, 0.019942, 0.347269, 1.0,
    0.272594, 0.025563, 0.353093, 1.0,
    0.273809, 0.031497, 0.358853, 1.0,
    0.274952, 0.037752, 0.364543, 1.0,
    0.276022, 0.044167, 0.370164, 1.0,
    0.277018, 0.050344, 0.375715, 1.0,
    0.277941, 0.056324, 0.381191, 1.0,
    0.278791, 0.062145, 0.386592, 1.0,
    0.279566, 0.067836, 0.391917, 1.0,
    0.280267, 0.073417, 0.397163, 1.0,
    0.280894, 0.078907, 0.402329, 1.0,
    0.281446, 0.084320, 0.407414, 1.0,
    0.281924, 0.089666, 0.412415, 1.0,
    0.282327, 0.094955, 0.417331, 1.0,
    0.282656, 0.100196, 0.422160, 1.0,
    0.282910, 0.105393, 0.426902, 1.0,
    0.283091, 0.110553, 0.431554, 1.0,
    0.283197, 0.115680, 0.436115, 1.0,
    0.283229, 0.120777, 0.440584, 1.0,
    0.283187, 0.125848, 0.444960, 1.0,
    0.283072, 0.130895, 0.449241, 1.0,
    0.282884, 0.135920, 0.453427, 1.0,
    0.282623, 0.140926, 0.457517, 1.0,
    0.282290, 0.145912, 0.461510, 1.0,
    0.281887, 0.150881, 0.465405, 1.0,
    0.281412, 0.155834, 0.469201, 1.0,
    0.280868, 0.160771, 0.472899, 1.0,
    0.280255, 0.165693, 0.476498, 1.0,
    0.279574, 0.170599, 0.479997, 1.0,
    0.278826, 0.175490, 0.483397, 1.0,
    0.278012, 0.180367, 0.486697, 1.0,
    0.277134, 0.185228, 0.489898, 1.0,
    0.276194, 0.190074, 0.493001, 1.0,
    0.275191, 0.194905, 0.496005, 1.0,
    0.274128, 0.199721, 0.498911, 1.0,
    0.273006, 0.204520, 0.501721, 1.0,
    0.271828, 0.209303, 0.504434, 1.0,
    0.270595, 0.214069, 0.507052, 1.0,
    0.269308, 0.218818, 0.509577, 1.0,
    0.267968, 0.223549, 0.512008, 1.0,
    0.266580, 0.228262, 0.514349, 1.0,
    0.265145, 0.232956, 0.516599, 1.0,
    0.263663, 0.237631, 0.518762, 1.0,
    0.262138, 0.242286, 0.520837, 1.0,
    0.260571, 0.246922, 0.522828, 1.0,
    0.258965, 0.251537, 0.524736, 1.0,
    0.257322, 0.256130, 0.526563, 1.0,
    0.255645, 0.260703, 0.528312, 1.0,
    0.253935, 0.265254, 0.529983, 1.0,
    0.252194, 0.269783, 0.531579, 1.0,
    0.250425, 0.274290, 0.533103, 1.0,
    0.248629, 0.278775, 0.534556, 1.0,
    0.246811, 0.283237, 0.535941, 1.0,
    0.244972, 0.287675, 0.537260, 1.0,
    0.243113, 0.292092, 0.538516, 1.0,
    0.241237, 0.296485, 0.539709, 1.0,
    0.239346, 0.300855, 0.540844, 1.0,
    0.237441, 0.305202, 0.541921, 1.0,
    0.235526, 0.309527, 0.542944, 1.0,
    0.233603, 0.313828, 0.543914, 1.0,
    0.231674, 0.318106, 0.544834, 1.0,
    0.229739, 0.322361, 0.545706, 1.0,
    0.227802, 0.326594, 0.546532, 1.0,
    0.225863, 0.330805, 0.547314, 1.0,
    0.223925, 0.334994, 0.548053, 1.0,
    0.221989, 0.339161, 0.548752, 1.0,
    0.220057, 0.343307, 0.549413, 1.0,
    0.218130, 0.347432, 0.550038, 1.0,
    0.216210, 0.351535, 0.550627, 1.0,
    0.214298, 0.355619, 0.551184, 1.0,
    0.212395, 0.359683, 0.551710, 1.0,
    0.210503, 0.363727, 0.552206, 1.0,
    0.208623, 0.367752, 0.552675, 1.0,
    0.206756, 0.371758, 0.553117, 1.0,
    0.204903, 0.375746, 0.553533, 1.0,
    0.203063, 0.379716, 0.553925, 1.0,
    0.201239, 0.383670, 0.554294, 1.0,
    0.199430, 0.387607, 0.554642, 1.0,
    0.197636, 0.391528, 0.554969, 1.0,
    0.195860, 0.395433, 0.555276, 1.0,
    0.194100, 0.399323, 0.555565, 1.0,
    0.192357, 0.403199, 0.555836, 1.0,
    0.190631, 0.407061, 0.556089, 1.0,
    0.188923, 0.410910, 0.556326, 1.0,
    0.187231, 0.414746, 0.556547, 1.0,
    0.185556, 0.418570, 0.556753, 1.0,
    0.183898, 0.422383, 0.556944, 1.0,
    0.182256, 0.426184, 0.557120, 1.0,
    0.180629, 0.429975, 0.557282, 1.0,
    0.179019, 0.433756, 0.557430, 1.0,
    0.177423, 0.437527, 0.557565, 1.0,
    0.175841, 0.441290, 0.557685, 1.0,
    0.174274, 0.445044, 0.557792, 1.0,
    0.172719, 0.448791, 0.557885, 1.0,
    0.171176, 0.452530, 0.557965, 1.0,
    0.169646, 0.456262, 0.558030, 1.0,
    0.168126, 0.459988, 0.558082, 1.0,
    0.166617, 0.463708, 0.558119, 1.0,
    0.165117, 0.467423, 0.558141, 1.0,
    0.163625, 0.471133, 0.558148, 1.0,
    0.162142, 0.474838, 0.558140, 1.0,
    0.160665, 0.478540, 0.558115, 1.0,
    0.159194, 0.482237, 0.558073, 1.0,
    0.157729, 0.485932, 0.558013, 1.0,
    0.156270, 0.489624, 0.557936, 1.0,
    0.154815, 0.493313, 0.557840, 1.0,
    0.153364, 0.497000, 0.557724, 1.0,
    0.151918, 0.500685, 0.557587, 1.0,
    0.150476, 0.504369, 0.557430, 1.0,
    0.149039, 0.508051, 0.557250, 1.0,
    0.147607, 0.511733, 0.557049, 1.0,
    0.146180, 0.515413, 0.556823, 1.0,
    0.144759, 0.519093, 0.556572, 1.0,
    0.143343, 0.522773, 0.556295, 1.0,
    0.141935, 0.526453, 0.555991, 1.0,
    0.140536, 0.530132, 0.555659, 1.0,
    0.139147, 0.533812, 0.555298, 1.0,
    0.137770, 0.537492, 0.554906, 1.0,
    0.136408, 0.541173, 0.554483, 1.0,
    0.135066, 0.544853, 0.554029, 1.0,
    0.133743, 0.548535, 0.553541, 1.0,
    0.132444, 0.552216, 0.553018, 1.0,
    0.131172, 0.555899, 0.552459, 1.0,
    0.129933, 0.559582, 0.551864, 1.0,
    0.128729, 0.563265, 0.551229, 1.0,
    0.127568, 0.566949, 0.550556, 1.0,
    0.126453, 0.570633, 0.549841, 1.0,
    0.125394, 0.574318, 0.549086, 1.0,
    0.124395, 0.578002, 0.548287, 1.0,
    0.123463, 0.581687, 0.547445, 1.0,
    0.122606, 0.585371, 0.546557, 1.0,
    0.121831, 0.589055, 0.545623, 1.0,
    0.121148, 0.592739, 0.544641, 1.0,
    0.120565, 0.596422, 0.543611, 1.0,
    0.120092, 0.600104, 0.542530, 1.0,
    0.119738, 0.603785, 0.541400, 1.0,
    0.119512, 0.607464, 0.540218, 1.0,
    0.119423, 0.611141, 0.538982, 1.0,
    0.119483, 0.614817, 0.537692, 1.0,
    0.119699, 0.618490, 0.536347, 1.0,
    0.120081, 0.622161, 0.534946, 1.0,
    0.120638, 0.625828, 0.533488, 1.0,
    0.121380, 0.629492, 0.531973, 1.0,
    0.122312, 0.633153, 0.530398, 1.0,
    0.123444, 0.636809, 0.528763, 1.0,
    0.124780, 0.640461, 0.527068, 1.0,
    0.126326, 0.644107, 0.525311, 1.0,
    0.128087, 0.647749, 0.523491, 1.0,
    0.130067, 0.651384, 0.521608, 1.0,
    0.132268, 0.655014, 0.519661, 1.0,
    0.134692, 0.658636, 0.517649, 1.0,
    0.137339, 0.662252, 0.515571, 1.0,
    0.140210, 0.665859, 0.513427, 1.0,
    0.143303, 0.669459, 0.511215, 1.0,
    0.146616, 0.673050, 0.508936, 1.0,
    0.150148, 0.676631, 0.506589, 1.0,
    0.153894, 0.680203, 0.504172, 1.0,
    0.157851, 0.683765, 0.501686, 1.0,
    0.162016, 0.687316, 0.499129, 1.0,
    0.166383, 0.690856, 0.496502, 1.0,
    0.170948, 0.694384, 0.493803, 1.0,
    0.175707, 0.697900, 0.491033, 1.0,
    0.180653, 0.701402, 0.488189, 1.0,
    0.185783, 0.704891, 0.485273, 1.0,
    0.191090, 0.708366, 0.482284, 1.0,
    0.196571, 0.711827, 0.479221, 1.0,
    0.202219, 0.715272, 0.476084, 1.0,
    0.208030, 0.718701, 0.472873, 1.0,
    0.214000, 0.722114, 0.469588, 1.0,
    0.220124, 0.725509, 0.466226, 1.0,
    0.226397, 0.728888, 0.462789, 1.0,
    0.232815, 0.732247, 0.459277, 1.0,
    0.239374, 0.735588, 0.455688, 1.0,
    0.246070, 0.738910, 0.452024, 1.0,
    0.252899, 0.742211, 0.448284, 1.0,
    0.259857, 0.745492, 0.444467, 1.0,
    0.266941, 0.748751, 0.440573, 1.0,
    0.274149, 0.751988, 0.436601, 1.0,
    0.281477, 0.755203, 0.432552, 1.0,
    0.288921, 0.758394, 0.428426, 1.0,
    0.296479, 0.761561, 0.424223, 1.0,
    0.304148, 0.764704, 0.419943, 1.0,
    0.311925, 0.767822, 0.415586, 1.0,
    0.319809, 0.770914, 0.411152, 1.0,
    0.327796, 0.773980, 0.406640, 1.0,
    0.335885, 0.777018, 0.402049, 1.0,
    0.344074, 0.780029, 0.397381, 1.0,
    0.352360, 0.783011, 0.392636, 1.0,
    0.360741, 0.785964, 0.387814, 1.0,
    0.369214, 0.788888, 0.382914, 1.0,
    0.377779, 0.791781, 0.377939, 1.0,
    0.386433, 0.794644, 0.372886, 1.0,
    0.395174, 0.797475, 0.367757, 1.0,
    0.404001, 0.800275, 0.362552, 1.0,
    0.412913, 0.803041, 0.357269, 1.0,
    0.421908, 0.805774, 0.351910, 1.0,
    0.430983, 0.808473, 0.346476, 1.0,
    0.440137, 0.811138, 0.340967, 1.0,
    0.449368, 0.813768, 0.335384, 1.0,
    0.458674, 0.816363, 0.329727, 1.0,
    0.468053, 0.818921, 0.323998, 1.0,
    0.477504, 0.821444, 0.318195, 1.0,
    0.487026, 0.823929, 0.312321, 1.0,
    0.496615, 0.826376, 0.306377, 1.0,
    0.506271, 0.828786, 0.300362, 1.0,
    0.515992, 0.831158, 0.294279, 1.0,
    0.525776, 0.833491, 0.288127, 1.0,
    0.535621, 0.835785, 0.281908, 1.0,
    0.545524, 0.838039, 0.275626, 1.0,
    0.555484, 0.840254, 0.269281, 1.0,
    0.565498, 0.842430, 0.262877, 1.0,
    0.575563, 0.844566, 0.256415, 1.0,
    0.585678, 0.846661, 0.249897, 1.0,
    0.595839, 0.848717, 0.243329, 1.0,
    0.606045, 0.850733, 0.236712, 1.0,
    0.616293, 0.852709, 0.230052, 1.0,
    0.626579, 0.854645, 0.223353, 1.0,
    0.636902, 0.856542, 0.216620, 1.0,
    0.647257, 0.858400, 0.209861, 1.0,
    0.657642, 0.860219, 0.203082, 1.0,
    0.668054, 0.861999, 0.196293, 1.0,
    0.678489, 0.863742, 0.189503, 1.0,
    0.688944, 0.865448, 0.182725, 1.0,
    0.699415, 0.867117, 0.175971, 1.0,
    0.709898, 0.868751, 0.169257, 1.0,
    0.720391, 0.870350, 0.162603, 1.0,
    0.730889, 0.871916, 0.156029, 1.0,
    0.741388, 0.873449, 0.149561, 1.0,
    0.751884, 0.874951, 0.143228, 1.0,
    0.762373, 0.876424, 0.137064, 1.0,
    0.772852, 0.877868, 0.131109, 1.0,
    0.783315, 0.879285, 0.125405, 1.0,
    0.793760, 0.880678, 0.120005, 1.0,
    0.804182, 0.882046, 0.114965, 1.0,
    0.814576, 0.883393, 0.110347, 1.0,
    0.824940, 0.884720, 0.106217, 1.0,
    0.835270, 0.886029, 0.102646, 1.0,
    0.845561, 0.887322, 0.099702, 1.0,
    0.855810, 0.888601, 0.097452, 1.0,
    0.866013, 0.889868, 0.095953, 1.0,
    0.876168, 0.891125, 0.095250, 1.0,
    0.886271, 0.892374, 0.095374, 1.0,
    0.896320, 0.893616, 0.096335, 1.0,
    0.906311, 0.894855, 0.098125, 1.0,
    0.916242, 0.896091, 0.100717, 1.0,
    0.926106, 0.897330, 0.104071, 1.0,
    0.935904, 0.898570, 0.108131, 1.0,
    0.945636, 0.899815, 0.112838, 1.0,
    0.955300, 0.901065, 0.118128, 1.0,
    0.964894, 0.902323, 0.123941, 1.0,
    0.974417, 0.903590, 0.130215, 1.0,
    0.983868, 0.904867, 0.136897, 1.0,
    0.993248, 0.906157, 0.143936, 1.0,
};
