/* $Id: Return.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Return: return from subroutine (intermediate opcode).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RETURN_HPP_INCLUDED
#define __RETURN_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"

namespace intermediate {

//! return from a subroutine.
/** This class will return from a given subroutine.
 *
 *  Read operands: None.
 *  Write operands: implicit stack pointer, implicit instruction pointer.
 *
 *  No operands can be specified for Return.
 *  
 *  Operation:
 *      pop instruction pointer from stack.
 */
class Return : public OpCode {
public:
	//! c'tor
	Return() {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}
};

};

#endif /* __RETURN_HPP_INCLUDED */
